<!DOCTYPE html>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php $page_name = 'Detalhes da Propriedade'; ?>

    <?php require_once __DIR__ . '/../../inc/conn.php'; ?>
    <?php require_once __DIR__ . '/../../inc/variables.php'; ?>

    <?php require_once __DIR__ . '/../../inc/cdns.php'; ?>
    <?php require_once __DIR__ . '/../../inc/styles.php'; ?>

    <?php if ($plan['search'] == 0) { Route('projects'); } ?>

    <title><?php echo $page_name . ' | ' . $app['name']; ?></title>

    <?php 

    $uri = $_SERVER['REQUEST_URI'];
    $parts = explode('/', $uri);
    $propertyIndex = array_search('property', $parts);
    $propertyCode = $parts[$propertyIndex + 1];

    $propId = $propertyCode;

    // Verifica se as informações estão completas
    $queryGet = "SELECT * FROM properties WHERE api_id = '$propId'";
    $mysqliGet = mysqli_query($conn, $queryGet);
    while ($prop_data = mysqli_fetch_assoc($mysqliGet)) {
    
        $prop = $prop_data;

        if (strtotime($prop['sync_date']) <= strtotime('-5 days')
            || empty($prop['pictures'])
            || empty($prop['price_history'])
            || $prop['price_history'] == 'null') {

            $curl = curl_init();

            curl_setopt_array($curl, [
                CURLOPT_URL => "https://zillow56.p.rapidapi.com/property?zpid=" . $prop['api_id'],
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => [
                    "Content-Type: application/json",
                    "x-rapidapi-host: zillow56.p.rapidapi.com",
                    "x-rapidapi-key: 0e81c64f85msh344a62f86282268p15eb81jsn7faa9194b5c8"
                ],
            ]);

            $api_data = curl_exec($curl);
            $err = curl_error($curl);

            curl_close($curl);

            if ($err) { $error = 'Não foi possível atualizar os dados desta propriedade';

            } else {

                // Pega as informações atualizadas da API
                $prop_api = json_decode($api_data, true);
                $prop_sync = $prop_api;

                $features = isset($prop_sync['resoFacts']) ? json_encode($prop_sync['resoFacts']) : 'null';
                $tax_assessments = isset($prop_sync['taxHistory']) ? json_encode($prop_sync['taxHistory']) : 'null';
                $photos = isset($prop_sync['big']) ? json_encode($prop_sync['big']) : 'null';
                $tags = isset($prop_sync['resoFacts']) ? json_encode($prop_sync['resoFacts']) : 'null';
                $price_history = isset($prop_sync['priceHistory']) ? json_encode($prop_sync['priceHistory']) : 'null';

                $updateStmt = $conn->prepare("UPDATE properties SET features = ?, tax_assessments = ?, pictures = ?, tags = ?, price_history = ?, sync_status = 1 WHERE api_id = ?");
                $updateStmt->bind_param("sssssi", $features, $tax_assessments, $photos, $tags, $price_history, $propId);
                $success = $updateStmt->execute();
                $updateStmt->close();

                $queryGet = "SELECT * FROM properties WHERE api_id = '$propId'";
                $mysqliGet = mysqli_query($conn, $queryGet);
                while ($prop_data = mysqli_fetch_assoc($mysqliGet)) { 
                    $prop = $prop_data;
                }


            }

        }

    }

    ?>

    <?php if (!isset($_SESSION['user'])) { Route('entrar'); } ?>

    <link rel="stylesheet" type="text/css" href="<?php echo $local['assets'] . '/css/property.css'; ?>">

    <!-- Slider -->
    <script src="https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.4/dist/js/splide.min.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.4/dist/css/splide.min.css">

    <!-- Charts -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/date-fns@2.16.1/dist/date-fns.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chartjs-adapter-date-fns"></script>

</head>
<body>

    <?php require_once __DIR__ . '/../layout/topbar.php'; ?>

    <div class="content">
        <div class="container">
            <div class="row">
                <div style="margin-bottom: 20px;" class="col-12 col-md-12 col-lg-7 col-xxl-8">
                    <div id="pictureBox" class="splide" role="group">
                        <div class="splide__track">
                            <ul class="splide__list">
                                <?php 
                                $pictures = json_decode($prop['pictures'], true);
                                foreach ($pictures as $i => $picture) { ?>
                                <li class="splide__slide">
                                    <div style="background: url('<?php echo $picture['url']; ?>');" class="picture__item"></div>
                                </li>
                                <?php } ?>
                            </ul>
                        </div>
                    </div>
					<div class="accordion accordion-flush" id="details__box">
					    <div class="accordion-item">
					        <h2 class="accordion-header">
					            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#panelsStayOpen-collapseOne" aria-expanded="true" aria-controls="panelsStayOpen-collapseOne">
    								<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
    								  <path stroke-linecap="round" stroke-linejoin="round" d="M8.25 21v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21m0 0h4.5V3.545M12.75 21h7.5V10.75M2.25 21h1.5m18 0h-18M2.25 9l4.5-1.636M18.75 3l-1.5.545m0 6.205 3 1m1.5.5-1.5-.5M6.75 7.364V3h-3v18m3-13.636 10.5-3.819"></path>
    								</svg>
    					            Detalhes da propriedade
					            </button>
					        </h2>
					        <div id="panelsStayOpen-collapseOne" class="accordion-collapse collapse">
					            <div class="accordion-body">
					                <?php

					                $features = json_decode($prop['features'], true);

                                    $detailsNoShow = array(
                                        'atAGlanceFacts',
                                        'hasCooling',
                                        'hasHeating',
                                        'onMarketDate',
                                        'parcelNumber',
                                        'storiesTotal',
                                        'bathroomsFull',
                                        'bathroomsHalf',
                                        'bathroomsHalf',
                                        'hasOpenParking',
                                        'hasPetsAllowed',
                                        'hasAttachedProperty',
                                        'patioAndPorchFeatures',
                                        'buyerAgencyCompensation',
                                        'buyerAgencyCompensationType',
                                        'virtualTourURLUnbranded',
                                        'virtualTour',
                                        'hasFireplace',
                                        'rooms',
                                    );

                                    foreach ($features AS $title => $value) {
                                        if (isset($value) && !empty($value) && !in_array($title, $detailsNoShow)) {

                                            echo '<h1 class="details__parent">' . (!empty($title) ? Translate(TagToText($title)) : '') . ': </h1>'    ;

                                            echo '<div class="details__row">';

                                                if (is_array($value)) {
                                                    foreach ($value as $value_item) {
                                                        if (is_array($value_item)) {
                                                            foreach ($value_item as $value_subitem) {
                                                                echo '<h2 class="details__subcategory">' . (!empty($value_subitem) ? Translate(TagToText($value_subitem)) : '') . '</h2>';
                                                            }
                                                        } else {
                                                            echo '<h2 class="details__subcategory">' . (!empty($value_item) ? Translate(TagToText($value_item)) : '') . '</h2>';
                                                        }
                                                    }
                                                } else {
                                                    echo '<h2 class="details__subcategory">' . (!empty($value) ? Translate(TagToText($value)) : '') . '</h2>';
                                                }

                                            echo '</div>';
                                        }
                                    }

					                ?>
					            </div>
					        </div>
					    </div>
                        <?php if (isset($prop['tax_assessments']) && $prop['tax_assessments'] != 'null') { ?>
					    <div class="accordion-item">
					        <h2 class="accordion-header">
					            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#panelsStayOpen-collapseTwo" aria-expanded="false" aria-controls="panelsStayOpen-collapseTwo">
                                <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                  <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 15.75V18m-7.5-6.75h.008v.008H8.25v-.008Zm0 2.25h.008v.008H8.25V13.5Zm0 2.25h.008v.008H8.25v-.008Zm0 2.25h.008v.008H8.25V18Zm2.498-6.75h.007v.008h-.007v-.008Zm0 2.25h.007v.008h-.007V13.5Zm0 2.25h.007v.008h-.007v-.008Zm0 2.25h.007v.008h-.007V18Zm2.504-6.75h.008v.008h-.008v-.008Zm0 2.25h.008v.008h-.008V13.5Zm0 2.25h.008v.008h-.008v-.008Zm0 2.25h.008v.008h-.008V18Zm2.498-6.75h.008v.008h-.008v-.008Zm0 2.25h.008v.008h-.008V13.5ZM8.25 6h7.5v2.25h-7.5V6ZM12 2.25c-1.892 0-3.758.11-5.593.322C5.307 2.7 4.5 3.65 4.5 4.757V19.5a2.25 2.25 0 0 0 2.25 2.25h10.5a2.25 2.25 0 0 0 2.25-2.25V4.757c0-1.108-.806-2.057-1.907-2.185A48.507 48.507 0 0 0 12 2.25Z"></path>
                                </svg>
					            Impostos e taxas
					            </button>
					        </h2>
					        <div id="panelsStayOpen-collapseTwo" class="accordion-collapse collapse">
					            <div class="accordion-body">
					                <div class="table">
                                        <table id="taxs__table">
                                            <thead>
                                                <tr>
                                                    <th>Ano</th>
                                                    <th style="text-align: center;">Imposto da Propriedade</th>
                                                    <th style="text-align: center;">%</th>
                                                    <th style="text-align: center;">Avaliação Fiscal</th>
                                                    <th style="text-align: center;">%</th>
                                                </tr>
                                            </thead>
                                            <tbody>

                                                <?php 
                                                $tax_data = json_decode($prop['tax_assessments'], true);
                                                foreach ($tax_data as $i => $tax) { ?>
                                                <tr>
                                                    <td><?php echo date('Y', intval($tax['time'] / 1000)); ?></td>
                                                    <td style="text-align: center"><?php echo '$ ' . (!empty($tax['taxPaid']) ? Money($tax['taxPaid']) : '0,00'); ?></td>
                                                    <td style="text-align: center; color: <?php echo NumberColor($tax['taxIncreaseRate']) ?>;"><?php echo FormatPercentage($tax['taxIncreaseRate']); ?></td>
                                                    <td style="text-align: center"><?php echo '$ ' . Money($tax['value']); ?></td>
                                                    <td style="text-align: center; color: <?php echo NumberColor($tax['valueIncreaseRate']) ?>;"><?php echo FormatPercentage($tax['valueIncreaseRate']); ?></td>
                                                </tr>
                                                <?php } ?>

                                            </tbody>
                                        </table>               
                                    </div>
					            </div>
					        </div>
					    </div>
                        <?php } ?>
                        <?php if (isset($prop['price_history']) && $prop['price_history'] != 'null') { ?>
					    <div class="accordion-item">
					        <h2 class="accordion-header">
					            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#panelsStayOpen-collapseThree" aria-expanded="false" aria-controls="panelsStayOpen-collapseThree">
                                <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                  <path stroke-linecap="round" stroke-linejoin="round" d="M3.75 3v11.25A2.25 2.25 0 0 0 6 16.5h2.25M3.75 3h-1.5m1.5 0h16.5m0 0h1.5m-1.5 0v11.25A2.25 2.25 0 0 1 18 16.5h-2.25m-7.5 0h7.5m-7.5 0-1 3m8.5-3 1 3m0 0 .5 1.5m-.5-1.5h-9.5m0 0-.5 1.5m.75-9 3-3 2.148 2.148A12.061 12.061 0 0 1 16.5 7.605"></path>
                                </svg>
					            Histórico de preços
					            </button>
					        </h2>
					        <div id="panelsStayOpen-collapseThree" class="accordion-collapse collapse">
                                <?php

                                $price_history = $prop['price_history'];
                                $array_history = json_decode($price_history, true);

                                $grouped_data = [];

                                foreach ($array_history as $item) {
                                    $source = $item['source'];
                                    if (!isset($grouped_data[$source])) {
                                        $grouped_data[$source] = [];
                                    }
                                    $grouped_data[$source][] = $item;
                                }

                                $history_average = [
                                    'minimum' => [
                                        'value' => null,
                                        'source' => null,
                                        'date' => null
                                    ],
                                    'maximum' => [
                                        'value' => null,
                                        'source' => null,
                                        'date' => null
                                    ]
                                ];

                                foreach ($array_history as $item) {
                                    $price = $item['price'];
                                    $source = $item['source'];
                                    $date = $item['date'];

                                    if ($history_average['minimum']['value'] === null || $price < $history_average['minimum']['value']) {
                                        $history_average['minimum']['value'] = $price;
                                        $history_average['minimum']['source'] = $source;
                                        $history_average['minimum']['date'] = $date;
                                    }

                                    if ($history_average['maximum']['value'] === null || $price > $history_average['maximum']['value']) {
                                        $history_average['maximum']['value'] = $price;
                                        $history_average['maximum']['source'] = $source;
                                        $history_average['maximum']['date'] = $date;
                                    }
                                }

                                $priceHistoryGrouped = json_encode($grouped_data);

                                ?>
					            <div class="accordion-body">
                                    <div class="row">
                                        <div style="margin-bottom: 20px;" class="col-12 col-md-6 col-lg-6 col-xxl-4">
                                            <div class="history__module">
                                                <div class="history__text">
                                                    <p class="history__title">Estimativa mínima</p>
                                                    <p class="history__value"><?php echo isset($history_average['minimum']['value']) ? '$ ' . MoneyShow($history_average['minimum']['value'], 0) : '$ 0,00';  ?></p>
                                                    <?php if (isset($history_average['minimum']['source'])) { 
                                                        echo '<label style="background: ' . '' . ';" class="history__tag">' . $history_average['minimum']['source'] . '</label>'; 
                                                        echo '<label class="history__date">' . date('M, Y', strtotime($history_average['minimum']['date'])) . '</label>'; 
                                                    } ?>
                                                </div>
                                                <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                                  <path stroke-linecap="round" stroke-linejoin="round" d="M3 4.5h14.25M3 9h9.75M3 13.5h9.75m4.5-4.5v12m0 0-3.75-3.75M17.25 21 21 17.25"></path>
                                                </svg>
                                            </div>
                                        </div>
                                        <div style="margin-bottom: 20px;" class="col-12 col-md-6 col-lg-6 col-xxl-4">
                                            <div class="history__module">
                                                <div class="history__text">
                                                    <p class="history__title">Estimativa máxima</p>
                                                    <p class="history__value"><?php echo isset($history_average['maximum']['value']) ? '$ ' . MoneyShow($history_average['maximum']['value'], 0) : '$ 0,00';  ?></p>
                                                    <?php if (isset($history_average['maximum']['source'])) { 
                                                        echo '<label style="background: ' . '' . ';" class="history__tag">' . $history_average['maximum']['source'] . '</label>'; 
                                                        echo '<label class="history__date">' . date('M, Y', strtotime($history_average['maximum']['date'])) . '</label>'; 
                                                    } ?>
                                                </div>
                                                <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                                  <path stroke-linecap="round" stroke-linejoin="round" d="M3 4.5h14.25M3 9h9.75M3 13.5h5.25m5.25-.75L17.25 9m0 0L21 12.75M17.25 9v12"></path>
                                                </svg>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <canvas id="priceChart"></canvas>
                                        </div>
                                    </div>
                                    <script>

                                        // Passa os dados do PHP para o JavaScript
                                        var groupedData = <?php echo $priceHistoryGrouped; ?>;

                                        // Preparar os datasets para o Chart.js
                                        var datasets = [];
                                        for (var source in groupedData) {
                                            var data = groupedData[source].map(item => ({ x: new Date(item.time), y: item.price }));
                                            datasets.push({
                                                label: source,
                                                data: data,
                                                borderWidth: 1
                                            });
                                        }

                                        var ctx = document.getElementById('priceChart').getContext('2d');

                                        var priceChart = new Chart(ctx, {
                                            type: 'line',
                                            data: {
                                                datasets: datasets
                                            },
                                            options: {
                                                responsive: true,
                                                maintainAspectRatio: false,
                                                scales: {
                                                    x: {
                                                        type: 'time',
                                                        time: {
                                                            unit: 'year',
                                                            tooltipFormat: 'MMM dd, yyyy',
                                                            displayFormats: {
                                                                month: 'MMM yyyy'
                                                            }
                                                        }
                                                    },
                                                    y: {
                                                        beginAtZero: false
                                                    }
                                                },
                                                plugins: {
                                                    tooltip: {
                                                        enabled: true,
                                                        displayColors: false,
                                                        titleFont: { family: 'Inter', weight: '300', size: 11 },
                                                        bodyFont: { family: 'Inter', weight: '300', size: 14 },
                                                        padding: { top: 10, right: 15, bottom: 10, left: 15 },
                                                        backgroundColor: '#161617',
                                                        titleColor: '#ffffffa9',
                                                        bodyColor: '#ffffff',
                                                        cornerRadius: 10,
                                                        caretPadding: 10,
                                                        callbacks: {
                                                            label: function(context) {
                                                                var label = context.dataset.label || '';
                                                                var value = context.parsed.y !== null ? '$ ' + context.parsed.y.toLocaleString() : '$ 0,00';
                                                                return label + ': ' + value;
                                                            }
                                                        }
                                                    },
                                                    legend: {
                                                        align: 'end',
                                                        position: 'bottom',
                                                        labels: {
                                                            boxWidth: 15,
                                                            boxHeight: 15,
                                                            font: {
                                                                size: 14,
                                                                weight: '300',
                                                                family: 'Inter'
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        });

                                    </script>
					            </div>
					        </div>
					    </div>
                        <?php } ?>
					</div>
                </div>
                <div style="margin-bottom: 20px;" class="order-first order-lg-last col-12 col-md-12 col-lg-5 col-xxl-4">
                    <div class="prop__module">
                        <div class="info__header">
                            <label class="info__status">
                                <?php echo StatusFormat($prop['status']); ?>
                            </label>
                        </div>
                        <div class="info__price">
                            <h1 class="prop__price">
                                <?php echo '$' . MoneyShow($prop['price'], $prop['business_type'] == 'sale' ? 0 : 2) . ($prop['business_type'] == 'rent' ? '<small>/mês</small>' : ''); ?>
                            </h1>
                        </div>
                        <div class="info__details">
                            <p><b><?php echo $prop['bedrooms'] > 0 ? $prop['bedrooms'] : 0; ?></b> quartos</p>
                            <p><b><?php echo $prop['bedrooms'] > 0 ? $prop['bathrooms'] : 0; ?></b> banheiros</p>

                            <?php if (!empty($prop['square_footage'])) { ?>
                            <p>
                                <b><?php echo $prop['square_footage'] ?></b> sqft
                                <span data-bs-toggle="tooltip" data-bs-title="Cerca de <?php echo sqftToM2($prop['square_footage']) . 'm²'; ?>"><i class="fa-regular fa-circle-question"></i></span>
                            </p>
                            <?php } ?>

                        </div>
                        <div class="info__address">
                            <?php echo $prop['address'] . ', ' . $prop['city'] . ', ' . $prop['state'] . ' ' . $prop['zipcode']; ?>
                        </div>
                        <?php if (!empty($prop['tags'])) { ?>
                        <div class="info__tags">
                            <?php 

                                function ArrayTags($array_json) {
                                    $tags = json_decode($array_json, true);
                                    $new = [];

                                    // Inicia as tags
                                    $tags['hasCooling'] == true ? $new[] = 'Refrigeração' : null;
                                    $tags['hasFireplace'] == true ? $new[] = 'Lareira' : null;
                                    $tags['hasGarage'] == true ? $new[] = 'Garagem' : null;
                                    $tags['hasHeating'] == true ? $new[] = 'Aquecedor' : null;
                                    $tags['hasHomeWarranty'] == true ? $new[] = 'Garantia residencial' : null;
                                    $tags['hasOpenParking'] == true ? $new[] = 'Estacionamento aberto' : null;
                                    $tags['hasPetsAllowed'] == true ? $new[] = 'Permite Pets' : null;
                                    $tags['hasPrivatePool'] == true ? $new[] = 'Piscina' : null;
                                    $tags['hasSpa'] == true ? $new[] = 'SPA' : null;
                                    $tags['hasView'] == true ? $new[] = 'Vista' : null;
                                    $tags['hasWaterfrontView'] == true ? $new[] = 'Vista para o mar' : null;
                                    isset($tags['basementYN']) && $tags['basementYN'] == true ? $new[] = 'Porão' : null;
                                    isset($tags['canRaiseHorses']) && $tags['canRaiseHorses'] == true ? $new[] = 'Pode criar Cavalos' : null;

                                    foreach ($new AS $tag) {
                                        echo '<label>' . $tag . '</label>';
                                    }

                                }

                                if (isset($prop['tags']) && !empty($prop['tags'])) {
                                    ArrayTags($prop['tags']);
                                }

                            ?>
                        </div>
                        <?php } ?>
                        <div class="hr"></div>
                        <div class="info__square">
                            <div class="square__item">
                                <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                  <path stroke-linecap="round" stroke-linejoin="round" d="M8.25 21v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21m0 0h4.5V3.545M12.75 21h7.5V10.75M2.25 21h1.5m18 0h-18M2.25 9l4.5-1.636M18.75 3l-1.5.545m0 6.205 3 1m1.5.5-1.5-.5M6.75 7.364V3h-3v18m3-13.636 10.5-3.819"></path>
                                </svg>
                                <div>
                                    <p class="value"><?php echo Translate(TagToText($prop['property_type'])); ?></p>
                                    <p class="subvalue">Tipo de propriedade</p>
                                </div>
                            </div>
                            <div class="square__item">
                                <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                  <path stroke-linecap="round" stroke-linejoin="round" d="M6.75 3v2.25M17.25 3v2.25M3 18.75V7.5a2.25 2.25 0 0 1 2.25-2.25h13.5A2.25 2.25 0 0 1 21 7.5v11.25m-18 0A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75m-18 0v-7.5A2.25 2.25 0 0 1 5.25 9h13.5A2.25 2.25 0 0 1 21 11.25v7.5m-9-6h.008v.008H12v-.008ZM12 15h.008v.008H12V15Zm0 2.25h.008v.008H12v-.008ZM9.75 15h.008v.008H9.75V15Zm0 2.25h.008v.008H9.75v-.008ZM7.5 15h.008v.008H7.5V15Zm0 2.25h.008v.008H7.5v-.008Zm6.75-4.5h.008v.008h-.008v-.008Zm0 2.25h.008v.008h-.008V15Zm0 2.25h.008v.008h-.008v-.008Zm2.25-4.5h.008v.008H16.5v-.008Zm0 2.25h.008v.008H16.5V15Z"></path>
                                </svg>
                                <div>
                                    <p class="value"><?php echo !empty($prop['year_built']) ? $prop['year_built'] : 'Indefinido'; ?></p>
                                    <p class="subvalue">Construção</p>
                                </div>
                            </div>
                        </div>
                        <div class="hr"></div>
                        <div class="info__buttons">
                            <button onclick="NewProject(<?php echo $prop['api_id'] ?>)" id="newProject">
                                Criar Projeto
                            </button>
                        </div>
                    </div>
                    <div class="map__box mobile_hide">
                        <iframe
                            id="map"
                            loading="lazy"
                            src="https://www.openstreetmap.org/export/embed.html?bbox=<?php echo ($prop['longitude']-0.009); ?>%2C<?php echo ($prop['latitude']-0.009); ?>%2C<?php echo ($prop['longitude']+0.009); ?>%2C<?php echo ($prop['latitude']+0.009); ?>&amp;layer=mapnik&amp;marker=<?php echo $prop['latitude']; ?>%2C<?php echo $prop['longitude']; ?>">
                        </iframe>
                    </div>
                </div>
            </div>
        </div>
    </div>

</body>
<script type="text/javascript">

function NewProject(prop_id) {

    const url = base_url + '/projects/new/fix-and-flip';
    const data = { property: prop_id };

    // Cria um elemento de formulário
    const form = document.createElement('form');
    form.target = '_blank';
    form.method = 'GET';
    form.action = url;

    // Cria campos de input com os dados a serem enviados
    for (const key in data) {
        if (data.hasOwnProperty(key)) {
            const input = document.createElement('input');
            input.type = 'hidden';
            input.name = key;
            input.value = data[key];
            form.appendChild(input);
        }
    }

    document.body.appendChild(form);
    form.submit();

}

document.addEventListener('DOMContentLoaded', function() {
    // Seleciona todos os elementos .picture__item
    var items = document.querySelectorAll('.picture__item');
    
    items.forEach(function(item) {
        // Extrai a URL da imagem de fundo do elemento
        var imageUrl = item.style.backgroundImage.slice(5, -2); // Remove "url(" e ")" do estilo

        // Cria o pseudo-elemento de fundo desfocado
        var pseudoBg = document.createElement('div');
        pseudoBg.style.position = "absolute";
        pseudoBg.style.top = "0";
        pseudoBg.style.left = "0";
        pseudoBg.style.width = "100%";
        pseudoBg.style.height = "100%";
        pseudoBg.style.backgroundImage = `url('${imageUrl}')`;
        pseudoBg.style.backgroundSize = "cover";
        pseudoBg.style.filter = "blur(5px) brightness(110%) saturate(50%)";
        pseudoBg.style.transform = "scale(1.15)";
        pseudoBg.style.zIndex = "-1";
        pseudoBg.style.zIndex = "-1";

        // Insere o pseudo-elemento antes do conteúdo do item
        item.appendChild(pseudoBg);
    });
});

document.addEventListener( 'DOMContentLoaded', function() {

    var carousel_pictures = new Splide('#pictureBox', {

    });
    carousel_pictures.mount();

    const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
    const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))

});
</script>
</html>