<!DOCTYPE html>
<html>
<head>

	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<?php $page_name = 'Alterar Senha'; ?>

	<?php require_once __DIR__ . '/../../../inc/conn.php'; ?>
	<?php require_once __DIR__ . '/../../../inc/variables.php'; ?>

	<?php if (isset($_SESSION['user'])) { Route(''); } ?>
	<?php 

	$code = $_GET['code'];
	$currentUserIp = $_SERVER['REMOTE_ADDR'];

	$stmt = $conn->prepare("SELECT * FROM recovery_requests WHERE code = ? AND requester = ?");
	$stmt->bind_param("ss", $code, $currentUserIp);
	$stmt->execute();
	$result = $stmt->get_result();

	if ($result->num_rows == 0) {
	    Route('entrar');
	    exit;
	}

	$stmt->close();

	?>

	<?php require_once __DIR__ . '/../../../inc/cdns.php'; ?>
	<?php require_once __DIR__ . '/../../../inc/styles.php'; ?>

	<link rel="stylesheet" type="text/css" href="<?php echo $local['assets'] . '/css/login.css'; ?>">
	<script type="text/javascript" src="<?php echo $local['assets'] . '/js/authentication/update-password.js'; ?>"></script>

	<title><?php echo $page_name . ' | ' . $app['name']; ?></title>

</head>
<body>
	<div class="container-fluid">
		<div class="row">
			<div class="mobile_hide col-sm-12 col-md-5 col-lg-6 col-xl-7 gx-0">
				<div class="left__box">
					<div style="background: url('https://i.ibb.co/Q9SR4k8/sunrise-5111409-1280.jpg');" class="left__wallpaper"></div>
				</div>
			</div>
			<div class="col-sm-12 col-md-7 col-lg-6 col-xl-5 gx-0">
				<div class="right__box">
					<div class="right__content">
						<form method="POST" onsubmit="verify__recovery(event)">
						
						<div class="logo__box">
							<img src="<?php echo $local['assets'] . '/marca/icone_dark.svg'; ?>">
						</div>

						<h1 class="login__title">Altere sua senha!</h1>
						<p class="login__subtitle">Insira sua nova senha no campo abaixo:</p>

						<div class="input__box">
							<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
							  <path stroke-linecap="round" stroke-linejoin="round" d="M16.5 10.5V6.75a4.5 4.5 0 1 0-9 0v3.75m-.75 11.25h10.5a2.25 2.25 0 0 0 2.25-2.25v-6.75a2.25 2.25 0 0 0-2.25-2.25H6.75a2.25 2.25 0 0 0-2.25 2.25v6.75a2.25 2.25 0 0 0 2.25 2.25Z"></path>
							</svg>
							<input maxlength="255" required placeholder="Digite sua nova senha" type="email" id="recovery__email">
						</div>

						<button id="login__button">
							ALTERAR SENHA
						</button>

						<p class="login__register">Ou <a href="<?php echo RouteLink('entrar'); ?>">Faça Login</a></p>

						<p id="message__error"></p>

						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="copy__bar">
		<p>Feito com ❤️ por <?php echo $app['name']; ?>. Todos os direitos reservados © 2024.</p>
	</div>
</body>
<script type="text/javascript">var codeRecovery = '<?php echo $_GET['code']; ?>'</script>
</html>