<?php 

if (session_status() == PHP_SESSION_NONE) { session_start(); }
require_once __DIR__ . '/../../inc/conn.php';

// Verifica se o 'id' foi enviado
if (!isset($_POST['id'])) {
    $response = array(
        'code' => 400,
        'status' => 'error',
        'message' => 'User ID not provided.',
    );
} else {
    $user_id = $_POST['id'];

    if ($conn->connect_error) {
        $response = array(
            'code' => 500,
            'status' => 'error',
            'message' => 'Connection error',
            'description' => $conn->connect_error,
        );
    } else {
        // Prepara e executa a consulta para verificar se o usuário existe
        $stmt = $conn->prepare("SELECT id FROM users WHERE id = ?");
        $stmt->bind_param("i", $user_id); // 'i' indica que o parâmetro é um inteiro
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            // O usuário existe, então prepara e executa a consulta de deleção
            $stmt_delete = $conn->prepare("DELETE FROM users WHERE id = ?");
            $stmt_delete->bind_param("i", $user_id);
            $stmt_delete->execute();

            if ($stmt_delete->affected_rows > 0) {
                $response = array(
                    'code' => 200,
                    'status' => 'success',
                    'message' => 'User deleted successfully.',
                );
            } else {
                // O comando DELETE foi executado, mas não afetou nenhuma linha (isso é improvável de acontecer neste ponto)
                $response = array(
                    'code' => 500,
                    'status' => 'error',
                    'message' => 'User could not be deleted.',
                );
            }
        } else {
            // Usuário não encontrado
            $response = array(
                'code' => 404,
                'status' => 'error',
                'message' => 'User not found',
            );
        }
    }
}

header('Content-Type: application/json');
echo json_encode($response);

?>
