<?php

    require_once __DIR__ . '/../../inc/conn.php';

    $params = [
        'place' => $_POST['place'] ?? '',
        'zipcode' => $_POST['zipcode'] ?? '',
        'city' => $_POST['city'] ?? '',
        'county' => $_POST['county'] ?? '',
        'property_type' => $_POST['property_type'] ?? '',
        'transaction_type' => $_POST['transaction_type'] ?? '',
        'bedrooms' => $_POST['bedrooms'] ?? '',
        'bathrooms' => $_POST['bathrooms'] ?? ''
    ];

    $business_types = [
        'FOR_SALE' => 'sale',
        'FOR_RENT' => 'rent',
        'RECENTLY_SOLD' => 'sold'
    ];

    $business_type = $business_types[$params['transaction_type']] ?? '';

    $query = "SELECT *, (0";
    if (!empty($params['place'])) {
        $query .= " + CASE WHEN address LIKE '%" . $conn->real_escape_string($params['place']) . "%' THEN 1 ELSE 0 END";
    }
    if (!empty($params['zipcode'])) {
        $query .= " + CASE WHEN zipcode LIKE '%" . $conn->real_escape_string($params['zipcode']) . "%' THEN 1 ELSE 0 END";
    }
    if (!empty($params['city'])) {
        $query .= " + CASE WHEN city LIKE '%" . $conn->real_escape_string($params['city']) . "%' THEN 1 ELSE 0 END";
    }
    if (!empty($params['county'])) {
        $query .= " + CASE WHEN state LIKE '%" . $conn->real_escape_string($params['county']) . "%' THEN 1 ELSE 0 END";
    }
    if (!empty($params['property_type'])) {
        $query .= " + CASE WHEN property_type LIKE '%" . $conn->real_escape_string($params['property_type']) . "%' THEN 1 ELSE 0 END";
    }
    $query .= ") AS relevance FROM properties WHERE 1=1";
    if (!empty($business_type)) {
        $query .= " AND business_type = '" . $conn->real_escape_string($business_type) . "'";
    }
    if (!empty($params['bedrooms'])) {
        $query .= " AND bedrooms = " . (int) $params['bedrooms'];
    }
    if (!empty($params['bathrooms'])) {
        $query .= " AND bathrooms = " . (int) $params['bathrooms'];
    }
    $query .= " ORDER BY relevance DESC LIMIT 50";

    // Executando a query
    $result = $conn->query($query);
    if ($result) {
        while ($row = $result->fetch_assoc()) {
            echo json_encode($row);
        }
    } else {
        echo "Erro ao buscar propriedades: " . $conn->error;
    }

?>
