<html>
<head>

    <?php require_once __DIR__ . '/../../inc/conn.php'; ?>
    <?php require_once __DIR__ . '/../../inc/variables.php'; ?>
    <?php require_once __DIR__ . '/../../inc/functions.php'; ?>
    <?php require_once __DIR__ . '/../../inc/styles.php'; ?>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <style type="text/css">

        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@100..900&display=swap');
        @import url('https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;1,300;1,400;1,500;1,600;1,700;1,800&display=swap');

        @media (max-width: 767px) {
            #contentExport {
                padding: 0px !important;
            }
            .content__boxs {
                display: block !important;
            }
            .content__header {
                display: block !important;
                text-align: center !important;
            }
            .content__header * {
                text-align: center !important;
            }
            .content__header div {
                margin-bottom: 20px;
            }
            .content__header img {
                margin-bottom: 25px;
                margin-top: 25px;
            }
            .picture__box {
                margin-bottom: 25px !important;
            }
            .value {
                padding-left: 0px !important;
            }
        }

        html {
            font-family: Inter;
        }

        #contentExport {
            padding: 50px;
            margin-top: 50px;
        }

        #actionHeader {
            padding: 0px 20px;
            background: #000;
            display: flex;
            justify-content: flex-end;
            align-items: center;
            position: fixed;
            top: 0;
            width: 100%;
            height: 50px;
            z-index: 1000;
        }

        #actionHeader button {
            padding: 5px 15px;
            font-size: .9em;
            font-weight: 300;
            border-radius: 10px;
            background: transparent;
            color: #fff;
            border: 1px solid #fff;
            font-weight: 400;
            margin-left: 10px;
        }

        .content__header {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        img.logo {
            height: 45px;
        }

        .content__log p {
            text-align: right;
            font-size: .8em;
            font-weight: 400;
            margin-bottom: 3px;
            color: #343a40;
        }

        .content__log p:last-child {
            margin-bottom: 0px;
        }

        .picture__box {
            width: 100%;
            height: 250px;
            border-radius: 10px;
            background-size: cover !important;
            background-position: center center !important;
            position: relative;
            overflow: hidden;
        }

        .picture__bg {
            width: 100%;
            height: 100%;
            position: absolute;
            background: linear-gradient(0deg, rgba(2,0,36,0.5690651260504201) 0%, rgba(0,0,1,0) 24%, rgba(0,0,0,0) 100%);
            top: 0;
        }

        .divider {
            margin: 20px 0px;
            border-top: 1px solid #00000010;
        }

        .content__tags {
            margin-left: 10px;
            margin-bottom: 10px;
            display: flex;
            justify-content: flex-start;
            align-items: flex-end;
            position: absolute;
            bottom: 0;
        }

        .content__tags label {
            font-size: .75rem;
            font-weight: 300;
            line-height: 1;
            padding: 0px 5px 4px 5px;
            border-radius: 5px;
            background: #000;
            color: #fff;
            font-weight: 600;
            margin-right: 10px;
        }

        .content__address h3 {
            font-size: 1.5rem;
            font-weight: 400;
            text-align: center;
            margin-bottom: 0px;
        }

        .content__address p {
            text-align: center;
            font-size: 1.2rem;
            font-weight: 300;
            margin-bottom: 0px;
        }

        h1.price {
            font-size: 1.4rem;
            font-weight: 600;
            font-family: Poppins !important;
            margin-bottom: 7px;
            line-height: 1;
        }

        p.price {
            font-size: .8rem;
            font-weight: 200;
            margin-bottom: 0px;
            line-height: 1;
            font-family: Poppins;
            color: #343a40;
        }

        .content__boxs {
            display: flex;
            justify-content: space-evenly;
            align-items: center;

            border: 1px solid #00000010;
            border-radius: 15px;
            padding: 20px 0px;
        }

        .box__item {
/*            width: 100%;*/
            padding: 20px 15px;
            border-radius: 15px;
            background: white;
            border: 1px solid #00000000;
            margin-right: 20px;
            text-align: center;
        }

        .box__item .text {
            display: flex;
            justify-content: center;
            flex-direction: column;
            align-items: center;
        }

        .box__item small {
            font-weight: 400;
            font-size: .7em;
        }

        .box__item:last-child {
            margin-right: 0px;
        }

        .content__boxs .icon {
            width: 35px;
            height: 35px;
            background: #00c9a71a;
            border-radius: 100%;
            margin-bottom: 15px;
            color: #00c9a7;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .content__boxs .icon svg {
            width: 20px;
        }

        table td {
            padding: 5px 0px;
        }

        tr .value {
            padding: 0px 0px 0px 15px;
            text-align: right;
        }

        tr th {
            font-size: .8em;
            font-weight: 400;
            color: #343a4060;
        }

        td.title {
            font-size: .9em;
            font-weight: 400;
        }

        td.value {
            font-size: .9em;
            font-weight: 500;
        }

        h2.title {
            font-size: 1.1em;
            font-family: Inter;
            font-weight: 200;
            margin-bottom: 15px;
            padding: 10px 20px;
            background: #000;
            color: #fff;
            border-radius: 15px 15px 0px 0px;
            margin-bottom: 0px;
        }

        table td {
            white-space: nowrap;
        }

        table {
            width: 100%;
            margin-bottom: 15px;
        }

        .table__module {
            padding: 10px 20px;
            border-radius: 0px 0px 15px 15px;
            border: 1px solid #00000010;
        }

        .table__total {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding-top: 15px;
            border-top: 1px solid #00000008;
        }

        .table__total h1 {
            font-size: .9em;
            font-weight: 400;
        }

        .table__total h2 {
            font-size: 1.3em;
            font-weight: 700;
        }

        .table__total h2 small {
            font-size: .7em;
            font-weight: 400;
        }

        tr.title td {
            font-size: 1.2em;
            font-weight: 600;
        }

        tr .divider {
            margin: 5px 0px;
        }

    </style>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.3.1/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.3.2/html2canvas.min.js"></script>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>

    <?php 

        $uri = $_SERVER['REQUEST_URI'];
        $parts = explode('/', $uri);
        $projectIndex = array_search('project', $parts);
        $projectCode = $parts[$projectIndex + 1];

        $project_id = $projectCode;

        // Pega o array do projeto
        $stmt = $conn->prepare("SELECT * FROM projects WHERE code = ?");
        $stmt->bind_param("s", $project_id);
        $stmt->execute();
        $project_result = $stmt->get_result();

        if (!$project_result) {
            Route('projects');
        }

        $project = $project_result->fetch_assoc();
        $stmt->close();

        // Pega o array do usuário
        $user_id = $project['user'];
        $user_query = "SELECT * FROM users WHERE id = '$user_id'";
        $user_result = $conn->query($user_query);
        $user = $user_result->fetch_assoc();

    ?>

    <title><?php echo $project['address'] . ' | ' . $project['code']; ?></title>

</head>
<body>
    <div id="actionHeader">
        <button onclick="exportReport('pdf')" class="save">Salvar PDF</button>
        <button onclick="exportReport('print')" class="print">Imprimir</button>
    </div>
    <div class="container" >
        <div id="contentExport">
            <div class="row">
                <div class="col-12">
                    <div class="content__header">
                        <img class="logo" src="https://i.ibb.co/dJYYtW7/logo-black.png">
                        <div>
                            <div class="content__address">
                                <h3 class="title"><?php echo $project['address']; ?></h3>
                                <p class="subtitle"><?php echo $project['city'] . ' ' . $project['county'] . ', ' . $project['zipcode']; ?></p>
                            </div>
                        </div>
                        <div class="content__log">
                            <p><?php echo date('d/m/Y H:i', strtotime($project['updated_at'])); ?></p>
                            <p><?php echo $user['name']; ?></p>
                            <p><?php echo $user['mail']; ?></p>
                        </div>
                    </div>
                </div>
            </div>
            <div style="margin-bottom: 35px;" class="col-12">
                <div class="divider"></div>
            </div>
            <div class="row gx-4">
                <div class="col-12 col-md-6">
                    <?php 

                        if (isset($project['picture']) && !empty($project['picture']) && $project['picture'] != '[]') {
                            $picture_array = json_decode($project['picture'], true);
                            $picture_dir = isset($picture_array[0]) ? $local['raiz'] . '/attachments/projects/' . $project['code'] . '/' . $picture_array[0] : 'https://i.ibb.co/VCTBHtj/nopic-1.png';

                        } elseif (isset($project['api_pictures']) && !empty($project['api_pictures'])) {
                            $picture_array = json_decode($project['api_pictures'], true);
                            $picture_dir = isset($picture_array[0]['href']) ? str_replace('http', 'https', $picture_array[0]['href']) : 'https://i.ibb.co/VCTBHtj/nopic-1.png';

                        } else { $picture_dir = 'https://i.ibb.co/VCTBHtj/nopic-1.png'; }

                    ?>
                    <div style="background: url('<?php echo $picture_dir; ?>');" class="picture__box">
                        <div class="picture__bg"></div>
                        <div class="content__tags">

                            <?php if ($project['bedrooms'] > 0) { ?>
                            <label><?php echo $project['bedrooms'] ?> quartos</label>
                            <?php } ?>

                            <?php if ($project['bathrooms'] > 0) { ?>
                            <label><?php echo $project['bathrooms'] ?> banheiros</label>
                            <?php } ?>

                            <?php if ($project['size'] > 0) { ?>
                            <label><?php echo $project['size'] ?> sqft</label>
                            <?php } ?>

                        </div>
                    </div>
                </div>
                <div class="col-12 col-md-6">
                    <div class="row">
                        <div class="col-12">
                            <h2 class="title">Valores e custos da propriedade:</h2>
                            <div class="table__module">
                                <table>
                                    <tr>
                                        <td class="title">ARV (Após o valor do reparo):</td>
                                        <td class="value"><?php echo '$ ' . Money(isset($project['price_arv']) ? $project['price_arv'] : 0); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="title">Preço de compra:</td>
                                        <td class="value"><?php echo '$ ' . Money(isset($project['price_buy']) ? $project['price_buy'] : 0); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="title">Custos estimados de reparo:</td>
                                        <td class="value"><?php echo '$ ' . Money(isset($project['rehab_total']) ? $project['rehab_total'] : 0); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="title">Tempo estimado de espera:</td>
                                        <td class="value"><?php echo isset($project['duration']) ? number_format($project['duration'], 1, '.') : 0; ?> (meses)</td>
                                    </tr>
                                </table>
                                <div class="table__total">
                                    <h1>Total de compra e reparo:</h1>
                                    <?php 

                                         $price_buy = isset($project['price_buy']) ? $project['price_buy'] : 0;
                                         $rehab_total = isset($project['rehab_total']) ? $project['rehab_total'] : 0;

                                    ?>
                                    <h2><?php echo '$ ' . Money($price_buy + $rehab_total); ?></h2>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12 col-md-6">
                    <div style="margin-top: 25px;" class="row">
                        <div class="col-12">
                            <?php 

                                $first_mortgage = isset($project['first_mortgage']) ? json_decode($project['first_mortgage'], true) : null;
                                $secound_mortgage = isset($project['secound_mortgage']) ? json_decode($project['secound_mortgage'], true) : null;

                            ?>
                            <h2 class="title">Custos de financiamento:</h2>
                            <div class="table__module table-responsive">
                                <table>
                                    <tr class="title">
                                        <td colspan="3">Primeira hipoteca: (Hard Money Lender)</td>
                                    </tr>
                                    <tr><td colspan="3"><div class="divider"></div></td></tr>
                                    <tr>
                                        <td class="title">Down Payment:</td>
                                        <td class="value"><?php echo (isset($first_mortgage) ? $first_mortgage['down_payment']['percentage'] : 0) . '%'; ?></td>
                                        <td class="value"><?php echo '$ ' . Money(isset($first_mortgage) ? $first_mortgage['down_payment']['amount'] : 0); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="title">Rehab Financing:</td>
                                        <td class="value"><?php echo (isset($first_mortgage) ? $first_mortgage['rehab']['percentage'] : 0) . '%'; ?></td>
                                        <td class="value"><?php echo '$ ' . Money(isset($first_mortgage) ? $first_mortgage['rehab']['amount'] : 0); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="title">Quantia:</td>
                                        <td colspan="2" class="value"><?php echo '$ ' . Money(isset($first_mortgage) ? $first_mortgage['amount'] : 0); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="title">Points:</td>
                                        <td class="value"><?php echo (isset($first_mortgage) ? $first_mortgage['points']['percentage'] : 0) . '%'; ?></td>
                                        <td class="value"><?php echo '$ ' . Money(isset($first_mortgage) ? $first_mortgage['points']['amount'] : 0); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="title">Interest:</td>
                                        <td class="value"><?php echo (isset($first_mortgage) ? $first_mortgage['interest']['percentage'] : 0) . '%'; ?></td>
                                        <td class="value"><?php echo '$ ' . Money(isset($first_mortgage) ? $first_mortgage['interest']['amount'] : 0); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="title">Total:</td>
                                        <td colspan="2" class="value"><?php echo '$ ' . Money(isset($first_mortgage) ? $first_mortgage['costs'] : 0); ?></td>
                                    </tr>
                                    <tr><td colspan="3"><div style="border-color: transparent;" class="divider"></div></td></tr>
                                    <tr class="title">
                                        <td colspan="3">Segunda hipoteca: (Private Money Lender)</td>
                                    </tr>
                                    <tr><td colspan="3"><div class="divider"></div></td></tr>
                                    <tr>
                                        <td class="title">Quantia:</td>
                                        <td colspan="2" class="value"><?php echo '$ ' . Money(isset($secound_mortgage) ? $secound_mortgage['amount'] : 0); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="title">Points:</td>
                                        <td class="value"><?php echo (isset($secound_mortgage) ? $secound_mortgage['points']['percentage'] : 0) . '%'; ?></td>
                                        <td class="value"><?php echo '$ ' . Money(isset($secound_mortgage) ? $secound_mortgage['points']['amount'] : 0); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="title">Interest:</td>
                                        <td class="value"><?php echo (isset($secound_mortgage) ? $secound_mortgage['interest']['percentage'] : 0) . '%'; ?></td>
                                        <td class="value"><?php echo '$ ' . Money(isset($secound_mortgage) ? $secound_mortgage['interest']['amount'] : 0); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="title">Total:</td>
                                        <td colspan="2" class="value"><?php echo '$ ' . Money(isset($secound_mortgage) ? $secound_mortgage['costs'] : 0); ?></td>
                                    </tr>
                                    <tr><td colspan="3"><div style="border-color: transparent;" class="divider"></div></td></tr>
                                    <tr class="title">
                                        <td colspan="3">Outros custos:</td>
                                    </tr>
                                    <tr><td colspan="3"><div class="divider"></div></td></tr>
                                    <tr>
                                        <td class="title">Quantia:</td>
                                        <td colspan="2" class="value"><?php echo '$ ' . Money(isset($project['others_mortgage']) ? $project['others_mortgage'] : 0); ?></td>
                                    </tr>
                                </table>
                                <div class="table__total">
                                    <?php 

                                        $amount_first = isset($first_mortgage) ? $first_mortgage['costs'] : 0;
                                        $amount_secound = isset($secound_mortgage) ? $secound_mortgage['costs'] : 0;
                                        $amount_others = $project['others_mortgage'] > 0 ? $project['others_mortgage'] : 0;

                                    ?>
                                    <h1>Total de custos de financiamento:</h1>
                                    <h2><?php echo '$ ' . Money($amount_first + $amount_secound + $amount_others); ?></h2>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12 col-md-6">
                    <div style="margin-top: 25px;" class="row">
                        <div class="col-12">
                            <?php 

                                $holding_costs = isset($project['holding_costs']) ? json_decode($project['holding_costs'], true) : null;
                                $buy_costs = isset($project['buy_costs']) ? json_decode($project['buy_costs'], true) : null;
                                $sell_costs = isset($project['sell_costs']) ? json_decode($project['sell_costs'], true) : null;

                            ?>
                            <h2 class="title">Custos de manutenção:</h2>
                            <div class="table__module">
                                <table>
                                    <tr>
                                        <th></th>
                                        <th class="value">Anual</th>
                                        <th class="value">Mensal</th>
                                    </tr>
                                    <tr>
                                        <td class="title">Impostos da propriedade:</td>
                                        <td class="value"><?php echo '$ ' . Money(isset($holding_costs) ? $holding_costs['property_taxs']['yearly'] : 0); ?></td>
                                        <td class="value"><?php echo '$ ' . Money(isset($holding_costs) ? $holding_costs['property_taxs']['monthly'] : 0); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="title">HOA e taxas de condomínio:</td>
                                        <td class="value"><?php echo '$ ' . Money(isset($holding_costs) ? $holding_costs['hoa_fees']['yearly'] : 0); ?></td>
                                        <td class="value"><?php echo '$ ' . Money(isset($holding_costs) ? $holding_costs['hoa_fees']['monthly'] : 0); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="title">Custos de seguro:</td>
                                        <td class="value"><?php echo '$ ' . Money(isset($holding_costs) ? $holding_costs['insurance']['yearly'] : 0); ?></td>
                                        <td class="value"><?php echo '$ ' . Money(isset($holding_costs) ? $holding_costs['insurance']['monthly'] : 0); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="title">Custos de serviços público:</td>
                                        <td class="value"><?php echo '$ ' . Money(isset($holding_costs) ? $holding_costs['utilities']['yearly'] : 0); ?></td>
                                        <td class="value"><?php echo '$ ' . Money(isset($holding_costs) ? $holding_costs['utilities']['monthly'] : 0); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="title">Custos diversos:</td>
                                        <td class="value"><?php echo '$ ' . Money(isset($holding_costs) ? $holding_costs['miscellaneous']['yearly'] : 0); ?></td>
                                        <td class="value"><?php echo '$ ' . Money(isset($holding_costs) ? $holding_costs['miscellaneous']['monthly'] : 0); ?></td>
                                    </tr>
                                </table>
                                <div class="table__total">
                                    <h1>Total de compra e reparo:</h1>
                                    <h2><?php echo '$ ' . Money(isset($holding_costs['total']['monthly']) ? $holding_costs['total']['monthly'] : 0); ?> <small>/mês</small></h2>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div style="margin-top: 25px;" class="row">
                        <div class="col-12">
                            <h2 class="title">Custos de transação da compra:</h2>
                            <div class="table__module">
                                <table>
                                    <tr>
                                        <td class="title">Custos de transação:</td>
                                        <td class="value"><?php echo (isset($buy_costs) ? $buy_costs['transaction']['percentage'] : 0) . '%'; ?></td>
                                        <td class="value"><?php echo '$ ' . Money(isset($buy_costs) ? $buy_costs['transaction']['amount'] : 0); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="title">Custos diversos:</td>
                                        <td colspan="2" class="value"><?php echo '$ ' . Money(isset($buy_costs) ? $buy_costs['miscellaneous'] : 0); ?></td>
                                    </tr>
                                </table>
                                <div class="table__total">
                                    <h1>Total de custos da compra:</h1>
                                    <h2><?php echo '$ ' . Money(isset($buy_costs['costs']) ? $buy_costs['costs'] : 0); ?></h2>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div style="margin-top: 25px;" class="row">
                        <div class="col-12">
                            <h2 class="title">Custos de transação da venda:</h2>
                            <div class="table__module">
                                <table>
                                    <tr>
                                        <td class="title">Custos de transação:</td>
                                        <td class="value"><?php echo (isset($sell_costs) ? $sell_costs['transaction']['percentage'] : 0) . '%'; ?></td>
                                        <td class="value"><?php echo '$ ' . Money(isset($sell_costs) ? $sell_costs['transaction']['amount'] : 0); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="title">Taxas de corretagem:</td>
                                        <td class="value"><?php echo (isset($sell_costs) ? $sell_costs['realtor']['percentage'] : 0) . '%'; ?></td>
                                        <td class="value"><?php echo '$ ' . Money(isset($sell_costs) ? $sell_costs['realtor']['amount'] : 0); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="title">Custos diversos:</td>
                                        <td colspan="2" class="value"><?php echo '$ ' . Money(isset($sell_costs) ? $sell_costs['miscellaneous'] : 0); ?></td>
                                    </tr>
                                </table>
                                <div class="table__total">
                                    <h1>Total de custos da venda:</h1>
                                    <h2><?php echo '$ ' . Money(isset($sell_costs['costs']) ? $sell_costs['costs'] : 0); ?></h2>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div style="margin-top: 45px;" class="content__boxs">
                        <?php

                            $price_arv = $project['price_arv'] > 0 ? $project['price_arv'] : 0;
                            $price_buy = $project['price_buy'] > 0 ? $project['price_buy'] : 0;
                            $rehab_total = $project['rehab_total'] > 0 ? $project['rehab_total'] : 0;
                            $total_costs = $project['total_costs'] > 0 ? $project['total_costs'] : 0;

                            $totalInvest = $total_costs + $price_buy + $rehab_total;
                            $natProfit = round($price_arv - $totalInvest, 2);
                            $perProfit = $natProfit <= 0 ? round($natProfit, 0) . '%' : PercentToAmount($natProfit, $price_arv);

                        ?>
                        <div class="box__item">
                            <div class="text">
                                <label style="background: #db377a20; color: #db373d;" class="icon">
                                    <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                      <path stroke-linecap="round" stroke-linejoin="round" d="M2.25 18.75a60.07 60.07 0 0 1 15.797 2.101c.727.198 1.453-.342 1.453-1.096V18.75M3.75 4.5v.75A.75.75 0 0 1 3 6h-.75m0 0v-.375c0-.621.504-1.125 1.125-1.125H20.25M2.25 6v9m18-10.5v.75c0 .414.336.75.75.75h.75m-1.5-1.5h.375c.621 0 1.125.504 1.125 1.125v9.75c0 .621-.504 1.125-1.125 1.125h-.375m1.5-1.5H21a.75.75 0 0 0-.75.75v.75m0 0H3.75m0 0h-.375a1.125 1.125 0 0 1-1.125-1.125V15m1.5 1.5v-.75A.75.75 0 0 0 3 15h-.75M15 10.5a3 3 0 1 1-6 0 3 3 0 0 1 6 0Zm3 0h.008v.008H18V10.5Zm-12 0h.008v.008H6V10.5Z"></path>
                                    </svg>
                                </label>
                                <h1 class="price"><?php echo '$ ' . Money($totalInvest); ?></h1>
                                <p class="price">Estimativa de custos.</p>
                            </div>
                        </div>
                        <div class="box__item">
                            <div class="text">
                                <label <?php echo $natProfit <= 0 ? 'style="background: #db377a20; color: #db373d;"' : ''; ?> class="icon">
                                    <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                      <path stroke-linecap="round" stroke-linejoin="round" d="M12 6v12m-3-2.818.879.659c1.171.879 3.07.879 4.242 0 1.172-.879 1.172-2.303 0-3.182C13.536 12.219 12.768 12 12 12c-.725 0-1.45-.22-2.003-.659-1.106-.879-1.106-2.303 0-3.182s2.9-.879 4.006 0l.415.33M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z"></path>
                                    </svg>
                                </label>
                                <h1 class="price"><?php echo '$ ' . Money($natProfit); ?></h1>
                                <p class="price">Estimativa de lucro.</p>
                            </div>
                        </div>
                        <div class="box__item">
                            <div class="text">
                                <label <?php echo $natProfit <= 0 ? 'style="background: #db377a20; color: #db373d;"' : ''; ?> class="icon">
                                    <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                      <path stroke-linecap="round" stroke-linejoin="round" d="M7.5 21 3 16.5m0 0L7.5 12M3 16.5h13.5m0-13.5L21 7.5m0 0L16.5 12M21 7.5H7.5"></path>
                                    </svg>
                                </label>
                                <h1 class="price"><?php echo $perProfit; ?> <small>(ROI)</small></h1>
                                <p class="price">Retorno do Investimento.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
<script type="text/javascript">

function exportReport(type) {
    const elementToCapture = document.getElementById('contentExport');
    elementToCapture.style.width = '100%';
    const canvasOptions = {
        scale: 2,
        useCORS: true
    };
    html2canvas(elementToCapture, canvasOptions).then(canvas => {
        const imgWidth = canvas.width;
        const imgHeight = canvas.height;
        const pdfWidth = 210;
        const pdfHeight = (imgHeight * pdfWidth) / imgWidth;
        const pdf = new jspdf.jsPDF({
            orientation: 'portrait',
            unit: 'mm',
            format: [pdfWidth, pdfHeight]
        });
        const imgData = canvas.toDataURL('image/jpeg', 1.0);
        pdf.addImage(imgData, 'JPEG', 0, 0, pdfWidth, pdfHeight); // Certifique-se de que o formato aqui está correto

        if (type === 'pdf') {
            pdf.save('<?php echo $project['code'] . '.pdf'; ?>');
        } else if (type === 'print') {
            // Configurar o PDF para imprimir automaticamente
            pdf.autoPrint();

            // Criar um blob URL a partir do PDF
            const pdfBlob = pdf.output('blob');
            const pdfUrl = URL.createObjectURL(pdfBlob);

            const iframe = document.createElement('iframe');
            iframe.style.visibility = 'hidden';
            document.body.appendChild(iframe);

            iframe.onload = function() {
                iframe.contentWindow.print();
            };

            iframe.src = pdfUrl;
        }
    });

    elementToCapture.style.width='100%';
}


</script>
</html>