<?php

if (session_status() == PHP_SESSION_NONE) { session_start(); }
require_once __DIR__ . '/../../inc/conn.php';
require_once __DIR__ . '/../../assets/vendor/autoload.php';

$config['api_pay'] = 'sk_test_51PHzozRxMBZIERtFyY1tZn8NzmZYXpBDr3KpI2UhISxGF6klF6Ha4cgIc1cMmjr4mmsYb71TXbymZrg4oKwiwPsx0004ZWu0ib';

// Verifica se o método é POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Pega os dados do plano
    $plan_id = $_POST['plan'];
    $stmt = $conn->prepare("SELECT * FROM plans WHERE id = ?");
    $stmt->bind_param("i", $plan_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $plan = $result->fetch_assoc();
    $stmt->close();

    // Abre a instância Stripe
    $stripe = new \Stripe\StripeClient($config['api_pay']);

    // Verifica se já tem o id, caso não tenha, cria um
    if (empty($plan['api_id'])) {
        try {

            $intervals = array(
                'yearly' => 12,
                'semi-annual' => 6,
                'quarterly' => 3,
                'monthly' => 1,
            );

            // Cria o price id na Stripe
            $create_plan = $stripe->prices->create([
              'currency' => 'usd',
              'unit_amount' => ($plan['price'] * 10),
              'recurring' => ['interval' => 'month', 'interval_count' => $intervals[$plan['recurrence']]],
              'product_data' => ['name' => $plan['name']],
            ]);

            // Pegar o ID do cliente criado
            $plan['api_id'] = $create_plan->id;

            $stmt = $conn->prepare("UPDATE plans SET api_id = ? WHERE id = ?");
            $stmt->bind_param("si", $plan['api_id'], $plan_id);
            $stmt->execute();
            $stmt->close();

        } catch (\Stripe\Exception\ApiErrorException $e) {

            return json_encode(array(
                'status' => 'error',
                'message' => 'API Error > Create new custom',
                'details' => $e->getMessage(),
            ));

        }
    }

    // Enviar a response
    $response = array(
        'status' => 'success',
        'plan' => $plan['api_id']
    );

} else {
    $response = array(
        'code' => 400 ,
        'status' => 'error',
        'message' => 'invalid request method',
        'description' => 'The endpoint request method is invalid, check the documentation.',
    );
}

header('Content-Type: application/json');
echo json_encode($response);

?>