<?php

session_start();
require_once __DIR__ . '/../../inc/conn.php'; // Certifique-se de que esta conexão é com mysqli

// Recupera os dados enviados via POST
$password = $_POST['password'];
$code = $_POST['code'];

// Prepara a consulta para verificar se o código existe na tabela recovery_requests
$stmt = $conn->prepare("SELECT user FROM recovery_requests WHERE code = ?");
$stmt->bind_param("s", $code);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $recoveryRequest = $result->fetch_assoc();
    $userId = $recoveryRequest['user'];

    // Hasheia a nova senha
    $hashedPassword = hash('sha256', $password);

    // Atualiza a senha do usuário na tabela users
    $updateStmt = $conn->prepare("UPDATE users SET password = ? WHERE id = ?");
    $updateStmt->bind_param("si", $hashedPassword, $userId);
    $success = $updateStmt->execute();

    if ($success) {
        // Apaga todos os registros em recovery_requests associados ao usuário
        $deleteStmt = $conn->prepare("DELETE FROM recovery_requests WHERE user = ?");
        $deleteStmt->bind_param("i", $userId);
        $deleteStmt->execute();
        $deleteStmt->close();

        // Busca o registro do usuário para definir a sessão
        $userStmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
        $userStmt->bind_param("i", $userId);
        $userStmt->execute();
        $userResult = $userStmt->get_result();
        if ($userRow = $userResult->fetch_assoc()) {
            // Define a sessão do usuário com os dados obtidos
            $_SESSION['user'] = $userRow; // Ajuste conforme necessário para armazenar apenas os dados desejados na sessão
            $response = ['status' => 'success'];
        } else {
            $response = [
                'status' => 'error',
                'message' => 'Usuário não encontrado após atualização da senha.'
            ];
        }
        $userStmt->close();
    } else {
        $response = [
            'status' => 'error',
            'message' => 'Erro ao atualizar a senha.'
        ];
    }
    $updateStmt->close();
} else {
    $response = [
        'status' => 'error',
        'message' => 'Código de recuperação inválido.'
    ];
}

$stmt->close();

header('Content-Type: application/json');
echo json_encode($response);

?>
