<?php require_once __DIR__ . '/config.php'; ?>

<style type="text/css">
	
:root {

	--color-primary: #000;
	--color-secondary: #161617;

	--color-dark: #161618;
	--color-white: #ffffff;
	--color-border: #1F2023;
	--color-module: #222225;

	--color-mid: #19191B;
	--color-midwhite: #f9f9f9;

}

body {
	font-family: Inter;
	background: #f6f6f6 !important;
}

</style>

<link rel="icon" type="image/x-icon" href="<?php echo $local['assets'] . '/brands/favicon.png'; ?>">

<script>
document.addEventListener('DOMContentLoaded', function() {

	$('.moneyMask').inputmask({
	    alias: 'numeric',
	    radixPoint: '.',
	    groupSeparator: ',',
	    autoGroup: true,
	    digits: 2,
	    digitsOptional: false,
	    placeholder: '0',
	    rightAlign: false,
	    prefix: '$ ',
	    numericInput: true,
	    allowMinus: false,
	    onBeforeMask: function(value, opts) {
	        return value.replace(/[^\d.]/g, '');
	    }
	});

	$('.money').inputmask({
	    alias: 'numeric',
	    radixPoint: '.',
	    groupSeparator: ',',
	    autoGroup: true,
	    digits: 2,
	    digitsOptional: false,
	    placeholder: '0',
	    rightAlign: false,
	    prefix: '$ ',
	    numericInput: true,
	    allowMinus: false,
	    onBeforeMask: function(value, opts) {
	        return value.replace(/[^\d.]/g, '');
	    }
	});

	$('.percentageMask').inputmask({
	    alias: 'numeric',
	    radixPoint: '.',
	    autoGroup: true,
	    digits: 2,
	    digitsOptional: false,
	    placeholder: '0',
	    rightAlign: false,
	    suffix: ' %',
	    numericInput: true,
	    min: 0,
	    max: 100,
	});

	$('.maskStateCode').inputmask({
	    mask: "AA",
	    definitions: {
	        'A': {
	            validator: "[A-Za-z]",
	            casing: "upper"
	        }
	    },
	    placeholder: "",
	    showMaskOnHover: false,
	    showMaskOnFocus: false,
	    clearIncomplete: true
	});


});

</script>