document.addEventListener("DOMContentLoaded", () => {
  const animatedNumbers = document.querySelectorAll(".animated_number");

  animatedNumbers.forEach(el => {
    const targetNumber = parseInt(el.textContent, 10);

    if (targetNumber !== 0) {
      animateNumber(el, 0, targetNumber, 2000);
    }
  });
});

function animateNumber(element, start, end, duration) {
  let startTime = null;

  function easeIn(t) {
    return t * t;
  }

  function animation(currentTime) {
    if (startTime === null) startTime = currentTime;
    const elapsedTime = currentTime - startTime;
    const progress = Math.min(elapsedTime / duration, 1);
    const easedProgress = easeIn(progress);
    const currentNumber = Math.floor(start + easedProgress * (end - start));
    element.textContent = currentNumber;

    if (elapsedTime < duration) {
      requestAnimationFrame(animation);
    } else {
      element.textContent = end;
    }
  }

  requestAnimationFrame(animation);
}