<!DOCTYPE html>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php $page_name = 'Novo projeto'; ?>

    <?php require_once __DIR__ . '/../../../../inc/conn.php'; ?>
    <?php require_once __DIR__ . '/../../../../inc/variables.php'; ?>

    <?php require_once __DIR__ . '/../../../../inc/cdns.php'; ?>
    <?php require_once __DIR__ . '/../../../../inc/styles.php'; ?>

    <?php if ($plan['custom_project'] == 0) { Route('projects'); } ?>

    <title><?php echo $page_name . ' | ' . $app['name']; ?></title>

    <?php if (!isset($_SESSION['user'])) { Route('entrar'); } ?>
    <?php $userId = $_SESSION['user']['id']; ?>

    <?php 

        // Abre a sessão de rascunho do projeto
        if (!isset($_SESSION['user']['draft']['code'])) {

            $hash_code = md5($_SESSION['user']['id'] . session_id() . '_financial_' . date('Y-m-d H:i:s'));

            $query = "INSERT INTO projects (user, code, type) VALUES ('$userId', '$hash_code', 'build_financial')";
            if (mysqli_query($conn, $query)) {
                $_SESSION['user']['draft']['code'] = $hash_code; }

        } else { $hash_code = $_SESSION['user']['draft']['code']; }

        $projectQuery = "SELECT * FROM projects WHERE code = '$hash_code'";
        $mysqliQuery = mysqli_query($conn, $projectQuery);
        while ($project__data = mysqli_fetch_array($mysqliQuery)) { $project = $project__data; }

        function IssetValue($value, $valueFormatted = true) {
            if (isset($value) && !empty($value)) {
                if ($valueFormatted) {
                    return 'value="' . $value . '"';
                } else {
                    return $value;
                }
            }
        }

    ?>

    <link rel="stylesheet" type="text/css" href="<?php echo $local['assets'] . '/css/new-project.css'; ?>">

    <!-- Toasts -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css">
    <script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>

</head>
<body>

    <?php require_once __DIR__ . '/../../../layout/topbar.php'; ?>
    <div class="content">
        <div class="container">
            <div class="row">
                <div class="col-12 col-md-3">
                    <div class="title__box">
                        <h1 class="title">Novo Projeto</h1>
                        <p class="draft__hash"><?php echo md5('teste'); ?></p>
                    </div>
                </div>
                <div class="col-12 col-md-9">
                    <div id="header__steps" class="header__steps">
                        <div onclick="Step(1)" data-step="1" class="step__item active__step">
                            <i class="fa-solid fa-location-dot"></i>
                        </div>
                        <hr>
                        <div onclick="Step(2)" data-step="2" class="step__item">
                            <i class="fa-solid fa-images"></i>
                        </div>
                        <hr>
                        <div onclick="Step(3)" data-step="3" class="step__item">
                            <i class="fa-solid fa-filter-circle-dollar"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div style="margin-top: 20px;" class="row">
                <div class="col-12 col-md-3">
                    <div id="right__menu" class="module">
                        <div style="display: none;" id="roi__menu">
                            <div class="row">
                                <div class="col-12">
                                    <div class="statistic__module">
                                        <div class="statistic__icon">
                                            <i class="fa-solid fa-money-bill-wheat"></i>
                                        </div>
                                        <div class="statistic__content">
                                            <h2 class="statistic__value"><span id="statistic__profit">$ 0.00</span></h2>
                                            <input type="hidden" id="statistic__profit__input">
                                            <p class="statistic__subtitle">Lucro líquido estimado</p>
                                        </div>
                                    </div>
                                    <div class="statistic__module">
                                        <div class="statistic__icon">
                                            <i class="fa-solid fa-money-bill-trend-up"></i>
                                        </div>
                                        <div class="statistic__content">
                                            <h2 class="statistic__value"><span id="statistic__roi">0%</span> <small>(ROI)</small></h2>
                                            <p class="statistic__subtitle">(Retorno do Investimento)</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div style="margin: 25px 0px !important;" class="divider"></div>
                                </div>
                                <div class="col-12">
                                    <div class="roi__actions">
                                        <button onclick="exportPdf()" id="exportPdf"><i class="fa-regular fa-floppy-disk"></i> Exportar PDF</button>
                                        <!-- <button onclick="sendMail()" id="sendMail"><i class="fa-solid fa-at"></i> Receber no E-mail</button> -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <button onclick="UpdateDraft()" id="saveProject">SALVAR</button>
                        <p id="autoSave" class="autosave">Rascunho salvo em <?php echo date('d/m/Y H:i', strtotime($project['updated_at'])) ?></p>
                    </div>
                </div>
                <div class="col-12 col-md-9">
                    <div id="stepModuleRows">
                        <div id="step__info" data-step="1" class="module">
                            <div class="row">
                                <div class="col-12 col-md-12">
                                    <button onclick="searchNearMe()" id="searchNearMe">Preencher meu endereço</button>
                                </div>
                                <div class="col-12 col-md-5">
                                    <div class="input__box">
                                        <label>Endereço: <b>*</b></label>
                                        <input type="text" <?php echo IssetValue($project['address']); ?> oninput="ValidPrevNext()" onkeypress="ValidInput(this)" required id="project__address">
                                        <p id="error__address" class="error__message"></p>
                                    </div>
                                </div>
                                <div class="col-12 col-md-3">
                                    <div class="input__box">
                                        <label>Cidade: <b>*</b></label>
                                        <input type="text" <?php echo IssetValue($project['city']); ?> oninput="ValidPrevNext()" onkeypress="ValidInput(this)" required id="project__city">
                                        <p id="error__city" class="error__message"></p>
                                    </div>
                                </div>
                                <div class="col-12 col-md-2">
                                    <div class="input__box">
                                        <label>Zipcode: <b>*</b></label>
                                        <input type="text" <?php echo IssetValue($project['zipcode']); ?> oninput="ValidPrevNext()" onkeypress="ValidInput(this)" required id="project__zipcode">
                                        <p id="error__zipcode" class="error__message"></p>
                                    </div>
                                </div>
                                <div class="col-12 col-md-12">
                                    <div class="divider"></div>
                                </div>
                                <div class="col-12 col-md-2">
                                    <div class="input__box">
                                        <label>Quartos: <b>*</b></label>
                                        <input type="number" min="0" value="<?php echo isset($project['bedrooms']) ? $project['bedrooms'] : 0; ?>" oninput="ValidPrevNext()" onkeypress="ValidInput(this)" required id="project__bedrooms">
                                        <p id="error__bedrooms" class="error__message"></p>
                                    </div>
                                </div>
                                <div class="col-12 col-md-2">
                                    <div class="input__box">
                                        <label>Banheiros: <b>*</b></label>
                                        <input type="number" min="0" value="<?php echo isset($project['bathrooms']) ? $project['bathrooms'] : 0; ?>" oninput="ValidPrevNext()" onkeypress="ValidInput(this)" required id="project__bathrooms">
                                        <p id="error__bathrooms" class="error__message"></p>
                                    </div>
                                </div>
                                <div class="col-12 col-md-2">
                                    <div class="input__box">
                                        <label>Tamanho: (sqft/m²) <b>*</b></label>
                                        <input type="number" min="0" <?php echo IssetValue($project['size']); ?> oninput="ValidPrevNext()" onkeypress="ValidInput(this)" required id="project__size">
                                        <p id="error__size" class="error__message"></p>
                                    </div>
                                </div>
                                <div class="col-12 col-md-12">
                                    <div class="divider"></div>
                                </div>
                                <div class="col-12 col-md-5">
                                    <div class="input__box">
                                        <label>Observações:</label>
                                        <textarea id="project__notes"><?php echo IssetValue($project['notes'], false); ?></textarea>
                                        <p id="error__notes" class="error__message"></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="step__photos" data-step="2" class="module hidden__module">
                            <div class="row">
                                <div class="col-12">
                                    <div id="squarePhoto" ondragover="allowDrop(event)" ondrop="handleDrop(event)">
                                        <i class="fa-regular fa-image"></i>
                                        <p>Escolha uma foto ou arraste e solte aqui.</p>
                                        <p>Tamanho máximo do arquivo: 12MB. Apenas JPG ou PNG.</p>
                                        <button id="choosePicture">Enviar foto de capa</button>
                                        <input type="file" id="project__picture" multiple style="display: none;" onchange="handleFileSelect(event)">
                                    </div>
                                    <div id="previewPhoto">
                                        <?php if (isset($project['picture']) && !empty($project['picture'])) { 
                                            $pictureArray = json_decode($project['picture'], true);
                                            foreach ($pictureArray as $i => $pic) { ?>

                                                <div class="itemPicBox">
                                                    <label onclick="trashPicture('<?php echo $pic ?>', this.parentNode)"><i class="fa-solid fa-xmark"></i></label>
                                                    <img id="previewImage" src="<?php echo $local['raiz'] . '/attachments/projects/' . $hash_code . '/' . $pic; ?>">
                                                </div>

                                            <?php }
                                        } ?>
                                        <?php if (isset($project['api_pictures']) && !empty($project['api_pictures'])) { 
                                            $apiPicturesArray = json_decode($project['api_pictures'], true);
                                            foreach ($apiPicturesArray as $i => $pic) { ?>

                                                <div class="itemPicBox">
                                                    <label onclick="trashPicture('<?php echo $pic ?>', this.parentNode)"><i class="fa-solid fa-xmark"></i></label>
                                                    <img id="previewImage" src="<?php echo $pic['url']; ?>">
                                                </div>

                                            <?php }
                                        } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="step__roi" data-step="3" class="module noModule hidden__module">
                            <div class="row">
                                <div style="margin-bottom: 25px;" class="col-12">
                                    <h1 class="title">Detalhes da construção</h1>
                                    <div class="moduleInside">
                                        <div class="row">
                                            <div class="col-12 col-md-4">
                                                <div style="margin-bottom: 20px;" class="input__box">
                                                    <label>Custo do terreno <b>*</b></label>
                                                    <input type="text" class="money" value="<?php echo isset($project['price_land']) ? $project['price_land'] : 0; ?>" oninput="UpdateTotalBuy()" id="buycost__land">
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div style="margin-bottom: 20px;" class="input__box">
                                                    <label>Valor da construção <b>*</b></label>
                                                    <input type="text" class="money" value="<?php echo isset($project['price_build']) ? $project['price_build'] : 0; ?>" oninput="UpdateTotalBuy()" id="buycost__build">
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div style="margin-bottom: 0px;" class="input__box">
                                                    <label>Valor de venda</label>
                                                    <input type="text" class="money" value="<?php echo isset($project['price_sell']) ? $project['price_sell'] : 0; ?>" id="sell__price">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6">
                                    <h1 class="title">Detalhes da compra</h1>
                                    <?php 

                                        if (isset($project['cash_buy']) && !empty($project['cash_buy'])) {
                                            $details_buy = json_decode($project['cash_buy'], true);
                                        }

                                    ?>
                                    <div class="moduleInside">
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="input__box">
                                                    <label>Entrada <b>*</b></label>
                                                    <div class="row">
                                                        <div class="col-4">
                                                            <input type="text" class="percentageMask" value="<?php echo !empty($details_buy['incoming']['percentage']) ? $details_buy['incoming']['percentage'] : '0,00 %' ?>" min="0" oninput="UpdateTotalBuy()" id="buy__percentage__incoming">
                                                        </div>
                                                        <div class="col-8">
                                                            <input type="text" class="money readonly" value="<?php echo !empty($details_buy['incoming']['amount']) ? $details_buy['incoming']['amount'] : 0 ?>" readonly id="buy__value__incoming">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div style="margin: 15px 0px !important;" class="divider"></div>
                                            </div>
                                            <div class="col-12">
                                                <div class="input__box">
                                                    <label>Financiamento <b>*</b></label>
                                                    <div class="row">
                                                        <div class="col-4">
                                                            <input type="text" value="<?php echo !empty($details_buy['financing']['percentage']) ? $details_buy['financing']['percentage'] : '0,00 %' ?>" class="percentageMask" min="0" oninput="UpdateTotalBuy()" id="buy__percentage__financial">
                                                        </div>
                                                        <div class="col-8">
                                                            <input type="text" value="<?php echo !empty($details_buy['financing']['amount']) ? $details_buy['financing']['amount'] : 0 ?>" class="money readonly" id="buy__value__financial" readonly>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div style="margin-top: 20px;" class="col-12">
                                                <div class="input__box">
                                                    <label>Fechamento Inicial <b>*</b></label>
                                                    <div class="row">
                                                        <div class="col-4">
                                                            <input type="text" value="<?php echo !empty($details_buy['initial']['percentage']) ? $details_buy['initial']['percentage'] : '0,00 %' ?>" class="percentageMask" min="0" oninput="UpdateTotalBuy()" id="buy__percentage__initial">
                                                        </div>
                                                        <div class="col-8">
                                                            <input type="text" value="<?php echo !empty($details_buy['initial']['amount']) ? $details_buy['initial']['amount'] : 0 ?>" class="money readonly" id="buy__value__initial" readonly>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div style="margin-top: 20px;" class="col-12">
                                                <div class="input__box">
                                                    <label>Fechamento Meio</label>
                                                    <div class="row">
                                                        <div class="col-4">
                                                            <input type="text" value="<?php echo !empty($details_buy['quite']['percentage']) ? $details_buy['quite']['percentage'] : '0,00 %' ?>" class="percentageMask" min="0" oninput="UpdateTotalBuy()" id="buy__percentage__mid">
                                                        </div>
                                                        <div class="col-8">
                                                            <input type="text" value="<?php echo !empty($details_buy['quite']['amount']) ? $details_buy['quite']['amount'] : 0 ?>" class="money readonly" id="buy__value__mid" readonly>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div style="margin-top: 20px;" class="col-12">
                                                <div class="input__box">
                                                    <label>Fechamento Final <b>*</b></label>
                                                    <div class="row">
                                                        <div class="col-4">
                                                            <input type="text" value="<?php echo !empty($details_buy['final']['percentage']) ? $details_buy['final']['percentage'] : '0,00 %' ?>" class="percentageMask" min="0" oninput="UpdateTotalBuy()" id="buy__percentage__finish">
                                                        </div>
                                                        <div class="col-8">
                                                            <input type="text" value="<?php echo !empty($details_buy['final']['amount']) ? $details_buy['final']['amount'] : 0 ?>" class="money readonly" id="buy__value__finish" readonly>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div style="margin-top: 10px;" class="col-12">
                                                <div class="divider"></div>
                                            </div>
                                            <div style="margin-bottom: 20px;" class="col-12">
                                                <div class="input__box">
                                                    <label>Outros custos</label>
                                                    <input type="text" class="money" value="<?php echo isset($details_buy['amount']) ? Money($details_buy['amount']) : 0;  ?>" oninput="UpdateTotalBuy()" id="buy__miscellaneous">
                                                </div>
                                            </div>
                                            <div style="margin-top: 10px;" class="col-12">
                                                <div class="input__box">
                                                    <label>Custo total da compra</label>
                                                    <input type="text" class="readonly" value="<?php echo isset($details_buy['total']) ? '$' . Money($details_buy['total']) : '$0,00';  ?>" readonly id="buy__total">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6">
                                    <h1 class="title">Detalhes da venda</h1>
                                    <?php 

                                        if (isset($project['cash_sell']) && !empty($project['cash_sell'])) {
                                            $details_sell = json_decode($project['cash_sell'], true);
                                            // $details_sell['transaction']['percentage'] = str_replace(' %', '', $details_sell['transaction']['percentage']);
                                        }

                                    ?>
                                    <div class="moduleInside">
                                        <div class="row">
                                            <div style="margin-bottom: 20px;" class="col-12">
                                                <div class="input__box">
                                                    <label>Custos da transação</label>
                                                    <div class="input__row">
                                                        <input style="width: 50%;" type="text" class="percentageMask" oninput="UpdateSell()" value="<?php echo isset($details_sell['transaction']['percentage']) ? $details_sell['transaction']['percentage'] : '0'; ?>" id="sell__percentage">
                                                        <input type="text" class="readonly" readonly value="<?php echo isset($details_sell['transaction']['amount']) ? '$' . Money($details_sell['transaction']['amount']) : '$0,00'; ?>" id="sell__amount">
                                                    </div>
                                                </div>
                                            </div>
                                            <div style="margin-bottom: 20px;" class="col-12">
                                                <div class="input__box">
                                                    <label>Custos da corretagem</label>
                                                    <div class="input__row">
                                                        <input style="width: 50%;" type="text" class="percentageMask" oninput="UpdateSell()" value="<?php echo isset($details_sell['realtor']['percentage']) ? $details_sell['realtor']['percentage'] : '0'; ?>" id="sell__realtor__percentage">
                                                        <input type="text" class="readonly" readonly value="<?php echo isset($details_sell['realtor']['amount']) ? '$' . Money($details_sell['realtor']['amount']) : '$0,00'; ?>" id="sell__realtor__amount">
                                                    </div>
                                                </div>
                                            </div>
                                            <div style="margin-bottom: 20px;" class="col-12">
                                                <div class="input__box">
                                                    <label>Project Management Fee</label>
                                                    <div class="input__row">
                                                        <input style="width: 50%;" type="text" class="percentageMask" oninput="UpdateSell()" value="<?php echo isset($details_sell['fee']['percentage']) ? $details_sell['fee']['percentage'] : '$0,00'; ?>" id="sell__miscellaneous__percentage">
                                                        <input type="text" class="money" oninput="UpdateSell()" value="<?php echo isset($details_sell['fee']['amount']) ? '$' . Money($details_sell['fee']['amount']) : '$0,00'; ?>" id="sell__miscellaneous">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="input__box">
                                                    <label>Custo total da venda</label>
                                                    <input type="text" class="readonly" readonly value="<?php echo isset($details_sell['total']) ? '$' . Money($details_sell['total']) : '$0,00'; ?>" id="sell__total">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="step__buttons">
                        <div>
                            <button onclick="exitWithoutSave()" class="exitButton">Sair sem Salvar</button>
                        </div>
                        <div>
                            <button id="prevStep" onclick="Step(current__step - 1)" disabled>Voltar</button>
                            <button id="nextStep" onclick="Step(current__step + 1)" disabled>Avançar</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</body>
<script type="text/javascript">

    var notyf = new Notyf();
    current__step = 1;

    let arrayPictures = <?php echo isset($project['picture']) ? $project['picture'] : "[]" ?>;
    var hash__code = '<?php echo $hash_code; ?>';

    // =============  ACTIONS

    function Step(step) {

        const menu__steps = document.querySelectorAll('#header__steps .step__item');
        const module__steps = document.querySelectorAll('#stepModuleRows .module');

        if (!VerifyStep()) {
            return false; }

        current__step = step;

        menu__steps.forEach(step => {
            if (step.dataset.step != current__step) { 
                step.classList.remove('active__step'); 
            } else { step.classList.add('active__step'); }
        });
        module__steps.forEach(step => {
            if (step.dataset.step != current__step) { 
                step.classList.add('hidden__module'); 
            } else { step.classList.remove('hidden__module'); }
        });

        ValidPrevNext();

        // STEP: ROI
        if (current__step === 3) {

            const roi__menu = document.getElementById('roi__menu');
            roi__menu.style.display = 'block';

            const nextBtn = document.getElementById('nextStep');
            nextBtn.innerHTML = 'Publicar';
            nextBtn.onclick = () => UpdateDraft(true);
            nextBtn.disabled = false;

        } else {
            const nextBtn = document.getElementById('nextStep');
            nextBtn.onclick = () => Step(current__step + 1);
            nextBtn.innerHTML = 'Avançar';
            const publish__button = document.getElementById('saveProject');
            publish__button.style.background = 'var(--color-gradient)';
            publish__button.innerHTML = 'SALVAR';
            publish__button.style.display='block';
            const roi__menu = document.getElementById('roi__menu');
            roi__menu.style.display = 'none';
        }
    }
    function searchNearMe() {
        // Obter elementos do input
        const input__address = document.getElementById('project__address');
        const input__city = document.getElementById('project__city');
        const input__zipcode = document.getElementById('project__zipcode');

        // Atualiza load no botão
        const button = document.getElementById('searchNearMe');
        const button_old_value = button.innerHTML;
        button.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i>';

        // Verificar se a geolocalização é suportada
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(position => {
                // Obter latitude e longitude
                const latitude = position.coords.latitude;
                const longitude = position.coords.longitude;

                // Construir URL da API com a chave de API e coordenadas
                const apiKey = 'b08ccab1889a4c52be68fd4192cb3c94'; // Substitua 'SUA_CHAVE_API' pela sua chave real da OpenCage Data
                const url = `https://api.opencagedata.com/geocode/v1/json?q=${latitude}+${longitude}&key=${apiKey}`;

                // Fazer requisição à API
                fetch(url)
                    .then(response => response.json())
                    .then(data => {
                        if (data && data.results && data.results.length > 0) {
                            // Extrair dados do primeiro resultado
                            const components = data.results[0].components;

                            // Definir os valores dos inputs
                            input__address.value = components.road || '' + ' ' + components.house_number || '';
                            input__city.value = components.city || components.town || '';
                            input__zipcode.value = components.postcode || '';

                            button.innerHTML = button_old_value;
                        }
                    })
                    .catch(error => {
                        button.innerHTML = button_old_value;
                        console.error('Erro ao buscar o endereço:', error);
                    });
            }, error => {
                button.innerHTML = button_old_value;
                console.error('Erro ao obter localização:', error);
            });
        } else {
            button.innerHTML = button_old_value;
            console.log("Geolocalização não é suportada por este navegador.");
        }
    }
    function VerifyStep() {
        let error__inputs = false;
        if (current__step === 1) {
            const stepOneInputs = document.querySelectorAll('#step__info input');
            stepOneInputs.forEach(input => {
                if (input.required) {
                    const isValid = input.validity.valid;
                    if (!isValid) {
                        input.style.borderColor = '#ff0000';
                        input.nextElementSibling.style.display = 'block';
                        input.nextElementSibling.innerHTML = 'Este campo é obrigatório';
                        error__inputs = true;
                    }
                }
            });
        }

        if (error__inputs) { return false; } else { 
            UpdateDraft(current__step === 4 ? true : null);
            return true; }
    }
    function ValidInput(input) {
        if (input.value.length > 0) {
            input.style.borderColor = '#00000040';
            input.nextElementSibling.style.display = 'none';
            input.nextElementSibling.innerHTML = '';
        }
    }
    function ValidPrevNext() {
        let error__inputs = false;
        const stepOneInputs = document.querySelectorAll('#step__info input');
        stepOneInputs.forEach(input => {
            if (input.required) {
                const isValid = input.validity.valid;
                if (!isValid) {
                    error__inputs = true;
                }
            }
        });

        const prevBtn = document.getElementById('prevStep');
        const nextBtn = document.getElementById('nextStep');

        if (!error__inputs) {
            current__step != 1 ? prevBtn.disabled = false : prevBtn.disabled = true;
            current__step != 4 ? nextBtn.disabled = false : nextBtn.disabled = true;
        } else {
            prevBtn.disabled = true;
            nextBtn.disabled = true;
        }
    }
    function UpdateDraft(rehab = false) {

        // Step one
        const input__address = document.getElementById('project__address');
        const input__city = document.getElementById('project__city');
        const input__zipcode = document.getElementById('project__zipcode');
        const input__bedrooms = document.getElementById('project__bedrooms');
        const input__bathrooms = document.getElementById('project__bathrooms');
        const input__size = document.getElementById('project__size');
        const input__notes = document.getElementById('project__notes');

        // Step Picture
        const input__picture = document.getElementById('project__picture');

        // Step ROI
        const input__land = document.getElementById('buycost__land');
        const input__build = document.getElementById('buycost__build');
        const input__sell = document.getElementById('sell__price');

        $.ajax({
          type: "POST",
          url: base_url + "/api/projects/update_build_cash.php",
          data: {

            code: hash__code,

            // Step one
            address: input__address.value,
            city: input__city.value,
            zipcode: input__zipcode.value,
            bedrooms: input__bedrooms.value,
            bathrooms: input__bathrooms.value,
            size: input__size.value,
            notes: input__notes.value,

            // Step picture
            picture: arrayPictures ? JSON.stringify(arrayPictures) : null,

            // Step ROI
            price_land: FormatMoneyToSql(input__land.value),
            price_build: FormatMoneyToSql(input__build.value),
            price_sell: FormatMoneyToSql(input__sell.value),
            details_buy: GetBuyJson(),
            details_sell: GetSellJson(),

          },
          success: function(response) {
            if (response.status === 'success') {
                notyf.success('Rascunho salvo!');

                const autosave = document.getElementById('autoSave');
                autosave.innerHTML = 'Rascunho salvo em ' + GetDate();

            }

            else { console.log(response); }

          },
          error: function(xhr, status, error) {
            console.error("Erro:", error);
          }
        });
    }
    function exportPdf() {
        const button = document.getElementById('exportPdf');
        const oldValue = button.innerHTML;
        button.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i>';

        // Chama a função UpdateDraft
        UpdateDraft(true);

        // Aguarda 2 segundos antes de continuar
        setTimeout(() => {
            button.innerHTML = oldValue;
            window.open(base_url + '/project/' + hash__code);
        }, 2000); // 2000 milissegundos = 2 segundos
    }
    function exitWithoutSave() {
        Swal.fire({
            title: "Você tem certeza?",
            text: "O rascunho salvo será excluido definitivamente!",
            icon: "warning",
            showCancelButton: true,
            cancelButtonText: "Cancelar",
            confirmButtonText: "Confirmar"
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                  type: "POST",
                  url: base_url + "/api/projects/delete.php",
                  data: { code: hash__code },
                  success: function(response) {
                    // Deletado
                    if (response.status === 'success') {
                        Route('projects');
                    }
                    else { console.log(response); }
                  },
                  error: function(xhr, status, error) {
                    console.error("Erro:", error);
                  }
                });
            }
        });
    }

    // ==============  STEP: PICTURE

    function InputPicture() {
        const inputPicture = document.getElementById('project__picture');
        inputPicture.click();
    }
    function allowDrop(event) {
        event.preventDefault();
    }
    function handleDrop(event) {
        event.preventDefault();
        const inputPicture = document.getElementById('project__picture');
        const files = event.dataTransfer.files;
        const validTypes = ['image/png', 'image/jpeg', 'image/jpg'];
        for (let file of files) {
            if (validTypes.includes(file.type) && file.size <= 12 * 1024 * 1024) {
                showPreview(file);
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: 'Por favor, selecione um arquivo PNG, JPG ou JPEG ou que não exceda 12MB.',
                });
            }
        }
        inputPicture.files = files;
    }
    function handleFileSelect(event) {
        const inputPicture = event.target;
        const files = inputPicture.files;
        const validTypes = ['image/png', 'image/jpeg', 'image/jpg'];
        if (files.length > 0) {
            for (let file of files) {
                if (validTypes.includes(file.type) && file.size <= 12 * 1024 * 1024) {
                    uploadFile(file);
                    showPreview(file);
                } else if (!validTypes.includes(file.type)) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: 'Por favor, selecione um arquivo PNG, JPG ou JPEG.',
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: 'O tamanho do arquivo excede o limite de 12MB.',
                    });
                }
            }
        }
    }
    function uploadFile(file) {
        const formData = new FormData();
        formData.append('file', file);
        formData.append('code', '<?php echo $hash_code; ?>');
        $.ajax({
            url: base_url + '/api/projects/picture.php',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.status === 'success') {
                    console.log('Arquivo enviado com sucesso!');
                    arrayPictures.push(response.filePath || file.name);
                    UpdateDraft();
                } else {
                    console.log('Erro ao enviar o arquivo: ' + response.message);
                }
            },
            error: function(xhr, status, error) {
                console.log('Erro ao enviar a requisição: ' + error);
            }
        });
    }
    function showPreview(file) {
        const reader = new FileReader();
        reader.onload = function(e) {

            const divElement = document.createElement("div");
            divElement.classList.add('itemPicBox');

            // Preciso colocar o nome do arquivo como valor ali da tashPicture()

            divElement.innerHTML = `
                <label onclick="trashPicture('${file.name}', this.parentNode)"><i class="fa-solid fa-xmark"></i></label>
                <img id="previewImage" src="${e.target.result}">
            `;

            document.getElementById('previewPhoto').appendChild(divElement);


        }
        reader.readAsDataURL(file);
    }
    function trashPicture(file_name, element) {
        const index = arrayPictures.indexOf(file_name);
        if (index !== -1) {
            arrayPictures.splice(index, 1); }

        element.remove();
        UpdateDraft();
    }
    function SelectAnotherPicture() {

        const squarePhoto = document.getElementById('squarePhoto');
        squarePhoto.classList.remove('showing');

        const previewImage = document.getElementById('previewImage');
        previewImage.style.display = 'none';
        previewImage.src = '';

        const inputPicture = document.getElementById('project__picture');
        inputPicture.files = null;

        InputPicture();
    }

    document.getElementById('choosePicture').addEventListener('click', InputPicture);

    // ============== STEP: FINANCIAL

    function getPercentage(valorTotal, porcentagemString) {
        if (isNaN(valorTotal)) {
            throw new Error("O valor total deve ser um número.");
        }

        let porcentagem = porcentagemString.replace('%', '').trim();

        if (isNaN(porcentagem)) {
            throw new Error("A porcentagem deve estar no formato '0.00 %'.");
        }

        porcentagem = parseFloat(porcentagem);
        let resultado = (valorTotal * porcentagem) / 100;

        return resultado;
    }

    function UpdateTotalBuy() {
      // Total price
      const input__price__land = document.getElementById('buycost__land');
      const input__price__build = document.getElementById('buycost__build');

      // Down Payment
      const incoming__percentage = document.getElementById('buy__percentage__incoming');
      const incoming__value = document.getElementById('buy__value__incoming');

      // Financial
      const financial__percentage = document.getElementById('buy__percentage__financial');
      const financial__value = document.getElementById('buy__value__financial');

      // Initial Closing
      const initial__percentage = document.getElementById('buy__percentage__initial');
      const initial__value = document.getElementById('buy__value__initial');

      // Mid Closing
      const mid__percentage = document.getElementById('buy__percentage__mid');
      const mid__value = document.getElementById('buy__value__mid');

      // Finish Closing
      const finish__percentage = document.getElementById('buy__percentage__finish');
      const finish__value = document.getElementById('buy__value__finish');

      // Others
      const miscellaneous = document.getElementById('buy__miscellaneous');
      const input__total = document.getElementById('buy__total');

      // Formats values by percentage
      const price__land = +FormatMoneyToSql(input__price__land.value);
      const price__build = +FormatMoneyToSql(input__price__build.value);

      // Calcula o total
      const total__buy = price__land + price__build;

      // Função auxiliar para obter e ajustar a porcentagem
      function parsePercentage(element) {
        let percentage = parseFloat(element.value.replace('%', '').trim());
        if (isNaN(percentage) || percentage < 0) percentage = 0;
        return percentage;
      }

      // Obtém todas as porcentagens
      let incomingPercentage = parsePercentage(incoming__percentage);
      let financialPercentage = parsePercentage(financial__percentage);
      let initialPercentage = parsePercentage(initial__percentage);
      let midPercentage = parsePercentage(mid__percentage);
      let finishPercentage = parsePercentage(finish__percentage);


      // Calcula a soma das porcentagens
      let totalPercentage = incomingPercentage + financialPercentage + initialPercentage + midPercentage + finishPercentage;

      // Ajusta a última porcentagem se a soma for superior a 100%
      if (totalPercentage > 100) {
        const excess = totalPercentage - 100;
        if (incomingPercentage === parsePercentage(incoming__percentage)) {
          incomingPercentage -= excess;
          incoming__percentage.value = incomingPercentage.toFixed(2) + ' %';
        } else if (financialPercentage === parsePercentage(financial__percentage)) {
          financialPercentage -= excess;
          financial__percentage.value = financialPercentage.toFixed(2) + ' %';
        } else if (initialPercentage === parsePercentage(initial__percentage)) {
          initialPercentage -= excess;
          initial__percentage.value = initialPercentage.toFixed(2) + ' %';
        } else if (midPercentage === parsePercentage(mid__percentage)) {
          midPercentage -= excess;
          mid__percentage.value = midPercentage.toFixed(2) + ' %';
        } else if (finishPercentage === parsePercentage(finish__percentage)) {
          finishPercentage -= excess;
          finish__percentage.value = finishPercentage.toFixed(2) + ' %';
        }
        totalPercentage = 100;
      }

      // Incoming
      const incoming = getPercentage(total__buy, incoming__percentage.value);
      incoming__value.value = FormatMoney(incoming);

      // Financial
      const financial = getPercentage(total__buy, financial__percentage.value);
      financial__value.value = FormatMoney(financial);

      // Initial Closing
      const initial = getPercentage(total__buy, initial__percentage.value);
      initial__value.value = FormatMoney(initial);

      // Mid Closing
      const mid = getPercentage(total__buy, mid__percentage.value);
      mid__value.value = FormatMoney(mid);

      // Finish Closing
      const finish = getPercentage(total__buy, finish__percentage.value);
      finish__value.value = FormatMoney(finish);

      // Miscellaneous
      const remainingPercentage = 100 - totalPercentage;
      const miscellaneousValue = (total__buy * remainingPercentage) / 100;
      miscellaneous.value = FormatMoney(miscellaneousValue);

      // Update total value
      input__total.value = FormatMoney(total__buy);
      UpdateRoi();
    }

    // Chama a função para inicializar os valores na carga inicial da página
    window.addEventListener('load', UpdateTotalBuy);

    // Get JSON
    function GetBuyJson() {

        // Down Payment
        const incoming__percentage = document.getElementById('buy__percentage__incoming');
        const incoming__value = document.getElementById('buy__value__incoming');

        // Financial
        const financial__percentage = document.getElementById('buy__percentage__financial');
        const financial__value = document.getElementById('buy__value__financial');

        // Initial Closing
        const initial__percentage = document.getElementById('buy__percentage__initial');
        const initial__value = document.getElementById('buy__value__initial');

        // Mid Closing
        const mid__percentage = document.getElementById('buy__percentage__mid');
        const mid__value = document.getElementById('buy__value__mid');

        // Finish Closing
        const finish__percentage = document.getElementById('buy__percentage__finish');
        const finish__value = document.getElementById('buy__value__finish');

        // Miscellaneous
        const input__miscellaneous = document.getElementById('buy__miscellaneous');
        const miscellaneous = +FormatMoneyToSql(input__miscellaneous.value);

        // Total
        const input__total = document.getElementById('buy__total');
        const total = +FormatMoneyToSql(input__total.value);

        let json = {
            incoming: {
                percentage: incoming__percentage.value,
                amount: +FormatMoneyToSql(incoming__value.value),
            },
            financing: {
                percentage: financial__percentage.value,
                amount: +FormatMoneyToSql(financial__value.value),
            },
            initial: {
                percentage: initial__percentage.value,
                amount: +FormatMoneyToSql(initial__value.value),
            },
            quite: {
                percentage: mid__percentage.value,
                amount: +FormatMoneyToSql(mid__value.value),
            },
            final: {
                percentage: finish__percentage.value,
                amount: +FormatMoneyToSql(finish__value.value),
            },
            miscellaneous: {
                percentage: finish__percentage.value,
                amount: +FormatMoneyToSql(finish__value.value),
            },
            amount: miscellaneous,
            total: total,
        };

        return json;

    }

    function UpdateSell() {
        SellPercentage();
        RealtorPercentage();
        UpdateTotalSell();
        UpdateManagementFee();
    }

    function SellPercentage() {
        const sell__price = document.getElementById('sell__price');
        const percentage = document.getElementById('sell__percentage');
        const amount = document.getElementById('sell__amount');
        const amountValue = FormatMoney(GetPercentage(percentage.value, sell__price.value));
        amount.value = amountValue
    }

    function RealtorPercentage() {
        const sell__price = document.getElementById('sell__price');
        const percentage = document.getElementById('sell__realtor__percentage');
        const amount = document.getElementById('sell__realtor__amount');
        const amountValue = FormatMoney(GetPercentage(percentage.value, sell__price.value));
        amount.value = amountValue
    }

    function UpdateTotalSell() {

        const input__total = document.getElementById('sell__price');
        const input__amount = document.getElementById('sell__amount');
        const input__realtor = document.getElementById('sell__realtor__amount');
        const input__miscellaneous = document.getElementById('sell__miscellaneous');

        const buy__costs = document.getElementById('buy__total');
        const sell__costs = document.getElementById('sell__total');

        // Trata os dados
        const amount = FormatMoneyToSql(input__amount.value) > 0 ? FormatMoneyToSql(input__amount.value) : 0;
        const realtor = FormatMoneyToSql(input__realtor.value) > 0 ? FormatMoneyToSql(input__realtor.value) : 0;

        const total__sell = (+amount) + (+realtor);
        sell__costs.value = FormatMoney(total__sell);
        UpdateRoi();
    }

    function UpdateManagementFee() {
        const profit = document.getElementById('statistic__profit__input');
        const amount = document.getElementById('sell__miscellaneous');
        const percentage = document.getElementById('sell__miscellaneous__percentage');
        const amountValue = FormatMoney(GetPercentage(percentage.value, profit.value));
        amount.value = amountValue;
        UpdateRoi();
    }

    // Sell
    function GetSellJson() {

        // Transaction
        const transaction__percentage = document.getElementById('sell__percentage');
        const transaction__amount = document.getElementById('sell__amount');

        // Realtor
        const realtor__percentage = document.getElementById('sell__realtor__percentage');
        const realtor__amount = document.getElementById('sell__realtor__amount');

        // Fee
        const fee__percentage = document.getElementById('sell__miscellaneous__percentage');
        const fee__amount = document.getElementById('sell__miscellaneous');

        // Json
        let json = {
            transaction: {
                percentage: transaction__percentage.value,
                amount: +FormatMoneyToSql(transaction__amount.value),
            },
            realtor: {
                percentage: realtor__percentage.value,
                amount: +FormatMoneyToSql(realtor__amount.value),
            },
            fee: {
                percentage: fee__percentage.value,
                amount: +FormatMoneyToSql(fee__amount.value),
            },
            total: +FormatMoneyToSql(transaction__amount.value) + +FormatMoneyToSql(realtor__amount.value),
        };

        return json;

    }

    function GetPercentage(percentage, value) {
        let pct = parseFloat(percentage.replace(',', '.'));
        let val = parseFloat(value.replace(/[^\d.-]/g, ''));
        let result = (pct / 100) * val;
        return result;
    }

    function GetProfitPercentage(profit, total) {
        let prof = parseFloat(profit);
        let val = parseFloat(total);
        let percentage = (prof / val) * 100;

        if (isNaN(percentage) || !isFinite(percentage)) {
            return '0.00%';
        } else {
            return percentage.toFixed(2) + '%';
        }
    }

    function UpdateRoi() {
        const input = document.getElementById('statistic__profit__input');
        const profit = document.getElementById('statistic__profit');
        const roi = document.getElementById('statistic__roi');

        // Sell
        const price__sell = document.getElementById('sell__price');
        const sell = +FormatMoneyToSql(price__sell.value);

        // Fee
        const price__fee = document.getElementById('sell__miscellaneous');
        const fee = +FormatMoneyToSql(price__fee.value);

        // Sell Costs
        const sell__total = document.getElementById('sell__total');
        const costs = +FormatMoneyToSql(sell__total.value);

        // Buy
        const total__buy = document.getElementById('buy__total');
        const buy = +FormatMoneyToSql(total__buy.value);

        // Total
        const total = sell - buy - costs; 

        // Atualiza o profit
        input.value = total;
        profit.innerHTML = FormatMoney(total - fee);
        roi.innerHTML = GetProfitPercentage((total - fee), buy);

        // Atualiz a cor
        total < 0 ? profit.style.color = 'red' : profit.style.color = '#161617';
        total < 0 ? roi.style.color = 'red' : roi.style.color = '#161617';
    }

    const brandSave = document.getElementById('topbar__save');
    brandSave.addEventListener('click', function() {
        UpdateDraft();
    });

    // Tooltip
    const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
    const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))

    document.addEventListener('DOMContentLoaded', function() {
        // UpdateRoi();
    });

</script>
</html>