<!DOCTYPE html>
<html>
<head>

	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<?php $page_name = 'Meus Projetos'; ?>

	<?php require_once __DIR__ . '/../../inc/conn.php'; ?>
	<?php require_once __DIR__ . '/../../inc/variables.php'; ?>

	<?php require_once __DIR__ . '/../../inc/cdns.php'; ?>
	<?php require_once __DIR__ . '/../../inc/styles.php'; ?>

	<title><?php echo $page_name . ' | ' . $app['name']; ?></title>

	<?php if (!isset($_SESSION['user'])) { Route('entrar'); } ?>
	<?php $userId = $_SESSION['user']['id']; ?>

	<link rel="stylesheet" type="text/css" href="<?php echo $local['assets'] . '/css/my-projects.css'; ?>">

</head>
<body>

	<?php require_once __DIR__ . '/../layout/topbar.php'; ?>
	<div class="content">
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="project__title">
						<h1 class="title">Projetos</h1>
						<div class="dropdown">
							<button id="newProject" data-bs-toggle="dropdown" aria-expanded="false">
								<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
								  <path stroke-linecap="round" stroke-linejoin="round" d="M13.5 16.875h3.375m0 0h3.375m-3.375 0V13.5m0 3.375v3.375M6 10.5h2.25a2.25 2.25 0 0 0 2.25-2.25V6a2.25 2.25 0 0 0-2.25-2.25H6A2.25 2.25 0 0 0 3.75 6v2.25A2.25 2.25 0 0 0 6 10.5Zm0 9.75h2.25A2.25 2.25 0 0 0 10.5 18v-2.25a2.25 2.25 0 0 0-2.25-2.25H6a2.25 2.25 0 0 0-2.25 2.25V18A2.25 2.25 0 0 0 6 20.25Zm9.75-9.75H18a2.25 2.25 0 0 0 2.25-2.25V6A2.25 2.25 0 0 0 18 3.75h-2.25A2.25 2.25 0 0 0 13.5 6v2.25a2.25 2.25 0 0 0 2.25 2.25Z"></path>
								</svg>
								Novo Projeto
							</button>
							<ul class="dropdown-menu dropdown-menu-end">

								<?php if ($plan['fix_and_flip'] == 1) { ?>
								<li><a href="<?php echo RouteLink('search'); ?>" class="dropdown-item">Fix And Flip</a></li>
								<?php } ?>

								<?php if ($plan['custom_project'] == 1) { ?>
								<li><a href="<?php echo RouteLink('projects/new/custom'); ?>" class="dropdown-item">Projeto Personalizado</a></li>
								<?php } ?>

								<?php if ($plan['new_construction'] == 1) { ?>
								<li><a href="#" data-bs-toggle="modal" data-bs-target="#modalNewBuild" class="dropdown-item">Nova Construção</a></li>
								<?php } ?>
							</ul>
						</div>
					</div>
				</div>
				<?php if ($plan['new_construction'] == 1) { ?>
				<!-- Modal New Construction -->
				<div class="modal fade" id="modalNewBuild" tabindex="-1" aria-labelledby="modalNewBuildLabel" aria-hidden="true">
					<div class="modal-dialog modal-dialog-centered">
						<div class="modal-content">
							<div class="modal-body">
								<div class="row">
									<div class="col-12">
										<h1 class="title">Selecione o tipo:</h1>
									</div>
									<div class="col-6">
										<button onclick="Route('projects/new/build/cash')" data-bs-toggle="tooltip" data-bs-placement="bottom" data-bs-title="Investimento total com recursos próprios, sem custos de juros ou financiamento.">Cash</button>
									</div>
									<div class="col-6">
										<button onclick="Route('projects/new/build/financial')" data-bs-toggle="tooltip" data-bs-placement="bottom" data-bs-title="Parte do custo financiado, com menor investimento inicial e custos de juros sobre o valor emprestado.">Financial</button>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<?php } ?>
				<div style="margin-top: 25px" class="col-12">
					<div id="header__links" class="project__header">
						<div onclick="FilterProjects(1)" data-status="1" class="header__item header__active">
							<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
							  <path stroke-linecap="round" stroke-linejoin="round" d="M9 12h3.75M9 15h3.75M9 18h3.75m3 .75H18a2.25 2.25 0 0 0 2.25-2.25V6.108c0-1.135-.845-2.098-1.976-2.192a48.424 48.424 0 0 0-1.123-.08m-5.801 0c-.065.21-.1.433-.1.664 0 .414.336.75.75.75h4.5a.75.75 0 0 0 .75-.75 2.25 2.25 0 0 0-.1-.664m-5.8 0A2.251 2.251 0 0 1 13.5 2.25H15c1.012 0 1.867.668 2.15 1.586m-5.8 0c-.376.023-.75.05-1.124.08C9.095 4.01 8.25 4.973 8.25 6.108V8.25m0 0H4.875c-.621 0-1.125.504-1.125 1.125v11.25c0 .621.504 1.125 1.125 1.125h9.75c.621 0 1.125-.504 1.125-1.125V9.375c0-.621-.504-1.125-1.125-1.125H8.25ZM6.75 12h.008v.008H6.75V12Zm0 3h.008v.008H6.75V15Zm0 3h.008v.008H6.75V18Z"></path>
							</svg>
							Em análise
						</div>
						<div onclick="FilterProjects(2)" data-status="2" class="header__item">
							<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
							  <path stroke-linecap="round" stroke-linejoin="round" d="M20.25 14.15v4.25c0 1.094-.787 2.036-1.872 2.18-2.087.277-4.216.42-6.378.42s-4.291-.143-6.378-.42c-1.085-.144-1.872-1.086-1.872-2.18v-4.25m16.5 0a2.18 2.18 0 0 0 .75-1.661V8.706c0-1.081-.768-2.015-1.837-2.175a48.114 48.114 0 0 0-3.413-.387m4.5 8.006c-.194.165-.42.295-.673.38A23.978 23.978 0 0 1 12 15.75c-2.648 0-5.195-.429-7.577-1.22a2.016 2.016 0 0 1-.673-.38m0 0A2.18 2.18 0 0 1 3 12.489V8.706c0-1.081.768-2.015 1.837-2.175a48.111 48.111 0 0 1 3.413-.387m7.5 0V5.25A2.25 2.25 0 0 0 13.5 3h-3a2.25 2.25 0 0 0-2.25 2.25v.894m7.5 0a48.667 48.667 0 0 0-7.5 0M12 12.75h.008v.008H12v-.008Z"></path>
							</svg>
							Em negociação
						</div>
						<div onclick="FilterProjects(3)" data-status="3" class="header__item">
							<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
							  <path stroke-linecap="round" stroke-linejoin="round" d="M11.35 3.836c-.065.21-.1.433-.1.664 0 .414.336.75.75.75h4.5a.75.75 0 0 0 .75-.75 2.25 2.25 0 0 0-.1-.664m-5.8 0A2.251 2.251 0 0 1 13.5 2.25H15c1.012 0 1.867.668 2.15 1.586m-5.8 0c-.376.023-.75.05-1.124.08C9.095 4.01 8.25 4.973 8.25 6.108V8.25m8.9-4.414c.376.023.75.05 1.124.08 1.131.094 1.976 1.057 1.976 2.192V16.5A2.25 2.25 0 0 1 18 18.75h-2.25m-7.5-10.5H4.875c-.621 0-1.125.504-1.125 1.125v11.25c0 .621.504 1.125 1.125 1.125h9.75c.621 0 1.125-.504 1.125-1.125V18.75m-7.5-10.5h6.375c.621 0 1.125.504 1.125 1.125v9.375m-8.25-3 1.5 1.5 3-3.75"></path>
							</svg>
							Negócio feito
						</div>
						<div onclick="FilterProjects(4)" data-status="4" class="header__item">
							<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
							  <path stroke-linecap="round" stroke-linejoin="round" d="m20.25 7.5-.625 10.632a2.25 2.25 0 0 1-2.247 2.118H6.622a2.25 2.25 0 0 1-2.247-2.118L3.75 7.5m8.25 3v6.75m0 0-3-3m3 3 3-3M3.375 7.5h17.25c.621 0 1.125-.504 1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125Z"></path>
							</svg>
							Arquivado
						</div>
						<div onclick="FilterProjects(0)" data-status="0" class="header__item">
							<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
							  <path stroke-linecap="round" stroke-linejoin="round" d="m20.25 7.5-.625 10.632a2.25 2.25 0 0 1-2.247 2.118H6.622a2.25 2.25 0 0 1-2.247-2.118L3.75 7.5m8.25 3v6.75m0 0-3-3m3 3 3-3M3.375 7.5h17.25c.621 0 1.125-.504 1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125Z"></path>
							</svg>
							Rascunhos
						</div>
					</div>
				</div>
				<div style="margin-top: 35px;" class="col-12">
					<div class="project__rows">
						<div class="row" id="project__rows">

							<?php 

							$projectTypes = [
							    'search' => $plan['search'],
							    'fix_and_flip' => $plan['fix_and_flip'],
							    'build' => $plan['new_construction'],
							    'build_cash' => $plan['new_construction'],
							    'build_financial' => $plan['new_construction'],
							    'custom' => $plan['custom_project']
							];

							$activeProjectTypes = array_filter($projectTypes);
							$whereClause = "type IN ('" . implode("','", array_keys($activeProjectTypes)) . "')";

							$consulta = "SELECT * FROM projects WHERE user = '$userId' AND $whereClause ORDER BY updated_at DESC";
							$con = $conn->query($consulta) or die($conn->error);
							while($project = $con->fetch_array()) { 

								$project['profit'] = $project['price_arv'] - $project['rehab_total'] - $project['price_buy'] - $project['total_costs'];

		                        if (isset($project['picture']) && !empty($project['picture']) && $project['picture'] != '[]') {
		                            $picture_array = json_decode($project['picture'], true);
		                            $picture_dir = isset($picture_array[0]) ? $local['raiz'] . '/attachments/projects/' . $project['code'] . '/' . $picture_array[0] : 'https://i.ibb.co/VCTBHtj/nopic-1.png';

		                        } elseif (isset($project['api_pictures']) && !empty($project['api_pictures'])) {
		                            $picture_array = json_decode($project['api_pictures'], true);
		                            $picture_dir = isset($picture_array[0]['url']) ? $picture_array[0]['url'] : 'https://i.ibb.co/VCTBHtj/nopic-1.png';

		                        } else { $picture_dir = 'https://i.ibb.co/VCTBHtj/nopic-1.png'; }

							?>

							<div data-type="<?php echo $project['type']; ?>" 
								 id="projectRow__<?php echo $project['code']; ?>"
								 data-status="<?php echo $project['is_draft'] == 1 ? 0 : $project['status']; ?>" 
								 class="col-md-6 col-lg-4 col-xl-4 col-xxl-3 project__item">

								<div class="project__box">
									<div onclick="Route('<?php echo 'project/' . $project['code']; ?>')" class="project__picture">
										<div style="background: url('<?php echo $picture_dir; ?>');" class="picture__item"></div>
									</div>
									<div onclick="Route('<?php echo 'project/' . $project['code']; ?>')" class="project__content">
										<div class="project__location">
											<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
											  <path stroke-linecap="round" stroke-linejoin="round" d="M15 10.5a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z"></path>
											  <path stroke-linecap="round" stroke-linejoin="round" d="M19.5 10.5c0 7.142-7.5 11.25-7.5 11.25S4.5 17.642 4.5 10.5a7.5 7.5 0 1 1 15 0Z"></path>
											</svg>
											<div>
												<p class="location__address"><?php echo $project['address']; ?></p>
												<p class="location__city"><?php echo $project['city'] . ' ' . $project['county'] . ', ' . $project['zipcode']; ?></p>
											</div>
										</div>
										<div class="project__text">
											<div class="text__item">
												<p class="title">Criado em:</p>
												<p class="value"><?php echo date('M d, Y', strtotime($project['created_at'])); ?></p>
											</div>
											<?php if (in_array($project['type'], ['custom', 'fix_and_flip'])) { ?>
											<div class="text__item">
												<p class="title">Preço de compra:</p>
												<p class="value"><?php echo '$ ' . Money($project['price_buy']); ?></p>
											</div>
											<div class="text__item">
												<p class="title">Preço final (ARV):</p>
												<p class="value"><?php echo '$ ' . Money($project['price_arv']); ?></p>
											</div>
											<div class="text__item">
												<p class="title">Custo de reforma:</p>
												<p class="value"><?php echo '$ ' . Money($project['rehab_total']); ?></p>
											</div>
											<div class="text__item <?php echo $project['profit'] > 0 ? 'upColor' : 'downColor'; ?>" style="margin-top: 20px;">
												<p class="title">Lucro:</p>
												<p class="value"><?php echo '$ ' . Money($project['profit']); ?></p>
											</div>
											<div class="text__item <?php echo $project['profit'] > 0 ? 'upColor' : 'downColor'; ?>">
												<p class="title">% Lucro:</p>
												<p class="value"><?php echo $project['price_arv'] <= 0 ? '0%' : PercentToAmount($project['profit'], $project['price_arv'], true, true); ?></p>
											</div>
											<?php } ?>
											<?php if (in_array($project['type'], ['build_cash','build_financial'])) { ?>
											<div class="text__item">
												<p class="title">Custo de construção:</p>
												<p class="value"><?php echo '$ ' . Money($project['price_land'] + $project['price_build']); ?></p>
											</div>
											<div class="text__item">
												<p class="title">Preço de venda:</p>
												<p class="value"><?php echo '$ ' . Money($project['price_sell']); ?></p>
											</div>
											<?php 

												$buy_costs = json_decode($project['cash_buy'], true);
												$sell_costs = json_decode($project['cash_sell'], true);
												$project['profit'] = $project['price_sell'] - ($buy_costs['total'] + $sell_costs['total'] + $sell_costs['fee']['amount']); 

											?>
											<div class="text__item <?php echo $project['profit'] > 0 ? 'upColor' : 'downColor'; ?>" style="margin-top: 20px;">
												<p class="title">Lucro:</p>
												<p class="value"><?php echo '$ ' . Money($project['profit']); ?></p>
											</div>
											<div class="text__item <?php echo $project['profit'] > 0 ? 'upColor' : 'downColor'; ?>">
												<p class="title">% Lucro:</p>
												<p class="value"><?php echo $project['price_sell'] <= 0 ? '0%' : PercentToAmount($project['profit'], $project['price_sell'], true, true); ?></p>
											</div>
											<?php } ?>
										</div>
									</div>
									<div class="project__actions">
										<span data-bs-toggle="tooltip" onclick="Route('<?php echo 'project/' . $project['code']; ?>')" data-bs-placement="top" data-bs-title="Visualizar" class="show__row">
											<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
											  <path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 0 1 0-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178Z"></path>
											  <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z"></path>
											</svg></span>
										<span data-bs-toggle="tooltip" onclick="ChangeStatus('<?php echo $project['code'] ?>', <?php echo $project['is_draft'] == 1 ? 0 : $project['status']; ?>)" data-bs-placement="top" data-bs-title="Alterar o Status" class="status__row">
											<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
											  <path stroke-linecap="round" stroke-linejoin="round" d="M19.5 12c0-1.232-.046-2.453-.138-3.662a4.006 4.006 0 0 0-3.7-3.7 48.678 48.678 0 0 0-7.324 0 4.006 4.006 0 0 0-3.7 3.7c-.017.22-.032.441-.046.662M19.5 12l3-3m-3 3-3-3m-12 3c0 1.232.046 2.453.138 3.662a4.006 4.006 0 0 0 3.7 3.7 48.656 48.656 0 0 0 7.324 0 4.006 4.006 0 0 0 3.7-3.7c.017-.22.032-.441.046-.662M4.5 12l3 3m-3-3-3 3"></path>
											</svg></span>
										<?php 

											$edit_link = array(
											    'fix_and_flip' => 'fix-and-flip',
											    'custom' => 'custom',
											    'build_cash' => 'build/cash',
											    'build_financial' => 'build/financial',
											);

										?>
										<span data-bs-toggle="tooltip" onclick="Route('project/edit/<?php echo $edit_link[$project['type']]; ?>/<?php echo $project['code']; ?>')" data-bs-placement="top" data-bs-title="Editar" class="edit__row">
											<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
											  <path stroke-linecap="round" stroke-linejoin="round" d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10"></path>
											</svg></span>
										<span data-bs-toggle="tooltip" onclick="TrashProject('<?php echo $project['code'] ?>')" data-bs-placement="top" data-bs-title="Excluir" class="trash__row">
											<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
											  <path stroke-linecap="round" stroke-linejoin="round" d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0"></path>
											</svg></span>
									</div>
								</div>
							</div>

							<?php } ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

</body>
<script type="text/javascript">

	var current__type = 1;

	function FilterProjects(type) {

		const project__rows = document.getElementById('project__rows');
		const project__items = document.querySelectorAll('#project__rows .project__item');
		const menu__items = document.querySelectorAll('#header__links .header__item');

		current__type = type;

		menu__items.forEach(item => {

			if (item.dataset.status != current__type) { 
				item.classList.remove('header__active'); } 

			else { item.classList.add('header__active'); }

		});

		project__items.forEach(project => {
			if (project.dataset.status != current__type) {
				project.classList.add('row__hidden'); }

			else { project.classList.remove('row__hidden'); }
		});

	}

	FilterProjects(current__type);

	function ChangeStatus(code, current) {
		Swal.fire({
			icon: 'info',
			title: "Selecione o novo status",
			showCancelButton: true,
			confirmButtonColor: '#000',
			confirmButtonText: "Salvar",
			cancelButtonText: "Cancelar",
			focusCancel: true,
			html: `
				<select id="changeStatus__input">
					<option ${current === 1 ? 'checked' : ''} value="1">Em análise</option>
					<option ${current === 2 ? 'checked' : ''} value="2">Em negociação</option>
					<option ${current === 3 ? 'checked' : ''} value="3">Negócio feito</option>
					<option ${current === 4 ? 'checked' : ''} value="4">Arquivado</option>
					<option ${current === 0 ? 'checked' : ''} value="0">Rascunho</option>
				</select>
			`,
		}).then((result) => {
			if (result.isConfirmed) {
				const input_status = document.getElementById('changeStatus__input');
			    $.ajax({
					type: "POST",
					url: base_url + "/api/projects/changeStatus.php",
					data: { hash_code: code, new_status: input_status.value, },
					success: function(response) {

						// Sucesso
						if (response.status === 'success') {
							console.log(response);

							Swal.fire({
								icon: "success",
								title: "Sucesso!",
								timer: 2000,
								timerProgressBar: true,
								didOpen: () => { Swal.showLoading(); },
								willClose: () => { location.reload(); }
							}).then((result) => {});

						} else { console.log(response); }

					},
					error: function(xhr, status, error) {
					console.error("Erro:", error);
					}
			    });
			}
		});
	}

	function TrashProject(code) {
		Swal.fire({
			icon: 'warning',
			title: "Você tem certeza?",
			showCancelButton: true,
			confirmButtonColor: '#ea295e',
			confirmButtonText: "Excluir Projeto",
			cancelButtonText: "Cancelar",
			focusCancel: true,
		}).then((result) => {
			if (result.isConfirmed) {
			    $.ajax({
					type: "POST",
					url: base_url + "/api/projects/delete.php",
					data: { hash_code: code },
					success: function(response) {

						// Sucesso
						if (response.status === 'success') {
							console.log(response);

							// Remove o box do projeto
							document.getElementById('projectRow__' + code).remove();

							Swal.fire({
								icon: "success",
								title: "Sucesso!",
								timer: 2000,
								timerProgressBar: true,
								didOpen: () => { Swal.showLoading(); },
								willClose: () => {}
							}).then((result) => {});

						} else { console.log(response); }

					},
					error: function(xhr, status, error) {
					console.error("Erro:", error);
					}
			    });
			}
		});
	}

	const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
	const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))
	
</script>
</html>