<!DOCTYPE html>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php 

        $page_name = 'Planos'; 
        $profilePage = true;

    ?>

    <?php require_once __DIR__ . '/../../inc/conn.php'; ?>
    <?php require_once __DIR__ . '/../../inc/variables.php'; ?>

    <?php require_once __DIR__ . '/../../inc/cdns.php'; ?>
    <?php require_once __DIR__ . '/../../inc/styles.php'; ?>

    <title><?php echo $page_name . ' | ' . $app['name']; ?></title>

    <?php if (!isset($_SESSION['user'])) { Route('entrar'); } ?>

    <link rel="stylesheet" type="text/css" href="<?php echo $local['assets'] . '/css/plans.css'; ?>">

</head>
<body>

    <?php require_once __DIR__ . '/../layout/topbar.php'; ?>
    <div class="content">
        <div class="container">
            <div class="row">
                <?php if (!UserStatus()) { ?>
                <div class="col-12">
                    <div class="plan__expired">
                        &#x1F6A8;⠀
                        Sua assinatura está vencida desde <strong><?php echo date('d/m/Y', strtotime($user['next_payment'])); ?></strong>. Para continuar utilizando nossos serviços sem interrupções, por favor, renove seu plano.
                    </div>
                </div>
                <?php } ?>
                <div class="col-12">
                    <div class="header__content">
                        <div class="header__title">
                            <h1 class="title">Minha conta</h1>
                            <p class="subtitle">Gerencie as configurações e o faturamento da sua conta.</p>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="divider"></div>
                </div>
                <div class="col-12">
                    <div id="plans__box">
                        <div class="selector__box">
                            <div id="selector">
                                <?php 
                                $consulta = "SELECT DISTINCT(recurrence) FROM plans WHERE status != 0";
                                $con = $conn->query($consulta) or die($conn->error);
                                while($dado = $con->fetch_array()) { ?>
                                <button value="<?php echo $dado['recurrence']; ?>" class="<?php echo $dado['recurrence'] == 'monthly' ? 'active' : '' ?> selectType"><?php echo Translate(TagToText($dado['recurrence'])); ?></button>
                                <?php } ?>
                            </div>
                        </div>
                        <div id="plans__type">
                            <div class="row justify-content-center">
                                <?php 

                                function RecurrenceLabel($recurrence) {
                                    if ($recurrence == 'monthly') {
                                        return '/mês';
                                    } elseif ($recurrence == 'quarterly') {
                                        return '/trimestre';
                                    } elseif ($recurrence == 'semi-annual') {
                                        return '/semestre';
                                    } elseif ($recurrence == 'yearly') {
                                        return '/ano';
                                    }
                                }

                                $consulta = "SELECT * FROM plans WHERE status != 0 ORDER BY price";
                                $con = $conn->query($consulta) or die($conn->error);
                                while($plan = $con->fetch_array()) { ?>

                                <div data-type="<?php echo $plan['recurrence']; ?>" class="col-4 plan__column">
                                    <div class="plan__item <?php echo $plan['emphasis'] == 1 ? 'plan__popular' : ''; ?>">
                                        <div class="plan__content">
                                            <h3 class="plan__name"><?php echo $plan['name']; ?></h3>
                                            <p class="plan__desc"><?php echo $plan['description']; ?></p>
                                            <h2 class="plan__price"><?php echo '$' . Money($plan['price']); ?> <small><?php echo RecurrenceLabel($plan['recurrence']); ?></small></h2>
                                            <button onclick="Checkout(<?php echo $plan['id']; ?>, this)" class="plan__pay"><?php echo $user['plan'] == $plan['id'] ? 'Renovar' : 'Contratar'; ?></button>
                                        </div>
                                        <div class="plan__list">
                                            <ul>
                                                <?php 
                                                    if (!empty($plan['coverage'])) {
                                                        $coverage = json_decode($plan['coverage'], true);
                                                        foreach ($coverage AS $list) { ?>
                                                            <li class="<?php echo $list['status'] ? 'list__check' : 'list__xmark'; ?>">
                                                                <?php echo $list['status'] ? '<i class="fa-solid fa-check"></i>' : '<i class="fa-solid fa-xmark"></i>'; ?>
                                                                <?php echo $list['title']; ?>
                                                                <span data-bs-toggle="tooltip" data-bs-title="<?php echo $list['description']; ?>"><i class="fa-regular fa-circle-question"></i></span>
                                                            </li>
                                                        <?php }
                                                    }
                                                ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</body>
<script type="text/javascript">

function Checkout(plan_id, button) {

    const oldContent = button.innerHTML;
    button.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i>';

    $.ajax({
        type: "POST",
        url: base_url + "/api/payments/subscription.php",
        data: {
            plan: plan_id,
        },
        success: function(response) {

            if (response.status === 'success') {

                window.location.href = response.checkout;
                console.log(response);

            } else { console.log(response); button.innerHTML = oldContent; }

        },
        error: function(xhr, status, error) {
        console.error("Erro:", error);
        }
    });
    
}

document.addEventListener('DOMContentLoaded', function() {

    let current__type = 'monthly';

    buttonType = document.querySelectorAll('.selectType');
    buttonType.forEach((button) => {
        button.addEventListener('click', function() {
            ChangeType(button);
        });
    });

    function ChangeType(button) {
        allButtons = document.querySelectorAll('.selectType');
        allButtons.forEach((single) => { single.classList.remove('active'); });
        current__type = button.value;
        button.classList.add('active');
        FilterPlans();
    }

    function FilterPlans() {
        const plans = document.querySelectorAll('.plan__column');
        plans.forEach((plan) => {
            if (plan.dataset.type != current__type) {
                plan.style.display = 'none';
            } else {
                plan.style.display = 'flex';
            }
        });
    }

    FilterPlans();

    const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
    const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));

});
</script>
</html>