<!DOCTYPE html>
<html>
<head>

	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<?php $page_name = 'Recuperar Senha'; ?>

	<?php require_once __DIR__ . '/../../../inc/conn.php'; ?>
	<?php require_once __DIR__ . '/../../../inc/variables.php'; ?>

	<?php if (isset($_SESSION['user'])) { Route(''); } ?>

	<?php require_once __DIR__ . '/../../../inc/cdns.php'; ?>
	<?php require_once __DIR__ . '/../../../inc/styles.php'; ?>

	<link rel="stylesheet" type="text/css" href="<?php echo $local['assets'] . '/css/login.css'; ?>">
	<script type="text/javascript" src="<?php echo $local['assets'] . '/js/authentication/recovery.js'; ?>"></script>

	<title><?php echo $page_name . ' | ' . $app['name']; ?></title>

</head>
<body>
	<div class="container-fluid">
		<div class="row">
			<div class="mobile_hide col-sm-12 col-md-5 col-lg-6 col-xl-7 gx-0">
				<div class="left__box">
					<div style="background: url('https://i.ibb.co/Q9SR4k8/sunrise-5111409-1280.jpg');" class="left__wallpaper"></div>
				</div>
			</div>
			<div class="col-sm-12 col-md-7 col-lg-6 col-xl-5 gx-0">
				<div class="right__box">
					<div class="right__content">
						<form method="POST" onsubmit="verify__recovery(event)">
						
						<div class="logo__box">
							<img src="<?php echo $local['assets'] . '/marca/icone_dark.svg'; ?>">
						</div>

						<h1 class="login__title">Esqueci minha senha!</h1>
						<p class="login__subtitle">Insira abaixo o seu e-mail para recuperar:</p>

						<div class="input__box">
							<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
							  <path stroke-linecap="round" stroke-linejoin="round" d="M21.75 6.75v10.5a2.25 2.25 0 0 1-2.25 2.25h-15a2.25 2.25 0 0 1-2.25-2.25V6.75m19.5 0A2.25 2.25 0 0 0 19.5 4.5h-15a2.25 2.25 0 0 0-2.25 2.25m19.5 0v.243a2.25 2.25 0 0 1-1.07 1.916l-7.5 4.615a2.25 2.25 0 0 1-2.36 0L3.32 8.91a2.25 2.25 0 0 1-1.07-1.916V6.75"></path>
							</svg>
							<input maxlength="255" required placeholder="Digite seu e-mail" type="email" id="recovery__email">
						</div>

						<button id="login__button">
							RECUPERAR
						</button>

						<p class="login__register">Ou <a href="<?php echo RouteLink('entrar'); ?>">Faça Login</a></p>

						<p id="message__error"></p>

						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="copy__bar">
		<p>Feito com ❤️ por <?php echo $app['name']; ?>. Todos os direitos reservados © 2024.</p>
	</div>
</body>
</html>