<?php

// Abre a conexão com o banco de dados
require_once __DIR__ . '/inc/conn.php';

// Define as rotas e vincula os arquivos
$routes = array(

	// Estrutura
    '' 	            => 'pages/projects/index.php',
    'search'        => 'pages/search/index.php',

    // Projetos
    'projects'                          => 'pages/projects/index.php',
    'projects/new/fix-and-flip'         => 'pages/projects/new/fix-and-flip.php',
    'projects/new/custom'               => 'pages/projects/new/custom.php',
    'projects/new/build/cash'           => 'pages/projects/new/build/cash.php',
    'projects/new/build/financial'      => 'pages/projects/new/build/financial.php',

    // Autenticação
    'sair' 		=> 'pages/authentication/logout.php',
    'entrar' 	=> 'pages/authentication/login.php',
    'cadastrar' => 'pages/authentication/register.php',
    'app/perfil'  => 'pages/authentication/profile.php',
    'entrar/recuperar' => 'pages/authentication/recovery/first-step.php',
    'entrar/recuperar/alterar-senha' => 'pages/authentication/recovery/recovery.php',

    // Plan
    'app/plans'  => 'pages/payment/plans.php',
    'app/plans/success'  => 'pages/payment/success.php',
    'app/invoices'  => 'pages/payment/invoices.php',

);

// Verifica a rota atual
$page = isset($_GET['page']) ? $_GET['page'] : '';

// $consulta = "SELECT code FROM projects";
// $con = $conn->query($consulta) or die($conn->error);
// while($dado = $con->fetch_array()) {
//     $routes['project/' . $dado['code']] = 'pages/projects/show.php';
// }

$consulta = "SELECT code, type FROM projects";
$con = $conn->query($consulta) or die($conn->error);
while($dado = $con->fetch_array()) {

    if ($dado['type'] == 'build_cash') {
        $routes['project/' . $dado['code']] = 'api/projects/pdf_cash.php';
        $routes['project/edit/' . 'build/cash' . '/' . $dado['code']] = 'pages/projects/edit/' . 'build/cash' . '.php';
    } elseif ($dado['type'] == 'build_financial') {
        $routes['project/' . $dado['code']] = 'api/projects/pdf_financial.php';
        $routes['project/edit/' . 'build/financial' . '/' . $dado['code']] = 'pages/projects/edit/' . 'build/financial' . '.php';
    } else {
        $routes['project/' . $dado['code']] = 'api/projects/pdf.php';
        $routes['project/edit/' . str_replace('_', '-', $dado['type']) . '/' . $dado['code']] = 'pages/projects/edit/' . str_replace('_', '-', $dado['type']) . '.php';
    }

}

$consulta = "SELECT api_id FROM properties";
$con = $conn->query($consulta) or die($conn->error);
while($dado = $con->fetch_array()) {
    $routes['property/' . $dado['api_id']] = 'pages/properties/show.php';
}

// Roda a lógica das rotas
if (array_key_exists($page, $routes)) {
    
    $viewFile = __DIR__ . '/' . $routes[$page];
    
    if (file_exists($viewFile) && is_file($viewFile)) { include $viewFile; } 
    else { include __DIR__ . '/pages/layout/404.php'; }

} else { include __DIR__ . '/pages/layout/404.php'; }