<?php 

	require_once (__DIR__ . '/translate/dictionary.php');

	function RouteLink($route) {
		global $local;
		return $local['raiz'] . '/' . $route;
	}

	function Route($route) {
		global $local;
		echo '<script>window.location.href="' . $local['raiz'] . '/' . $route . '"</script>';
	}

	function FirstName($complet_name) {
	    $nameParts = explode(' ', $complet_name);
	    if (count($nameParts) > 1) {
	        return $nameParts[0];
	    } else { return $complet_name; }
	}

	function Money($value) {
		return number_format($value, 2, '.', ',');
	}

	function MoneyShow($value, $zero = 2) {
		return number_format($value, $zero, '.', ',');
	}

	function StatusFormat($status) {
		if ($status == 'for_rent') {
			return '<i class="fa-solid fa-circle fa-beat"></i>' . 'Aluguel disponível';
		} elseif ($status == 'for_sale') {
			return '<i class="fa-solid fa-circle fa-beat"></i>' . 'Venda disponível';
		} else if ($status == 'sold') {
			return '<i style="font-size: 1em; color: #DE574D;" class="fa-solid fa-circle-check"></i>' . 'Vendido';
		} else if ($status == 'FOR_SALE') {
			return '<i class="fa-solid fa-circle fa-beat"></i>' . 'Venda disponível';
		} else if ($status == 'FOR_RENT') {
			return '<i class="fa-solid fa-circle fa-beat"></i>' . 'Aluguel disponível';
		} else {
			return $status;
		}
	}

	function PercentToAmount($profit, $amount, $formatted = true, $symbol = false) {
	    if (!is_numeric($profit) || !is_numeric($amount) || $profit == 0) {
	        return "NaN"; }

	    $percentage = ($profit / $amount) * 100;

	    if ($symbol) {
	    	if ($percentage > 0) {
	    		$symbol = '<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true"><path stroke-linecap="round" stroke-linejoin="round" d="M2.25 18 9 11.25l4.306 4.306a11.95 11.95 0 0 1 5.814-5.518l2.74-1.22m0 0-5.94-2.281m5.94 2.28-2.28 5.941"></path></svg>';
	    	} else {
	    		$symbol = '<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true"> <path stroke-linecap="round" stroke-linejoin="round" d="M2.25 6 9 12.75l4.286-4.286a11.948 11.948 0 0 1 4.306 6.43l.776 2.898m0 0 3.182-5.511m-3.182 5.51-5.511-3.181"></path> </svg>'; }
	    } else {
	    	$symbol = '';
	    }

	    if ($formatted) {
	    	$formatted = '%';
	    } else {
	    	$formatted = '';
	    }

		return $symbol . number_format($percentage, 2, ',', '.') . $formatted;

	}

	function TagToText($text) {
		$removeSymbols = str_replace(['-', '_'], ' ', $text);
		return ucwords($removeSymbols);
	}

	function Translate($text) {
	    global $dictionary;

	    if (array_key_exists($text, $dictionary)) {
	        return $dictionary[$text];
	    }

	    foreach ($dictionary as $key => $value) {
	        if (strpos($key, ":") !== false) {
	            $pattern_isolated = '/(^|\n|\r|^)\s*' . preg_quote($key, '/') . '(?=:)/';
	            $text = preg_replace($pattern_isolated, '$1' . $value, $text);
	        }
	    }
	    
	    return $text;
	}

	function sqftToM2($sqft) {
	    $m2 = $sqft * 0.092903;
	    return round($m2);
	}

	function NumberColor($number) {
		if ($number > 0) {
			return 'green';
		} elseif ($number < 0) {
			return 'red';
		} else {
			return '#161617';
		}
	}

	function FormatPercentage($percentage) {
		return number_format($percentage, 2, ',', '.');
	}

?>

<script type="text/javascript">
	
	function Route(route) {
		window.location.href = base_url + '/' + route;
	}

	function FormatMoney(value) {
		return new Intl.NumberFormat('en', { style: 'currency', currency: 'USD'}).format(value);
	}

	function FormatPercentage(value) {
	    let cleanedValue = value.replace(/[^\d.-]/g, '');
	    let floatValue = parseFloat(cleanedValue);
	    let formattedPercentage = new Intl.NumberFormat('pt-BR', {
	        minimumFractionDigits: 2,
	        maximumFractionDigits: 2
	    }).format(floatValue) + '%';
	    return formattedPercentage;
	}

	function FormatDate(dataString, secound = true) {
		function padLeft(num) {
		    return num < 10 ? '0' + num : num; }
	    let data = new Date(dataString);
	    if (isNaN(data.getTime())) {
	        return ''; console.log('Data inválida: ' + dataString); }
	    let dia = padLeft(data.getDate());
	    let mes = padLeft(data.getMonth() + 1);
	    let ano = data.getFullYear();
	    let horas = padLeft(data.getHours());
	    let minutos = padLeft(data.getMinutes());
	    let segundos = padLeft(data.getSeconds());
	    return `${dia}/${mes}/${ano} ${horas}:${minutos}${secound === true ? ':' + segundos : '' }`;
	}

	function FormatMoneyToSql(number) {
	    let cleanSymbols = number.replace(/\$ /g, '');
	    let cleanSpaces = cleanSymbols.replace(/\$/g, '');
	    let cleanZeros = cleanSpaces.replace(/\,/g, '');
	    let formattedNumber = cleanZeros.replace('.', '.');
	    return formattedNumber;
	}

	function GetDate(formatted = true) {
		const timeElapsed = Date.now();
		const today = new Date(timeElapsed);
		return today.toUTCString();
	}

	function round(num, decimalPlaces) {
	    var factor = Math.pow(10, decimalPlaces);
	    return Math.round(num * factor) / factor;
	}

	function TypeToText(type) {
		if (type === 'rent') { 
			return 'Aluguel'; 

		} else if (type === 'sale') { 
			return 'Venda'; 

		} else { 
			return 'Vendido'; 
		}
	}

</script>