<?php

if (session_status() == PHP_SESSION_NONE) { session_start(); }
require_once __DIR__ . '/../../inc/conn.php';
require_once __DIR__ . '/../../assets/vendor/autoload.php';

$base_url = (in_array($_SERVER['HTTP_HOST'], ['localhost'], '192.168.0.11') ? 'http://' : 'https://') . (in_array($_SERVER['HTTP_HOST'], array('localhost', '192.168.0.111')) ? $_SERVER['HTTP_HOST'] . '/quick-realty' : $_SERVER['HTTP_HOST']);

$query_secret = "SELECT pay_api FROM config";
$result = $conn->query($query_secret);
$api_data = $result->fetch_assoc();

$api = json_decode($api_data['pay_api'], true);
// $config['api_pay'] = 'sk_test_51PHzozRxMBZIERtFyY1tZn8NzmZYXpBDr3KpI2UhISxGF6klF6Ha4cgIc1cMmjr4mmsYb71TXbymZrg4oKwiwPsx0004ZWu0ib';

// Verifica se o método é POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Pega os dados do usuário pela sessão
    $user_id = $_SESSION['user']['id'];
    $stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    $stmt->close();

    // Pega os dados do plano
    $plan_id = $_POST['plan'];
    $stmt = $conn->prepare("SELECT * FROM plans WHERE id = ?");
    $stmt->bind_param("i", $plan_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $plan = $result->fetch_assoc();
    $stmt->close();

    // Abre a instância Stripe
    $stripe = new \Stripe\StripeClient($api['secret']);

    // Verifica se já tem o custom id da Stripe, caso não tenha, cria um
    if (empty($user['pay_id'])) {
        try {

            // Cria o custom id na Stripe
            $customer = $stripe->customers->create([
              'name' => $user['name'],
              'email' => $user['mail'],
              'phone' => $user['telephone'],
            ]);

            // Pegar o ID do cliente criado
            $user['pay_id'] = $customer->id;

            $stmt = $conn->prepare("UPDATE users SET pay_id = ? WHERE id = ?");
            $stmt->bind_param("si", $user['pay_id'], $user_id);
            $stmt->execute();
            $stmt->close();

        } catch (\Stripe\Exception\ApiErrorException $e) {

            return json_encode(array(
                'status' => 'error',
                'message' => 'API Error > Create new custom',
                'details' => $e->getMessage(),
            ));

        }
    }

    // Verifica se já tem o price id no plano
    if (empty($plan['api_id'])) {
        try {

            $intervals = array(
                'yearly' => 12,
                'semi-annual' => 6,
                'quarterly' => 3,
                'monthly' => 1,
            );

            // Cria o price id na Stripe
            $create_plan = $stripe->prices->create([
              'currency' => 'usd',
              'unit_amount' => ($plan['price'] * 100),
              'recurring' => ['interval' => 'month', 'interval_count' => $intervals[$plan['recurrence']]],
              'product_data' => ['name' => $plan['name']],
            ]);

            // Pegar o ID do cliente criado
            $plan['api_id'] = $create_plan->id;

            $stmt = $conn->prepare("UPDATE plans SET api_id = ? WHERE id = ?");
            $stmt->bind_param("si", $plan['api_id'], $plan_id);
            $stmt->execute();
            $stmt->close();

        } catch (\Stripe\Exception\ApiErrorException $e) {

            return json_encode(array(
                'status' => 'error',
                'message' => 'API Error > Create price plan',
                'details' => $e->getMessage(),
            ));

        }
    }

    if (!empty($user['subscription'])) {
        try {
            $listSub = $stripe->subscriptions->all(['customer' => $user['pay_id']]);
            foreach ($listSub->data as $subscription) { $subscription->cancel(); }
        } catch (Exception $e) {
        }
    }

    try {

        $subscription = $stripe->checkout->sessions->create([
            'customer' => $user['pay_id'],
            'success_url' => $base_url . '/app/plans/success?r=' . strtotime('+30 minutes', time()),
            'line_items' => [
                [
                    'price' => $plan['api_id'],
                    'quantity' => 1,
                ],
            ],
            'mode' => 'subscription',
        ]);

    } catch (\Stripe\Exception\ApiErrorException $e) {

        return json_encode(array(
            'status' => 'error',
            'message' => 'API Error > Create price plan',
            'details' => $e->getMessage(),
        ));

    }

    // Enviar a response
    $response = array(
        'status' => 'success',
        'user' => $user['pay_id'],
        'plan' => $plan['api_id'],
        'checkout' => $subscription['url'],
    );

} else {
    $response = array(
        'code' => 400 ,
        'status' => 'error',
        'message' => 'invalid request method',
        'description' => 'The endpoint request method is invalid, check the documentation.',
    );
}

header('Content-Type: application/json');
echo json_encode($response);

?>