<?php

// Abre a conexão com o banco de dados
require_once __DIR__ . '/../inc/conn.php';

// Define as rotas e vincula os arquivos
$routes = array(

	// Estrutura
    'users/new' => 'authentication/register.php',
    'users/list' => 'users/list.php',
    'users/get' => 'users/get.php',
    'users/delete' => 'users/delete.php',
    'users/update' => 'users/update.php',

    // Permissions
    'permissions/list' => 'permissions/list.php',
    'permissions/user/get' => 'permissions/user_get.php',
    'permissions/user/update' => 'permissions/user_update.php',

    // Properties
    'properties/get' => 'properties/get.php',
    'properties/list' => 'properties/list.php',

    // Projects
    'projects/add' => 'projects/add.php',
    'projects/delete' => 'projects/delete.php',
    'projects/get' => 'projects/get.php',
    'projects/list' => 'projects/list.php',
    'projects/update' => 'projects/update.php',

    // Tasks
    'tasks/add' => 'tasks/add.php',
    'tasks/delete' => 'tasks/delete.php',
    'tasks/get' => 'tasks/get.php',
    'tasks/list' => 'tasks/list.php',
    'tasks/update' => 'tasks/update.php',

);

// Verifica a rota atual
$page = isset($_GET['page']) ? $_GET['page'] : '';

// Roda a lógica das rotas
if (array_key_exists($page, $routes)) {
    
    $viewFile = __DIR__ . '/' . $routes[$page];
    
    if (file_exists($viewFile) && is_file($viewFile)) { include $viewFile; } 
    else { include __DIR__ . '/../pages/layout/ForbidenApi.php'; }

} else { include __DIR__ . '/../pages/layout/ForbidenApi.php'; }