<?php

if (session_status() == PHP_SESSION_NONE) { session_start(); }
require_once __DIR__ . '/../../inc/conn.php';

// Verifica se o método é POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verifica se as chaves enviadas estão presentes
    if (isset($_POST['name']) && isset($_POST['mail']) && isset($_POST['password']) && isset($_POST['telephone'])) {        

        $name = mysqli_real_escape_string($conn, ucwords($_POST['name']));
        $mail = mysqli_real_escape_string($conn, $_POST['mail']);
        $password = mysqli_real_escape_string($conn, hash('sha256', $_POST['password']));
        $telephone = mysqli_real_escape_string($conn, str_replace(' ', '', $_POST['telephone']));

        $query = "SELECT * FROM users WHERE mail = '$mail' OR telephone = '$telephone'";
        $result = mysqli_query($conn, $query);

        if(mysqli_num_rows($result) > 0) {
            $response = [
                'status' => 'error',
                'message' => 'Email or telephone number already registered.'
            ];
        } else {

            $insertQuery = "INSERT INTO users (name, mail, password, telephone, next_payment) 
                            VALUES ('$name', '$mail', '$password', '$telephone', DATE_ADD(NOW(), INTERVAL 7 DAY));";
                            
            if(mysqli_query($conn, $insertQuery)) {
                $userId = mysqli_insert_id($conn);

                $userQuery = "SELECT * FROM users WHERE id = $userId";
                $userResult = mysqli_query($conn, $userQuery);
                if($user = mysqli_fetch_assoc($userResult)) {
                    $_SESSION['user'] = $user;

                    $response = [
                        'status' => 'success',
                        'message' => 'User registered successfully.',
                        'user_id' => $user['id']
                    ];
                } else {
                    $response = [
                        'status' => 'error',
                        'message' => 'Registered user, but there was an error retrieving data.'
                    ];
                }
            } else {
                $response = [
                    'status' => 'error',
                    'message' => 'Error registering user.'
                ];
            }
        }
    } else {
        $response = array(
            'code' => 400,
            'status' => 'error',
            'message' => 'missing required keys',
            'description' => 'One or more required keys are missing from the request. Please ensure all required data is included.',
        );
    }
} else {
    $response = array(
        'code' => 400 ,
        'status' => 'error',
        'message' => 'invalid request method',
        'description' => 'The endpoint request method is invalid, check the documentation.',
    );
}

header('Content-Type: application/json');
echo json_encode($response);

?>
