<!DOCTYPE html>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php 

        $page_name = 'Projetos';

        require_once __DIR__ . '/../../../../inc/conn.php';
        
        require_once __DIR__ . '/../../../inc/config.php';
        require_once __DIR__ . '/../../../inc/functions.php';

        CheckAuth();

        require_once __DIR__ . '/../../../../inc/cdns.php';
        require_once __DIR__ . '/../../../inc/styles.php';


    ?>

    <title><?php echo $page_name . ' | ' . $app['name']; ?></title>

    <script src="<?php echo $local['assets'] . '/js/functions.js'; ?>"></script>
    <link rel="stylesheet" type="text/css" href="<?php echo $local['assets'] . '/css/projects/list.css'; ?>">

    <!-- Datatables -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.8/css/dataTables.dataTables.min.css">

</head>
<body>

    <?php require_once __DIR__ . '/../layout/leftbar.php'; ?>
    <div class="content__box">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="row">
                        <div class="col-6 col-xl-3">
                            <div class="topbar__module">
                                <div class="module__icon">
                                    <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                      <path stroke-linecap="round" stroke-linejoin="round" d="M3.75 9.776c.112-.017.227-.026.344-.026h15.812c.117 0 .232.009.344.026m-16.5 0a2.25 2.25 0 0 0-1.883 2.542l.857 6a2.25 2.25 0 0 0 2.227 1.932H19.05a2.25 2.25 0 0 0 2.227-1.932l.857-6a2.25 2.25 0 0 0-1.883-2.542m-16.5 0V6A2.25 2.25 0 0 1 6 3.75h3.879a1.5 1.5 0 0 1 1.06.44l2.122 2.12a1.5 1.5 0 0 0 1.06.44H18A2.25 2.25 0 0 1 20.25 9v.776"></path>
                                    </svg>
                                </div>
                                <div class="module__content">
                                    <?php 

                                        $sql = "SELECT COUNT(*) AS total FROM projects WHERE status = 1 AND is_draft = 0";
                                        $result = $conn->query($sql);
                                        $row = $result->fetch_assoc();
                                        $total = isset($row['total']) ? $row['total'] : 0;

                                    ?>
                                    <p class="module__value animated_number"><?php echo $total; ?></p>
                                    <p class="module__title">Projetos</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="module">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Código</th>
                                    <th>Usuário</th>
                                    <th>Tipo</th>
                                    <th>Criação</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 

                                function ProjectType($type) {
                                    switch ($type) {
                                        case 'build_cash':
                                            return 'Cash';
                                            break;
                                        case 'build_financial':
                                            return 'Financial';
                                            break;
                                        case 'custom':
                                            return 'Custom';
                                            break;
                                        case 'fix_and_flip':
                                            return 'Fix and Flip';
                                            break;
                                    }
                                }

                                $consulta = "SELECT projects.*,
                                                    users.name AS user_name

                                                    FROM projects 
                                                    LEFT JOIN users ON users.id = projects.user

                                                    WHERE projects.status = 1
                                                    AND projects.is_draft = 0

                                                    ORDER BY id DESC";

                                $con = $conn->query($consulta) or die($conn->error);
                                while($project = $con->fetch_array()) { ?>

                                <tr id="<?php echo 'project__' . $project['id']; ?>">
                                    <td><?php echo '#' . $project['id']; ?></td>
                                    <td><?php echo $project['code']; ?></td>
                                    <td><?php echo $project['user_name']; ?></td>
                                    <td>
                                        <?php echo ProjectType($project['type']); ?>
                                    </td>
                                    <td>
                                        <?php echo date('d/m/Y', strtotime($project['created_at'])); ?>
                                    </td>
                                    <td class="td__actions">
                                        <label onclick="Open('<?php echo $project['code']; ?>')"> <!-- See -->
                                            <svg data-slot="icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                              <path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 0 1 0-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178Z"></path>
                                              <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z"></path>
                                            </svg>
                                        </label>
                                        <label onclick="Delete(<?php echo $project['id']; ?>)"> <!-- Trash -->
                                            <svg data-slot="icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                              <path stroke-linecap="round" stroke-linejoin="round" d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0"></path>
                                            </svg>
                                        </label>
                                    </td>
                                </tr>

                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

</body>
<script type="text/javascript" src="https://cdn.datatables.net/2.0.8/js/dataTables.min.js"></script>
<script type="text/javascript">

    function Open(code) {
        window.location.href = base_url_site + '/project/' + code;
    }

    function Delete(project_id) {
        Swal.fire({
            icon: 'warning',
            title: "Você tem certeza?",
            html: 'Essa ação é irreversível!',
            showCancelButton: true,
            confirmButtonText: "Excluir",
            cancelButtonText: "Cancelar",
        }).then((result) => {
            if (result.isConfirmed) {
                // Envia o AJAX 
                $.ajax({
                    type: "POST",
                    url: base_url + "/api/projects/delete.php",
                    data: { id: project_id },
                    success: function(response) {
                        console.log(response);

                        // Sucesso
                        if (response.status === 'success') {
                            const rowToDelete = document.getElementById('project__' + project_id);
                            rowToDelete.remove();
                            Swal.fire("Saved!", "", "success");
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error("Erro:", error);
                    }
                });
            }
        });
    }

    // Datatables    
    $(document).ready(function(){
        $('table').DataTable({
            language: {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "_START_ à _END_ de _TOTAL_ registros",
                "sInfoEmpty": "Nenhum registro",
                "sInfoFiltered": "(filtrado de _MAX_ registros)",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_ registros",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sSearch": "Pesquisar:",
                "sZeroRecords": "Nenhum registro encontrado",
                "oPaginate": {
                    "sFirst": "<<",
                    "sLast": ">>",
                    "sNext": ">",
                    "sPrevious": "<"
                },
                "oAria": {
                    "sSortAscending": ": ativar para ordenar a coluna em ordem crescente",
                    "sSortDescending": ": ativar para ordenar a coluna em ordem decrescente"
                }
            },
            dom: '<"top"rt><"dt__bottom"ipf><"clear">',
            order: [[0, 'desc']]
        });

        $('.dt-search input').attr('placeholder', 'Pesquisar');
    });

</script>
</html>