<!DOCTYPE html>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php 

        $page_name = 'Financeiro';

        require_once __DIR__ . '/../../../../inc/conn.php';
        
        require_once __DIR__ . '/../../../inc/config.php';
        require_once __DIR__ . '/../../../inc/functions.php';

        CheckAuth();

        require_once __DIR__ . '/../../../../inc/cdns.php';
        require_once __DIR__ . '/../../../inc/styles.php';


    ?>

    <title><?php echo $page_name . ' | ' . $app['name']; ?></title>

    <script src="<?php echo $local['assets'] . '/js/functions.js'; ?>"></script>
    <link rel="stylesheet" type="text/css" href="<?php echo $local['assets'] . '/css/financial/list.css'; ?>">

    <!-- Datatables -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.8/css/dataTables.dataTables.min.css">

</head>
<body>

    <?php require_once __DIR__ . '/../layout/leftbar.php'; ?>
    <div class="content__box">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="row">
                        <?php 

                            $sql = "
                                SELECT
                                    SUM(CASE WHEN u.plan != 0 THEN 1 ELSE 0 END) AS active_plans_count,
                                    COUNT(CASE WHEN u.plan = 0 THEN 1 ELSE NULL END) AS free_plans_count,
                                    SUM(p.price) AS total_revenue,
                                    SUM(CASE WHEN p.recurrence = 'monthly' THEN p.price ELSE 0 END) AS monthly_revenue,
                                    SUM(CASE WHEN p.recurrence = 'yearly' THEN p.price ELSE 0 END) AS yearly_revenue,
                                    SUM(CASE WHEN p.recurrence = 'quarterly' THEN p.price ELSE 0 END) AS quarterly_revenue,
                                    SUM(CASE WHEN p.recurrence = 'semi-annual' THEN p.price ELSE 0 END) AS semi_annual_revenue
                                FROM
                                    users u
                                INNER JOIN
                                    plans p ON u.plan = p.id
                                WHERE
                                    u.status = 1;
                            ";

                            $result = $conn->query($sql);

                            if ($result->num_rows > 0) {
                                $row = $result->fetch_assoc();

                                // Atribuir os resultados às variáveis
                                $active_plans_count = $row['active_plans_count'];
                                $free_plans_count = $row['free_plans_count'];
                                $total_revenue = $row['total_revenue'];
                                $monthly_revenue = $row['monthly_revenue'];
                                $yearly_revenue = $row['yearly_revenue'];
                                $quarterly_revenue = $row['quarterly_revenue'];
                                $semi_annual_revenue = $row['semi_annual_revenue'];

                            }

                        ?>
                        <div class="col-6 col-xl-3">
                            <div class="topbar__module">
                                <div class="module__icon">
                                    <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                      <path stroke-linecap="round" stroke-linejoin="round" d="M11.48 3.499a.562.562 0 0 1 1.04 0l2.125 5.111a.563.563 0 0 0 .475.345l5.518.442c.499.04.701.663.321.988l-4.204 3.602a.563.563 0 0 0-.182.557l1.285 5.385a.562.562 0 0 1-.84.61l-4.725-2.885a.562.562 0 0 0-.586 0L6.982 20.54a.562.562 0 0 1-.84-.61l1.285-5.386a.562.562 0 0 0-.182-.557l-4.204-3.602a.562.562 0 0 1 .321-.988l5.518-.442a.563.563 0 0 0 .475-.345L11.48 3.5Z"></path>
                                    </svg>
                                </div>
                                <div class="module__content">
                                    <p class="module__value animated_number">
                                        <?php echo $active_plans_count ? $active_plans_count : 0; ?>
                                    </p>
                                    <p class="module__title">Planos Ativos</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-6 col-xl-3">
                            <div class="topbar__module">
                                <div class="module__icon">
                                    <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                      <path stroke-linecap="round" stroke-linejoin="round" d="M11.48 3.499a.562.562 0 0 1 1.04 0l2.125 5.111a.563.563 0 0 0 .475.345l5.518.442c.499.04.701.663.321.988l-4.204 3.602a.563.563 0 0 0-.182.557l1.285 5.385a.562.562 0 0 1-.84.61l-4.725-2.885a.562.562 0 0 0-.586 0L6.982 20.54a.562.562 0 0 1-.84-.61l1.285-5.386a.562.562 0 0 0-.182-.557l-4.204-3.602a.562.562 0 0 1 .321-.988l5.518-.442a.563.563 0 0 0 .475-.345L11.48 3.5Z"></path>
                                    </svg>
                                </div>
                                <div class="module__content">
                                    <p class="module__value animated_number">
                                        <?php echo $free_plans_count ? $free_plans_count : 0; ?>
                                    </p>
                                    <p class="module__title">Usuários Testando</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-6 col-xl-3">
                            <div class="topbar__module">
                                <div class="module__icon">
                                    <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                      <path stroke-linecap="round" stroke-linejoin="round" d="M12 6v12m-3-2.818.879.659c1.171.879 3.07.879 4.242 0 1.172-.879 1.172-2.303 0-3.182C13.536 12.219 12.768 12 12 12c-.725 0-1.45-.22-2.003-.659-1.106-.879-1.106-2.303 0-3.182s2.9-.879 4.006 0l.415.33M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z"></path>
                                    </svg>
                                </div>
                                <div class="module__content">
                                    <p class="module__value">
                                        <?php echo $total_revenue ? '$ ' . number_format($total_revenue, 2, '.', ',') : '$ 0.00'; ?>
                                    </p>
                                    <p class="module__title">Rendimento Total</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-12"></div>
                        <div class="col-6 col-xl-3">
                            <div class="topbar__module">
                                <div class="module__icon">
                                    <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                      <path stroke-linecap="round" stroke-linejoin="round" d="M6.75 3v2.25M17.25 3v2.25M3 18.75V7.5a2.25 2.25 0 0 1 2.25-2.25h13.5A2.25 2.25 0 0 1 21 7.5v11.25m-18 0A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75m-18 0v-7.5A2.25 2.25 0 0 1 5.25 9h13.5A2.25 2.25 0 0 1 21 11.25v7.5m-9-6h.008v.008H12v-.008ZM12 15h.008v.008H12V15Zm0 2.25h.008v.008H12v-.008ZM9.75 15h.008v.008H9.75V15Zm0 2.25h.008v.008H9.75v-.008ZM7.5 15h.008v.008H7.5V15Zm0 2.25h.008v.008H7.5v-.008Zm6.75-4.5h.008v.008h-.008v-.008Zm0 2.25h.008v.008h-.008V15Zm0 2.25h.008v.008h-.008v-.008Zm2.25-4.5h.008v.008H16.5v-.008Zm0 2.25h.008v.008H16.5V15Z"></path>
                                    </svg>
                                </div>
                                <div class="module__content">
                                    <p class="module__value">
                                        <?php echo $monthly_revenue ? '$ ' . number_format($monthly_revenue, 2, '.', ',') : '$ 0.00'; ?>
                                    </p>
                                    <p class="module__title">Rendimento Mensal</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-6 col-xl-3">
                            <div class="topbar__module">
                                <div class="module__icon">
                                    <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                      <path stroke-linecap="round" stroke-linejoin="round" d="M6.75 3v2.25M17.25 3v2.25M3 18.75V7.5a2.25 2.25 0 0 1 2.25-2.25h13.5A2.25 2.25 0 0 1 21 7.5v11.25m-18 0A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75m-18 0v-7.5A2.25 2.25 0 0 1 5.25 9h13.5A2.25 2.25 0 0 1 21 11.25v7.5m-9-6h.008v.008H12v-.008ZM12 15h.008v.008H12V15Zm0 2.25h.008v.008H12v-.008ZM9.75 15h.008v.008H9.75V15Zm0 2.25h.008v.008H9.75v-.008ZM7.5 15h.008v.008H7.5V15Zm0 2.25h.008v.008H7.5v-.008Zm6.75-4.5h.008v.008h-.008v-.008Zm0 2.25h.008v.008h-.008V15Zm0 2.25h.008v.008h-.008v-.008Zm2.25-4.5h.008v.008H16.5v-.008Zm0 2.25h.008v.008H16.5V15Z"></path>
                                    </svg>
                                </div>
                                <div class="module__content">
                                    <p class="module__value">
                                        <?php echo $quarterly_revenue ? '$ ' . number_format($quarterly_revenue, 2, '.', ',') : '$ 0.00'; ?>
                                    </p>
                                    <p class="module__title">Rendimento Trimestral</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-6 col-xl-3">
                            <div class="topbar__module">
                                <div class="module__icon">
                                    <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                      <path stroke-linecap="round" stroke-linejoin="round" d="M6.75 3v2.25M17.25 3v2.25M3 18.75V7.5a2.25 2.25 0 0 1 2.25-2.25h13.5A2.25 2.25 0 0 1 21 7.5v11.25m-18 0A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75m-18 0v-7.5A2.25 2.25 0 0 1 5.25 9h13.5A2.25 2.25 0 0 1 21 11.25v7.5m-9-6h.008v.008H12v-.008ZM12 15h.008v.008H12V15Zm0 2.25h.008v.008H12v-.008ZM9.75 15h.008v.008H9.75V15Zm0 2.25h.008v.008H9.75v-.008ZM7.5 15h.008v.008H7.5V15Zm0 2.25h.008v.008H7.5v-.008Zm6.75-4.5h.008v.008h-.008v-.008Zm0 2.25h.008v.008h-.008V15Zm0 2.25h.008v.008h-.008v-.008Zm2.25-4.5h.008v.008H16.5v-.008Zm0 2.25h.008v.008H16.5V15Z"></path>
                                    </svg>
                                </div>
                                <div class="module__content">
                                    <p class="module__value">
                                        <?php echo $semi_annual_revenue ? '$ ' . number_format($semi_annual_revenue, 2, '.', ',') : '$ 0.00'; ?>
                                    </p>
                                    <p class="module__title">Rendimento Semestral</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-6 col-xl-3">
                            <div class="topbar__module">
                                <div class="module__icon">
                                    <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                      <path stroke-linecap="round" stroke-linejoin="round" d="M6.75 3v2.25M17.25 3v2.25M3 18.75V7.5a2.25 2.25 0 0 1 2.25-2.25h13.5A2.25 2.25 0 0 1 21 7.5v11.25m-18 0A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75m-18 0v-7.5A2.25 2.25 0 0 1 5.25 9h13.5A2.25 2.25 0 0 1 21 11.25v7.5m-9-6h.008v.008H12v-.008ZM12 15h.008v.008H12V15Zm0 2.25h.008v.008H12v-.008ZM9.75 15h.008v.008H9.75V15Zm0 2.25h.008v.008H9.75v-.008ZM7.5 15h.008v.008H7.5V15Zm0 2.25h.008v.008H7.5v-.008Zm6.75-4.5h.008v.008h-.008v-.008Zm0 2.25h.008v.008h-.008V15Zm0 2.25h.008v.008h-.008v-.008Zm2.25-4.5h.008v.008H16.5v-.008Zm0 2.25h.008v.008H16.5V15Z"></path>
                                    </svg>
                                </div>
                                <div class="module__content">
                                    <p class="module__value">
                                        <?php echo $yearly_revenue ? '$ ' . number_format($yearly_revenue, 2, '.', ',') : '$ 0.00'; ?>
                                    </p>
                                    <p class="module__title">Rendimento Anual</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="module">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Preço</th>
                                    <th>Plano</th>
                                    <th>Usuário</th>
                                    <th>Ultimo Pag.</th>
                                    <th>Próx. Pag.</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $consulta = "SELECT users.*,
                                                    plans.name AS plan_name,
                                                    plans.recurrence AS plan_recurrence,
                                                    plans.price AS plan_price

                                                    FROM users
                                                    LEFT JOIN plans ON plans.id = users.plan

                                                    WHERE users.plan != 0";

                                $con = $conn->query($consulta) or die($conn->error);
                                while($user = $con->fetch_array()) { ?>

                                    <tr>
                                        <td><?php echo '#' . $user['id']; ?></td>
                                        <td><?php echo !empty($user['plan_price']) ? '$ ' . number_format($user['plan_price'], 2, '.', ',') : 'Grátis'; ?></td>
                                        <td><?php echo $user['plan_name'] . ' - ' . ucfirst($user['plan_recurrence']); ?></td>
                                        <td><a target="_blank" href="<?php echo $base_url . '/users/' . $user['id'] ?>"><?php echo $user['name']; ?></a></td>
                                        <td><?php echo !empty($user['last_payment']) ? date('d/m/Y', strtotime($user['last_payment'])) : ''; ?></td>
                                        <td><?php echo !empty($user['next_payment']) ? date('d/m/Y', strtotime($user['next_payment'])) : ''; ?></td>
                                    </tr>

                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

</body>
<script type="text/javascript" src="https://cdn.datatables.net/2.0.8/js/dataTables.min.js"></script>
<script type="text/javascript">

    // Datatables    
    $(document).ready(function(){
        $('table').DataTable({
            language: {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "_START_ à _END_ de _TOTAL_ registros",
                "sInfoEmpty": "Nenhum registro",
                "sInfoFiltered": "(filtrado de _MAX_ registros)",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_ registros",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sSearch": "Pesquisar:",
                "sZeroRecords": "Nenhum registro encontrado",
                "oPaginate": {
                    "sFirst": "<<",
                    "sLast": ">>",
                    "sNext": ">",
                    "sPrevious": "<"
                },
                "oAria": {
                    "sSortAscending": ": ativar para ordenar a coluna em ordem crescente",
                    "sSortDescending": ": ativar para ordenar a coluna em ordem decrescente"
                }
            },
            dom: '<"top"rt><"dt__bottom"ipf><"clear">',
            order: [[5, 'desc']]
        });

        $('.dt-search input').attr('placeholder', 'Pesquisar');
    });

</script>
</html>