<?php

    session_start();
    require_once __DIR__ . '/../../../inc/conn.php';

    // Verifica se o 'id' foi enviado
    if (!isset($_POST['id']) || empty(trim($_POST['id']))) {
        $response = array(
            'code' => 400,
            'status' => 'error',
            'message' => 'User ID not provided.',
        );
    } else {
        $user_id = $_POST['id'];

        if ($conn->connect_error) {
            $response = array(
                'code' => 500,
                'status' => 'error',
                'message' => 'Connection error',
                'description' => $conn->connect_error,
            );
        } else {
            // Inicializa um array para armazenar os campos a serem atualizados
            $fieldsToUpdate = [];
            $params = [];
            $paramTypes = '';

            // Verifica e adiciona os campos não vazios ao array de atualização
            if (isset($_POST['user']['mail']) && !empty(trim($_POST['user']['mail']))) {
                $fieldsToUpdate[] = "mail = ?";
                $params[] = $_POST['user']['mail'];
                $paramTypes .= 's'; // 's' indica string
            }

            // Verifica e adiciona os campos não vazios ao array de atualização
            if (isset($_POST['user']['plan'])) {
                $fieldsToUpdate[] = "plan = ?";
                $params[] = $_POST['user']['plan'];
                $paramTypes .= 'i'; // 's' indica string
            }

            // Verifica e adiciona os campos não vazios ao array de atualização
            if (isset($_POST['user']['status'])) {
                $fieldsToUpdate[] = "status = ?";
                $params[] = $_POST['user']['status'];
                $paramTypes .= 'i'; // 'i' indica inteiro
            }
            
            if (isset($_POST['telephone']) && !empty(trim($_POST['telephone']))) {
                $fieldsToUpdate[] = "telephone = ?";
                $params[] = $_POST['telephone'];
                $paramTypes .= 's';
            }
            
            if (isset($_POST['user']['name']) && !empty(trim($_POST['user']['name']))) {
                $fieldsToUpdate[] = "name = ?";
                $params[] = $_POST['user']['name'];
                $paramTypes .= 's';
            }

            if (empty($fieldsToUpdate)) {
                $response = array(
                    'code' => 400,
                    'status' => 'error',
                    'message' => 'No valid fields provided for update.',
                );
            } else {
                // Constrói a consulta SQL dinamicamente
                $sql = "UPDATE users SET " . implode(', ', $fieldsToUpdate) . " WHERE id = ?";
                $params[] = $user_id;
                $paramTypes .= 'i';
                
                $stmt_update = $conn->prepare($sql);
                $stmt_update->bind_param($paramTypes, ...$params);
                $stmt_update->execute();

                if ($stmt_update->affected_rows > 0) {
                    $response = array(
                        'code' => 200,
                        'status' => 'success',
                        'message' => 'User updated successfully.',
                    );
                } else {
                    $response = array(
                        'code' => 304, // Not Modified
                        'status' => 'error',
                        'message' => 'User not updated or does not exist.',
                        'post' => json_encode($_POST),
                    );
                }
            }
        }
    }

    header('Content-Type: application/json');
    echo json_encode($response);

?>