<!DOCTYPE html>
<html>
<head>

	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<?php 

		// Configuration files
		require_once __DIR__ . '/../../inc/conn.php';
		require_once __DIR__ . '/../../inc/config.php';

		// Styling files
		require_once __DIR__ . '/../../inc/cdns.php';
		require_once __DIR__ . '/../../inc/functions.php';

	?>

	<link rel="stylesheet" type="text/css" href="<?php echo $local['source'] . '/assets/vars.css'; ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo $local['source'] . '/assets/css/home.css'; ?>">

</head>
<body>
	<?php require_once __DIR__ . '/../templates/topbar.php'; ?>
	<div class="content__box">		
		<div class="header">
			<div style="margin-top: -35px;" id="banner">
				<div class="banner__background"></div>
				<div class="banner__backdrop"></div>
				<div class="banner__content">
					<h1 class="title">Encontre o veículo perfeito para você!</h1>
					<p class="subtitle">Consulte carros novos, seminovos e usados com o melhor preço</p>
				</div>
			</div>
			<div id="search__box">
				<div class="row">
					<div class="col-12">
						<div id="type__box" class="search__type">
							<div onclick="SearchType('car', this)" class="type__item type__active">
								Comprar carros
							</div>
							<div onclick="SearchType('motorcycle', this)" class="type__item">
								Comprar motos
							</div>
							<div onclick="SearchType('boat', this)" class="type__item">
								Comprar barcos
							</div>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-12 col-md-9">
						<div class="search__input">
							<i class="fa-solid fa-magnifying-glass"></i>
							<input type="search" placeholder="Digite a marca ou modelo" id="search__query" onkeydown="if(event.key === 'Enter') Search()">
							<input type="hidden" id="search__type" value="car">
						</div>
					</div>
					<div class="col-12 col-md-3">
						<button onclick="Search()" id="search__submit">Ver ofertas</button>
					</div>
				</div>
			</div>
		</div>
		<div style="margin-top: 65px;" id="category__banners">
			<div class="container">
				<div class="row">
					<div class="col-12">
						<center>
							<h1 class="title">Categorias</h1>
							<div style="margin-bottom: 0px;" class="title__divider"></div>
						</center>
					</div>
					<div style="margin-top: 20px;" class="col-12">
						<div class="swiper" id="categorys__swiper">
							<div class="swiper-wrapper">
								<?php 
								$consulta = "SELECT * FROM categories WHERE status = 1 ORDER BY hits DESC";
								$con = $conn->query($consulta) or die($conn->error);
								while($category = $con->fetch_array()) { ?>
								<div class="swiper-slide ">
									<a onclick="CategoryHit(<?php echo $category['id']; ?>)" target="_blank" href="<?php echo Route('search?cn=' . $category['name'] . '&ci=' . $category['id']); ?>">
										<div style="background: url('<?php echo $local['assets'] . '/attachments/categories/' . $category['file']; ?>');" class="category__item">
											<div class="backdrop__blur"></div>
											<h1><?php echo $category['name']; ?></h1>
										</div>
									</a>
								</div>
								<?php } ?>
							</div>
						</div>
					</div>
					<script type="text/javascript">
						// Categorys: Inicializa o slider
						const categorys__swiper = new Swiper('#categorys__swiper', {
							autoplay: { delay: 5000 },
							slidesPerView: 5,
							spaceBetween: 1,
							loop: true,
							breakpoints: {
								100: {
								  slidesPerView: 2,
								  spaceBetween: 10,
								  centeredSlides: true,
								},
								540: {
								  slidesPerView: 2,
								  spaceBetween: 10,
								  centeredSlides: false,
								},
								810: {
								  slidesPerView: 3,
								  spaceBetween: 20,
								  centeredSlides: true,
								},
								1080: {
								  slidesPerView: 4,
								  spaceBetween: 20,
								  centeredSlides: true,
								},
								1250: {
								  slidesPerView: 5,
								  spaceBetween: 20,
								  centeredSlides: true,
								},
								1650: {
								  slidesPerView: 5,
								  spaceBetween: 20,
								  centeredSlides: true,
								}
							},
							autoHeight: true,
						});
					</script>
				</div>
			</div>
		</div>
		<div style="margin-top: 65px;" id="brand__banners">
			<div class="container">
				<div class="row">
					<div class="col-12">
						<center>
							<h1 class="title">Principais marcas</h1>
							<div style="margin-bottom: 0px;" class="title__divider"></div>
						</center>
					</div>
					<div style="margin-top: 20px;" class="col-12">
						<div class="swiper" id="brands__swiper">
							<div class="swiper-wrapper">
								<?php 

								$consulta = "SELECT * FROM brands WHERE `file` IS NOT NULL ORDER BY hits DESC";
								$con = $conn->query($consulta) or die($conn->error);
								while($brand = $con->fetch_array()) { ?>
								<div class="swiper-slide ">
									<a onclick="BrandHit(<?php echo $brand['id']; ?>)" target="_blank" href="<?php echo Route('search?bn=' . $brand['name'] . '&bi=' . $brand['id']); ?>">
										<div class="brand__item">
											<img alt="<?php echo $brand['name']; ?>" src="<?php echo $local['assets'] . '/attachments/brands/' . $brand['file']; ?>">
										</div>
									</a>
								</div>
								<?php } ?>
							</div>
						</div>
					</div>
					<script type="text/javascript">
						// Brands: Inicializa o slider
						const brands__swiper = new Swiper('#brands__swiper', {
							autoplay: { delay: 5000 },
							slidesPerView: 8,
							spaceBetween: 1,
							loop: true,
							breakpoints: {
								100: {
								  slidesPerView: 3,
								  spaceBetween: 10,
								  centeredSlides: true,
								},
								540: {
								  slidesPerView: 3,
								  spaceBetween: 10,
								  centeredSlides: false,
								},
								810: {
								  slidesPerView: 4,
								  spaceBetween: 20,
								  centeredSlides: true,
								},
								1080: {
								  slidesPerView: 6,
								  spaceBetween: 20,
								  centeredSlides: true,
								},
								1250: {
								  slidesPerView: 7,
								  spaceBetween: 20,
								  centeredSlides: true,
								},
								1650: {
								  slidesPerView: 8,
								  spaceBetween: 20,
								  centeredSlides: true,
								}
							},
							autoHeight: true,
						});
					</script>
				</div>
			</div>
		</div>
		<div style="margin-top: 65px;" id="car__carousel">
			<div class="container">
				<div class="row">
					<div class="col-12">
						<center>
							<h1 class="title">Carros</h1>
							<div style="margin-bottom: 0px;" class="title__divider"></div>
						</center>
					</div>
					<div style="margin-top: 35px;" class="col-12">

						<div class="swiper" id="cars__swiper">
							<div class="swiper-wrapper">
								<?php 

								$consulta = "SELECT vehicles.*,
													brands.name AS brand_name 

													FROM vehicles 
													LEFT JOIN brands ON brands.id = vehicles.brand

													WHERE status = 1
													AND vehicles.type = 'car' 
													ORDER BY hits DESC, inserted_at DESC
													LIMIT 10";

								$con = $conn->query($consulta) or die($conn->error);
								while($vehicle = $con->fetch_array()) { 

									if (!empty($vehicle['photos'])) {
										$vehicle['photos'] = json_decode($vehicle['photos'], true);
										$attachment = $local['assets'] . '/attachments/vehicles/' . $vehicle['code'];
									}

								?>
								<div class="swiper-slide ">
									<div class="vehicle__item">
										<div onclick="Route('<?php echo VehicleRoute($vehicle); ?>')" class="vehicle__picture">
											<div 
												 <?php if (isset($vehicle['photos'][1])) { ?>
											 	 onmouseenter="HoverPicture('enter', '<?php echo $attachment . '/' . $vehicle['photos'][1] ?>', this)" 
												 <?php } ?>

												 <?php if (isset($vehicle['photos'][0])) { ?>
												 onmouseleave="HoverPicture('leave', '<?php echo $attachment . '/' . $vehicle['photos'][0] ?>', this)" 
												 <?php } ?>

												 style="background: url('<?php echo isset($vehicle['photos'][0]) ? $attachment . '/' . $vehicle['photos'][0] : 'https://i.ibb.co/sWStrwH/no-picture-1.png'; ?>');" 
												 class="picture__item"
											></div>
										</div>
										<div class="vehicle__details">
											<h3 onclick="Route('<?php echo VehicleRoute($vehicle); ?>')" class="vehicle__title"><?php echo strtoupper($vehicle['brand_name'] . ' ' . $vehicle['model']); ?></h3>
											<p onclick="Route('<?php echo VehicleRoute($vehicle); ?>')" class="vehicle__attributes"><?php echo strtoupper($vehicle['engine'] . ' ' . $vehicle['fuel'] . ' ' . $vehicle['transmission']); ?></p>
											<h2 class="vehicle__price"><?php echo 'USD ' . Money($vehicle['price']); ?></h2>
											<div class="vehicle__statistics">
												<p class="vehicle__year">
													<svg viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg">
														<path d="M8.4115 4.32167C8.7025 4.24067 8.4085 4.32067 8.7305 4.26067C9.7425 4.07267 10.9105 3.98667 12.2495 3.98667C12.8945 3.98667 13.4995 4.00667 14.0665 4.04767" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M12.2495 22.5345C5.29446 22.5345 2.97546 20.2165 2.97546 13.2605C2.97546 9.13348 3.79146 6.63848 5.90846 5.29248" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M16.2706 4.36572C20.1326 5.26572 21.5246 7.87072 21.5246 13.2607C21.5246 19.1167 19.8806 21.6857 15.2096 22.3517" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M3.25037 9.80884H21.2584" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M16.6533 13.7458H16.6623" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M12.2544 13.7458H12.2634" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M7.84645 13.7458H7.85545" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M16.6533 17.5979H16.6623" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M12.2544 17.5979H12.2634" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M7.84645 17.5979H7.85545" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M16.2584 2.53491V5.79691" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M8.25037 2.53491V5.79691" stroke-linecap="round" stroke-linejoin="round"/></svg>
													<?php echo Year($vehicle); ?>
												</p>
												<p class="vehicle__mileage">
													<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
														<path d="M6.979 4.60132V17.2193" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M2.8999 8.69998C2.8999 8.69998 5.0689 4.59998 6.9779 4.59998C8.8859 4.59998 11.0559 8.69998 11.0559 8.69998" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M16.9058 19.4274V6.80945" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M20.9849 15.3284C20.9849 15.3284 18.8149 19.4284 16.9069 19.4284C14.9989 19.4284 12.8289 15.3284 12.8289 15.3284" stroke-linecap="round" stroke-linejoin="round"/></svg>
													<?php echo Mileage($vehicle['mileage'], $vehicle['type']); ?>
												</p>
											</div>
											<div class="vehicle__action">
												<button onclick="Route('<?php echo VehicleRoute($vehicle); ?>')">Ver parcelas</button>
											</div>
										</div>
										<div class="vehicle__footer">
											<div class="vehicle__location">
												<?php echo $vehicle['city'] . ', ' . $vehicle['state']; ?>
											</div>
											<div class="vehicle__icons">
												<span onclick="Like(<?php echo $vehicle['id'] ?>, this)" data-like="<?php echo isset($user['likes']) ? (in_array($vehicle['id'], $user['likes']) ? 'true' : 'false') : 'false'; ?>">
													<?php if (isset($user['likes']) && in_array($vehicle['id'], $user['likes'])) { ?>
													<svg viewBox="0 0 26 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.9068 10.698H17.8818C17.4678 10.683 17.1428 10.337 17.1568 9.92298C17.1888 8.97198 16.7238 8.35498 15.9128 8.27198C15.5008 8.22998 15.2008 7.86198 15.2428 7.44998C15.2858 7.03898 15.6558 6.73598 16.0658 6.77998C17.6738 6.94398 18.7148 8.22698 18.6558 9.97298C18.6418 10.379 18.3088 10.698 17.9068 10.698ZM17.8248 3.28398C16.1048 2.73398 13.7238 2.96198 12.2378 4.64798C10.6768 2.97398 8.37679 2.73098 6.66879 3.28498C2.75379 4.54498 1.53279 9.08098 2.64679 12.56V12.561C4.40479 18.032 10.2498 20.983 12.2518 20.983C14.0388 20.983 20.1158 18.087 21.8538 12.56C22.9678 9.08198 21.7438 4.54598 17.8248 3.28398Z" stroke-width="1" stroke="red" fill="red"/></svg>
													<?php } else { ?>
													<svg viewBox="0 0 26 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M3.12319 12.4101C2.05019 9.06006 3.30519 4.89506 6.82219 3.76306C8.67219 3.16606 10.9552 3.66406 12.2522 5.45306C13.4752 3.59806 15.8242 3.17006 17.6722 3.76306C21.1882 4.89506 22.4502 9.06006 21.3782 12.4101C19.7082 17.7201 13.8812 20.4861 12.2522 20.4861C11.0412 20.4861 7.53719 18.9911 5.11119 16.0151" stroke-linecap="round" stroke-linejoin="round"/><path d="M15.9902 7.52771C17.1972 7.65171 17.9522 8.60871 17.9072 9.94971" stroke-linecap="round" stroke-linejoin="round"/></svg>
													<?php } ?>
												</span>
											</div>
										</div>
									</div>
								</div>
								<?php } ?>
							</div>
						</div>

					</div>
				</div>
			</div>
		</div>
		<div style="margin-top: 65px;" id="motorcycle__carousel">
			<div class="container">
				<div class="row">
					<div class="col-12">
						<center>
							<h1 class="title">Motos</h1>
							<div style="margin-bottom: 0px;" class="title__divider"></div>
						</center>
					</div>
					<div style="margin-top: 35px;" class="col-12">

						<div class="swiper" id="motorcycle__swiper">
							<div class="swiper-wrapper">
								<?php 

								$consulta = "SELECT vehicles.*,
													brands.name AS brand_name 

													FROM vehicles 
													LEFT JOIN brands ON brands.id = vehicles.brand

													WHERE status = 1
													AND vehicles.type = 'motorcycle' 
													ORDER BY hits DESC, inserted_at DESC
													LIMIT 10";

								$con = $conn->query($consulta) or die($conn->error);
								while($vehicle = $con->fetch_array()) { 

									if (!empty($vehicle['photos'])) {
										$vehicle['photos'] = json_decode($vehicle['photos'], true);
										$attachment = $local['assets'] . '/attachments/vehicles/' . $vehicle['code'];
									}

								?>
								<div class="swiper-slide ">
									<div class="vehicle__item">
										<div onclick="Route('<?php echo VehicleRoute($vehicle); ?>')" class="vehicle__picture">
											<div 
												 <?php if (isset($vehicle['photos'][1])) { ?>
											 	 onmouseenter="HoverPicture('enter', '<?php echo $attachment . '/' . $vehicle['photos'][1] ?>', this)" 
												 <?php } ?>

												 <?php if (isset($vehicle['photos'][0])) { ?>
												 onmouseleave="HoverPicture('leave', '<?php echo $attachment . '/' . $vehicle['photos'][0] ?>', this)" 
												 <?php } ?>

												 style="background: url('<?php echo isset($vehicle['photos'][0]) ? $attachment . '/' . $vehicle['photos'][0] : 'https://i.ibb.co/sWStrwH/no-picture-1.png'; ?>');" 
												 class="picture__item"
											></div>
										</div>
										<div class="vehicle__details">
											<h3 onclick="Route('<?php echo VehicleRoute($vehicle); ?>')" class="vehicle__title"><?php echo strtoupper($vehicle['brand_name'] . ' ' . $vehicle['model']); ?></h3>
											<p onclick="Route('<?php echo VehicleRoute($vehicle); ?>')" class="vehicle__attributes">
												<?php echo strtoupper($vehicle['engine']); ?> 
											</p>
											<h2 class="vehicle__price"><?php echo 'USD ' . Money($vehicle['price']); ?></h2>
											<div class="vehicle__statistics">
												<p class="vehicle__year">
													<svg viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg">
														<path d="M8.4115 4.32167C8.7025 4.24067 8.4085 4.32067 8.7305 4.26067C9.7425 4.07267 10.9105 3.98667 12.2495 3.98667C12.8945 3.98667 13.4995 4.00667 14.0665 4.04767" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M12.2495 22.5345C5.29446 22.5345 2.97546 20.2165 2.97546 13.2605C2.97546 9.13348 3.79146 6.63848 5.90846 5.29248" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M16.2706 4.36572C20.1326 5.26572 21.5246 7.87072 21.5246 13.2607C21.5246 19.1167 19.8806 21.6857 15.2096 22.3517" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M3.25037 9.80884H21.2584" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M16.6533 13.7458H16.6623" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M12.2544 13.7458H12.2634" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M7.84645 13.7458H7.85545" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M16.6533 17.5979H16.6623" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M12.2544 17.5979H12.2634" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M7.84645 17.5979H7.85545" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M16.2584 2.53491V5.79691" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M8.25037 2.53491V5.79691" stroke-linecap="round" stroke-linejoin="round"/></svg>
													<?php echo Year($vehicle); ?>
												</p>
												<p class="vehicle__mileage">
													<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
														<path d="M6.979 4.60132V17.2193" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M2.8999 8.69998C2.8999 8.69998 5.0689 4.59998 6.9779 4.59998C8.8859 4.59998 11.0559 8.69998 11.0559 8.69998" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M16.9058 19.4274V6.80945" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M20.9849 15.3284C20.9849 15.3284 18.8149 19.4284 16.9069 19.4284C14.9989 19.4284 12.8289 15.3284 12.8289 15.3284" stroke-linecap="round" stroke-linejoin="round"/></svg>
													<?php echo Mileage($vehicle['mileage'], $vehicle['type']); ?>
												</p>
											</div>
											<div class="vehicle__action">
												<button onclick="Route('<?php echo VehicleRoute($vehicle); ?>')">Ver parcelas</button>
											</div>
										</div>
										<div class="vehicle__footer">
											<div class="vehicle__location">
												<?php echo $vehicle['city'] . ', ' . $vehicle['state']; ?>
											</div>
											<div class="vehicle__icons">
												<span onclick="Like(<?php echo $vehicle['id'] ?>, this)" data-like="<?php echo isset($user['likes']) ? (in_array($vehicle['id'], $user['likes']) ? 'true' : 'false') : 'false'; ?>">
													<?php if (isset($user['likes']) && in_array($vehicle['id'], $user['likes'])) { ?>
													<svg viewBox="0 0 26 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.9068 10.698H17.8818C17.4678 10.683 17.1428 10.337 17.1568 9.92298C17.1888 8.97198 16.7238 8.35498 15.9128 8.27198C15.5008 8.22998 15.2008 7.86198 15.2428 7.44998C15.2858 7.03898 15.6558 6.73598 16.0658 6.77998C17.6738 6.94398 18.7148 8.22698 18.6558 9.97298C18.6418 10.379 18.3088 10.698 17.9068 10.698ZM17.8248 3.28398C16.1048 2.73398 13.7238 2.96198 12.2378 4.64798C10.6768 2.97398 8.37679 2.73098 6.66879 3.28498C2.75379 4.54498 1.53279 9.08098 2.64679 12.56V12.561C4.40479 18.032 10.2498 20.983 12.2518 20.983C14.0388 20.983 20.1158 18.087 21.8538 12.56C22.9678 9.08198 21.7438 4.54598 17.8248 3.28398Z" stroke-width="1" stroke="red" fill="red"/></svg>
													<?php } else { ?>
													<svg viewBox="0 0 26 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M3.12319 12.4101C2.05019 9.06006 3.30519 4.89506 6.82219 3.76306C8.67219 3.16606 10.9552 3.66406 12.2522 5.45306C13.4752 3.59806 15.8242 3.17006 17.6722 3.76306C21.1882 4.89506 22.4502 9.06006 21.3782 12.4101C19.7082 17.7201 13.8812 20.4861 12.2522 20.4861C11.0412 20.4861 7.53719 18.9911 5.11119 16.0151" stroke-linecap="round" stroke-linejoin="round"/><path d="M15.9902 7.52771C17.1972 7.65171 17.9522 8.60871 17.9072 9.94971" stroke-linecap="round" stroke-linejoin="round"/></svg>
													<?php } ?>
												</span>
											</div>
										</div>
									</div>
								</div>
								<?php } ?>
							</div>
						</div>

					</div>
				</div>
			</div>
		</div>
		<div style="margin-top: 65px;" id="boat__carousel">
			<div class="container">
				<div class="row">
					<div class="col-12">
						<center>
							<h1 class="title">Veículos Aquáticos</h1>
							<div style="margin-bottom: 0px;" class="title__divider"></div>
						</center>
					</div>
					<div style="margin-top: 35px;" class="col-12">

						<div class="swiper" id="boat__swiper">
							<div class="swiper-wrapper">
								<?php 

								$consulta = "SELECT vehicles.*,
													brands.name AS brand_name 

													FROM vehicles 
													LEFT JOIN brands ON brands.id = vehicles.brand

													WHERE status = 1
													AND vehicles.type = 'boat' 
													ORDER BY hits DESC, inserted_at DESC
													LIMIT 10";

								$con = $conn->query($consulta) or die($conn->error);
								while($vehicle = $con->fetch_array()) { 

									if (!empty($vehicle['photos'])) {
										$vehicle['photos'] = json_decode($vehicle['photos'], true);
										$attachment = $local['assets'] . '/attachments/vehicles/' . $vehicle['code'];
									}

								?>
								<div class="swiper-slide ">
									<div class="vehicle__item">
										<div onclick="Route('<?php echo VehicleRoute($vehicle); ?>')" class="vehicle__picture">
											<div 
												 <?php if (isset($vehicle['photos'][1])) { ?>
											 	 onmouseenter="HoverPicture('enter', '<?php echo $attachment . '/' . $vehicle['photos'][1] ?>', this)" 
												 <?php } ?>

												 <?php if (isset($vehicle['photos'][0])) { ?>
												 onmouseleave="HoverPicture('leave', '<?php echo $attachment . '/' . $vehicle['photos'][0] ?>', this)" 
												 <?php } ?>

												 style="background: url('<?php echo isset($vehicle['photos'][0]) ? $attachment . '/' . $vehicle['photos'][0] : 'https://i.ibb.co/sWStrwH/no-picture-1.png'; ?>');" 
												 class="picture__item"
											></div>
										</div>
										<div class="vehicle__details">
											<h3 onclick="Route('<?php echo VehicleRoute($vehicle); ?>')" class="vehicle__title"><?php echo strtoupper($vehicle['brand_name'] . ' ' . $vehicle['model']); ?></h3>
											<p onclick="Route('<?php echo VehicleRoute($vehicle); ?>')" class="vehicle__attributes">
												<?php echo $vehicle['feet'] > 0 ? $vehicle['feet'] . ' FEETS ' : ''; ?>
											</p>
											<h2 class="vehicle__price"><?php echo 'USD ' . Money($vehicle['price']); ?></h2>
											<div class="vehicle__statistics">
												<p class="vehicle__year">
													<svg viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg">
														<path d="M8.4115 4.32167C8.7025 4.24067 8.4085 4.32067 8.7305 4.26067C9.7425 4.07267 10.9105 3.98667 12.2495 3.98667C12.8945 3.98667 13.4995 4.00667 14.0665 4.04767" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M12.2495 22.5345C5.29446 22.5345 2.97546 20.2165 2.97546 13.2605C2.97546 9.13348 3.79146 6.63848 5.90846 5.29248" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M16.2706 4.36572C20.1326 5.26572 21.5246 7.87072 21.5246 13.2607C21.5246 19.1167 19.8806 21.6857 15.2096 22.3517" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M3.25037 9.80884H21.2584" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M16.6533 13.7458H16.6623" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M12.2544 13.7458H12.2634" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M7.84645 13.7458H7.85545" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M16.6533 17.5979H16.6623" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M12.2544 17.5979H12.2634" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M7.84645 17.5979H7.85545" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M16.2584 2.53491V5.79691" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M8.25037 2.53491V5.79691" stroke-linecap="round" stroke-linejoin="round"/></svg>
													<?php echo Year($vehicle); ?>
												</p>
												<p class="vehicle__mileage">
													<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
														<path d="M6.979 4.60132V17.2193" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M2.8999 8.69998C2.8999 8.69998 5.0689 4.59998 6.9779 4.59998C8.8859 4.59998 11.0559 8.69998 11.0559 8.69998" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M16.9058 19.4274V6.80945" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M20.9849 15.3284C20.9849 15.3284 18.8149 19.4284 16.9069 19.4284C14.9989 19.4284 12.8289 15.3284 12.8289 15.3284" stroke-linecap="round" stroke-linejoin="round"/></svg>
													<?php echo Mileage($vehicle['mileage'], $vehicle['type']); ?>
												</p>
											</div>
											<div class="vehicle__action">
												<button onclick="Route('<?php echo VehicleRoute($vehicle); ?>')">Ver parcelas</button>
											</div>
										</div>
										<div class="vehicle__footer">
											<div class="vehicle__location">
												<?php echo $vehicle['city'] . ', ' . $vehicle['state']; ?>
											</div>
											<div class="vehicle__icons">
												<span onclick="Like(<?php echo $vehicle['id'] ?>, this)" data-like="<?php echo isset($user['likes']) ? (in_array($vehicle['id'], $user['likes']) ? 'true' : 'false') : 'false'; ?>">
													<?php if (isset($user['likes']) && in_array($vehicle['id'], $user['likes'])) { ?>
													<svg viewBox="0 0 26 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.9068 10.698H17.8818C17.4678 10.683 17.1428 10.337 17.1568 9.92298C17.1888 8.97198 16.7238 8.35498 15.9128 8.27198C15.5008 8.22998 15.2008 7.86198 15.2428 7.44998C15.2858 7.03898 15.6558 6.73598 16.0658 6.77998C17.6738 6.94398 18.7148 8.22698 18.6558 9.97298C18.6418 10.379 18.3088 10.698 17.9068 10.698ZM17.8248 3.28398C16.1048 2.73398 13.7238 2.96198 12.2378 4.64798C10.6768 2.97398 8.37679 2.73098 6.66879 3.28498C2.75379 4.54498 1.53279 9.08098 2.64679 12.56V12.561C4.40479 18.032 10.2498 20.983 12.2518 20.983C14.0388 20.983 20.1158 18.087 21.8538 12.56C22.9678 9.08198 21.7438 4.54598 17.8248 3.28398Z" stroke-width="1" stroke="red" fill="red"/></svg>
													<?php } else { ?>
													<svg viewBox="0 0 26 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M3.12319 12.4101C2.05019 9.06006 3.30519 4.89506 6.82219 3.76306C8.67219 3.16606 10.9552 3.66406 12.2522 5.45306C13.4752 3.59806 15.8242 3.17006 17.6722 3.76306C21.1882 4.89506 22.4502 9.06006 21.3782 12.4101C19.7082 17.7201 13.8812 20.4861 12.2522 20.4861C11.0412 20.4861 7.53719 18.9911 5.11119 16.0151" stroke-linecap="round" stroke-linejoin="round"/><path d="M15.9902 7.52771C17.1972 7.65171 17.9522 8.60871 17.9072 9.94971" stroke-linecap="round" stroke-linejoin="round"/></svg>
													<?php } ?>
												</span>
											</div>
										</div>
									</div>
								</div>
								<?php } ?>
							</div>
						</div>

					</div>
				</div>
			</div>
		</div>
	</div>
	<?php require_once __DIR__ . '/../templates/footer.php'; ?>
</body>
<script type="text/javascript">

	// Cars: Inicializa o slider
	const cars__swiper = new Swiper('#cars__swiper', {
		autoplay: {
			delay: 5000
		},
		slidesPerView: 4,
		spaceBetween: 20,
		lazyPreloadPrevNext: 4,
		loop: true,
		loopAddBlankSlides: true,
		breakpoints: {
			100: {
			  slidesPerView: 1,
			  spaceBetween: 10,
			},
			540: {
			  slidesPerView: 2,
			  spaceBetween: 10,
			},
			810: {
			  slidesPerView: 3,
			  spaceBetween: 20,
			},
			1080: {
			  slidesPerView: 4,
			  spaceBetween: 20,
			},
			1250: {
			  slidesPerView: 4,
			  spaceBetween: 20,
			},
			1650: {
			  slidesPerView: 5,
			  spaceBetween: 20,
			  centerInsufficientSlides: true,
			}
		},
		autoHeight: true,
	});
	
	// Motorcycles: Inicializa o slider
	const motorcycle__swiper = new Swiper('#motorcycle__swiper', {
		autoplay: {
			delay: 5000
		},
		slidesPerView: 4,
		spaceBetween: 20,
		lazyPreloadPrevNext: 4,
		loop: true,
		loopAddBlankSlides: true,
		breakpoints: {
			100: {
			  slidesPerView: 1,
			  spaceBetween: 10,
			},
			540: {
			  slidesPerView: 2,
			  spaceBetween: 10,
			},
			810: {
			  slidesPerView: 3,
			  spaceBetween: 20,
			},
			1080: {
			  slidesPerView: 4,
			  spaceBetween: 20,
			},
			1250: {
			  slidesPerView: 4,
			  spaceBetween: 20,
			},
			1650: {
			  slidesPerView: 5,
			  spaceBetween: 20,
			  centerInsufficientSlides: true,
			}
		},
		autoHeight: true,
	});
	
	// Boats: Inicializa o slider
	const boat__swiper = new Swiper('#boat__swiper', {
		autoplay: {
			delay: 5000
		},
		slidesPerView: 4,
		spaceBetween: 20,
		lazyPreloadPrevNext: 4,
		loop: true,
		loopAddBlankSlides: true,
		breakpoints: {
			100: {
			  slidesPerView: 1,
			  spaceBetween: 10,
			},
			540: {
			  slidesPerView: 2,
			  spaceBetween: 10,
			},
			810: {
			  slidesPerView: 3,
			  spaceBetween: 20,
			},
			1080: {
			  slidesPerView: 4,
			  spaceBetween: 20,
			},
			1250: {
			  slidesPerView: 4,
			  spaceBetween: 20,
			},
			1650: {
			  slidesPerView: 5,
			  spaceBetween: 20,
			  centerInsufficientSlides: true,
			}
		},
		autoHeight: true,
	});

	function HoverPicture(action, file, box) {
		box.style.background = 'url("' + file + '")';
	}

	function Search() {

		const input__query = document.getElementById('search__query');
		const input__type = document.getElementById('search__type');
		const input__submit = document.getElementById('search__submit');

		const old__value = input__submit.innerHTML;
		input__submit.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i>';

		// Cria e envia o form
		var form = document.createElement('form');
		form.method = 'GET';
		form.action = base_url + '/search';

		var params = {
		    t: input__type.value,
		};

		if (input__query.value.length >= 1) {
			params.q = input__query.value;
		}

		for (var key in params) {
		    if (params.hasOwnProperty(key)) {
		        var input = document.createElement('input');
		        input.type = 'hidden';
		        input.name = key;
		        input.value = params[key];
		        form.appendChild(input);
		    }
		}

		document.body.appendChild(form);
		form.submit();

	}

	function SearchType(type, button) {
		const allButtons = document.querySelectorAll('#type__box .type__item');
		const input__type = document.getElementById('search__type');

		allButtons.forEach((item) => {
			item.classList.remove('type__active');
		});

		input__type.value = type;
		button.classList.add('type__active');
	}

</script>
</html>