<!DOCTYPE html>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php 

        $page_name = 'Account';

        // Configuration files
        require_once __DIR__ . '/../../../inc/conn.php';
        require_once __DIR__ . '/../../../inc/config.php';

        // Styling files
        require_once __DIR__ . '/../../../inc/cdns.php';
        require_once __DIR__ . '/../../../inc/functions.php';

        CheckAuth();

    ?>

    <link rel="stylesheet" type="text/css" href="<?php echo $local['source'] . '/assets/vars.css'; ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo $local['source'] . '/assets/css/account/profile.css'; ?>">

</head>
<body>
    
    <?php require_once __DIR__ . '/../../templates/topbar.php'; ?>
    <div class="content__box">
        <div class="container">
            <div class="row">
                <div style="margin-bottom: 20px;" class="col-12 col-md-4 col-lg-3">
                    <?php include_once __DIR__ . '/../../templates/account_menu.php'; ?>
                </div>
                <div class="col-12 col-md-8 col-lg-9">
                    <form id="profile__form" onsubmit="UpdateProfile(event);">
                        <div class="row">
                            <div class="col-md-12 col-lg-5">
                                <div class="profile__box">
                                    <h1 class="title">Meus dados</h1>
                                    <p class="subtitle">Campos com asterisco (*) são obrigatórios</p>
                                    <hr>
                                    <div class="input__box">
                                        <label>Nome <b>*</b></label>
                                        <input type="text" required value="<?php echo !empty($user['name']) ? $user['name'] : ''; ?>" id="profile__name">
                                    </div>
                                    <div class="input__box">
                                        <label>E-mail <b>*</b></label>
                                        <input type="email" required disabled value="<?php echo !empty($user['email']) ? $user['email'] : ''; ?>" id="profile__email">
                                    </div>
                                    <div class="input__box">
                                        <label>Telefone</label>
                                        <input type="text" value="<?php echo !empty($user['telephone']) ? $user['telephone'] : ''; ?>" id="profile__telephone">
                                    </div>
                                    <div class="input__box">
                                        <label>Data de nascimento <b>*</b></label><br>
                                        <input type="date" required max="<?php echo date('Y-m-d', strtotime('-18 years')); ?>" value="<?php echo !empty($user['birth']) ? $user['birth'] : ''; ?>" id="profile__birth">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12 col-lg-7">
                                <div class="profile__box">
                                    <h1 class="title">Endereço</h1>
                                    <p class="subtitle">Campos com asterisco (*) são obrigatórios</p>
                                    <hr>
                                    <div class="row gx-3">
                                        <div class="col-6 col-md-3">
                                            <div class="input__box">
                                                <label>Zipcode <b>*</b></label>
                                                <input type="text" required value="<?php echo !empty($user['zipcode']) ? $user['zipcode'] : ''; ?>" id="profile__zipcode">
                                            </div>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <div class="input__box">
                                                <label>Estado <b>*</b></label>
                                                <input type="text" required value="<?php echo !empty($user['state']) ? $user['state'] : ''; ?>" id="profile__state">
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <div class="input__box">
                                                <label>Cidade <b>*</b></label>
                                                <input type="text" required value="<?php echo !empty($user['city']) ? $user['city'] : ''; ?>" id="profile__city">
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="input__box">
                                                <label>Logradouro</label>
                                                <input type="text" value="<?php echo !empty($user['address']) ? $user['address'] : ''; ?>" id="profile__address">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="input__submit">
                                    <button id="profile__submit" disabled>Salvar alterações</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</body>
<script type="text/javascript">
    
    function UpdateProfile(event) {
        event.preventDefault();

        // Define as variáveis
        const input__name = document.getElementById('profile__name');
        const input__telephone = document.getElementById('profile__telephone');
        const input__birth = document.getElementById('profile__birth');
        const input__zipcode = document.getElementById('profile__zipcode');
        const input__city = document.getElementById('profile__city');
        const input__address = document.getElementById('profile__address');

        // Declara o submit
        const input__submit = document.getElementById('profile__submit');
        const old__value = input__submit.innerHTML;

        // Inicia o load
        input__submit.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i>';

        // Envia o AJAX
        $.ajax({
            type: "POST",
            url: base_url + "/api/users/update.php",
            data: {
                name: input__name.value,
                telephone: iti.getNumber(),
                birth: input__birth.value,
                zipcode: input__zipcode.value,
                city: input__city.value,
                address: input__address.value,
            },
            success: function(response) {
                if (response.status === 'success') {
                    input__submit.innerHTML = old__value;

                    Swal.fire({
                      icon: 'success',
                      iconColor: '#729fff',
                      title: 'Dados atualizados!',
                      html: "",
                      timerProgressBar: true,
                      timer: 5000,
                    });

                } else {
                    console.error('contact_error: ' + response);
                    input__submit.innerHTML = old__value;
                }
            },
            error: function(xhr, status, error) {
                console.error("contact_error:", error);
            }
        });

    }

</script>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@21.1.1/build/css/intlTelInput.css">
<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@21.1.1/build/js/intlTelInput.min.js"></script>

<script type="text/javascript">

    // Verifica se teve alguma alteração nos dados
    document.addEventListener('DOMContentLoaded', function() {
        var form = document.getElementById('profile__form');
        const btnSUbmit = document.getElementById('profile__submit');
        form.addEventListener('input', function(event) {
            if (event.target.tagName === 'INPUT') {
                btnSUbmit.disabled = false;
            }
        });
    });

    
    // Adiciona a mask no telefone
    var phoneInput = document.querySelector("#profile__telephone");
    iti = window.intlTelInput(phoneInput, {
        initialCountry: "auto",
        geoIpLookup: function(success, failure) {
            success('us');
        },
        utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@21.1.1/build/js/utils.js",
    });

</script>
</html>