<?php 

    function Money($value) {
        if (!is_numeric($value)) {
            $value = floatval($value);
        }

        $numberFormatted = number_format($value, 0, ',', '.');
        return $numberFormatted;
    }

    function Mileage($value, $type = 'car') {
        if (!is_numeric($value)) {
            $value = floatval($value);
        }

        switch ($type) {
            case 'car':
                $code = 'mi';
                break;

            case 'motorcycle':
                $code = 'mi';
                break;

            case 'boat':
                $code = 'hr';
                break;
            
            default:
                $code = 'mi';
                break;
        }

        $numberFormatted = number_format($value, 0, ',', '.');
        return $numberFormatted . ' ' . $code;
    }

    function isAuth() {
        if (isset($_SESSION['user'])) {
            return true;
        } else {
            return false;
        }
    }

    function Redirect($route) {
        global $local;
        echo '<script>window.location.href="' . $local['source'] . '/' . $route . '"</script>';
    }

    function Route($route) {
        global $local;
        echo $local['source'] . '/' . $route;
    }

    if (!function_exists('VehicleRoute')) {
        function VehicleRoute($vehicle) {
            $formattedModel = strtolower(str_replace([' ', '-', '_'], '-', $vehicle['model']));
            $formattedBrand = isset($vehicle['brand_name']) ? strtolower(str_replace([' ', '-', '_'], '-', $vehicle['brand_name'])) : '';
            $brand_name = isset($vehicle['brand_name']) ? $formattedBrand . '/' : '';
            $link = $vehicle['type'] . '/' . $brand_name . $formattedModel . '/' . $vehicle['id'] . '/' . $vehicle['code'];
            return $link;
        }
    }

    if (!function_exists('CategoryRoute')) {
        function CategoryRoute($category) {
            $formattedName = strtolower(str_replace([' ', '-', '_'], '-', $category['name']));
            $link = $category['type'] . '/' . $formattedName;
            return Route($link);
        }
    }

    if (!function_exists('BrandRoute')) {
        function BrandRoute($brand) {
            $formattedName = strtolower(str_replace([' ', '-', '_'], '-', $brand['name']));
            return Route('brand/' . $formattedName);
        }
    }

    function UnmaskMoney($moneyString) {
        if (!is_string($moneyString)) {
            return $moneyString;
        }
        
        $moneyString = trim($moneyString);

        $moneyString = str_replace('$', '', $moneyString);
        $moneyString = str_replace(' ', '', $moneyString);

        $moneyString = str_replace('.', '', $moneyString);
        $moneyString = str_replace(',', '.', $moneyString);

        if (!is_numeric($moneyString)) {
            throw new InvalidArgumentException('O valor informado não é um formato monetário válido.');
        }

        $unmaskedMoney = (float) $moneyString;
        return $unmaskedMoney;
    }

    function Fuel($fuel, $lang = 'en') {
        switch ($lang) {
            case 'en':
                switch ($fuel) {
                    case 'gasoline':
                        return 'Gasolina';
                    case 'electric':
                        return 'Elétrico';
                    case 'diesel':
                        return 'Diesel';
                    default:
                        return null;
                }
            case 'pt':
                switch ($fuel) {
                    case 'Gasolina':
                        return 'gasoline';
                    case 'Elétrico':
                        return 'electric';
                    case 'Diesel':
                        return 'diesel';
                    default:
                        return null;
                }
            default:
                return null;
        }
    }

    function Transmission($transmission, $lang = 'en') {
        switch ($lang) {
            case 'en':
                switch ($transmission) {
                    case 'automatic':
                        return 'Automático';
                    case 'manual':
                        return 'Manual';
                    default:
                        return null;
                }
            case 'pt':
                switch ($transmission) {
                    case 'Automático':
                        return 'automatic';
                    case 'Manual':
                        return 'manual';
                    default:
                        return null;
                }
            default:
                return null;
        }
    }

    function Year($vehicle) {
        if ($vehicle['type'] == 'boat') {
            return $vehicle['year_build'];
        } else {
            $output = [];

            if (!empty($vehicle['year_build'])) {
                $output[] = $vehicle['year_build'];
            }

            if (!empty($vehicle['year_model'])) {
                $output[] = $vehicle['year_model'];
            }

            return implode('/', $output);
        }
    }

    function CheckAuth() {
        if (session_status() === PHP_SESSION_NONE) { session_start(); }
        if (!isset($_SESSION['user'])) {
            Redirect('login');
        }
    }


?>

<?php if (!isset($removeJs)) { ?>
<script type="text/javascript">

    var base_url = '<?php echo $local['source']; ?>';
    var debug = true;

    if (!debug) { 
        const methods = ['log', 'warn', 'error', 'info', 'debug', 'assert', 'clear', 'count', 'countReset', 'dir', 'dirxml', 'group', 'groupCollapsed', 'groupEnd', 'table', 'time', 'timeEnd', 'timeLog', 'trace'];
        methods.forEach(method => {
            console[method] = function() {};
        });
    }

    function Route(route) {
        window.location.href = base_url + '/' + route;
    }
    
    function Like(prod_id, element) {
        const like_status = element.dataset.like;
        const user_id = <?php echo isset($user['id']) ? $user['id'] : 'null'; ?>;

        if (user_id) {

            $.ajax({
                type: "POST",
                url: base_url + "/api/vehicles/like.php",
                data: {
                    user: user_id,
                    vehicle: prod_id,
                    action: like_status === 'true' ? 'unlike' : 'like',
                },
                success: function(response) {
                    response = JSON.parse(response);
                    if (response.status === 'success') {
                        if (like_status === 'true') {
                            element.dataset.like = 'false';
                            element.innerHTML = '<svg data-slot="icon" fill="none" stroke="#343a4050" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true"><path stroke-linecap="round" stroke-linejoin="round" d="M21 8.25c0-2.485-2.099-4.5-4.688-4.5-1.935 0-3.597 1.126-4.312 2.733-.715-1.607-2.377-2.733-4.313-2.733C5.1 3.75 3 5.765 3 8.25c0 7.22 9 12 9 12s9-4.78 9-12Z"></path></svg>';
                        } else {
                            element.dataset.like = 'true';
                            element.innerHTML = '<svg data-slot="icon" fill="red" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true"><path d="m11.645 20.91-.007-.003-.022-.012a15.247 15.247 0 0 1-.383-.218 25.18 25.18 0 0 1-4.244-3.17C4.688 15.36 2.25 12.174 2.25 8.25 2.25 5.322 4.714 3 7.688 3A5.5 5.5 0 0 1 12 5.052 5.5 5.5 0 0 1 16.313 3c2.973 0 5.437 2.322 5.437 5.25 0 3.925-2.438 7.111-4.739 9.256a25.175 25.175 0 0 1-4.244 3.17 15.247 15.247 0 0 1-.383.219l-.022.012-.007.004-.003.001a.752.752 0 0 1-.704 0l-.003-.001Z"></path></svg>';
                        }
                    }
                    console.log(response);
                },
                error: function(xhr, status, error) {
                    console.error("like_error:", error);
                }
            });

        } else { Route('login'); }

    }

    function getQueryParam(param) {
        const urlParams = new URLSearchParams(window.location.search);
        return urlParams.get(param);
    }

    function CategoryHit(category_id) {
        $.ajax({
            type: "POST",
            url: base_url + "/api/categories/hit.php",
            data: { id: category_id },
            success: function(response) {},
            error: function(xhr, status, error) {}
        });
    }

    function BrandHit(brand_id) {
        $.ajax({
            type: "POST",
            url: base_url + "/api/brands/hit.php",
            data: { id: brand_id },
            success: function(response) {},
            error: function(xhr, status, error) {}
        });
    }

</script>
<?php } ?>