<?php

    session_start();
    header('Content-Type: application/json');
    require_once __DIR__ . '/../../inc/conn.php';

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Prepara a resposta
        $response = [];

        // Define as variáveis
        $user_id = $_SESSION['user']['id'];
        $name = !empty($_POST['name']) ? $_POST['name'] : '';
        $telephone = !empty($_POST['telephone']) ? $_POST['telephone'] : '';
        $birth = !empty($_POST['birth']) ? $_POST['birth'] : '';
        $zipcode = !empty($_POST['zipcode']) ? $_POST['zipcode'] : '';
        $city = !empty($_POST['city']) ? $_POST['city'] : '';
        $address = !empty($_POST['address']) ? $_POST['address'] : '';

        // Atualiza no db
        $query = "UPDATE users SET 
                    name = ?, 
                    telephone = ?, 
                    birth = ?, 
                    zipcode = ?, 
                    city = ?, 
                    address = ? 
                  WHERE id = ?";

        if ($stmt = $conn->prepare($query)) {
            $stmt->bind_param('ssssssi', $name, $telephone, $birth, $zipcode, $city, $address, $user_id);
            
            if ($stmt->execute()) {
                $response['status'] = 'success';
                $response['message'] = 'Dados atualizados com sucesso.';
            } else {
                http_response_code(500);
                $response['status'] = 'error';
                $response['message'] = 'Erro ao atualizar os dados: ' . $stmt->error;
            }

            $stmt->close();

        } else {

            http_response_code(500);
            $response['status'] = 'error';
            $response['message'] = 'Erro na preparação da consulta: ' . $conn->error;
            
        }

        echo json_encode($response);

    } else {

        http_response_code(400);

        $response['status'] = 'error';
        $response['message'] = 'Método de requisição inválido.';

        echo json_encode($response);

    }

?>