<?php 

session_start();
require_once __DIR__ . '/../../inc/conn.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {

    $action = $_POST['action'];
    $code = isset($_POST['code']) ? $_POST['code'] : null;
    $file = isset($_POST['file']) ? $_POST['file'] : null;
    $path = '../../assets/attachments/vehicles/' . $code . '/' . $file;

    if ($action == 'trash') {
        if (file_exists($path)) {
            if (unlink($path)) {

                $queryTrash = "SELECT photos FROM vehicles WHERE code = ?";
                $stmt = $conn->prepare($queryTrash);
                $stmt->bind_param('s', $code);
                $stmt->execute();
                $resultTrash = $stmt->get_result();
                $data = $resultTrash->fetch_assoc();
                $photos = !empty($data['photos']) ? json_decode($data['photos'], true) : [];

                if (!empty($photos) && array_key_exists($file, $photos)) {
                    unset($photos[$file]);

                    $photosJson = json_encode($photos);
                    $queryUpdate = "UPDATE vehicles SET photos = ? WHERE code = ?";
                    $stmtUpdate = $conn->prepare($queryUpdate);
                    $stmtUpdate->bind_param('ss', $photosJson, $code);
                    
                    if ($stmtUpdate->execute()) {
                        print_r($photos);
                    } else {
                        echo 'Erro ao atualizar no banco de dados';
                    }
                } else {
                    print_r($photos);
                    echo 'O arquivo não está presente na lista de fotos';
                }

            } else { echo 'Erro ao remover'; }
        } else { echo 'Arquivo não existe'; }
    } elseif ($action == 'upload') {
        
        $vehicle_id = $_POST['id'];
        $file_link = $_POST['link'];

        $query = ¨SELECT photos FROM vehicles WHERE id = '$vehicle_id'¨;
        $result = $conn->query($query);
        $vehicle = $result->fetch_assoc();
        $photos = $vehicle['photos'];

        if (!empty($photos)) {
            $pics = json_decode($photos, true);
        } else {
            $pics = [];
        }

        $pics[] = $file_link;
        $pics_json = json_encode($pics);

        $query_update = ¨UPDATE vehicles SET photos = '$pics_json'¨;
        $conn->query($query_update);

    }
    
    
} else { http_response_code(401); }

echo 'aqui';
?>