<!DOCTYPE html>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">

    <?php 

        // Configuration files
        require_once __DIR__ . '/../../../inc/conn.php';
        require_once __DIR__ . '/../../../inc/config.php';

        // Styling files
        require_once __DIR__ . '/../../../inc/cdns.php';
        require_once __DIR__ . '/../../../inc/functions.php';

        // Pega o código na URL
        $requestUri = $_SERVER['REQUEST_URI'];
        $uri = parse_url($requestUri, PHP_URL_PATH);
        $segments = explode('/', trim($uri, '/'));
        $code = end($segments);

        // Busca o registro no db
        $query_vehicle = "SELECT vehicles.*,
                                 brands.name AS brand_name,
                                 users.name AS seller_name,
                                 users.email AS seller_email,
                                 users.telephone AS seller_telephone,
                                 users.address AS seller_address,
                                 users.city AS seller_city,
                                 users.state AS seller_state,
                                 users.zipcode AS seller_zipcode

                                 FROM vehicles 
                                 INNER JOIN brands ON brands.id = vehicles.brand
                                 LEFT JOIN users ON users.id = vehicles.seller

                                 WHERE code = '$code'";

        $result_vehicle = $conn->query($query_vehicle);
        $vehicle = $result_vehicle->fetch_assoc();

        if (!isset($_SESSION['hits'][$code])) {
            $_SESSION['hits'][$code] = time();
            $query_hit = "UPDATE vehicles SET hits = hits + 1 WHERE code = '$code'";
            @$conn->query($query_hit);
        }

    ?>

    <link rel="stylesheet" type="text/css" href="<?php echo $local['source'] . '/assets/vars.css'; ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo $local['source'] . '/assets/css/vehicles/show.css'; ?>">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@21.1.1/build/css/intlTelInput.css">
    <script src="https://cdn.jsdelivr.net/npm/intl-tel-input@21.1.1/build/js/intlTelInput.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/libphonenumber-js@1.9.34/bundle/libphonenumber-js.min.js"></script>

</head>
<body>
<?php require_once __DIR__ . '/../../templates/topbar.php'; ?>
    <div class="content__box">
        <div class="container">
            <div class="row">
                <div class="col-12 col-md-8">
                    <div id="picture__box">
                        <div class="swiper">
                            <div class="swiper-wrapper">
                                <?php 

                                if (!empty($vehicle['photos'])) {
                                    $vehicle['photos'] = json_decode($vehicle['photos'], true); 
                                    $local_file = $local['attachments'] . '/vehicles/' . $vehicle['code'];
                                }
 
                                if (isset($vehicle['photos'])) {
                                    foreach ($vehicle['photos'] AS $pic) { ?>

                                    <div class="swiper-slide">
                                        <div class="picture__content">
                                            <div style="background: url('<?php echo !empty($pic) ? $local_file . '/' . $pic : 'https://i.ibb.co/sWStrwH/no-picture-1.png'; ?>');" class="picture__hover"></div>
                                            <div style="background: url('<?php echo !empty($pic) ? $local_file . '/' . $pic : 'https://i.ibb.co/sWStrwH/no-picture-1.png'; ?>');" class="picture__item"></div>
                                        </div>
                                    </div>    

                                <?php } } else { ?>

                                    <div class="swiper-slide">
                                        <div class="picture__content">
                                            <div style="background: url('https://i.ibb.co/sWStrwH/no-picture-1.png');" class="picture__hover"></div>
                                            <div style="background: url('https://i.ibb.co/sWStrwH/no-picture-1.png'); background-size: cover !important;" class="picture__item"></div>
                                        </div>
                                    </div>   

                                <?php } ?>
                            </div>
                            <div class="swiper-pagination"></div>
                            <div class="swiper-button-prev"></div>
                            <div class="swiper-button-next"></div>
                        </div>
                    </div>
                    <div id="description__box">
                        <div class="desc__header">
                            <div class="desc__title">
                                <div>
                                    <h1><?php echo strtoupper($vehicle['brand_name']); ?> <b><?php echo strtoupper($vehicle['model']); ?></b></h1>
                                    <p>
                                        <?php echo !empty($vehicle['engine']) ? strtoupper($vehicle['engine']) : ''; ?> 
                                        <?php echo !empty($vehicle['fuel']) ? strtoupper($vehicle['fuel']) : ''; ?> 
                                        <?php echo !empty($vehicle['transmission']) ? strtoupper($vehicle['transmission']) : ''; ?> 
                                    </p>
                                    <div class="desc__tags">
                                        <div class="desc__share">
                                            <div onclick="Share('facebook')" class="share__item">
                                                <i class="fa-brands fa-facebook"></i>
                                            </div>
                                            <div onclick="Share('twitter')" class="share__item">
                                                <i class="fa-brands fa-twitter"></i>
                                            </div>
                                            <div onclick="Share('whatsapp')" class="share__item">
                                                <i class="fa-brands fa-whatsapp"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="desc__price">
                                <h1><small>USD</small> <?php echo number_format($vehicle['price'], 0, ',', '.'); ?></h1>
                            </div>
                        </div>
                        <div class="desc__content">
                            <div class="row">
                                <?php if (!empty($vehicle['city'])) { ?>
                                <div class="col-6">
                                    <p class="desc__row">Cidade</p>
                                    <p class="desc__value"><?php echo $vehicle['city'] . ', ' . $vehicle['state']; ?></p>
                                </div>
                                <div class="col-6">
                                    
                                </div>
                                <?php } ?>
                                <?php if (Year($vehicle)) { ?>
                                <div class="col-6 col-md-3">
                                    <p class="desc__row">Ano</p>
                                    <p class="desc__value"><?php echo Year($vehicle); ?></p>
                                </div>
                                <?php } ?>
                                <?php if (!empty($vehicle['mileage'])) { ?>
                                <div class="col-6 col-md-3">
                                    <p class="desc__row">Quilometragem</p>
                                    <p class="desc__value"><?php echo Mileage($vehicle['mileage']); ?></p>
                                </div>
                                <?php } ?>
                                <?php if (!empty($vehicle['feet'])) { ?>
                                <div class="col-6 col-md-3">
                                    <p class="desc__row">Tamanho</p>
                                    <p class="desc__value"><?php echo number_format($vehicle['feet'], 0, ',', '.') . ' pés'; ?></p>
                                </div>
                                <?php } ?>
                                <?php if (!empty($vehicle['transmission'])) { ?>
                                <div class="col-6 col-md-3">
                                    <p class="desc__row">Câmbio</p>
                                    <p class="desc__value"><?php echo !empty($vehicle['transmission']) ? Transmission($vehicle['transmission']) : ''; ?></p>
                                </div>
                                <?php } ?>
                                <?php if (!empty($vehicle['body'])) { ?>
                                <div class="col-6 col-md-3">
                                    <p class="desc__row">Carroceria</p>
                                    <p class="desc__value"><?php echo !empty($vehicle['body']) ? ucfirst($vehicle['body']) : ''; ?></p>
                                </div>
                                <?php } ?>
                                <?php if (!empty($vehicle['fuel'])) { ?>
                                <div class="col-6 col-md-3">
                                    <p class="desc__row">Combustível</p>
                                    <p class="desc__value"><?php echo !empty($vehicle['fuel']) ? Fuel($vehicle['fuel']) : ''; ?></p>
                                </div>
                                <?php } ?>
                                <?php if (!empty($vehicle['plate'])) { ?>
                                <div class="col-6 col-md-3">
                                    <p class="desc__row">Final de placa</p>
                                    <p class="desc__value"><?php echo substr($vehicle['plate'], -1); ?></p>
                                </div>
                                <?php } ?>
                                <?php if (!empty($vehicle['color'])) { ?>
                                <div class="col-6 col-md-3">
                                    <p class="desc__row">Cor</p>
                                    <p class="desc__value"><?php echo !empty($vehicle['color']) ? ucfirst($vehicle['color']) : ''; ?></p>
                                </div>
                                <?php } ?>
                                <?php if (!empty($vehicle['licensed'])) { ?>
                                <div class="col-6 col-md-3">
                                    <p class="desc__row">Licenciado</p>
                                    <p class="desc__value"><?php echo $vehicle['licensed'] == 1 ? 'Sim' : 'Não'; ?></p>
                                </div>
                                <?php } ?>
                                <?php if (!empty($vehicle['only_owner'])) { ?>
                                <div class="col-6 col-md-3">
                                    <p class="desc__row">Único dono</p>
                                    <p class="desc__value"><?php echo $vehicle['only_owner'] == 1 ? 'Sim' : 'Não'; ?></p>
                                </div>
                                <?php } ?>
                                <?php if (!empty($vehicle['engine_start'])) { ?>
                                <div class="col-6 col-md-3">
                                    <p class="desc__row">Partida</p>
                                    <p class="desc__value"><?php echo ucfirst($vehicle['engine_start']); ?></p>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                        <?php if (!empty($vehicle['description'])) { ?>
                        <div class="desc__content">
                            <p class="desc__text"><?php echo $vehicle['description']; ?></p>
                        </div>
                        <?php } ?>
                    </div>
                    <?php if (!empty($vehicle['details'])) { ?>
                    <div id="details__box">
                        <h1 class="title">Informações adicionais</h1>
                        <div class="details__row">
                            <?php 
                            $details__tags = !empty($vehicle['details']) ? json_decode($vehicle['details'], true) : null;
                            foreach ($details__tags as $tag) {
                                echo '<label>' . $tag . '</label>';
                            } ?>
                        </div>
                    </div>
                    <?php } ?>
                    <?php if (!empty($vehicle['seller_name'])) { ?>
                    <div id="seller__box">
                        <div class="seller__info">
                            <div style="background: url('https://i.ibb.co/M8GC0cH/no-picture.png');" class="seller__picture"></div>
                            <div class="seller__title">
                                <h1>
                                    <?php echo $vehicle['seller_name']; ?>
                                    <svg data-slot="icon" fill="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true"><path clip-rule="evenodd" fill-rule="evenodd" d="M8.603 3.799A4.49 4.49 0 0 1 12 2.25c1.357 0 2.573.6 3.397 1.549a4.49 4.49 0 0 1 3.498 1.307 4.491 4.491 0 0 1 1.307 3.497A4.49 4.49 0 0 1 21.75 12a4.49 4.49 0 0 1-1.549 3.397 4.491 4.491 0 0 1-1.307 3.497 4.491 4.491 0 0 1-3.497 1.307A4.49 4.49 0 0 1 12 21.75a4.49 4.49 0 0 1-3.397-1.549 4.49 4.49 0 0 1-3.498-1.306 4.491 4.491 0 0 1-1.307-3.498A4.49 4.49 0 0 1 2.25 12c0-1.357.6-2.573 1.549-3.397a4.49 4.49 0 0 1 1.307-3.497 4.49 4.49 0 0 1 3.497-1.307Zm7.007 6.387a.75.75 0 1 0-1.22-.872l-3.236 4.53L9.53 12.22a.75.75 0 0 0-1.06 1.06l2.25 2.25a.75.75 0 0 0 1.14-.094l3.75-5.25Z"></path></svg>
                                </h1>
                                <p><?php echo $vehicle['seller_city'] . ', ' . $vehicle['seller_state']; ?></p>
                            </div>
                        </div>
                        <div class="seller__contact">
                            <button onclick="ShowTelephone('<?php echo $vehicle['seller_telephone']; ?>', this)">Telefone</button>
                            <button onclick="OpenMaps('<?php echo $vehicle['seller_address']; ?>', '<?php echo $vehicle['seller_city']; ?>', '<?php echo $vehicle['seller_state']; ?>', '<?php echo $vehicle['seller_zipcode']; ?>')">Como chegar</button>
                            <!-- <button>Estoque</button> -->
                        </div>
                    </div>
                    <?php } ?>
                </div>
                <div class="col-12 col-md-4">
                    <div id="contact__box">
                        <form method="POST" action="#" id="contact__form" onsubmit="SendContact(event)">
                            <h1 class="title">Envie uma mensagem</h1>
                            <div class="input__row">
                                <label>Nome <b>*</b></label>
                                <input type="text" required maxlength="255" id="contact__name" value="<?php echo isset($user['name']) ? $user['name'] : ''; ?>" name="contact[name]">
                            </div>
                            <div class="input__row">
                                <label>E-mail <b>*</b></label>
                                <input type="email" required maxlength="550" id="contact__email" value="<?php echo isset($user['email']) ? $user['email'] : ''; ?>" name="contact[email]">
                            </div>
                            <div class="phone__row">
                                <label>Telefone <b>*</b></label>
                                <input type="text" required maxlength="50" id="contact__telephone" value="<?php echo isset($user['telephone']) ? $user['telephone'] : ''; ?>" name="contact[telephone]">
                            </div>
                            <div class="input__row">
                                <label>Mensagem <b>*</b></label>
                                <textarea id="contact__message" required name="contact[message]">Olá, tenho interesse no veículo. Por favor entre em contato.</textarea>
                            </div>
                            <div class="checkbox__row">
                                <input type="checkbox" id="contact__validate" name="contact__validate">
                                <label for="contact__validate">Receber ofertas e promoções.</label>
                            </div>
                            <div class="input__submit">
                                <button id="contact__submit">Enviar mensagem</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="need__help">
                        <i class="fa-regular fa-circle-question"></i>
                        <p>Precida de ajuda?</p>
                        <a href="<?php echo Route('help'); ?>">Fale conosco</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php require_once __DIR__ . '/../../templates/footer.php'; ?>
</body>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script type="text/javascript">

    // Envia a solicitação de contato
    function SendContact(event) {
        event.preventDefault();

        // Declara as variáveis
        const input__name = document.getElementById('contact__name');
        const input__email = document.getElementById('contact__email');
        const input__telephone = document.getElementById('contact__telephone');
        const input__message = document.getElementById('contact__message');
        const input__validate = document.getElementById('contact__validate');
        const input__submit = document.getElementById('contact__submit');

        const old__value = input__submit.innerHTML;
        input__submit.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i>';

        // Envia o AJAX
        $.ajax({
            type: "POST",
            url: base_url + "/api/vehicles/contact.php",
            data: {
                name: input__name.value,
                email: input__email.value,
                telephone: iti.getNumber(),
                message: input__message.value,
                newslatter: input__validate.checked,
                vehicle: <?php echo $vehicle['id']; ?>,
                seller: <?php echo $vehicle['seller']; ?>,
                link: window.location.href,
            },
            success: function(response) {
                response = JSON.parse(response);

                if (response.status === 'success') {
                    input__submit.innerHTML = old__value;

                    Swal.fire({
                      icon: 'success',
                      iconColor: '#729fff',
                      title: 'Mensagem enviada!',
                      html: "Fique atento ao seu e-mail e telefone para aguardar o retorno do vendedor.",
                      timerProgressBar: true,
                      timer: 5000,
                    });

                } else {
                    console.error('contact_error: ' + response);
                    input__submit.innerHTML = old__value;
                }

            },
            error: function(xhr, status, error) {
                console.error("contact_error:", error);
            }
        });

    }

    // Adiciona a mask no telefone
    var phoneInput = document.querySelector("#contact__telephone");
    iti = window.intlTelInput(phoneInput, {
        initialCountry: "auto",
        geoIpLookup: function(success, failure) {
            success('us');
        },
        utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@21.1.1/build/js/utils.js",
    });


    // Abre o slider das fotos
    const swiper = new Swiper('.swiper', {
      direction: 'horizontal',
      loop: true,

      pagination: {
        el: '.swiper-pagination',
      },

      navigation: {
        nextEl: '.swiper-button-next',
        prevEl: '.swiper-button-prev',
      },

    });


    // Compartilha nas redes
    function Share(social) {
        const currentUrl = window.location.href;
        let shareUrl = '';

        switch (social) {
            case 'facebook':
                shareUrl = `https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(currentUrl)}`;
                break;
            case 'twitter':
                shareUrl = `https://twitter.com/intent/tweet?url=${encodeURIComponent(currentUrl)}&text=Confira este veículo!`;
                break;
            case 'whatsapp':
                shareUrl = `https://api.whatsapp.com/send?text=${encodeURIComponent('Confira este veículo: ' + currentUrl)}`;
                break;
            default:
                console.log('Rede social não suportada');
                return;
        }

        window.open(shareUrl, '_blank', 'width=800,height=600');
    }


    // Link de como chegar
    function OpenMaps(address, city, state, zipcode) {
        const fullAddress = `${address}, ${city}, ${state} ${zipcode}`;
        const encodedAddress = encodeURIComponent(fullAddress);
        const googleMapsUrl = `https://www.google.com/maps/search/?api=1&query=${encodedAddress}`;
        window.open(googleMapsUrl, '_blank'); // Abre em uma nova aba
    }


    // Mostra o telefone do vendedor
    function ShowTelephone(telephone, button) {
        const { parsePhoneNumberFromString } = window.libphonenumber;
        const phoneNumber = parsePhoneNumberFromString(telephone);

        if (phoneNumber && phoneNumber.isValid()) {

            const formattedTelephone = phoneNumber.formatInternational();
            const old__value = button.innerHTML;
            const old__style = button.style;

            button.style.background = 'transparent';
            button.style.border = '1px solid #343a40';
            button.style.color = '#343a40';
            button.style.fontWeight = '400';

            window.open('tel:' + telephone, '_self');
            button.innerHTML = formattedTelephone;

        } else {
            button.innerHTML = telephone;
        }
    }
    
    // Carrega o position sticky
    document.addEventListener('DOMContentLoaded', function() {
        const contact__box = document.getElementById('contact__box');
        contact__box.style.top = contact__box.getBoundingClientRect().top + window.pageYOffset + 'px';
    });

</script>
</html>