<!DOCTYPE html>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php 

        $page_name = 'Help';

        // Configuration files
        require_once __DIR__ . '/../../inc/conn.php';
        require_once __DIR__ . '/../../inc/config.php';

        // Styling files
        require_once __DIR__ . '/../../inc/cdns.php';
        require_once __DIR__ . '/../../inc/functions.php';

    ?>

    <link rel="stylesheet" type="text/css" href="<?php echo $local['source'] . '/assets/vars.css'; ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo $local['source'] . '/assets/css/help.css'; ?>">

    <!-- JivoChat -->
    <script src="//code.jivosite.com/widget/d2An4pRm68" async></script>

</head>
<body>
    <?php require_once __DIR__ . '/../templates/topbar.php'; ?>
    <div class="content__box">
        <div class="container">
            <div class="row justify-content-center">
                <div style="margin-bottom: 0px;" class="col-12">
                    <div class="help__header">
                        <i class="fa-regular fa-life-ring"></i>
                        <h1 class="title">Central de ajuda</h1>
                        <hr>
                    </div>
                </div>
                <div style="margin-bottom: 15px;" class="col-12 col-md-3">
                    <div class="help__item">
                        <i class="fa-regular fa-life-ring"></i>
                        <h2>Atendimento</h2>
                        <p>
                            O atendimento no MyMotors está disponível de segunda a sexta-feira, das <b>9h às 18h</b>, exceto feriados nacionais. 
                        </p>
                    </div>
                </div>
                <div style="margin-bottom: 15px;" class="col-12 col-md-3">
                    <div class="help__item">
                        <i class="fa-regular fa-envelope"></i>
                        <h2>E-mail</h2>
                        <p>
                            Você pode entrar em contato com o nosso suporte através do e-mail <a href="mailto:support@mymotorsusa.com">support@mymotorsusa.com</a>.
                        </p>
                    </div>
                </div>
                <div style="margin-bottom: 15px;" class="col-12 col-md-3">
                    <div class="help__item">
                        <i class="fa-solid fa-headset"></i>
                        <h2>Ouvidoria</h2>
                        <p>
                            Para reclamações, entre em contato com nossa Ouvidoria através do e-mail <a href="mailto:ombudsman@mymotorsusa.com">ombudsman@mymotorsusa.com</a>.
                        </p>
                    </div>
                </div>
                <div style="margin-bottom: 15px;" class="col-12 col-md-3">
                    <div class="help__item">
                        <i class="fa-regular fa-message"></i>
                        <h2>Chat</h2>
                        <p>
                            Entre em contato conosco através do Chat ao-vivo disponível no canto inferior direito da tela.
                        </p>
                    </div>
                </div>
                <div style="margin-top: 30px;" class="col-12 mobile_no_margin"></div>
                <div class="col-12 col-md-8">
                    <h1 class="title">Dúvidas frequentes</h1>
                    <div id="help__faq">
                        <div class="accordion accordion-flush" id="faq">
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                                        O que é MyMotors?
                                    </button>
                                </h2>
                                <div id="collapseOne" class="accordion-collapse collapse" data-bs-parent="#faq">
                                    <div class="accordion-body"></div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                        Como posso anunciar um veículo no MyMotors?
                                    </button>
                                </h2>
                                <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#faq">
                                    <div class="accordion-body"></div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                        Quais são as vantagens de usar o MyMotors para comprar e vender veículos?
                                    </button>
                                </h2>
                                <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#faq">
                                    <div class="accordion-body"></div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                        Como faço para criar uma conta no MyMotors?
                                    </button>
                                </h2>
                                <div id="collapseFour" class="accordion-collapse collapse" data-bs-parent="#faq">
                                    <div class="accordion-body"></div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                                        Como posso recuperar minha senha no MyMotors?
                                    </button>
                                </h2>
                                <div id="collapseFive" class="accordion-collapse collapse" data-bs-parent="#faq">
                                    <div class="accordion-body"></div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                                        O MyMotors é seguro para transações online?
                                    </button>
                                </h2>
                                <div id="collapseSix" class="accordion-collapse collapse" data-bs-parent="#faq">
                                    <div class="accordion-body"></div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven">
                                        Quais métodos de pagamento são aceitos no MyMotors?
                                    </button>
                                </h2>
                                <div id="collapseSeven" class="accordion-collapse collapse" data-bs-parent="#faq">
                                    <div class="accordion-body"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <h1 id="terms__title" class="title">Termos</h1>
                    <div id="help__terms">
                        <div onclick="Route('terms-of-use')" class="term__item">
                            <i class="fa-solid fa-arrow-up-right-from-square"></i>
                            Termos de uso
                        </div>
                        <div onclick="Route('privacy-policies')" class="term__item">
                            <i class="fa-solid fa-arrow-up-right-from-square"></i>
                            Termos de privacidade
                        </div>
                    </div>
                </div>
                <div class="col-12 col-md-4">
                    <h1 style="text-align: center;" class="title">Faça uma pergunta</h1>
                    <div id="help__contact">
                        <form method="POST" action="" id="help__form" onsubmit="Contact(event)">
                            <div class="input__box">
                                <label>Nome <b>*</b></label>
                                <input type="text" oninput="VerifyForm()" value="<?php echo isset($user['name']) ? $user['name'] : '' ?>" <?php echo isset($user['name']) ? 'disabled' : '' ?> placeholder="ex: Jhon Doe" id="contact__name">
                            </div>
                            <div class="input__box">
                                <label>E-mail <b>*</b></label>
                                <input type="email" oninput="VerifyForm()" value="<?php echo isset($user['email']) ? $user['email'] : '' ?>" <?php echo isset($user['email']) ? 'disabled' : '' ?> placeholder="ex: jhon@email.com" id="contact__email">
                            </div>
                            <div class="input__box">
                                <label>Assunto <b>*</b></label>
                                <select oninput="VerifyForm()" id="contact__subject">
                                    <option value="">Selecione...</option>
                                    <option value="cadastro_login">Cadastro e Login</option>
                                    <option value="anuncios_buscas">Anúncios e Buscas</option>
                                    <option value="pagamentos_transacoes">Pagamentos e Transações</option>
                                    <option value="configuracoes_conta">Configurações de Conta</option>
                                    <option value="seguranca_privacidade">Segurança e Privacidade</option>
                                    <option value="funcionalidades_sistema">Funcionalidades Específicas do Sistema</option>
                                    <option value="problemas_tecnicos">Problemas Técnicos e Erros</option>
                                    <option value="politicas_termos">Políticas e Termos de Uso</option>
                                    <option value="contato_suporte">Contato e Suporte</option>
                                    <option value="outros">Outros</option>
                                </select>
                            </div>
                            <div class="input__box">
                                <label>Mensagem <b>*</b></label>
                                <textarea placeholder="Descreva a sua dúvida aqui" oninput="VerifyForm()" minlength="50" id="contact__message"></textarea>
                            </div>
                            <div class="input__submit">
                                <button disabled id="contact__submit">Enviar</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php require_once __DIR__ . '/../templates/footer.php'; ?>
</body>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script type="text/javascript">
    
    function Contact(event) {
        event.preventDefault();

        const input__name = document.getElementById('contact__name');
        const input__email = document.getElementById('contact__email');
        const input__subject = document.getElementById('contact__subject');
        const input__message = document.getElementById('contact__message');
        const input__submit = document.getElementById('contact__submit');

        const old__value = input__submit.innerHTML;
        input__submit.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i>';

        // Envia o AJAX
        $.ajax({
            type: "POST",
            url: base_url + "/api/help/contact.php",
            data: {
                name: input__name.value,
                email: input__email.value,
                subject: input__subject.value,
                message: input__message.value,
            },
            success: function(response) {
                response = JSON.parse(response);

                if (response.status === 'success') {
                    input__submit.innerHTML = old__value;

                    Swal.fire({
                      icon: 'success',
                      iconColor: '#729fff',
                      title: 'Mensagem enviada!',
                      html: "Fique atento ao seu e-mail e telefone para aguardar o retorno do suporte.",
                      timerProgressBar: true,
                      timer: 5000,
                    });

                    const help__form = document.getElementById('help__form');
                    help__form.reset();

                    input__subject.value = '';
                    input__message.value = '';

                } else {
                    console.error('contact_error: ' + response);
                    input__submit.innerHTML = old__value;
                }

            },
            error: function(xhr, status, error) {
                console.error("contact_error:", error);
            }
        });

    }

    function VerifyForm() {

        const input__name = document.getElementById('contact__name');
        const input__email = document.getElementById('contact__email');
        const input__subject = document.getElementById('contact__subject');
        const input__message = document.getElementById('contact__message');
        const input__submit = document.getElementById('contact__submit');

        if (input__name.value === '' || input__email.value === '' || input__subject.value === '' || input__message.value === '') {
            input__submit.disabled = true;
        } else {
            input__submit.disabled = false;
        }

    }

</script>
</html>