<!DOCTYPE html>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php 

        $page_name = 'Search';

        // Configuration files
        require_once __DIR__ . '/../../../inc/conn.php';
        require_once __DIR__ . '/../../../inc/config.php';

        // Styling files
        require_once __DIR__ . '/../../../inc/cdns.php';
        require_once __DIR__ . '/../../../inc/functions.php';

        // Filtra a query
        $search_type = null;
        $search_query = null;

        switch ($search_type) {
            case 'car':
                $formatted_type = 'Carros';
                break;

            case 'motorcycle':
                $formatted_type = 'Motos';
                break;

            case 'boat':
                $formatted_type = 'Barcos';
                break;
            
            default:
                $formatted_type = 'Ops, não encontramos nenhum carro como este!';
                break;
        }

        $result_title = (!empty($search_query) ? $formatted_type . ': ' .$search_query : $formatted_type);

    ?>

    <link rel="stylesheet" type="text/css" href="<?php echo $local['source'] . '/assets/vars.css'; ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo $local['source'] . '/assets/css/search.css'; ?>">

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.inputmask/5.0.9/jquery.inputmask.min.js"></script>

</head>
<body>
<?php require_once __DIR__ . '/../../templates/topbar.php'; ?>

    <div class="content__box">
        <div id="filter__box">
            <div class="filter__content">
                <form method="GET" action="" id="filter__form">

                    <input type="hidden" name="type" value="<?php echo $search_type; ?>">
                    <input type="hidden" name="query" value="<?php echo $search_query; ?>">

                    <div class="filter__mobile__menu">
                        <h1 class="title">Filtros</h1>
                        <div onclick="ToggleMobileFilter('close')" class="filter__close">
                            <i class="fa-solid fa-xmark"></i>
                        </div>
                    </div>

                    <div class="filter__item">
                        <h3 class="filter__title">Ordenar por</h3>
                        <select onchange="Filter('filter')" name="sort">
                            <option value="most_relevant">Mais relevantes</option>
                            <option value="biggest_price">Maior preço</option>
                            <option value="lowest_price">Menor preço</option>
                            <option value="newer_year">Ano mais novo</option>
                            <option value="mileage">Quilometragem</option>
                        </select>
                    </div>

                    <div class="filter__item">
                        <h3 class="filter__title">Ano</h3>
                        <div class="filter__input">
                            <div class="input__item">
                                <input type="year" placeholder="de" class="year__mask" name="y_min">
                                <label>ex: 2010</label>
                            </div>
                            <div class="input__item">
                                <input type="year" placeholder="até" class="year__mask" name="y_max">
                                <label>ex: 2020</label>
                            </div>
                        </div>
                    </div>
                    <div class="filter__item">
                        <h3 class="filter__title">Preço</h3>
                        <div class="filter__input">
                            <div class="input__item">
                                <input type="year" placeholder="de" class="money__mask" name="p_min">
                                <label>ex: $ 40.000</label>
                            </div>
                            <div class="input__item">
                                <input type="year" placeholder="até" class="money__mask" name="p_max">
                                <label>ex: $ 80.000</label>
                            </div>
                        </div>
                    </div>
                    <div class="filter__item">
                        <h3 class="filter__title">Quilometragem</h3>
                        <div class="filter__input">
                            <div class="input__item">
                                <input type="year" placeholder="de" class="mileage__mask" name="k_min">
                                <label>ex: 10,000 <?php echo $search_type == 'boat' ? 'hr' : 'mi'; ?></label>
                            </div>
                            <div class="input__item">
                                <input type="year" placeholder="até" class="mileage__mask" name="k_max">
                                <label>ex: 40,000 <?php echo $search_type == 'boat' ? 'hr' : 'mi'; ?></label>
                            </div>
                        </div>
                    </div>
                    <div class="filter__item">
                        <h3 class="filter__title">Marca</h3>
                        <div id="filter__brand__box" class="filter__check">

                        </div>
                    </div>
                    <div class="filter__item">
                        <h3 class="filter__title">Câmbio</h3>
                        <div id="filter__transmission__box" class="filter__check">

                        </div>
                    </div>
                    <div class="filter__item">
                        <h3 class="filter__title">Combustível</h3>
                        <div id="filter__fuel__box" class="filter__check">

                        </div>
                    </div>
                </form>
            </div>
            <div class="filter__actions">
                <button onclick="Filter('filter')" id="action__filter">Filtrar</button>
                <button onclick="Filter('reset')" id="action__reset">Resetar</button>
            </div>
        </div>
        <div id="listing__header">
            <div id="listing__title">
                <h1 id="title__results" class="query"><?php echo $result_title; ?></h1>
                <p id="subtitle__results" class="results">Mostrando 0 de 0 resultados.</p>
            </div>
            <div class="header__menu">
                <div class="header__search">
                    <svg onclick="Filter('filter')" data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true"><path stroke-linecap="round" stroke-linejoin="round" d="m21 21-5.197-5.197m0 0A7.5 7.5 0 1 0 5.196 5.196a7.5 7.5 0 0 0 10.607 10.607Z"></path></svg>
                    <input type="search" value="<?php echo $search_query; ?>" id="filter__query" onkeydown="if(event.key === 'Enter') Filter('filter')" placeholder="Busque pela marca ou modelo" name="">
                </div>
                <div onclick="ToggleMobileFilter('open')" class="mobile__filter">
                    <i class="fa-solid fa-filter"></i>
                </div>
            </div>
        </div>
        <div id="loading__box">
            <i class="fa-solid fa-circle-notch fa-spin"></i>
        </div>
        <div id="listing__box">

        </div>
        <div id="loading__row">
            <p>Carregando...</p>
        </div>
    </div>
</body>
<script type="text/javascript">

    var to_filter = false;
    var is_loading = true;

    var per_page = 50;
    var current_page = 1;
    var showing__rows = 0;

    function List(is_filter = false, page = 1, load = false) {

        // Declara as variáveis
        const filter__query = document.getElementById('filter__query');
        const list__box = document.getElementById('listing__box');
        const load__box = document.getElementById('loading__box');
        const load__row = document.getElementById('loading__row');

        // Limpa ou carrega
        if (load) {
            load__row.style.display = 'flex';
        } else {
            // Inicia o carregamento
            list__box.style.display = 'none';
            load__box.style.display = 'flex';
            list__box.innerHTML = ``
        }


        // Envia o AJAX
        $.ajax({
            type: "POST",
            url: base_url + "/api/search/list.php",
            data: {
                page: current_page,
                per_page: per_page,
                type: '<?php echo $search_type; ?>',
                query: filter__query.value,
                filters: is_filter ? GetFilter() : null,
            },
            success: function(response) {
                console.log(response);

                if (response.status === 'success') {
                    const rows = response.rows;

                    // Atualiza o titulo
                    const title__results = document.getElementById('title__results');
                    const defaut__title = '<?php echo $formatted_type; ?>' + (filter__query.value !== '' ? ': ' + filter__query.value : '');
                    response.total === 0 ? title__results.innerHTML = 'Ops, não encontramos nenhum carro como este!' : title__results.innerHTML = defaut__title;

                    if (response.total.show === 0 && response.total.all <= per_page) {
                        showing__rows = response.total.all;
                    } else if (response.total.show === per_page && response.total.show <= response.total.all) {
                        showing__rows = per_page * current_page;
                    } else if (response.total.show === response.total.all && response.total.all < per_page) {
                        showing__rows = response.total.show;
                    } else {
                        showing__rows = per_page * current_page;
                    }

                    // Atualiza o subtitulo
                    const subtitle__results = document.getElementById('subtitle__results');
                    subtitle__results.innerHTML = 'Mostrando ' + showing__rows + ' de ' + response.total.all;

                    rows.forEach((item) => {
                        list__box.innerHTML += `
                        <div id=${item.code} class="vehicle__item">
                            <div onclick="Route('${item.route}')" class="vehicle__picture">
                                <div onmouseenter="HoverPicture('enter', '${item.photos && item.photos[1] ? base_url + '/assets/attachments/vehicles/' + item.code + '/' + (item.photos[1] ? item.photos[1] : item.photos[0]) : 'https://i.ibb.co/sWStrwH/no-picture-1.png'}', this)" onmouseleave="HoverPicture('leave', '${item.photos && item.photos[0] ? base_url + '/assets/attachments/vehicles/' + item.code + '/' + item.photos[0] : 'https://i.ibb.co/sWStrwH/no-picture-1.png'}', this)" style="background: url('${item.photos && item.photos[0] ? base_url + '/assets/attachments/vehicles/' + item.code + '/' + item.photos[0] : 'https://i.ibb.co/sWStrwH/no-picture-1.png'}');" class="picture__item"></div>
                            </div>
                            <div class="vehicle__details">
                                <h3 onclick="Route('${item.route}')" class="vehicle__title">${item.title}</h3>
                                <p onclick="Route('${item.route}')" class="vehicle__attributes">${item.subtitle}</p>
                                <h2 class="vehicle__price">${item.formated_price}</h2>
                                <div class="vehicle__statistics">
                                    <p class="vehicle__year">${item.year}</p>
                                    <p class="vehicle__mileage">${item.mileage}</p>
                                </div>
                                <div class="vehicle__action">
                                    <button onclick="Route('${item.route}')">Ver parcelas</button>
                                </div>
                            </div>
                            <div class="vehicle__footer">
                                <div class="vehicle__location">${item.city + ', ' + item.state}</div>
                                <div class="vehicle__icons">
                                    <span onclick="Like(${item.id}, this)" data-like="${item.like}">
                                        ${item.like ? '<svg data-slot="icon" fill="red" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true"><path d="m11.645 20.91-.007-.003-.022-.012a15.247 15.247 0 0 1-.383-.218 25.18 25.18 0 0 1-4.244-3.17C4.688 15.36 2.25 12.174 2.25 8.25 2.25 5.322 4.714 3 7.688 3A5.5 5.5 0 0 1 12 5.052 5.5 5.5 0 0 1 16.313 3c2.973 0 5.437 2.322 5.437 5.25 0 3.925-2.438 7.111-4.739 9.256a25.175 25.175 0 0 1-4.244 3.17 15.247 15.247 0 0 1-.383.219l-.022.012-.007.004-.003.001a.752.752 0 0 1-.704 0l-.003-.001Z"></path></svg>' : '<svg data-slot="icon" fill="none" stroke="#343a4050" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true"><path stroke-linecap="round" stroke-linejoin="round" d="M21 8.25c0-2.485-2.099-4.5-4.688-4.5-1.935 0-3.597 1.126-4.312 2.733-.715-1.607-2.377-2.733-4.313-2.733C5.1 3.75 3 5.765 3 8.25c0 7.22 9 12 9 12s9-4.78 9-12Z"></path></svg>'}
                                    </span>
                                </div>
                            </div>
                        </div>
                        `;
                    });

                    // Fecha o carregamento
                    load__box.style.display = 'none';
                    list__box.style.display = 'grid';

                    // Verifica se já carregou todos
                    response.total.show === 0 ? is_loading = true : is_loading = false;

                    // Tira o carregamento inferior
                    load__row.style.display = 'none';

                    // Verifica se tá filtrando
                    if (is_filter === false) {

                        const filterForm = document.getElementById('filter__form');
                        filterForm.reset();

                        // Adiciona as marcas
                        var brands = response.brands;
                        var brandCount = brands.reduce((acc, brand) => {
                            acc[brand.name] = (acc[brand.name] || 0) + 1;
                            return acc;
                        }, {});

                        var sortedBrandCount = Object.entries(brandCount).sort((a, b) => b[1] - a[1]);
                        var filterBox = document.getElementById('filter__brand__box');
                        brands.length === 0 ? filterBox.parentNode.style.display = 'none' : filterBox.parentNode.style.display = 'block';
                        filterBox.innerHTML = '';

                        // Itera sobre as marcas ordenadas e cria os checkboxes
                        sortedBrandCount.forEach(([brandName, count]) => {
                            var brand = brands.find(b => b.name === brandName);
                            var checkboxId = 'filter__brand__' + brandName.toLowerCase().replace(/\s+/g, '_');
                            
                            filterBox.innerHTML += `
                                <div class="check__item">
                                    <input type="checkbox" value="${brand.id}" id="${'brand_' + checkboxId}" name="b">
                                    <label for="${'brand_' + checkboxId}">${brandName} (${count})</label>
                                </div>
                            `;
                        });

                        // Adiciona os combustíveis
                        var fuels = response.fuels;
                        var fuelCount = fuels.reduce((acc, fuel) => {
                            acc[fuel.en] = (acc[fuel.en] || 0) + 1;
                            return acc;
                        }, {});

                        var sortedFuelCount = Object.entries(fuelCount).sort((a, b) => b[1] - a[1]);
                        var filterBoxFuel = document.getElementById('filter__fuel__box');
                        fuels.length === 0 ? filterBoxFuel.parentNode.style.display = 'none' : filterBoxFuel.parentNode.style.display = 'block';
                        filterBoxFuel.innerHTML = '';

                        sortedFuelCount.forEach(([fuel, count]) => {
                            var checkboxId = 'filter__fuel__' + fuel.toLowerCase().replace(/\s+/g, '_');
                            filterBoxFuel.innerHTML += `
                                <div class="check__item">
                                    <input type="checkbox" value="${fuel}" id="${'fuel_' + checkboxId}" name="f">
                                    <label for="${'fuel_' + checkboxId}">${response.fuels.find(item => item.en === fuel).pt} (${count})</label>
                                </div>
                            `;
                        });

                        // Adiciona os câmbios
                        var transmissions = response.transmissions;
                        var transmissionCount = transmissions.reduce((acc, transmission) => {
                            acc[transmission.en] = (acc[transmission.en] || 0) + 1;
                            return acc;
                        }, {});

                        var sortedTransmissionCount = Object.entries(transmissionCount).sort((a, b) => b[1] - a[1]);
                        var filterBoxTransmission = document.getElementById('filter__transmission__box');
                        transmissions.length === 0 ? filterBoxTransmission.parentNode.style.display = 'none' : filterBoxTransmission.parentNode.style.display = 'block';
                        filterBoxTransmission.innerHTML = '';

                        sortedTransmissionCount.forEach(([transmission, count]) => {
                            var checkboxId = 'filter__transmission__' + transmission.toLowerCase().replace(/\s+/g, '_');
                            filterBoxTransmission.innerHTML += `
                                <div class="check__item">
                                    <input type="checkbox" value="${transmission}" id="${'transmission_' + checkboxId}" name="t">
                                    <label for="${'transmission_' + checkboxId}">${response.transmissions.find(item => item.en === transmission).pt} (${count})</label>
                                </div>
                            `;
                        });

                    }


                } else if (response.status === 'not_found') {

                } else {

                }

            },
            error: function(xhr, status, error) {
                console.error("list__error: ", error);
            }
        });

    }

    function HoverPicture(action, file, box) {
        box.style.background = 'url("' + file + '")';
    }

    function ToggleMobileFilter(action) {
        const filter__box = document.getElementById('filter__box');

        if (action === 'open') {
            filter__box.style.left = 0;

        } else if (action === 'close') {
            filter__box.style.left = '-150%';

        }

    }

    function GetFilter() {
        const form__filter = document.getElementById('filter__form');
        const filter__data = new FormData(form__filter);
        const filter__row = {};

        for (const [key, value] of filter__data.entries()) {
            if (filter__row.hasOwnProperty(key)) {
                if (Array.isArray(filter__row[key])) {
                    filter__row[key].push(value);
                } else {
                    filter__row[key] = [filter__row[key], value];
                }
            } else {
                filter__row[key] = value;
            }
        }

        return filter__row;
    }

    function Filter(action) {
        switch (action) {
            case 'filter':
                current_page = 1;

                to_filter = true;
                is_loading = true;

                List(to_filter, current_page, false);
                break;

            case 'reset':
                current_page = 1;

                to_filter = false;
                is_loading = true;

                List(to_filter, 1, false);
                break;

            default:
        }

        ToggleMobileFilter('close');
    }

    function checkScrollAtBottom() {
        if ((window.innerHeight + window.scrollY) >= document.body.offsetHeight) {
            if (!is_loading) {
                is_loading = true;
                current_page = current_page + 1;
                List(to_filter, current_page, true);
            }
        }
    }

    // Adiciona um event listener para o evento de scroll
    window.addEventListener('scroll', checkScrollAtBottom);

    List();

    $(document).ready(function(){

        $('.money__mask').inputmask({
            alias: 'currency',
            prefix: '$ ',
            groupSeparator: '.',
            radixPoint: ',',
            autoGroup: true,
            digits: 0,
            rightAlign: false,
            placeholder: '0'
        });

        $('.mileage__mask').inputmask({
            alias: 'numeric',
            groupSeparator: '.',
            radixPoint: ',',
            autoGroup: true,
            digits: 0,
            rightAlign: false,
            placeholder: '0'
        });

        $('.year__mask').inputmask('9999',{ 
            placeholder: '', 
            clearIncomplete: true 
        });

    });

</script>
</html>