<?php

    require_once __DIR__ . '/inc/config.php';

    function RemoveAccents($str) {
        $str = mb_convert_encoding($str, 'UTF-8', 'UTF-8');
        $str = htmlentities($str, ENT_NOQUOTES, 'UTF-8');
        $str = preg_replace('/&([a-zA-Z])(uml|acute|grave|circ|tilde);/', '$1', $str);
        return html_entity_decode($str, ENT_NOQUOTES, 'UTF-8');
    }

    function VehicleRoute($vehicle) {
        $formattedModel = RemoveAccents(strtolower(str_replace([' ', '-', '_'], '-', $vehicle['model'])));
        $formattedBrand = isset($vehicle['brand_name']) ? RemoveAccents(strtolower(str_replace([' ', '-', '_'], '-', $vehicle['brand_name']))) : '';
        $brand_name = isset($vehicle['brand_name']) ? $formattedBrand . '/' : '';
        $link = $vehicle['type'] . '/' . $brand_name . $formattedModel . '/' . $vehicle['id'] . '/' . $vehicle['code'];
        return $link;
    }

    function FormatRoute($route) {
        return RemoveAccents(strtolower(str_replace([' ', '-', '_'], '-', $route)));
    }

    $rotas = [

        '' => 'src/views/home.php',
        'search' => 'src/views/search.php',

        // structure
        'help' => 'src/views/help.php',
        'privacy-policies' => 'src/templates/privacy-policies.php',
        'terms-of-use' => 'src/templates/terms-of-use.php',

        // authentication
        'login' => 'src/views/authentication/login.php',
        'logout' => 'src/views/authentication/logout.php',
        'register' => 'src/views/authentication/register.php',
        'recovery' => 'src/views/authentication/register.php',

        // Account
        'garage' => 'src/views/account/garage.php',
        'profile' => 'src/views/account/profile.php',
        'favorites' => 'src/views/account/favorites.php',

        // Sell
        'sell' => 'src/views/sell/new.php',

    ];

    // Mapeia as rotas dos anuncios
    $consulta = "SELECT vehicles.id, 
                        vehicles.type,
                        vehicles.model,
                        vehicles.code,
                        brands.name AS brand_name

                 FROM vehicles 
                 LEFT JOIN brands ON brands.id = vehicles.brand

                 WHERE status = 1";

    $con = $conn->query($consulta) or die($conn->error);
    while($dado = $con->fetch_array()) {
        $rotas[VehicleRoute($dado)] = 'src/views/vehicles/show.php';
    }

    // Mapeia o URI
    function getNormalizedUri() {
        $scriptPath = dirname($_SERVER['SCRIPT_NAME']);
        $uri = substr($_SERVER['REQUEST_URI'], strlen($scriptPath));
        if (strpos($uri, '?') !== false) {
            $uri = substr($uri, 0, strpos($uri, '?'));
        }
        return trim($uri, '/');
    }

    // Mapeia o URI normalizado
    $uri = getNormalizedUri();

    // Conecta o URI com a rota
    if (array_key_exists($uri, $rotas)) {
        require $rotas[$uri];

    } else { require 'src/templates/404.php'; }

?>