<?php 

session_start();
header('Content-type: application/json');

$removeJs = true;
require_once __DIR__ . '/../../inc/conn.php';
require_once __DIR__ . '/../../inc/config.php';
require_once __DIR__ . '/../../inc/functions.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST'
    && isset($_POST['code']) && isset($_POST['type'])) {

    // Define as variáveis
    $code = $_POST['code'];
    $type = $_POST['type'];
    $seller = $_SESSION['user']['id'];
    $step = isset($_POST['step']) ? intval($_POST['step']) : 0;

    switch ($step) {

        // Step One
        case 1:

            // Define os params
            $params = json_decode($_POST['params'], true);

            // Verifica se a marca já existe no db e insere
            $sql = "INSERT IGNORE INTO brands (name) VALUES (?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("s", $params['brand']);
            $stmt->execute();

            // Atualiza o registro no db
            $fields = [];
            $values = [];
            $types = '';

            if (isset($params['brand'])) {
                $fields[] = 'brand = (SELECT id FROM brands WHERE name = ?)';
                $values[] = $params['brand'];
                $types .= 's';
            }
            if (isset($params['model'])) {
                $fields[] = 'model = ?';
                $values[] = $params['model'];
                $types .= 's';
            }
            if (isset($params['transmission'])) {
                $fields[] = 'transmission = ?';
                $values[] = $params['transmission'];
                $types .= 's';
            }
            if (isset($params['fuel'])) {
                $fields[] = 'fuel = ?';
                $values[] = $params['fuel'];
                $types .= 's';
            }
            if (isset($params['body'])) {
                $fields[] = 'body = ?';
                $values[] = $params['body'];
                $types .= 's';
            }
            if (isset($params['mileage'])) {
                $fields[] = 'mileage = ?';
                $values[] = $params['mileage'];
                $types .= 's';
            }
            if (isset($params['plate'])) {
                $fields[] = 'plate = ?';
                $values[] = $params['plate'];
                $types .= 's';
            }
            if (isset($params['seats'])) {
                $fields[] = 'seats = ?';
                $values[] = $params['seats'];
                $types .= 's';
            }
            if (isset($params['color'])) {
                $fields[] = 'color = ?';
                $values[] = $params['color'];
                $types .= 's';
            }
            if (isset($params['year_build'])) {
                $fields[] = 'year_build = ?';
                $values[] = $params['year_build'];
                $types .= 's';
            }
            if (isset($params['year_model'])) {
                $fields[] = 'year_model = ?';
                $values[] = $params['year_model'];
                $types .= 's';
            }

            // Verifica e responde
            if (!empty($fields)) {
                $values[] = $code;
                $types .= 's';

                $sql = "UPDATE vehicles SET " . implode(', ', $fields) . " WHERE code = ?";

                $stmt = $conn->prepare($sql);
                $stmt->bind_param($types, ...$values);

                if ($stmt->execute()) {
                    $response = array(
                        'status' => 'success',
                        'message' => 'Updated',
                        'params' => $_POST['params'],
                        'step' => $step,
                    );
                } else {
                    $response = array(
                        'status' => 'error',
                        'message' => 'Erro no UPDATE',
                        'params' => $_POST['params'],
                        'step' => $step,
                    );
                }

                $stmt->close();

            } else {
                $response = array(
                    'status' => 'error',
                    'message' => 'Erro no UPDATE parametros não definidos',
                    'params' => $_POST['params'],
                    'step' => $step,
                );
            }

            break;

        // Step Two
        case 2:

            $params = isset($_POST['params']) ? $_POST['params'] : '';

            $sql = "UPDATE vehicles SET conditions = ? WHERE code = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ss", $params, $code);
            
            if ($stmt->execute()) {
                $response = array(
                    'status' => 'success',
                    'message' => 'Updated',
                    'params' => $params,
                    'step' => $step,
                );
            } else {
                $response = array(
                    'status' => 'error',
                    'message' => 'Erro no UPDATE',
                    'params' => $params,
                    'step' => $step,
                );
            }

            break;

        // Step Three
        case 3:

            $params = isset($_POST['params']) ? $_POST['params'] : '';

            $sql = "UPDATE vehicles SET details = ? WHERE code = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ss", $params, $code);
            
            if ($stmt->execute()) {
                $response = array(
                    'status' => 'success',
                    'message' => 'Updated',
                    'params' => $params,
                    'step' => $step,
                );
            } else {
                $response = array(
                    'status' => 'error',
                    'message' => 'Erro no UPDATE',
                    'params' => $params,
                    'step' => $step,
                );
            }

            break;

        // Step Four
        case 4:

            $params = isset($_FILES) ? $_FILES : '';
            $pictures = [];

            $folder = '../../assets/attachments/vehicles/' . $code;
            $error['status'] = false;

            // Verifica o diretório
            if (!is_dir($folder)) { 
                mkdir($folder, 0777, true); 
            }

            foreach ($params as $file) {
                $extension = pathinfo($file['name'], PATHINFO_EXTENSION);
                $filename = md5($file['name']) . '.' . $extension;
                $filepath = $folder . '/' . $filename;

                if (move_uploaded_file($file['tmp_name'], $filepath)) {
                    $pictures[] = $filename;
                } else {
                    $error['status'] = true;
                    $error['files'][] = $file['name'];
                }
                
            }

            if ($error['status']) {
                $response = array(
                    'status' => 'upload__error',
                    'files' => isset($error['files']) ? $error['files'] : null,
                    'folder' => $folder,
                    'step' => $step,
                );
            } else {

                $picturesJson = json_encode($pictures);
                
                $sql = "UPDATE vehicles SET photos = ? WHERE code = ?";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("ss", $picturesJson, $code);
                
                if ($stmt->execute()) {
                    $response = array(
                        'status' => 'success__test',
                        'pictures' => $pictures,
                        'code' => $code,
                        'step' => $step,
                    );
                } else {
                    $response = array(
                        'status' => 'update__error',
                        'message' => 'Erro ao atualizar no db',
                        'step' => $step,
                    );
                }

            }

            break;
        
        // Error
        default:
            $response = array(
                'status' => 'error',
                'message' => 'Undefined step',
                'step' => $step,
            );
            break;
    }

} else { $response['status'] = 'invalid'; $response['post'] = $_POST; }

echo json_encode($response);

?>