<?php

    session_start();
    require_once __DIR__ . '/../../inc/conn.php';

    $name = $_POST['name'];
    $mail = $_POST['email'];
    $password = hash('sha256', $_POST['password']);

    $response = [];

    // Verifica se o email já está registrado
    $stmt = $conn->prepare("SELECT * FROM users WHERE email = ?");
    $stmt->bind_param("s", $mail);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $response['status'] = 'existent_email';
        $response['message'] = 'Email já registrado.';
    } else {
        // Insere o novo usuário no banco de dados
        $stmt = $conn->prepare("INSERT INTO users (name, email, password, status) VALUES (?, ?, ?, 1)");
        $stmt->bind_param("sss", $name, $mail, $password);

        if ($stmt->execute()) {
            // Pega o ID do novo registro
            $new_user_id = $stmt->insert_id;

            // Recupera o registro completo do novo usuário
            $stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
            $stmt->bind_param("i", $new_user_id);
            $stmt->execute();
            $result = $stmt->get_result();
            $usuario = $result->fetch_assoc();

            $response['status'] = 'success';
            $response['message'] = 'Usuário registrado com sucesso.';

            // Inicia a sessão do usuário com os dados do banco de dados
            $_SESSION['user'] = $usuario;
        } else {
            $response['status'] = 'error';
            $response['message'] = 'Erro ao registrar o usuário. Por favor, tente novamente.';
        }
    }

    $stmt->close();

    header('Content-Type: application/json');
    echo json_encode($response);

?>
