<!DOCTYPE html>
<html>
<head>

	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<?php $page_name = 'Buscar Propriedades'; ?>

	<?php require_once __DIR__ . '/../../inc/conn.php'; ?>
	<?php require_once __DIR__ . '/../../inc/variables.php'; ?>

	<?php require_once __DIR__ . '/../../inc/cdns.php'; ?>
	<?php require_once __DIR__ . '/../../inc/styles.php'; ?>

	<?php if ($plan['search'] == 0) { Route('projects'); } ?>
	
	<title><?php echo $page_name . ' | ' . $app['name']; ?></title>

	<?php if (!isset($_SESSION['user'])) { Route('entrar'); } ?>

	<link rel="stylesheet" type="text/css" href="<?php echo $local['assets'] . '/css/search.css'; ?>">

</head>
<body>

	<?php require_once __DIR__ . '/../layout/topbar.php'; ?>

	<div class="content">
		<div class="container">
			<div class="row">
				<div style="text-align: center;" class="col-12">
					<h1 class="title">Buscar Propriedades</h1>
					<p class="subtitle">Pesquise estimativas de aluguel, comparações e tendências de mercado para qualquer propriedade nos EUA e Canadá.</p>
				</div>
			</div>
			<div style="margin-top: 40px;" class="row">
				<div class="col-12 col-md-10 mx-auto">
					<div class="search__box">
						<div class="row">
							<div style="margin-bottom: 10px;" class="col-12 col-md-12 col-lg-4">
								<div class="input__box">
									<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
									  <path stroke-linecap="round" stroke-linejoin="round" d="M12 21a9.004 9.004 0 0 0 8.716-6.747M12 21a9.004 9.004 0 0 1-8.716-6.747M12 21c2.485 0 4.5-4.03 4.5-9S14.485 3 12 3m0 18c-2.485 0-4.5-4.03-4.5-9S9.515 3 12 3m0 0a8.997 8.997 0 0 1 7.843 4.582M12 3a8.997 8.997 0 0 0-7.843 4.582m15.686 0A11.953 11.953 0 0 1 12 10.5c-2.998 0-5.74-1.1-7.843-2.918m15.686 0A8.959 8.959 0 0 1 21 12c0 .778-.099 1.533-.284 2.253m0 0A17.919 17.919 0 0 1 12 16.5c-3.162 0-6.133-.815-8.716-2.247m0 0A9.015 9.015 0 0 1 3 12c0-1.605.42-3.113 1.157-4.418"></path>
									</svg>
									<input type="text" oninput="handleAddressInput()" placeholder="Endereço" id="search__address">
								</div>
								<div id="suggestion__box" class="suggestion__box">
									
								</div>
							</div>
							<div style="margin-bottom: 10px;" class="col-12 col-md-4 col-lg-3">
								<div class="input__box">
									<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
									  <path stroke-linecap="round" stroke-linejoin="round" d="M9 6.75V15m6-6v8.25m.503 3.498 4.875-2.437c.381-.19.622-.58.622-1.006V4.82c0-.836-.88-1.38-1.628-1.006l-3.869 1.934c-.317.159-.69.159-1.006 0L9.503 3.252a1.125 1.125 0 0 0-1.006 0L3.622 5.689C3.24 5.88 3 6.27 3 6.695V19.18c0 .836.88 1.38 1.628 1.006l3.869-1.934c.317-.159.69-.159 1.006 0l4.994 2.497c.317.158.69.158 1.006 0Z"></path>
									</svg>
									<input type="text" placeholder="Zipcode (código postal)" id="search__zipcode">
								</div>
							</div>
							<div style="margin-bottom: 10px;" class="col-7 col-md-5 col-lg-3">
								<div class="input__box">
									<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
									  <path stroke-linecap="round" stroke-linejoin="round" d="M15 10.5a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z"></path>
									  <path stroke-linecap="round" stroke-linejoin="round" d="M19.5 10.5c0 7.142-7.5 11.25-7.5 11.25S4.5 17.642 4.5 10.5a7.5 7.5 0 1 1 15 0Z"></path>
									</svg>
									<input type="text" oninput="handleAddressCity()" placeholder="Cidade" id="search__city">
								</div>	
								<div id="suggestion__box__city" class="suggestion__box">
									
								</div>
							</div>
							<div style="margin-bottom: 10px;" class="col-5 col-md-3 col-lg-2">
								<div class="input__box">
									<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
									  <path stroke-linecap="round" stroke-linejoin="round" d="M15 10.5a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z"></path>
									  <path stroke-linecap="round" stroke-linejoin="round" d="M19.5 10.5c0 7.142-7.5 11.25-7.5 11.25S4.5 17.642 4.5 10.5a7.5 7.5 0 1 1 15 0Z"></path>
									</svg>
									<input type="text" placeholder="Estado" class="maskStateCode" id="search__state">
								</div>	
							</div>
							<div class="col-12">
								<div style="margin: 5px 0px 15px 0px" class="divider__box">
									<hr>
									<p>Filtros de busca (opcional)</p>
									<hr>
								</div>
							</div>
							<div class="col-12">
								<div class="row">
									<div style="margin-bottom: 10px;" class="col-12 col-md-6 col-lg-3">
										<div class="input__box">
											<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
											  <path stroke-linecap="round" stroke-linejoin="round" d="M2.25 21h19.5m-18-18v18m10.5-18v18m6-13.5V21M6.75 6.75h.75m-.75 3h.75m-.75 3h.75m3-6h.75m-.75 3h.75m-.75 3h.75M6.75 21v-3.375c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21M3 3h12m-.75 4.5H21m-3.75 3.75h.008v.008h-.008v-.008Zm0 3h.008v.008h-.008v-.008Zm0 3h.008v.008h-.008v-.008Z"></path>
											</svg>
											<select required id="filter__property__type">
												<option value="">Tipo de propriedade</option>
												<option value="">Todos</option>
												<option value="townhome">Townhomes</option>
												<option value="single_family">Single-Family</option>
												<option value="coop">Co-ops</option>
												<option value="condo">Condo</option>
												<option value="condop">Condop</option>
												<option value="apartment">Apartments</option>
												<option value="land">Lands</option>
											</select>
										</div>
									</div>
									<div style="margin-bottom: 10px;" class="col-12 col-md-6 col-lg-3">
										<div class="input__box">
											<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
											  <path stroke-linecap="round" stroke-linejoin="round" d="M12 6v12m-3-2.818.879.659c1.171.879 3.07.879 4.242 0 1.172-.879 1.172-2.303 0-3.182C13.536 12.219 12.768 12 12 12c-.725 0-1.45-.22-2.003-.659-1.106-.879-1.106-2.303 0-3.182s2.9-.879 4.006 0l.415.33M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z"></path>
											</svg>
											<select required id="filter__transaction__type">
												<option value="">Tipo de Transação</option>
												<option value="sale">Venda</option>
												<option value="rent">Aluguel</option>
												<option value="sold">Vendido</option>
											</select>
										</div>
									</div>
									<div style="margin-bottom: 10px;" class="col-12 col-md-6 col-lg-3">
										<div class="input__box">
											<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
											  <path stroke-linecap="round" stroke-linejoin="round" d="m2.25 12 8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25"></path>
											</svg>
											<select required id="filter__bedrooms">
												<option value="">Quartos</option>
												<option value="">Estúdio</option>
												<option value="1">1 quarto</option>
												<option value="2">2 quartos</option>
												<option value="3">3 quartos</option>
												<option value="4">4 quartos</option>
												<option value="5">5 quartos</option>
												<option value="6">6+ quartos</option>
											</select>
										</div>
									</div>
									<div style="margin-bottom: 10px;" class="col-12 col-md-6 col-lg-3">
										<div class="input__box">
											<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
											  <path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6A2.25 2.25 0 0 1 6 3.75h2.25A2.25 2.25 0 0 1 10.5 6v2.25a2.25 2.25 0 0 1-2.25 2.25H6a2.25 2.25 0 0 1-2.25-2.25V6ZM3.75 15.75A2.25 2.25 0 0 1 6 13.5h2.25a2.25 2.25 0 0 1 2.25 2.25V18a2.25 2.25 0 0 1-2.25 2.25H6A2.25 2.25 0 0 1 3.75 18v-2.25ZM13.5 6a2.25 2.25 0 0 1 2.25-2.25H18A2.25 2.25 0 0 1 20.25 6v2.25A2.25 2.25 0 0 1 18 10.5h-2.25a2.25 2.25 0 0 1-2.25-2.25V6ZM13.5 15.75a2.25 2.25 0 0 1 2.25-2.25H18a2.25 2.25 0 0 1 2.25 2.25V18A2.25 2.25 0 0 1 18 20.25h-2.25A2.25 2.25 0 0 1 13.5 18v-2.25Z"></path>
											</svg>
											<select required id="filter__bathroom">
												<option value="">Banheiros</option>
												<option value="1">1 banheiro</option>
												<option value="2">2 banheiros</option>
												<option value="3">3 banheiros</option>
												<option value="4">4+ banheiros</option>
											</select>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div style="margin-top: 40px;" class="row justify-content-center">
				<div style="margin-bottom: 15px !important;" class="col-12 col-md-6 col-lg-3">
					<button onclick="SearchProperty()" id="searchProperty">Buscar</button>
				</div>
				<div style="margin-bottom: 15px !important;" class="col-12 col-md-6 col-lg-3">
					<button onclick="SearchNearMe()" id="searchNearMe">Buscar no meu endereço</button>
				</div>
				<div style="margin-top: 25px;" class="col-11 mx-auto">
					<p id="message__error"></p>
				</div>
			</div>
			<div style="margin-top: 35px;" class="row">
				<div class="col-12">
					<div id="success__header">
						<div class="row">
							<div class="col-12">
								<div style="text-align: center; margin-bottom: 45px;" class="title__map">
									<h1 id="success__query" class="title"></h1>
									<div class="subtitle">Mostrando <span id="resultqntd"></span> resultados.</div>
								</div>
							</div>
							<div style="margin-bottom: 15px;" class="col-12 col-md-12 col-lg-3">
								<div class="result__module">
									<div class="row">
										<div style="margin-bottom: 30px;" class="col-12 mx-auto">
											<div class="estimated__box">
												<label class="estimated__tag estimated__sale">Média venda</label>
												<h1 id="average__sale" class="price__title">$949,500.00</h1>
												<div class="middle__divider">
													<div class="left">
														<p id="average__sqft__sale" class="price__subtitle">$ 714.28</p>
														<p class="price__description">per sq.ft.</p>
													</div>
													<div class="divider"></div>
													<div class="right">
														<p id="average__bed__sale" class="price__subtitle">$ 243.750</p>
														<p class="price__description">per bedroom</p>
													</div>
												</div>
											</div>
										</div>
										<div class="col-12 mx-auto">
											<div class="estimated__box">
												<label class="estimated__tag estimated__rent">Média aluguel</label>
												<h1 id="average__rent" class="price__title">$3,300.00</h1>
												<div class="middle__divider">
													<div class="left">
														<p id="average__sqft__rent" class="price__subtitle">$ 1.90</p>
														<p class="price__description">per sq.ft.</p>
													</div>
													<div class="divider"></div>
													<div class="right">
														<p id="average__bed__rent" class="price__subtitle">$ 825.00</p>
														<p class="price__description">per bedroom</p>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
							<div class="col-12 col-md-12 col-lg-9">
								<link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
								<script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
								<div id="map__box">
									<div id="result__map"></div>
								</div>
							</div>
						</div>
					</div>
					<div id="result__box">
						<div id="result__loading">
							<i class="fa-solid fa-circle-notch fa-spin"></i>
							<p>Carregando</p>
						</div>
						<div id="nothing__box" class="result__nothing">
							<img src="<?php echo $local['assets'] . '/img/nothingResult.svg' ?>">
							<p>Nenhum resultado encontrado.</p>
							<p>Verifique o endereço e tente novamente.</p>
						</div>
						<div id="result__success" class="table-responsive">
							<table id="result__table" class="table">
								<thead>
									<tr>
										<th></th>
										<th>Endereço</th>
										<th>Cidade</th>
										<th></th>
										<th style="text-align: center;">Valor</th>
										<th style="text-align: center;">Quartos</th>
										<th style="text-align: center;">Banheiros</th>
										<th class="flex">Tamanho <span data-bs-toggle="tooltip" data-bs-title="Tamanho do terreno em sqft"><i class="fa-regular fa-circle-question"></i></span></th>
										<th style="text-align: center;">Tipo</th>
									</tr>
								</thead>
								<tbody>
									<tr></tr>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

</body>
<script type="text/javascript">

	function SearchNearMe() {
	    // Obter elementos do input
	    const input__address = document.getElementById('search__address');
	    const input__zipcode = document.getElementById('search__zipcode');
	    const input__state = document.getElementById('search__state');
	    const input__city = document.getElementById('search__city');

	    // Atualiza load no botão
	    const button = document.getElementById('searchNearMe');
	    const button_old_value = button.innerHTML;
	    button.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i>';

	    // Verificar se a geolocalização é suportada
	    if (navigator.geolocation) {
	        navigator.geolocation.getCurrentPosition(position => {
	            // Obter latitude e longitude
	            const latitude = position.coords.latitude;
	            const longitude = position.coords.longitude;

	            // Construir URL da API com a chave de API e coordenadas
	            const apiKey = 'b08ccab1889a4c52be68fd4192cb3c94'; // Substitua 'SUA_CHAVE_API' pela sua chave real da OpenCage Data
	            const url = `https://api.opencagedata.com/geocode/v1/json?q=${latitude}+${longitude}&key=${apiKey}`;

	            // Fazer requisição à API
	            fetch(url)
	                .then(response => response.json())
	                .then(data => {
	                    if (data && data.results && data.results.length > 0) {
	                        // Extrair dados do primeiro resultado
	                        const components = data.results[0].components;

	                        // Definir os valores dos inputs
	                        input__address.value = components.road || '' + ' ' + components.house_number || '';
	                        input__city.value = components.city || components.town || '';
	                        input__state.value = components.state_code || '';
	                        input__zipcode.value = components.postcode || '';

	                        button.innerHTML = button_old_value;
	                        SearchProperty();
	                    }
	                })
	                .catch(error => {
                        button.innerHTML = button_old_value;
	                    console.error('Erro ao buscar o endereço:', error);
	                });
	        }, error => {
                button.innerHTML = button_old_value;
	            console.error('Erro ao obter localização:', error);
	        });
	    } else {
            button.innerHTML = button_old_value;
	        console.log("Geolocalização não é suportada por este navegador.");
	    }
	}

	function OpenProperty(propertyId) {
		window.open(base_url + '/property/' + propertyId);
	}

	var mapa;

	function SearchProperty() {

		// fixed search
		const input__address 	= document.getElementById('search__address');
		const input__zipcode 	= document.getElementById('search__zipcode');
		const input__city 		= document.getElementById('search__city');
		const input__state 		= document.getElementById('search__state');
		const input__transaction__type = document.getElementById('filter__transaction__type');

		// optional filters
		const input__property__type = document.getElementById('filter__property__type');
		const input__bedrooms = document.getElementById('filter__bedrooms');
		const input__bathroom = document.getElementById('filter__bathroom');

		// Error
		const message__error = document.getElementById('message__error');

		// checks if it is possible to make the request
		if (input__city.value === '') {
			message__error.innerHTML = 'Preencha os campos obrigatórios para fazer a pesquisa.';
			input__city.parentNode.classList.add('invalidInput');
			input__city.focus();
			return false;
		}

		// checks if it is possible to make the request
		if (input__state.value === '') {
			message__error.innerHTML = 'Preencha os campos obrigatórios para fazer a pesquisa.';
			input__state.parentNode.classList.add('invalidInput');
			input__state.focus();
			return false;
		}

		// checks whether the transaction type has been defined
		// if (input__transaction__type.value === '') {
		// 	message__error.innerHTML = 'Selecione o tipo da transação para iniciar a pesquisa.';
		// 	input__transaction__type.parentNode.classList.add('invalidInput');
		// 	input__transaction__type.focus();
		// 	return false;
		// }

		// reset active boxes
		const result__box = document.getElementById('result__box');
		const success__box = document.getElementById('result__success');
		const success__header = document.getElementById('success__header');
		const map__box = document.getElementById('map__box');
		const nothing__box = document.getElementById('nothing__box');
		message__error.style.display = 'none';
		nothing__box.style.display = 'none';
		success__header.style.display = 'none';
		map__box.style.display = 'none';
		success__box.style.display = 'none';
		result__box.style.display = 'flex';

		// turn on the loading box
		const loading__box = document.getElementById('result__loading');
		loading__box.style.display = 'block';

		// send ajax to event listing
	    $.ajax({
	      type: "POST",
	      url: base_url + "/api/properties/new_list.php",
	      data: { 

	      	state_code: input__state.value, 
	      	address: input__address.value, 
	      	zipcode: input__zipcode.value, 
	      	city: input__city.value, 
	      	property_type: input__property__type.value, 
	      	business_type: input__transaction__type.value, 
	      	bedrooms: input__bedrooms.value, 
	      	bathrooms: input__bathroom.value, 

	      },
	      success: function(response) {

      		if (response.status === 'nothing') {
      			loading__box.style.display = 'none';
      			nothing__box.style.display = 'flex';
      		}

      		else if (response.status === 'success') {
      			console.log(response);

      			loading__box.style.display = 'none';
      			success__box.style.display = 'flex';
      			success__header.style.display = 'block';

      			// Calcula a média
      			const average__sale = document.getElementById('average__sale');
      			const average__rent = document.getElementById('average__rent');
				average__sale.innerHTML = calculateAveragePrice(response.rows, 'sale');
				average__rent.innerHTML = calculateAveragePrice(response.rows, 'rent');

				// Calcula os custos de sqft pela média
				const average__sqft__sale = document.getElementById('average__sqft__sale');
				const average__sqft__rent = document.getElementById('average__sqft__rent');
				average__sqft__sale.innerHTML = calculateAveragePricePerSqft(response.rows, 'sale');
				average__sqft__rent.innerHTML = calculateAveragePricePerSqft(response.rows, 'rent');

				// Calcula os custos per bed pela média
				const average__bed__rent = document.getElementById('average__bed__rent');
				const average__bed__sale = document.getElementById('average__bed__sale');
				average__bed__rent.innerHTML = calculateAveragePricePerBedroom(response.rows, 'rent');
				average__bed__sale.innerHTML = calculateAveragePricePerBedroom(response.rows, 'sale');

      			// Título e quantidade
      			const title__query = document.getElementById('success__query');
      			const title__qntd = document.getElementById('resultqntd');
      			title__query.innerHTML = input__address.value + ' ' + input__city.value + ', ' + input__state.value + ' ' + input__zipcode.value;
      			title__qntd.innerHTML = response.rows.length;

      			// Adiciona os registros na tabela
      			const result__table = document.getElementById('result__table');
				let corpoTabela = document.querySelector("#result__table tbody");
				corpoTabela.innerHTML = '<tr></tr>';

				response.rows.sort(function(a, b) {
				    return b.relevance - a.relevance;
				});

				var coordenadas = [];
				Object.entries(response.rows).forEach(([key, value]) => {
					const newRow = result__table.insertRow();
					newRow.onclick = function() { OpenProperty(value.api_id); };
					// Id
					const cell1 = newRow.insertCell(0);
					cell1.innerHTML = '<p class="row__id">#'+value.api_id+'</p>';
					// Endereço
					const cell2 = newRow.insertCell(1);
					let lastCommaIndex = value.address.lastIndexOf(',');
					let penultimateCommaIndex = value.address.lastIndexOf(',', lastCommaIndex - 1);
					let streetAddress = value.address.substring(0, penultimateCommaIndex);
					let cityStateZip = value.address.substring(penultimateCommaIndex + 1);
					cell2.innerHTML = '<p class="row__city">' + value.address + ', ' + value.zipcode + '</p>';
					// Cidade
					const cell3 = newRow.insertCell(2);
					cell3.innerHTML = '<p class="row__city">'+value.city+', '+value.state+'</p>';
					// Tipo de negócio
					const cell4 = newRow.insertCell(3);
					let businessText = TypeToText(value.business_type);
					cell4.innerHTML = '<label class="row__proptype proptype__'+value.business_type+'">'+businessText+'</label>';
					// Preço
					const cell5 = newRow.insertCell(4);
					let priceFormated = new Intl.NumberFormat('en-US', { style: 'currency', currency: 'USD' }).format(value.price);
					cell5.innerHTML = '<p class="row__price">'+priceFormated+'</p>';
					// Quartos
					const cell6 = newRow.insertCell(5);
					cell6.innerHTML = '<p class="row__bedroom">'+value.bedrooms+'</p>';
					// Banheiros
					const cell7 = newRow.insertCell(6);
					cell7.innerHTML = '<p class="row__bathroom">'+value.bathrooms+'</p>';
					// Tamanho
					const cell8 = newRow.insertCell(7);
					cell8.innerHTML = '<p class="row__size">' + value.lot_size != '' && value.lot_size ? value.lot_size : '' + '</p>';
					// Tipo
					const cell9 = newRow.insertCell(8);
					cell9.innerHTML = '<p class="row__type">' + value.property_type + '</p>';
					// Adiciona as coordenadas no mapa

					if (value.latitude && value.longitude) {
						coordenadas.push([value.latitude, value.longitude, value.api_id]);
					}
				});

			    // $.ajax({
			    //   type: "POST",
			    //   url: base_url + "/api/properties/listMap.php",
			    //   data: {},
			    //   success: function(response) {
			    //   	console.log(response);
		      	// 	if (response.status === 'nothing') {

		      	// 	} else if (response.status === 'success') {

		      	// 		let all_coordinates = response.rows;
		      	// 		console.log(all_coordinates);
		      	// 		console.log(coordenadas);

				// 		// Inicializa o mapa
				// 		map__box.style.display = 'block';

				// 		// Remove qualquer instância já iniciada
				// 		if (mapa && mapa.remove) { mapa.remove(); }
				// 		mapa = L.map('result__map');

				// 		// Calcula a posição do mapa
				// 		let latMedia = 0, lngMedia = 0;
				// 		coordenadas.forEach(coord => {latMedia += coord[0]; lngMedia += coord[1];});
				// 		latMedia /= coordenadas.length;
				// 		lngMedia /= coordenadas.length;

				// 		// Inclui uma base
				// 		L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
				// 		    attribution: 'Map data &copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
				// 		}).addTo(mapa);

				// 		// Insere os marcadores
				// 		var limites = new L.LatLngBounds();
				// 		coordenadas.forEach(function(coord) {
				// 		    var marcador = L.marker([coord[0], coord[1]]);
				// 		    limites.extend(marcador.getLatLng());
				// 		});

				// 		all_coordinates.forEach(function(coord) {
				// 		    var marcador = L.marker([coord.latitude, coord.longitude]).addTo(mapa);
				// 		    marcador.on('click', function() {
				// 		        OpenProperty(coord.api_id);
				// 		    });
				// 		});

				// 		// Define a escala
				// 		mapa.fitBounds(limites);

		      	// 	} else { console.log(response); }
			    //   },
			    //   error: function(xhr, status, error) {
			    //     console.error("Erro:", error);
			    //   }
			    // });


				// Inicializa o mapa
				map__box.style.display = 'block';

				// Remove qualquer instância já iniciada
				if (mapa && mapa.remove) { mapa.remove(); }
				mapa = L.map('result__map');

				// Calcula a posição do mapa
				let latMedia = 0, lngMedia = 0;
				coordenadas.forEach(coord => {latMedia += coord[0]; lngMedia += coord[1];});
				latMedia /= coordenadas.length;
				lngMedia /= coordenadas.length;

				// Inclui uma base
				L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
				    attribution: ''
				}).addTo(mapa);

				// Insere os marcadores
				var limites = new L.LatLngBounds();
				coordenadas.forEach(function(coord) {
				    var marcador = L.marker([coord[0], coord[1]]).addTo(mapa);
				    marcador.on('click', function() {
				        OpenProperty(coord[2]);
				    });
				    limites.extend(marcador.getLatLng());
				});

				// Define a escala
				mapa.fitBounds(limites);


      		}

	      	else { console.log(response); }

	      },
	      error: function(xhr, status, error) {
	        console.error("Erro:", error);
	      }
	    });
	}

	function sortTable(column) {
	    var table = document.getElementById("result__table");
	    var tbody = table.getElementsByTagName("tbody")[0];
	    var rowsArray = Array.from(tbody.rows);
	    var dir = this.getAttribute('data-sort-dir') === 'asc' ? 'desc' : 'asc';

	    function parseCurrency(value) {
	        return parseFloat(value.replace(/[^0-9.-]+/g, ""));
	    }

	    var comparator = (a, b) => {
	        let aCell = a.cells[column];
	        let bCell = b.cells[column];
	        if (!aCell || !bCell) return 0;

	        let aValue = aCell.innerHTML;
	        let bValue = bCell.innerHTML;

	        if (column === 3) {
	            aValue = parseCurrency(aValue);
	            bValue = parseCurrency(bValue);
	        } else {
	            aValue = aValue.toLowerCase();
	            bValue = bValue.toLowerCase();
	        }

	        if (aValue < bValue) {
	            return dir === 'asc' ? -1 : 1;
	        } else if (aValue > bValue) {
	            return dir === 'asc' ? 1 : -1;
	        }
	        return 0;
	    };

	    rowsArray.sort(comparator);

	    for (let i = 0; i < rowsArray.length; i++) {
	        tbody.appendChild(rowsArray[i]);
	    }

	    this.setAttribute('data-sort-dir', dir);
	}

	// Adicionar evento de click em cada cabeçalho de coluna e atributo inicial de direção
	document.querySelectorAll("#result__table th").forEach((th, index) => {
	    th.setAttribute('data-sort-dir', 'desc');  // Iniciar todos como 'desc'
	    th.addEventListener('click', function() { sortTable.call(this, index); });
	});

	// Função para calcular o valor médio
	function calculateAveragePrice(rows, businessType) {
		if (!rows) { return '--'; }
		const filteredRows = rows.filter(row => row.business_type === businessType);
		const totalSum = filteredRows.reduce((sum, row) => sum + parseFloat(row.price), 0);
		const averagePrice = totalSum / filteredRows.length;
		const averageFormated = new Intl.NumberFormat('en-US', { style: 'currency', currency: 'USD' }).format(averagePrice);
		return filteredRows.length > 0 ? averageFormated : '--';
	}

	// Função para calcular a média de preço por square footage (pé quadrado)
	function calculateAveragePricePerSqft(rows, businessType) {
		if (!rows) { return '--'; }
		const filteredRows = rows.filter(row => row.business_type === businessType && row.square_footage !== "");
		const totalSum = filteredRows.reduce((sum, row) => sum + (parseFloat(row.price) / parseFloat(row.square_footage)), 0);
		const averagePricePerSqft = totalSum / filteredRows.length;
		const averageFormated = new Intl.NumberFormat('en-US', { style: 'currency', currency: 'USD' }).format(averagePricePerSqft);
		return filteredRows.length > 0 ? averageFormated : '--';
	}

	// Função para calcular a média de preço por quarto
	function calculateAveragePricePerBedroom(rows, businessType) {
		if (!rows) { return '--'; }
		const filteredRows = rows.filter(row => row.business_type === businessType && row.bedrooms !== "");
		const totalSum = filteredRows.reduce((sum, row) => sum + (parseFloat(row.price) / parseInt(row.bedrooms)), 0);
		const averagePricePerBedroom = totalSum / filteredRows.length;
		const averageFormated = new Intl.NumberFormat('en-US', { style: 'currency', currency: 'USD' }).format(averagePricePerBedroom);
		return filteredRows.length > 0 ? averageFormated : '--';
	}

	function handleAddressInput() {
	    const input__address = document.getElementById('search__address');
	    const input__zipcode = document.getElementById('search__zipcode');
	    const input__state = document.getElementById('search__state');
	    const input__city = document.getElementById('search__city');
	    const suggestion__box = document.getElementById('suggestion__box');

	    // Limpar conteúdo atual da caixa de sugestões
	    suggestion__box.innerHTML = '';

	    if (input__address.value.length >= 3) {
	        $.ajax({
	            type: "POST",
	            url: base_url + "/api/properties/handleSearch.php",
	            data: { input: input__address.value },
	            success: function(response) {
	                if (response && response.length > 0) {

	                    const fragment = document.createDocumentFragment();	                    
	                    response.forEach(function(result) {

	                        const suggestionItem = document.createElement('div');
	                        suggestionItem.classList.add('suggestion__item');
	                        suggestionItem.textContent = result.address;

	                        suggestionItem.addEventListener('click', function() {

							    const cityIndex = result.address.indexOf(`, ${result.city}`);
						        const compressAddress = result.address.substring(0, cityIndex).trim();

	                            input__address.value = result.address;
	                            input__state.value = result.state;
	                            input__city.value = result.city;
	                            input__zipcode.value = result.zipcode;

	                            suggestion__box.style.display = 'none';
	                        });

	                        fragment.appendChild(suggestionItem);
	                    });

	                    suggestion__box.appendChild(fragment);
	                    suggestion__box.style.display = 'block';
	                    suggestion__box.style.width = input__address.parentNode.offsetWidth + 'px';
	                } else {
	                    suggestion__box.style.display = 'none';
	                }
	            },
	            error: function(xhr, status, error) {
	                console.error("Erro:", error);
	                suggestion__box.style.display = 'none';
	            }
	        });
	    } else {
	        suggestion__box.style.display = 'none';
	    }
	}

	function handleAddressCity() {
	    const input__address = document.getElementById('search__address');
	    const input__zipcode = document.getElementById('search__zipcode');
	    const input__state = document.getElementById('search__state');
	    const input__city = document.getElementById('search__city');
	    const suggestion__box = document.getElementById('suggestion__box__city');

	    // Limpar conteúdo atual da caixa de sugestões
	    suggestion__box.innerHTML = '';

	    if (input__city.value.length >= 3) {
	        $.ajax({
	            type: "POST",
	            url: base_url + "/api/properties/handleSearchCity.php",
	            data: { input: input__city.value },
	            success: function(response) {
	                if (response && response.length > 0) {

	                    const fragment = document.createDocumentFragment();	                    
	                    response.forEach(function(result) {

	                        const suggestionItem = document.createElement('div');
	                        suggestionItem.classList.add('suggestion__item');
	                        suggestionItem.textContent = result.city + ', ' + result.state;

	                        suggestionItem.addEventListener('click', function() {

	                            input__state.value = result.state;
	                            input__city.value = result.city;

	                            suggestion__box.style.display = 'none';
	                        });

	                        fragment.appendChild(suggestionItem);
	                    });

	                    suggestion__box.appendChild(fragment);
	                    suggestion__box.style.display = 'block';
	                    suggestion__box.style.width = input__city.parentNode.offsetWidth + 'px';
	                } else {
	                    suggestion__box.style.display = 'none';
	                }
	            },
	            error: function(xhr, status, error) {
	                console.error("Erro:", error);
	                suggestion__box.style.display = 'none';
	            }
	        });
	    } else {
	        suggestion__box.style.display = 'none';
	    }
	}

	// Fechar a caixa de sugestões se o usuário clicar fora dela
	document.addEventListener('click', function(event) {
	    const suggestion__box = document.getElementById('suggestion__box');
	    const input__address = document.getElementById('search__address');
	    
	    if (!suggestion__box.contains(event.target) && event.target !== input__address) {
	        suggestion__box.style.display = 'none';
	    }
	});


	// Fechar a caixa de sugestões se o usuário clicar fora dela
	document.addEventListener('click', function(event) {
	    const suggestion__box = document.getElementById('suggestion__box__city');
	    const input__city = document.getElementById('search__city');
	    
	    if (!suggestion__box.contains(event.target) && event.target !== input__city) {
	        suggestion__box.style.display = 'none';
	    }
	});

	const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
	const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))

</script>
</html>