<!DOCTYPE html>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php $page_name = 'Novo projeto'; ?>

    <?php require_once __DIR__ . '/../../../inc/conn.php'; ?>
    <?php require_once __DIR__ . '/../../../inc/variables.php'; ?>

    <?php require_once __DIR__ . '/../../../inc/cdns.php'; ?>
    <?php require_once __DIR__ . '/../../../inc/styles.php'; ?>

    <?php if ($plan['custom_project'] == 0) { Route('projects'); } ?>

    <title><?php echo $page_name . ' | ' . $app['name']; ?></title>

    <?php if (!isset($_SESSION['user'])) { Route('entrar'); } ?>
    <?php $userId = $_SESSION['user']['id']; ?>

    <?php 

        // Abre a sessão de rascunho do projeto
        if (!isset($_SESSION['user']['draft']['code'])) {

            $hash_code = md5($_SESSION['user']['id'] . session_id() . date('Y-m-d H:i:s'));

            $query = "INSERT INTO projects (user, code, type) VALUES ('$userId', '$hash_code', 'custom')";
            if (mysqli_query($conn, $query)) {
                $_SESSION['user']['draft']['code'] = $hash_code; }

        } else { $hash_code = $_SESSION['user']['draft']['code']; }

        $projectQuery = "SELECT * FROM projects WHERE code = '$hash_code'";
        $mysqliQuery = mysqli_query($conn, $projectQuery);
        while ($project__data = mysqli_fetch_array($mysqliQuery)) { $project = $project__data; }

        function IssetValue($value, $valueFormatted = true) {
            if (isset($value) && !empty($value)) {
                if ($valueFormatted) {
                    return 'value="' . $value . '"';
                } else {
                    return $value;
                }
            }
        }

    ?>

    <link rel="stylesheet" type="text/css" href="<?php echo $local['assets'] . '/css/new-project.css'; ?>">

    <!-- Toasts -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css">
    <script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>

</head>
<body>

    <?php require_once __DIR__ . '/../../layout/topbar.php'; ?>
    <div class="content">
        <div class="container">
            <div class="row">
                <div class="col-12 col-md-3">
                    <div class="title__box">
                        <h1 class="title">Novo Projeto</h1>
                        <p class="draft__hash"><?php echo md5('teste'); ?></p>
                    </div>
                </div>
                <div class="col-12 col-md-9">
                    <div id="header__steps" class="header__steps">
                        <div onclick="Step(1)" data-step="1" class="step__item active__step">
                            <i class="fa-solid fa-location-dot"></i>
                        </div>
                        <hr>
                        <div onclick="Step(2)" data-step="2" class="step__item">
                            <i class="fa-solid fa-images"></i>
                        </div>
                        <hr>
                        <div onclick="Step(3)" data-step="3" class="step__item">
                            <i class="fa-solid fa-brush"></i>
                        </div>
                        <hr>
                        <div onclick="Step(4)" data-step="4" class="step__item">
                            <i class="fa-solid fa-filter-circle-dollar"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div style="margin-top: 20px;" class="row">
                <div class="col-12 col-md-3">
                    <div id="right__menu" class="module">
                        <div id="rehab__menu" style="display: none;">
                            <div class="total__box">
                                <div class="totalSquare">
                                    <div class="iconSquare">
                                        <i class="fa-solid fa-house-circle-check"></i>
                                    </div>
                                    <div class="textSquare">
                                        <label>Exterior:</label><br>
                                        <span id="total__exterior">$ 0.00</span>
                                    </div>
                                </div>
                                <div class="totalSquare">
                                    <div class="iconSquare">
                                        <i class="fa-solid fa-paint-roller"></i>
                                    </div>
                                    <div class="textSquare">
                                        <label>Interior:</label><br>
                                        <span id="total__interior">$ 0.00</span>
                                    </div>
                                </div>
                                <div class="totalSquare">
                                    <div class="iconSquare">
                                        <i class="fa-solid fa-plug"></i>
                                    </div>
                                    <div class="textSquare">
                                        <label>Mecânica:</label><br>
                                        <span id="total__mechanical">$ 0.00</span>
                                    </div>
                                </div>
                                <div class="totalSquare">
                                    <div class="iconSquare">
                                        <i class="fa-solid fa-ellipsis"></i>
                                    </div>
                                    <div class="textSquare">
                                        <label>Outros:</label><br>
                                        <span id="total__others">$ 0.00</span>
                                    </div>
                                </div>
                                <div class="totalSquare">
                                    <div class="iconSquare">
                                        <i class="fa-solid fa-dollar-sign"></i>
                                    </div>
                                    <div class="textSquare">
                                        <label>Total:</label><br>
                                        <span id="total__amount" class="totalColor">$ 0.00</span>
                                    </div>
                                </div>
                            </div>
                            <div class="divider"></div>
                        </div>
                        <div style="display: none;" id="roi__menu">
                            <div class="row">
                                <div class="col-12">
                                    <div class="statistic__module">
                                        <div class="statistic__icon">
                                            <i class="fa-solid fa-money-bill-wheat"></i>
                                        </div>
                                        <div class="statistic__content">
                                            <h2 class="statistic__value"><span id="statistic__profit">$ 0.00</span></h2>
                                            <p class="statistic__subtitle">Lucro líquido estimado</p>
                                        </div>
                                    </div>
                                    <div class="statistic__module">
                                        <div class="statistic__icon">
                                            <i class="fa-solid fa-money-bill-trend-up"></i>
                                        </div>
                                        <div class="statistic__content">
                                            <h2 class="statistic__value"><span id="statistic__roi">0%</span> <small>(ROI)</small></h2>
                                            <p class="statistic__subtitle">(Retorno do Investimento)</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div style="margin: 25px 0px !important;" class="divider"></div>
                                </div>
                                <div class="col-12">
                                    <div class="roi__actions">
                                        <button onclick="exportPdf()" id="exportPdf"><i class="fa-regular fa-floppy-disk"></i> Exportar PDF</button>
                                        <!-- <button onclick="sendMail()" id="sendMail"><i class="fa-solid fa-at"></i> Receber no E-mail</button> -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <button onclick="UpdateDraft()" id="saveProject">SALVAR</button>
                        <p id="autoSave" class="autosave">Rascunho salvo em <?php echo date('d/m/Y H:i', strtotime($project['updated_at'])) ?></p>
                    </div>
                </div>
                <div class="col-12 col-md-9">
                    <div id="stepModuleRows">
                        <div id="step__info" data-step="1" class="module">
                            <div class="row">
                                <div class="col-12 col-md-12">
                                    <button onclick="searchNearMe()" id="searchNearMe">Preencher meu endereço</button>
                                </div>
                                <div class="col-12 col-md-5">
                                    <div class="input__box">
                                        <label>Endereço: <b>*</b></label>
                                        <input type="text" <?php echo IssetValue($project['address']); ?> oninput="ValidPrevNext()" onkeypress="ValidInput(this)" required id="project__address">
                                        <p id="error__address" class="error__message"></p>
                                    </div>
                                </div>
                                <div class="col-12 col-md-3">
                                    <div class="input__box">
                                        <label>Cidade: <b>*</b></label>
                                        <input type="text" <?php echo IssetValue($project['city']); ?> oninput="ValidPrevNext()" onkeypress="ValidInput(this)" required id="project__city">
                                        <p id="error__city" class="error__message"></p>
                                    </div>
                                </div>
                                <div class="col-12 col-md-2">
                                    <div class="input__box">
                                        <label>Zipcode: <b>*</b></label>
                                        <input type="text" <?php echo IssetValue($project['zipcode']); ?> oninput="ValidPrevNext()" onkeypress="ValidInput(this)" required id="project__zipcode">
                                        <p id="error__zipcode" class="error__message"></p>
                                    </div>
                                </div>
                                <div class="col-12 col-md-12">
                                    <div class="divider"></div>
                                </div>
                                <div class="col-12 col-md-2">
                                    <div class="input__box">
                                        <label>Quartos: <b>*</b></label>
                                        <input type="number" min="0" <?php echo IssetValue($project['bedrooms']); ?> oninput="ValidPrevNext()" onkeypress="ValidInput(this)" required id="project__bedrooms">
                                        <p id="error__bedrooms" class="error__message"></p>
                                    </div>
                                </div>
                                <div class="col-12 col-md-2">
                                    <div class="input__box">
                                        <label>Banheiros: <b>*</b></label>
                                        <input type="number" min="0" <?php echo IssetValue($project['bathrooms']); ?> oninput="ValidPrevNext()" onkeypress="ValidInput(this)" required id="project__bathrooms">
                                        <p id="error__bathrooms" class="error__message"></p>
                                    </div>
                                </div>
                                <div class="col-12 col-md-2">
                                    <div class="input__box">
                                        <label>Tamanho: (sqft/m²) <b>*</b></label>
                                        <input type="number" min="0" <?php echo IssetValue($project['size']); ?> oninput="ValidPrevNext()" onkeypress="ValidInput(this)" required id="project__size">
                                        <p id="error__size" class="error__message"></p>
                                    </div>
                                </div>
                                <div class="col-12 col-md-12">
                                    <div class="divider"></div>
                                </div>
                                <div class="col-12 col-md-5">
                                    <div class="input__box">
                                        <label>Observações:</label>
                                        <textarea id="project__notes"><?php echo IssetValue($project['notes'], false); ?></textarea>
                                        <p id="error__notes" class="error__message"></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="step__photos" data-step="2" class="module hidden__module">
                            <div class="row">
                                <div class="col-12">
                                    <div id="squarePhoto" ondragover="allowDrop(event)" ondrop="handleDrop(event)">
                                        <i class="fa-regular fa-image"></i>
                                        <p>Escolha uma foto ou arraste e solte aqui.</p>
                                        <p>Tamanho máximo do arquivo: 12MB. Apenas JPG ou PNG.</p>
                                        <button id="choosePicture">Enviar foto de capa</button>
                                        <input type="file" id="project__picture" multiple style="display: none;" onchange="handleFileSelect(event)">
                                    </div>
                                    <div id="previewPhoto">
                                        <?php if (isset($project['picture']) && !empty($project['picture'])) { 
                                            $pictureArray = json_decode($project['picture'], true);
                                            foreach ($pictureArray as $i => $pic) { ?>

                                                <div class="itemPicBox">
                                                    <label onclick="trashPicture('<?php echo $pic ?>', this.parentNode)"><i class="fa-solid fa-xmark"></i></label>
                                                    <img id="previewImage" src="<?php echo $local['raiz'] . '/attachments/projects/' . $hash_code . '/' . $pic; ?>">
                                                </div>

                                            <?php }
                                        } ?>
                                        <?php if (isset($project['api_pictures']) && !empty($project['api_pictures'])) { 
                                            $apiPicturesArray = json_decode($project['api_pictures'], true);
                                            foreach ($apiPicturesArray as $i => $pic) { ?>

                                                <div class="itemPicBox">
                                                    <label onclick="trashPicture('<?php echo $pic ?>', this.parentNode)"><i class="fa-solid fa-xmark"></i></label>
                                                    <img id="previewImage" src="<?php echo $pic['url']; ?>">
                                                </div>

                                            <?php }
                                        } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="step__rehab" data-step="3" class="module noModule hidden__module">
                            <div id="rehabRows" class="moduleInside"></div>
                        </div>
                        <div id="step__roi" data-step="4" class="module noModule hidden__module">
                            <div class="row">
                                <div class="col-12 col-md-5">
                                    <h1 class="title">Valores e Custos da Propriedade</h1>
                                    <div class="moduleInside">
                                        <div class="input__box">
                                            <label>ARV: (valor após a reforma) <b>*</b></label>
                                            <input type="money" <?php echo IssetValue($project['price_arv']); ?> oninput="updateProfit()" class="moneyMask" id="roi__arv">
                                        </div>
                                        <div class="input__box">
                                            <label>Preço de Compra <b>*</b></label>
                                            <input type="text" <?php echo IssetValue($project['price_buy']); ?> class="moneyMask" oninput="updateLoanCosts();" id="roi__price__buy">
                                        </div>
                                        <div class="input__box">
                                            <label>Estimativa de custos de reforma</label>
                                            <input type="text" <?php echo IssetValue($project['rehab_total']); ?> class="moneyMask" oninput="updateLoanCosts();" id="roi__rehab__price">
                                        </div>
                                        <div class="input__box">
                                            <label>Estimativa de duração do projeto (meses)</label>
                                            <input type="number" oninput="CalcTotalMonthly()" value="1" <?php echo IssetValue($project['duration']); ?> min="1" id="roi__quantity__months">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-md-7">
                                    <h1 class="title">Custos de Manutenção</h1>
                                    <div class="moduleInside">
                                        <?php 

                                            if (isset($project['holding_costs']) && !empty($project['holding_costs'])) {
                                                $holding_costs = json_decode($project['holding_costs'], true);
                                            }

                                        ?>
                                        <div class="table">
                                            <table>
                                                <tbody>
                                                    <tr class="cost__item">
                                                        <td class="cost__title">Taxas da propriedade:</td>
                                                        <td class="cost__box" style="text-align: right;">
                                                            <input value="<?php echo isset($holding_costs['property_taxs']) ? Money($holding_costs['property_taxs']['yearly']) : 0; ?>" type="text" class="moneyMask" oninput="CalcTotalMonthly()" id="costs__property">
                                                            <label>/Anual</label>
                                                            <input value="<?php echo isset($holding_costs['property_taxs']) ? Money($holding_costs['property_taxs']['monthly']) : 0; ?>" disabled type="text" oninput="CalcTotalMonthly()" id="costs__property__montly">
                                                            <label>/Mensal</label>
                                                        </td>
                                                    </tr>
                                                    <tr class="cost__item">
                                                        <td class="cost__title">HOA & condo fees:</td>
                                                        <td class="cost__box" style="text-align: right;">
                                                            <input value="<?php echo isset($holding_costs['hoa__fees']) ? Money($holding_costs['hoa__fees']['yearly']) : 0; ?>" disabled type="text" oninput="CalcTotalMonthly()" id="costs__hoa__yearly">
                                                            <label>/Anual</label>
                                                            <input value="<?php echo isset($holding_costs['hoa__fees']) ? Money($holding_costs['hoa__fees']['monthly']) : 0; ?>" type="text" class="moneyMask" oninput="CalcTotalMonthly()" id="costs__hoa">
                                                            <label>/Mensal</label>
                                                        </td>
                                                    </tr>
                                                    <tr class="cost__item">
                                                        <td class="cost__title">Insurance:</td>
                                                        <td class="cost__box" style="text-align: right;">
                                                            <input value="<?php echo isset($holding_costs['insurance']) ? Money($holding_costs['insurance']['yearly']) : 0; ?>" disabled type="text" oninput="CalcTotalMonthly()" id="costs__insurance__yearly">
                                                            <label>/Anual</label>
                                                            <input value="<?php echo isset($holding_costs['insurance']) ? Money($holding_costs['insurance']['monthly']) : 0; ?>" type="text" class="moneyMask" oninput="CalcTotalMonthly()" id="costs__insurance">
                                                            <label>/Mensal</label>
                                                        </td>
                                                    </tr>
                                                    <tr class="cost__item">
                                                        <td class="cost__title">Utilities:</td>
                                                        <td class="cost__box" style="text-align: right;">
                                                            <input value="<?php echo isset($holding_costs['utilities']) ? Money($holding_costs['utilities']['yearly']) : 0; ?>" disabled type="text" oninput="CalcTotalMonthly()" id="costs__utilities__yearly">
                                                            <label>/Anual</label>
                                                            <input value="<?php echo isset($holding_costs['utilities']) ? Money($holding_costs['utilities']['monthly']) : 0; ?>" type="text" class="moneyMask" oninput="CalcTotalMonthly()" id="costs__utilities">
                                                            <label>/Mensal</label>
                                                        </td>
                                                    </tr>
                                                    <tr class="cost__item">
                                                        <td class="cost__title">Miscellaneous costs:</td>
                                                        <td class="cost__box" style="text-align: right;">
                                                            <input value="<?php echo isset($holding_costs['miscellaneous']) ? Money($holding_costs['miscellaneous']['yearly']) : 0; ?>" disabled type="text" oninput="CalcTotalMonthly()" id="costs__miscellaneous__yearly">
                                                            <label>/Anual</label>
                                                            <input value="<?php echo isset($holding_costs['miscellaneous']) ? Money($holding_costs['miscellaneous']['monthly']) : 0; ?>" type="text" class="moneyMask" oninput="CalcTotalMonthly()" id="costs__miscellaneous">
                                                            <label>/Mensal</label>
                                                        </td>
                                                    </tr>
                                                    <tr class="cost__item cost__footer">
                                                        <td class="cost__total"></td>
                                                        <td class="cost__value">
                                                            <span id="totalMonthly">$0.00</span> /mês
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>

                                    </div>
                                </div>
                                <div style="margin-top: 35px;" class="col-12">
                                    <h1 class="title">Financiamento: </h1>
                                    <?php 

                                        $first_mortgage = !empty($project['first_mortgage']) ? json_decode($project['first_mortgage'], true) : NULL;
                                        $secound_mortgage = !empty($project['secound_mortgage']) ? json_decode($project['secound_mortgage'], true) : NULL;
                                        $buy_costs = !empty($project['buy_costs']) ? json_decode($project['buy_costs'], true) : NULL;
                                        $sell_costs = !empty($project['sell_costs']) ? json_decode($project['sell_costs'], true) : NULL;

                                        function checkPercentage($percentage, $value) {
                                            if (is_numeric($percentage) && $percentage == $value) {
                                                echo 'checked';
                                            }
                                        }

                                    ?>
                                    <div style="padding: 25px !important;" id="financial__box" class="moduleInside">
                                        <div class="row gx-5">
                                            <div class="col-12 col-md-6 col-lg-6">
                                                <div class="row">
                                                    <div class="col-12">
                                                        <h2 class="title">Primeira Hipoteca:</h2>
                                                        <p class="financial__subtitle">(Hard Money Lender)</p>
                                                    </div>
                                                    <div class="col-12">
                                                        <div class="input__box">
                                                            <label>
                                                               Down Payment
                                                                <span data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="A quantidade de dinheiro que você irá desembolsar no ato da transação. Selecione a porcentagem ou insira o valor manualmente.">
                                                                    <i class="fa-regular fa-circle-question"></i>
                                                                </span>
                                                           </label>
                                                           <div class="radio__row">
                                                               <label><input onclick="updateLoanCosts()" value="10" <?php echo isset($first_mortgage) ? checkPercentage($first_mortgage['down_payment']['percentage'], 10) : 'checked'; ?> name="downPay" type="radio">10%</label>
                                                               <label><input onclick="updateLoanCosts()" value="15" <?php echo isset($first_mortgage) ? checkPercentage($first_mortgage['down_payment']['percentage'], 15) : ''; ?> name="downPay" type="radio">15%</label>
                                                               <label><input onclick="updateLoanCosts()" value="20" <?php echo isset($first_mortgage) ? checkPercentage($first_mortgage['down_payment']['percentage'], 20) : ''; ?> name="downPay" type="radio">20%</label>
                                                               <label><input onclick="updateLoanCosts()" value="25" <?php echo isset($first_mortgage) ? checkPercentage($first_mortgage['down_payment']['percentage'], 25) : ''; ?> name="downPay" type="radio">25%</label>
                                                               <label><input onclick="updateLoanCosts()" value="manual"  name="downPay" type="radio">Inserir manualmente</label>
                                                           </div>
                                                           <div class="input__row">
                                                               <input readonly class="percentageMask"
                                                                      type="text" oninput="downPaymentManual('percentage')"  
                                                                      <?php echo isset($first_mortgage['down_payment']) ? 'value="' . $first_mortgage['down_payment']['percentage'] . '"' : ''; ?> 
                                                                      id="downPayment__percentage">

                                                               <input readonly class="money"
                                                                      type="text" oninput="downPaymentManual('amount')"  
                                                                      <?php echo isset($first_mortgage['down_payment']) ? 'value="' . Money($first_mortgage['down_payment']['amount']) . '"' : ''; ?> 
                                                                      id="downPayment__amount">
                                                           </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-12">
                                                        <div class="divider"></div>
                                                    </div>
                                                    <div class="col-12">
                                                        <div class="input__box">
                                                            <label>
                                                                Financiamento da Reforma
                                                                <span data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="O total dos cutos de reforma que o credor irá cobrir. Selecione a porcentagem ou insira o valor manualmente.">
                                                                    <i class="fa-regular fa-circle-question"></i>
                                                                </span>
                                                           </label>
                                                           <div class="radio__row">
                                                               <label><input onclick="updateLoanCosts()" <?php echo isset($first_mortgage) ? checkPercentage($first_mortgage['rehab']['percentage'], 100) : 'checked'; ?> value="100" checked name="rehab" type="radio">100%</label>
                                                               <label><input onclick="updateLoanCosts()" <?php echo isset($first_mortgage) ? checkPercentage($first_mortgage['rehab']['percentage'], 90) : ''; ?> value="90" name="rehab" type="radio">90%</label>
                                                               <label><input onclick="updateLoanCosts()" value="manual" name="rehab" type="radio">Inserir manualmente</label>
                                                           </div>
                                                           <div class="input__row">
                                                               <input readonly type="text" class="percentageMask" 
                                                                      <?php echo isset($first_mortgage['rehab']) ? 'value="' . $first_mortgage['rehab']['percentage'] . '"' : ''; ?>
                                                                      oninput="rehabCostsManual('percentage')" 
                                                                      id="rehabTotal__percentage">
                                                               <input readonly type="text" class="money" 
                                                                      <?php echo isset($first_mortgage['rehab']) ? 'value="' . Money($first_mortgage['rehab']['amount']) . '"' : ''; ?>
                                                                      oninput="rehabCostsManual('amount')" 
                                                                      id="rehabTotal__amount">
                                                           </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-12">
                                                        <div class="divider"></div>
                                                    </div>
                                                    <div class="col-12">
                                                        <div class="input__box">
                                                            <label>
                                                                Valor total do empréstimo
                                                           </label>
                                                           <div class="input__row">
                                                               <input disabled id="totalLoanAmount" <?php echo isset($first_mortgage['amount']) ? 'value="' . Money($first_mortgage['amount']) . '"' : ''; ?> type="text" placeholder="$ 0.00">
                                                           </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-12">
                                                        <div class="divider"></div>
                                                    </div>
                                                    <div class="col-12">
                                                        <div class="input__box">
                                                            <label>
                                                               Points
                                                               <span data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="1 ponto = 1%"><i class="fa-regular fa-circle-question"></i></span>
                                                           </label>
                                                           <div class="radio__row">
                                                               <label><input onclick="updateLoanCosts()" value="1.5" <?php echo isset($first_mortgage) ? checkPercentage($first_mortgage['points']['percentage'], 1.5) : 'checked'; ?> name="points" type="radio">1.5%</label>
                                                               <label><input onclick="updateLoanCosts()" value="2" <?php echo isset($first_mortgage) ? checkPercentage($first_mortgage['points']['percentage'], 2) : ''; ?> name="points" type="radio">2%</label>
                                                               <label><input onclick="updateLoanCosts()" value="2.5" <?php echo isset($first_mortgage) ? checkPercentage($first_mortgage['points']['percentage'], 2.5) : ''; ?> name="points" type="radio">2.5%</label>
                                                               <label><input onclick="updateLoanCosts()" value="manual" name="points" type="radio">Inserir manualmente</label>
                                                           </div>
                                                           <div class="input__row">
                                                               <input readonly type="text" class="percentageMask" 
                                                                      oninput="pointsCostsManual('percentage')" 
                                                                      <?php echo isset($first_mortgage['points']) ? 'value="' . $first_mortgage['points']['percentage'] . '"' : ''; ?>
                                                                      id="points__percentage" placeholder="1.5%">
                                                               <input readonly type="text" class="money" 
                                                                      oninput="pointsCostsManual('amount')" 
                                                                      <?php echo isset($first_mortgage['points']) ? 'value="' . Money($first_mortgage['points']['amount']) . '"' : ''; ?>
                                                                      id="points__amount" placeholder="$0.00">
                                                           </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-12">
                                                        <div class="divider"></div>
                                                    </div>
                                                    <div class="col-12">
                                                        <div class="input__box">
                                                            <label>
                                                               Interest
                                                               <span data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Insira a taxa anual de interest"><i class="fa-regular fa-circle-question"></i></span>
                                                           </label>
                                                           <div class="radio__row">
                                                               <label><input onclick="updateLoanCosts()" value="9" <?php echo isset($first_mortgage) ? checkPercentage($first_mortgage['interest']['percentage'], 9) : 'checked'; ?> name="interest" type="radio">9%</label>
                                                               <label><input onclick="updateLoanCosts()" value="10" <?php echo isset($first_mortgage) ? checkPercentage($first_mortgage['interest']['percentage'], 10) : ''; ?> name="interest" type="radio">10%</label>
                                                               <label><input onclick="updateLoanCosts()" value="12" <?php echo isset($first_mortgage) ? checkPercentage($first_mortgage['interest']['percentage'], 12) : ''; ?> name="interest" type="radio">12%</label>
                                                               <label><input onclick="updateLoanCosts()" value="manual" name="interest" type="radio">Inserir manualmente</label>
                                                           </div>
                                                           <div class="input__row">
                                                               <input readonly type="text" class="percentageMask" 
                                                                      oninput="interestCostsManual('percentage')" 
                                                                      <?php echo isset($first_mortgage['interest']) ? 'value="' . $first_mortgage['interest']['percentage'] . '"' : ''; ?>
                                                                      id="interest__percentage" placeholder="9%">
                                                               <input readonly type="text" class="money" 
                                                                      oninput="interestCostsManual('amount')" 
                                                                      <?php echo isset($first_mortgage['interest']) ? 'value="' . Money($first_mortgage['interest']['amount']) . '"' : ''; ?>
                                                                      id="interest__amount" placeholder="$0.00">
                                                           </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-12">
                                                        <div style="margin: 25px 0px;" class="divider"></div>
                                                    </div>
                                                    <div class="col-12 mb-margin">
                                                        <h1 class="totalResult">Primeira Hipoteca: <span id="firstMortage__total">$0.00</span></h1>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-6">
                                                <div class="row">
                                                    <div class="col-12">
                                                        <h2 class="title">Segunda Hipoteca: </h2>
                                                        <p class="financial__subtitle">(Private Money Lender)</p>
                                                    </div>
                                                    <div style="margin-bottom: 15px;" class="col-12">
                                                        <div class="input__box">
                                                            <label>Quantia:</label>
                                                            <input type="text" class="money" <?php echo isset($secound_mortgage['amount']) ? 'value="' . Money($secound_mortgage['amount']) . '"' : ''; ?> id="secound__mortgage__amount">
                                                        </div>
                                                    </div>
                                                    <div style="margin-bottom: 15px;" class="col-12">
                                                        <div class="input__box">
                                                            <label>Points<span><i class="fa-regular fa-circle-question"></i></span></label>
                                                           <div class="input__row">
                                                               <input oninput="secoundMortgagePoints('percentage')" <?php echo isset($secound_mortgage['points']) ? 'value="' . $secound_mortgage['points']['percentage'] . '"' : ''; ?> type="text" class="percentageMask" id="sec__points__percentage" placeholder="%">
                                                               <input oninput="secoundMortgagePoints('amount')" <?php echo isset($secound_mortgage['points']) ? 'value="' . Money($secound_mortgage['points']['amount']) . '"' : ''; ?> type="text" class="money" id="sec__points__amount" placeholder="$ 0.00">
                                                           </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-12">
                                                        <div class="input__box">
                                                            <label>Interest<span><i class="fa-regular fa-circle-question"></i></span>
                                                           </label>
                                                           <div class="input__row">
                                                               <input oninput="secoundMortgageInterest('percentage')" <?php echo isset($secound_mortgage['interest']) ? 'value="' . $secound_mortgage['interest']['percentage'] . '"' : ''; ?> type="text" class="percentageMask" id="sec__interest__percentage" placeholder="%">
                                                               <input oninput="secoundMortgageInterest('amount')" <?php echo isset($secound_mortgage['interest']) ? 'value="' . Money($secound_mortgage['interest']['amount']) . '"' : ''; ?> type="text" class="money" id="sec__interest__amount" placeholder="$0.00">
                                                           </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-12">
                                                        <div style="margin: 25px 0px;" class="divider"></div>
                                                    </div>
                                                    <div class="col-12">
                                                        <h1 class="totalResult">Segunda Hipoteca: <span id="secMortage__total">$0.00</span></h1>
                                                    </div>
                                                </div>
                                                <div style="margin-top: 25px;" class="row">
                                                    <div class="col-12">
                                                        <div class="divider"></div>
                                                    </div>
                                                    <div class="col-12">
                                                        <h2 class="title">Outros custos</h2>
                                                        <p class="financial__subtitle">(Miscellaneous financing costs)</p>
                                                    </div>
                                                    <div style="margin-bottom: 15px;" class="col-12">
                                                        <div class="input__box">
                                                            <input style="text-align: center;" <?php echo isset($project['others_mortgage']) ? 'value="' . Money($project['others_mortgage']) . '"' : ''; ?> oninput="updateTotalLoanCosts()" type="text" class="money" id="miscellaneous__costs">
                                                        </div>
                                                    </div>
                                                    <div class="col-12">
                                                        <div class="divider"></div>
                                                    </div>
                                                    <div style="margin-top: 10px;" class="col-12">
                                                        <h1 class="totalResult">Custos totais: <span id="totalFinancialCosts">$0.00</span></h1>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div style="margin-top: 25px;" class="col-12 col-md-6">
                                    <h1 class="title">Custos da transação de compra: </h1>
                                    <div style="padding: 25px !important;" id="buycosts__box" class="moduleInside">
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="input__box">
                                                    <label>Custos da transação: (normalmente 2-4% do preço de compra)</label>
                                                    <div class="input__row">
                                                        <input type="text" <?php echo isset($buy_costs['transaction']) ? 'value="' . $buy_costs['transaction']['percentage'] . '"' : ''; ?> oninput="buyCostsUpdate('percentage')" class="percentageMask" id="buycosts__percentage" placeholder="%">
                                                        <input type="text" <?php echo isset($buy_costs['transaction']) ? 'value="' . Money($buy_costs['transaction']['amount']) . '"' : ''; ?> oninput="buyCostsUpdate('amount')" class="money" id="buycosts__amount" placeholder="$ 0,00">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="divider"></div>
                                            </div>
                                            <div class="col-12">
                                                <div class="input__box">
                                                    <label>Outros custos da transação</label>
                                                    <div class="input__row">
                                                        <input type="text" <?php echo isset($buy_costs['miscellaneous']) ? 'value="' . Money($buy_costs['miscellaneous']) . '"' : ''; ?> oninput="buyMiscellaneousUpdate()" class="money" id="buycosts__miscellaneous" placeholder="$ 0,00">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="divider"></div>
                                            </div>
                                            <div class="col-12">
                                                <h1 class="totalResult">Custos totais de compra: <span id="buycosts__total">$0.00</span></h1>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div style="margin-top: 25px;" class="col-12 col-md-6">
                                    <h1 class="title">Custos da transação de venda: </h1>
                                    <div style="padding: 25px !important;" id="sellcosts__box" class="moduleInside">
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="input__box">
                                                    <label>Custos da transação: (% do preço de venda (ARV))</label>
                                                    <div class="input__row">
                                                        <input type="text" <?php echo isset($sell_costs['transaction']) ? 'value="' . $sell_costs['transaction']['percentage'] . '"' : ''; ?> oninput="sellCostsUpdate('percentage')" class="percentageMask" id="sellcosts__percentage" placeholder="%">
                                                        <input type="text" class="money" <?php echo isset($sell_costs['transaction']) ? 'value="' . Money($sell_costs['transaction']['amount']) . '"' : ''; ?> oninput="sellCostsUpdate('amount')" id="sellcosts__amount" placeholder="$ 0,00">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="divider"></div>
                                            </div>
                                            <div class="col-12">
                                                <div class="input__box">
                                                    <label>Comissão de corretagem</label>
                                                    <div class="input__row">
                                                        <input type="text" <?php echo isset($sell_costs['realtor']) ? 'value="' . $sell_costs['realtor']['percentage'] . '"' : ''; ?> oninput="realtorCostsUpdate('percentage')" class="percentageMask" id="sellrealtor__percentage" placeholder="%">
                                                        <input type="text" class="money" <?php echo isset($sell_costs['realtor']) ? 'value="' . Money($sell_costs['realtor']['amount']) . '"' : ''; ?> oninput="realtorCostsUpdate('amount')" id="sellrealtor__amount" placeholder="$ 0,00">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="divider"></div>
                                            </div>
                                            <div class="col-12">
                                                <div class="input__box">
                                                    <label>Outros custos da transação</label>
                                                    <div class="input__row">
                                                        <input type="text" class="money" <?php echo isset($sell_costs['miscellaneous']) ? 'value="' . Money($sell_costs['miscellaneous']) . '"' : ''; ?> oninput="sellMiscellaneousUpdate()" id="sellcosts__miscellaneous" placeholder="$ 0,00">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="divider"></div>
                                            </div>
                                            <div class="col-12">
                                                <h1 class="totalResult">Custos totais de venda: <span id="sellcosts__total">$0.00</span></h1>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="step__buttons">
                        <div>
                            <button onclick="exitWithoutSave()" class="exitButton">Sair sem Salvar</button>
                        </div>
                        <div>
                            <button id="prevStep" onclick="Step(current__step - 1)" disabled>Voltar</button>
                            <button id="nextStep" onclick="Step(current__step + 1)" disabled>Avançar</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</body>
<script type="text/javascript">

    var notyf = new Notyf();
    current__step = 1;

    let arrayPictures = <?php echo isset($project['picture']) ? $project['picture'] : "[]" ?>;
    var hash__code = '<?php echo $hash_code; ?>';

    // =============  ACTIONS

    function Step(step) {

        const menu__steps = document.querySelectorAll('#header__steps .step__item');
        const module__steps = document.querySelectorAll('#stepModuleRows .module');

        if (!VerifyStep()) {
            return false; }

        current__step = step;

        menu__steps.forEach(step => {
            if (step.dataset.step != current__step) { 
                step.classList.remove('active__step'); 
            } else { step.classList.add('active__step'); }
        });
        module__steps.forEach(step => {
            if (step.dataset.step != current__step) { 
                step.classList.add('hidden__module'); 
            } else { step.classList.remove('hidden__module'); }
        });

        ValidPrevNext();

        // Roi menu
        const roi__menu = document.getElementById('roi__menu');
        current__step === 4 ? roi__menu.style.display = 'block' : roi__menu.style.display = 'none';

        // Rehab menu
        const rehab__menu = document.getElementById('rehab__menu');
        current__step === 3 ? rehab__menu.style.display = 'flex' : rehab__menu.style.display = 'none';

        // STEP: REHAB
        if (current__step === 3) {
            const saveButton = document.getElementById('saveProject');
            saveButton.onclick = () => UpdateDraft(true); }

        // STEP: ROI
        if (current__step === 4) {

            const nextBtn = document.getElementById('nextStep');
            nextBtn.innerHTML = 'Publicar';
            nextBtn.onclick = () => UpdateDraft(true);
            nextBtn.disabled = false;

            // Altera os inputs ROI
            const input__arv = document.getElementById('roi__arv');
            const input__rehab = document.getElementById('roi__rehab__price');
            const amount_rehab = document.getElementById('total__amount');
            input__rehab.value = FormatMoneyToSql(amount_rehab.innerHTML);
            updateLoanCosts();
            CalcTotalMonthly();

        } else {
            const nextBtn = document.getElementById('nextStep');
            nextBtn.onclick = () => Step(current__step + 1);
            nextBtn.innerHTML = 'Avançar';
            const publish__button = document.getElementById('saveProject');
            publish__button.style.background = 'var(--color-gradient)';
            publish__button.innerHTML = 'SALVAR';
            publish__button.style.display='block';
        }
    }
    function searchNearMe() {
        // Obter elementos do input
        const input__address = document.getElementById('project__address');
        const input__city = document.getElementById('project__city');
        const input__zipcode = document.getElementById('project__zipcode');

        // Atualiza load no botão
        const button = document.getElementById('searchNearMe');
        const button_old_value = button.innerHTML;
        button.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i>';

        // Verificar se a geolocalização é suportada
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(position => {
                // Obter latitude e longitude
                const latitude = position.coords.latitude;
                const longitude = position.coords.longitude;

                // Construir URL da API com a chave de API e coordenadas
                const apiKey = 'b08ccab1889a4c52be68fd4192cb3c94'; // Substitua 'SUA_CHAVE_API' pela sua chave real da OpenCage Data
                const url = `https://api.opencagedata.com/geocode/v1/json?q=${latitude}+${longitude}&key=${apiKey}`;

                // Fazer requisição à API
                fetch(url)
                    .then(response => response.json())
                    .then(data => {
                        if (data && data.results && data.results.length > 0) {
                            // Extrair dados do primeiro resultado
                            const components = data.results[0].components;

                            // Definir os valores dos inputs
                            input__address.value = components.road || '' + ' ' + components.house_number || '';
                            input__city.value = components.city || components.town || '';
                            input__zipcode.value = components.postcode || '';

                            button.innerHTML = button_old_value;
                        }
                    })
                    .catch(error => {
                        button.innerHTML = button_old_value;
                        console.error('Erro ao buscar o endereço:', error);
                    });
            }, error => {
                button.innerHTML = button_old_value;
                console.error('Erro ao obter localização:', error);
            });
        } else {
            button.innerHTML = button_old_value;
            console.log("Geolocalização não é suportada por este navegador.");
        }
    }
    function VerifyStep() {
        let error__inputs = false;
        if (current__step === 1) {
            const stepOneInputs = document.querySelectorAll('#step__info input');
            stepOneInputs.forEach(input => {
                if (input.required) {
                    const isValid = input.validity.valid;
                    if (!isValid) {
                        input.style.borderColor = '#ff0000';
                        input.nextElementSibling.style.display = 'block';
                        input.nextElementSibling.innerHTML = 'Este campo é obrigatório';
                        error__inputs = true;
                    }
                }
            });
        }

        if (error__inputs) { return false; } else { 
            UpdateDraft(current__step === 4 ? true : null);
            return true; }
    }
    function ValidInput(input) {
        if (input.value.length > 0) {
            input.style.borderColor = '#00000040';
            input.nextElementSibling.style.display = 'none';
            input.nextElementSibling.innerHTML = '';
        }
    }
    function ValidPrevNext() {
        let error__inputs = false;
        const stepOneInputs = document.querySelectorAll('#step__info input');
        stepOneInputs.forEach(input => {
            if (input.required) {
                const isValid = input.validity.valid;
                if (!isValid) {
                    error__inputs = true;
                }
            }
        });

        const prevBtn = document.getElementById('prevStep');
        const nextBtn = document.getElementById('nextStep');

        if (!error__inputs) {
            current__step != 1 ? prevBtn.disabled = false : prevBtn.disabled = true;
            current__step != 4 ? nextBtn.disabled = false : nextBtn.disabled = true;
        } else {
            prevBtn.disabled = true;
            nextBtn.disabled = true;
        }
    }
    function UpdateDraft(rehab = false) {

        // Step one
        const input__address = document.getElementById('project__address');
        const input__city = document.getElementById('project__city');
        const input__zipcode = document.getElementById('project__zipcode');
        const input__bedrooms = document.getElementById('project__bedrooms');
        const input__bathrooms = document.getElementById('project__bathrooms');
        const input__size = document.getElementById('project__size');
        const input__notes = document.getElementById('project__notes');

        // Step Picture
        const input__picture = document.getElementById('project__picture');

        // Step Rehab
        const json__rehab = gerarJSONReformas();

        // Step ROI
        const input__price__arv = document.getElementById('roi__arv');
        const input__price__buy = document.getElementById('roi__price__buy');
        const input__rehab__price = document.getElementById('roi__rehab__price');
        const input__quantity__months = document.getElementById('roi__quantity__months');
        const holding_costs = JsonHoldingCosts();
        const first_mortgage = JsonFirstMortgage();
        const secound_mortgage = JsonSecoundMortgage();
        const others_mortgage = getMiscellaneosCosts();
        const buy_costs = JsonBuyCosts();
        const sell_costs = JsonSellCosts();
        const total_costs = getTotalCosts();

        $.ajax({
          type: "POST",
          url: base_url + "/api/projects/update.php",
          data: {

            code: hash__code,

            // Step one
            address: input__address.value,
            city: input__city.value,
            zipcode: input__zipcode.value,
            bedrooms: input__bedrooms.value,
            bathrooms: input__bathrooms.value,
            size: input__size.value,
            notes: input__notes.value,

            // Step picture
            picture: arrayPictures ? JSON.stringify(arrayPictures) : null,

            // Step rehab
            rehab: rehab ? json__rehab : null,

            // Step ROI
            price__arv: FormatMoneyToSql(input__price__arv.value),
            price__buy: FormatMoneyToSql(input__price__buy.value),
            rehab__total: FormatMoneyToSql(input__rehab__price.value),
            duration: FormatMoneyToSql(input__quantity__months.value),
            holding_costs: holding_costs,
            first_mortgage: first_mortgage,
            secound_mortgage: secound_mortgage,
            others_mortgage: others_mortgage,
            buy_costs: buy_costs,
            sell_costs: sell_costs,
            total_costs: total_costs,

          },
          success: function(response) {
            if (response.status === 'success') {
                notyf.success('Rascunho salvo!');

                const autosave = document.getElementById('autoSave');
                autosave.innerHTML = 'Rascunho salvo em ' + GetDate();

            }

            else { console.log(response); }

          },
          error: function(xhr, status, error) {
            console.error("Erro:", error);
          }
        });
    }
    function exportPdf() {
        const button = document.getElementById('exportPdf');
        const oldValue = button.innerHTML;
        button.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i>';

        // Chama a função UpdateDraft
        UpdateDraft(true);

        // Aguarda 2 segundos antes de continuar
        setTimeout(() => {
            button.innerHTML = oldValue;
            window.open(base_url + '/project/' + hash__code);
        }, 2000); // 2000 milissegundos = 2 segundos
    }
    function exitWithoutSave() {
        Swal.fire({
            title: "Você tem certeza?",
            text: "O rascunho salvo será excluido definitivamente!",
            icon: "warning",
            showCancelButton: true,
            cancelButtonText: "Cancelar",
            confirmButtonText: "Confirmar"
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                  type: "POST",
                  url: base_url + "/api/projects/delete.php",
                  data: { code: hash__code },
                  success: function(response) {
                    // Deletado
                    if (response.status === 'success') {
                        Route('projects');
                    }
                    else { console.log(response); }
                  },
                  error: function(xhr, status, error) {
                    console.error("Erro:", error);
                  }
                });
            }
        });
    }

    // ==============  STEP: PICTURE

    function InputPicture() {
        const inputPicture = document.getElementById('project__picture');
        inputPicture.click();
    }
    function allowDrop(event) {
        event.preventDefault();
    }
    function handleDrop(event) {
        event.preventDefault();
        const inputPicture = document.getElementById('project__picture');
        const files = event.dataTransfer.files;
        const validTypes = ['image/png', 'image/jpeg', 'image/jpg'];
        for (let file of files) {
            if (validTypes.includes(file.type) && file.size <= 12 * 1024 * 1024) {
                showPreview(file);
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: 'Por favor, selecione um arquivo PNG, JPG ou JPEG ou que não exceda 12MB.',
                });
            }
        }
        inputPicture.files = files;
    }
    function handleFileSelect(event) {
        const inputPicture = event.target;
        const files = inputPicture.files;
        const validTypes = ['image/png', 'image/jpeg', 'image/jpg'];
        if (files.length > 0) {
            for (let file of files) {
                if (validTypes.includes(file.type) && file.size <= 12 * 1024 * 1024) {
                    uploadFile(file);
                    showPreview(file);
                } else if (!validTypes.includes(file.type)) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: 'Por favor, selecione um arquivo PNG, JPG ou JPEG.',
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: 'O tamanho do arquivo excede o limite de 12MB.',
                    });
                }
            }
        }
    }
    function uploadFile(file) {
        const formData = new FormData();
        formData.append('file', file);
        formData.append('code', '<?php echo $hash_code; ?>');
        $.ajax({
            url: base_url + '/api/projects/picture.php',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.status === 'success') {
                    console.log('Arquivo enviado com sucesso!');
                    arrayPictures.push(response.filePath || file.name);
                    UpdateDraft();
                } else {
                    console.log('Erro ao enviar o arquivo: ' + response.message);
                }
            },
            error: function(xhr, status, error) {
                console.log('Erro ao enviar a requisição: ' + error);
            }
        });
    }
    function showPreview(file) {
        const reader = new FileReader();
        reader.onload = function(e) {

            const divElement = document.createElement("div");
            divElement.classList.add('itemPicBox');

            // Preciso colocar o nome do arquivo como valor ali da tashPicture()

            divElement.innerHTML = `
                <label onclick="trashPicture('${file.name}', this)"><i class="fa-solid fa-xmark"></i></label>
                <img id="previewImage" src="${e.target.result}">
            `;

            document.getElementById('previewPhoto').appendChild(divElement);


        }
        reader.readAsDataURL(file);
    }
    function trashPicture(file_name, element) {
        const index = arrayPictures.indexOf(file_name);
        if (index !== -1) {
            arrayPictures.splice(index, 1); }

        element.remove();
        UpdateDraft();
    }
    function SelectAnotherPicture() {

        const squarePhoto = document.getElementById('squarePhoto');
        squarePhoto.classList.remove('showing');

        const previewImage = document.getElementById('previewImage');
        previewImage.style.display = 'none';
        previewImage.src = '';

        const inputPicture = document.getElementById('project__picture');
        inputPicture.files = null;

        InputPicture();
    }

    document.getElementById('choosePicture').addEventListener('click', InputPicture);

    // ============= STEP: REHAB

    function adicionarItemReforma(category, title, price, quantity = 1, validTitle = false, checkedBox = false, sqft = false) {
        const container = document.querySelector(`[data-category="${category}"]`);

        // Cria um novo item
        const novoItem = document.createElement('div');
        novoItem.classList.add('rehab__item');
        novoItem.dataset.category = category;

        novoItem.innerHTML = `
            <div class="row">
                <div class="col-12 col-md-7">
                    <div class="text__content">
                        <input type="checkbox" class="checkbox" ${checkedBox === true ? 'checked' : ''} name="status">
                        <input type="text" ${validTitle === true ? 'placeholder="Insira o título"' : 'readonly' } class="title" value="${title}">
                    </div>
                </div>
                <div class="col-12 col-md-5">
                    <div class="calc__content">
                        <div class="calc__item">
                            <label>${sqft ? 'Sqft (m²): ' : 'Qntd' }</label>
                            <input type="number" ${checkedBox === false ? 'disabled' : ''} class="quantity" value="${quantity}">
                        </div>
                        <div class="operationDivider">
                            <label>x</label>
                        </div>
                        <div class="calc__item">
                            <label>${sqft ? 'Preço/sqft (m²): ' : 'Preço' }</label>
                            <input type="text" ${checkedBox === false ? 'disabled' : ''} class="price" value="${price * 100}">
                        </div>
                        <div class="operationDivider">
                            <label>=</label>
                        </div>
                        <div class="calc__item">
                            <label>Total</label>
                            <input type="text" class="total" value="" readonly>
                        </div>
                    </div>
                </div>
            </div>
        `;

        // Adiciona o novo item abaixo do último item da categoria
        const lastItem = container.querySelector('.buttonRow');
        if (lastItem) {
            container.insertBefore(novoItem, lastItem);
        } else {
            container.appendChild(novoItem); }

        // Inicializa a máscara de dinheiro no campo de preço e total
        const priceInput = novoItem.querySelector('.price');
        const totalInput = novoItem.querySelector('.total');

        if (priceInput && totalInput) {
            VMasker(priceInput).maskMoney({
                precision: 2, // Número de casas decimais
                separator: '.', // Separador decimal
                delimiter: ',', // Separador de milhares
                unit: '$', // Símbolo da unidade monetária
                zeroCents: false // Mostrar valores com centavos mesmo se zero
            });
        }

        // Ouve mudanças nos campos de quantidade, preço e checkbox
        novoItem.querySelectorAll('.quantity, .price, .checkbox').forEach(input => {
            if (checkedBox) { calcularTotal(input); }
            input.addEventListener('input', () => {
                calcularTotal(input);
            });
        });
    }
    function calcularTotal(element) {
        const row = element.closest('.row');
        const isChecked = row.querySelector('.checkbox').checked;
        const quantity = row.querySelector('.quantity').value;
        const priceInput = row.querySelector('.price');
        const rawPrice = FormatMoneyToSql(priceInput.value);
        const totalField = row.querySelector('.total');

        if (!isNaN(quantity) && !isNaN(rawPrice)) {
            const total = (quantity * rawPrice) * 100;
            totalField.value = total;

            // const roi__rehab = document.getElementById('roi__rehab__price');
            // roi__rehab.value = total;

            VMasker(totalField).maskMoney({
                precision: 2,
                separator: '.',
                delimiter: ',',
                unit: '$',
                zeroCents: false
            });

            if (!isChecked) {
                row.querySelector('.quantity').disabled = true;
                priceInput.disabled = true;
                totalField.disabled = true;
            } else {
                row.querySelector('.quantity').disabled = false;
                priceInput.disabled = false;
                totalField.disabled = false;
            }

        } else {
            totalField.value = '';
        }

        UpdateTotal();
    }
    function UpdateTotal() {
        // Define os squares
        const square__exterior = document.getElementById('total__exterior');
        const square__interior = document.getElementById('total__interior');
        const square__mechanical = document.getElementById('total__mechanical');
        const square__others = document.getElementById('total__others');
        const square__amount = document.getElementById('total__amount');

        // Define os valores
        const amount__exterior = updateCategoryTotal('Exterior');
        const amount__interior = updateCategoryTotal('Interior');
        const amount__mechanical = updateCategoryTotal('Mecânica');
        const amount__others = updateCategoryTotal('Outros');

        // Insere na tela
        square__exterior.innerHTML = FormatMoney(amount__exterior);
        square__interior.innerHTML = FormatMoney(amount__interior);
        square__mechanical.innerHTML = FormatMoney(amount__mechanical);
        square__others.innerHTML = FormatMoney(amount__others);

        const square__total = amount__exterior + amount__interior + amount__mechanical + amount__others;

        square__amount.innerHTML = FormatMoney(square__total);
    }
    function updateCategoryTotal(category) {
        const items = document.querySelectorAll(`[data-category="${category}"] .rehab__item`);

        let categoryTotal = 0;
        items.forEach(item => {
            const checkbox = item.querySelector('.checkbox');
            if (checkbox.checked) {
                const totalValue = parseFloat(FormatMoneyToSql(item.querySelector('.total').value));
                if (!isNaN(totalValue)) {
                    categoryTotal += totalValue;
                }
            }
        });

        return categoryTotal;
    }
    function inicializarReformas(categorias, reformas) {
        categorias.forEach(category => {

            const container = document.createElement('div');
            container.dataset.category = category;
            container.innerHTML = `<h1 class="rehab__title">${category}:</h1>`;
            document.getElementById('rehabRows').appendChild(container);

            reformas[category].forEach(reforma => {
                adicionarItemReforma(category, reforma.title, reforma.price, reforma.quantity, false, false, reforma.sqft ? true : false);
            });

            const buttonRow = document.createElement('div');
            buttonRow.classList.add('buttonRow');

            const addButton = document.createElement('button');
            addButton.textContent = 'Adicionar item';
            addButton.classList.add('addRow');

            addButton.onclick = () => adicionarItemReforma(category, '', 0, 1, true, true);
            container.appendChild(buttonRow);
            buttonRow.appendChild(addButton);

        });
    }
    function gerarJSONReformas() {

        const categorias = ['Exterior', 'Interior', 'Mecânica', 'Outros'];
        const reformasJSON = [];

        categorias.forEach(category => {
            const items = [];
            const categoryItems = document.querySelectorAll(`[data-category="${category}"] .rehab__item`);

            categoryItems.forEach(item => {
                const added = item.querySelector('.title').readOnly;
                const title = item.querySelector('.title').value;
                const quantity = item.querySelector('.quantity').value;
                const rawPrice = item.querySelector('.price').value;
                const isChecked = item.querySelector('.checkbox').checked;
                const totalValue = isChecked ? quantity * FormatMoneyToSql(rawPrice) : 0;
                const itemObj = {
                    title: title,
                    quantity: quantity,
                    price: FormatMoneyToSql(rawPrice),
                    total: totalValue,
                    checked: isChecked,
                    added: added ? false : true
                };

                items.push(itemObj);
            });

            let categoryTotal = 0;
            items.forEach(item => {
                if (item.checked) {
                    categoryTotal += item.total;
                }
            });

            const categoryObj = {
                category: category,
                items: items,
                categoryTotal: categoryTotal
            };

            reformasJSON.push(categoryObj);
        });

        let totalGeral = 0;
        reformasJSON.forEach(categoryObj => {
            totalGeral += categoryObj.categoryTotal;
        });

        const jsonResult = {
            reformas: reformasJSON,
            totalGeral: totalGeral
        };

        return jsonResult;
    }
    function InitiRehabDatabase(reformasJSON) {
        const container = document.getElementById('rehabRows');
        container.innerHTML = '';

        reformasJSON.reformas.forEach(categoryObj => {
            const category = categoryObj.category;
            const items = categoryObj.items;

            const categoryContainer = document.createElement('div');
            categoryContainer.dataset.category = category;
            categoryContainer.innerHTML = `<h1 class="rehab__title">${category}:</h1>`;
            container.appendChild(categoryContainer);

            items.forEach(item => {
                const priceNumeric = parseFloat(item.price.replace(/[^\d.-]/g, ''));
                adicionarItemReforma(category, item.title, priceNumeric, item.quantity, item.added === 'true' ? true : false, item.checked === 'true' ? true : false);
            });

            const buttonRow = document.createElement('div');
            buttonRow.classList.add('buttonRow');

            const addButton = document.createElement('button');
            addButton.textContent = 'Adicionar item';
            addButton.classList.add('addRow');

            addButton.onclick = () => adicionarItemReforma(category, '', 0, 1, true, true);
            categoryContainer.appendChild(buttonRow);
            buttonRow.appendChild(addButton);
        });

        UpdateTotal();
    }

    const categorias = ['Exterior', 'Interior', 'Mecânica', 'Outros'];
    const reformas = {
        'Exterior': [
            { title: 'Remover e instalar telhado novo', price: 6, quantity: 1, sqft: true },
            { title: 'Consertar o telhado existente', price: 3, quantity: 1, sqft: true },
            { title: 'Janela pequenas (remover e instalar)', price: 250, quantity: 1 },
            { title: 'Janela média (remover e instalar)', price: 350, quantity: 1 },
            { title: 'Janela grande (remover e instalar)', price: 875, quantity: 1 },
            { title: 'Pintura externa', price: 3, quantity: 1, sqft: true },
            { title: 'Instalação de vinil/tapume', price: 5, quantity: 1, sqft: true },
            { title: 'Reboco', price: 7, quantity: 1, sqft: true },
            { title: 'Lavagem potente', price: 0.8, quantity: 1, sqft: true },
            { title: 'Portão de garagem manual (1 carro)', price: 800, quantity: 1 },
            { title: 'Portão de garagem manual (2 carros)', price: 1100, quantity: 1 },
            { title: 'Abridor de portão de garagem instalado', price: 225, quantity: 1 },
            { title: 'Paisagismo: Lote grande - reforma', price: 5200, quantity: 1 },
            { title: 'Paisagismo: Lote médio - reforma', price: 3500, quantity: 1 },
            { title: 'Paisagismo: Lote pequeno - reforma', price: 2200, quantity: 1 },
            { title: 'Paisagismo + Limpeza de quintal', price: 600, quantity: 1 },
            { title: 'Entrada/calçada de demonstração', price: 2.5, quantity: 0, sqft: true },
            { title: 'Instalar concreto para entrada de automóveis/calçada', price: 7, quantity: 0, sqft: true },
            { title: 'Construir um novo deck', price: 18, quantity: 0, sqft: true },
            { title: 'Reparo parcial em deck existente', price: 18, quantity: 0, sqft: true },
            { title: 'Cerca de madeira', price: 17, quantity: 0, sqft: true },
            { title: 'Cerca de metal', price: 47, quantity: 0, sqft: true },
            { title: 'Refazer piscina', price: 15000, quantity: 1 },
        ],
        'Interior': [
            { title: 'Pintura interior', price: 3, quantity: 1, sqft: true },
            { title: 'Piso laminado', price: 4, quantity: 1, sqft: true },
            { title: 'Piso de madeira', price: 7, quantity: 1, sqft: true },
            { title: 'Piso de carpet', price: 2.5, quantity: 1, sqft: true },
            { title: 'Piso de telha', price: 8, quantity: 1, sqft: true },
            { title: 'Eletrodomésticos: Luxuoso', price: 15000, quantity: 1 },
            { title: 'Eletrodomésticos: Sofisticado', price: 10500, quantity: 1 },
            { title: 'Eletrodomésticos: Mediano', price: 5000, quantity: 1 },
            { title: 'Eletrodomésticos: Baixo custo', price: 2500, quantity: 1 },
            { title: 'Banheiro principal grande - trocar tudo', price: 10000, quantity: 1 },
            { title: 'Banheiro completo - trocar tudo', price: 6000, quantity: 1 },
            { title: 'Banheiro pequeno - trocar tudo', price: 3500, quantity: 1 },
            { title: 'Isolamento de parede', price: 2, quantity: 1, sqft: true },
            { title: 'Paredes de drywall, fita e skimcoat', price: 3, quantity: 1, sqft: true },
            { title: 'Teto de drywall, fita e skimcoat', price: 4.5, quantity: 1, sqft: true },
            { title: 'Porta interior', price: 0, quantity: 0 },
            { title: 'Porta externa', price: 0, quantity: 0 },
            { title: 'Moldura de porta', price: 0, quantity: 0 },
            { title: 'Guarnição do rodapé', price: 0, quantity: 0 },
            { title: 'Piso de concreto no porão', price: 200, quantity: 0, sqft: true },
            { title: 'Reparar fundações existentes (faça um orçamento)', price: 10000, quantity: 1 },
            { title: 'Cozinha: Alto padrão', price: 15000, quantity: 1 },
            { title: 'Cozinha: Mediana', price: 11000, quantity: 1 },
            { title: 'Cozinha: Baixo custo', price: 8000, quantity: 1 },
        ],
        'Mecânica': [
            { title: 'Dutos do sistema de aquecimento e ar condicionado', price: 10000, quantity: 1 },
            { title: 'Aparelho de ar condicionado', price: 5000, quantity: 1 },
            { title: 'Substituir unidade de caldeira', price: 3000, quantity: 1 },
            { title: 'Substituir painel elétrico', price: 3000, quantity: 1 },
            { title: 'Substituir todas as luminárias', price: 2000, quantity: 1 },
        ],
        'Outros': [
            { title: 'Aluguel de caçamba de lixo de 40 metros', price: 600, quantity: 1 },
            { title: 'Mão de obra de demolição para encher 1 lixeira', price: 600, quantity: 1 },
            { title: 'Remoção e tratamento de cupins', price: 1000, quantity: 1 },
            { title: 'Remoção e tratamento de mofo', price: 2000, quantity: 1 },
            { title: 'Licenças para reforma (varia por cidade)', price: 1500, quantity: 1 },
            { title: 'Home staging: cozinha, quarto, sala de estar e sala de jantar', price: 2000, quantity: 1 },
        ]};

    function InitRehab(rehabData) {
        if (rehabData) {
            InitiRehabDatabase(JSON.parse(rehabData));
        } else {
            inicializarReformas(categorias, reformas);
        }
    }

    const rehab__database = '<?php echo !empty($project['rehab']) ? $project['rehab'] : null; ?>';
    InitRehab(rehab__database);


    // =============== ROI 

    function CalcTotalMonthly() {

        const property = document.getElementById('costs__property');
        const hoa = document.getElementById('costs__hoa');
        const insurance = document.getElementById('costs__insurance');
        const utilities = document.getElementById('costs__utilities');
        const miscellaneous = document.getElementById('costs__miscellaneous');
        const input__qntd = document.getElementById('roi__quantity__months');
        const quantityMonths = input__qntd.value > 1 ? input__qntd.value : 1;

        // Subcalc
        const sub__property = document.getElementById('costs__property__montly');
        const sub__hoa = document.getElementById('costs__hoa__yearly');
        const sub__insurance = document.getElementById('costs__insurance__yearly');
        const sub__utilities = document.getElementById('costs__utilities__yearly');
        const sub__miscellaneous = document.getElementById('costs__miscellaneous__yearly');

        calc__property = FormatMoneyToSql(property.value);

        sub__property.value = FormatMoney(calc__property / 12);
        sub__hoa.value = FormatMoney(+FormatMoneyToSql(hoa.value) * 12);
        sub__insurance.value = FormatMoney(+FormatMoneyToSql(insurance.value) * 12);
        sub__utilities.value = FormatMoney(+FormatMoneyToSql(utilities.value) * 12);
        sub__miscellaneous.value = FormatMoney(+FormatMoneyToSql(miscellaneous.value) * 12);

        const total__monthly = (calc__property / 12) + +FormatMoneyToSql(hoa.value) + +FormatMoneyToSql(insurance.value) + +FormatMoneyToSql(utilities.value) + +FormatMoneyToSql(miscellaneous.value);

        const totalSpan = document.getElementById('totalMonthly');
        totalSpan.innerHTML = FormatMoney(total__monthly);

        pointsCostsCheck();
        interestCostsCheck();
        secoundMortgagePoints('amount');
        secoundMortgageInterest('percentage');
        updateProfit();
    }
    function getTotalMonthly() {
        const property = document.getElementById('costs__property');
        const hoa = document.getElementById('costs__hoa');
        const insurance = document.getElementById('costs__insurance');
        const utilities = document.getElementById('costs__utilities');
        const miscellaneous = document.getElementById('costs__miscellaneous');
        const quantityMonths = document.getElementById('roi__quantity__months');

        const calc__property = +FormatMoneyToSql(property.value) > 0 ? +FormatMoneyToSql(property.value) : 0;
        const calc__hoa = +FormatMoneyToSql(hoa.value) > 0 ? +FormatMoneyToSql(hoa.value) * 12 : 0;
        const calc__insurance = +FormatMoneyToSql(insurance.value) > 0 ? +FormatMoneyToSql(insurance.value) * 12 : 0;
        const calc__utilities = +FormatMoneyToSql(utilities.value) > 0 ? +FormatMoneyToSql(utilities.value) * 12 : 0;
        const calc__miscellaneous = +FormatMoneyToSql(miscellaneous.value) > 0 ? +FormatMoneyToSql(miscellaneous.value) * 12 : 0;
        const quantity_months = +quantityMonths.value > 0 ? +quantityMonths.value : 0;

        const total_monthly = (calc__property / 12) + (calc__hoa / 12) + (calc__insurance / 12) + (calc__utilities / 12) + (calc__miscellaneous / 12);
        return total_monthly * quantity_months;
        updateProfit();
    }
    function JsonHoldingCosts() {

        const property = document.getElementById('costs__property');
        const hoa = document.getElementById('costs__hoa');
        const insurance = document.getElementById('costs__insurance');
        const utilities = document.getElementById('costs__utilities');
        const miscellaneous = document.getElementById('costs__miscellaneous');

        calc__property = +FormatMoneyToSql(property.value) > 0 ? +FormatMoneyToSql(property.value) : 0;
        calc__hoa = +FormatMoneyToSql(hoa.value) > 0 ? +FormatMoneyToSql(hoa.value) * 12 : 0;
        calc__insurance = +FormatMoneyToSql(insurance.value) > 0 ? +FormatMoneyToSql(insurance.value) * 12 : 0;
        calc__utilities = +FormatMoneyToSql(utilities.value) > 0 ? +FormatMoneyToSql(utilities.value) * 12 : 0;
        calc__miscellaneous = +FormatMoneyToSql(miscellaneous.value) > 0 ? +FormatMoneyToSql(miscellaneous.value) * 12 : 0;

        const total_yearly = calc__property + calc__hoa + calc__insurance + calc__utilities + calc__miscellaneous;
        const total_monthly = (calc__property / 12) + (calc__hoa / 12) + (calc__insurance / 12) + (calc__utilities / 12) + (calc__miscellaneous / 12);

        const array = {

            property_taxs: { 
                yearly: calc__property,
                monthly: (calc__property / 12),
            },
            hoa_fees: { 
                yearly: calc__hoa,
                monthly: (calc__hoa / 12),
            },
            insurance: { 
                yearly: calc__insurance,
                monthly: (calc__insurance / 12),
            },
            utilities: { 
                yearly: calc__utilities,
                monthly: (calc__utilities / 12),
            },
            miscellaneous: { 
                yearly: calc__miscellaneous,
                monthly: (calc__miscellaneous / 12),
            },
            total: {
                yearly: round(total_yearly, 2),
                monthly: round(total_monthly, 2)
            }

        };

        return JSON.stringify(array);
    }

    // Functions
    function getPercentage(percentage, amount) {
        if (typeof percentage !== 'number' || typeof amount !== 'number' || isNaN(percentage) || isNaN(amount)) {
            console.error("Erro: Os argumentos devem ser números válidos.");
            console.error("Amount: " + amount);
            console.error("Percentage: " + percentage);
            return 0; }
        if (percentage < 0 || percentage > 100) {
            console.error("Erro: A porcentagem deve estar entre 0 e 100.");
            return 0; }
        let result = (percentage / 100) * amount;
        return result;
    }
    function getPriceBuy() {
        const inputPriceBuy = document.getElementById('roi__price__buy');
        const result = +FormatMoneyToSql(inputPriceBuy.value);
        return result;
    }
    function getPriceArv() {
        const inputPriceArv = document.getElementById('roi__arv');
        const result = +FormatMoneyToSql(inputPriceArv.value);
        return result;
    }
    function getRehabTotal() {
        const inputRehabTotal = document.getElementById('roi__rehab__price');
        const result = +FormatMoneyToSql(inputRehabTotal.value);
        return result;
    }
    function percentToNumber(porcentagem) {
        let valorLimpo = porcentagem.replace('%', '').trim();
        valorLimpo = valorLimpo.replace(',', '.');
        return parseFloat(valorLimpo);
    }
    function numberToPercent(valor, total) {
        if (typeof valor !== 'number' || typeof total !== 'number' || total === 0) {
            return 'Valores inválidos';  }
        let porcentagem = (valor / total) * 100;
        return porcentagem.toFixed(2);
    }
    function getTotalMortgage() {
        const totalText = document.getElementById('firstMortage__total');
        const downPayment = document.getElementById('downPayment__amount');
        const rehabTotal = document.getElementById('rehabTotal__amount');
        const priceBuy = getPriceBuy();

        // Valor total do empréstimo
        const totalAmount = (priceBuy - +FormatMoneyToSql(downPayment.value)) + +FormatMoneyToSql(rehabTotal.value);

        // Insere o valor total do empréstimo
        const totalLoanAmount = document.getElementById('totalLoanAmount');
        totalLoanAmount.value = FormatMoney(totalAmount);

        // Insere o custo financeiro do empréstimo
        totalText.innerHTML = FormatMoney(getLoanCosts());
        updateProfit();
    }
    
    // First Mortgage
    function downPaymentCheck() {
        const priceBuy = getPriceBuy();
        const amount = document.getElementById('downPayment__amount');
        const percentage = document.getElementById('downPayment__percentage');

        // Busca o percentual automático
        const inputs = document.querySelectorAll('input[name="downPay"]');
        const checkedValue = Array.from(inputs).find(input => input.checked)?.value;
        const percentual = checkedValue ? checkedValue : 10;

        if (percentual === 'manual') {
            amount.readOnly = false;
            percentage.readOnly = false; 

            percentage.placeholder = 'Insira a porcentagem';
            amount.placeholder = 'Ou o valor de entrada';

            getTotalMortgage();
            return false; }

        percentage.value = +percentual + '%';
        amount.value = FormatMoney(getPercentage(+percentual, priceBuy));

        getTotalMortgage();
    }
    function downPaymentManual(inputType) {
        const priceBuy = getPriceBuy();
        const amount = document.getElementById('downPayment__amount');
        const percentage = document.getElementById('downPayment__percentage');

        if (inputType === 'percentage') {
            amount.value = FormatMoney(getPercentage(percentToNumber(percentage.value), priceBuy)); 

        } else if (inputType === 'amount') {
            percentage.value = numberToPercent(+FormatMoneyToSql(amount.value), priceBuy); }

        getTotalMortgage();
    }
    function rehabCostsCheck() {
        const totalRehab = getRehabTotal();
        const percentage = document.getElementById('rehabTotal__percentage');
        const amount = document.getElementById('rehabTotal__amount');

        amount.readOnly = true;
        percentage.readOnly = true; 

        // Busca o percentual automático
        const inputs = document.querySelectorAll('input[name="rehab"]');
        const checkedValue = Array.from(inputs).find(input => input.checked)?.value;
        const percentual = checkedValue ? checkedValue : 100;

        if (percentual === 'manual') {
            amount.readOnly = false;
            percentage.readOnly = false; 

            percentage.placeholder = 'Insira a porcentagem';
            amount.placeholder = 'Ou o valor de entrada';

            getTotalMortgage();
            return false; }

        percentage.value = +percentual + '%';
        amount.value = FormatMoney(getPercentage(+percentual, totalRehab));

        getTotalMortgage();
    }
    function rehabCostsManual(inputType) {
        const totalRehab = getRehabTotal();
        const percentage = document.getElementById('rehabTotal__percentage');
        const amount = document.getElementById('rehabTotal__amount');

        if (inputType === 'percentage') {
            console.log(percentToNumber(percentage.value));
            amount.value = FormatMoney(getPercentage(percentToNumber(percentage.value), totalRehab)); 

        } else if (inputType === 'amount') {
            percentage.value = numberToPercent(+FormatMoneyToSql(amount.value), totalRehab); }

        getTotalMortgage();
    }
    function pointsCostsCheck() {
        const downPayment = document.getElementById('downPayment__amount');
        const rehabTotal = document.getElementById('rehabTotal__amount');
        const priceBuy = getPriceBuy();

        // Valor total do empréstimo
        const loan_total = getPriceBuy() + getRehabTotal();

        // Seletores
        const percentage = document.getElementById('points__percentage');
        const amount = document.getElementById('points__amount');

        // Busca o percentual automático
        const inputs = document.querySelectorAll('input[name="points"]');
        const checkedValue = Array.from(inputs).find(input => input.checked)?.value;
        const percentual = checkedValue ? checkedValue : 1.5;

        amount.readOnly = true;
        percentage.readOnly = true;

        if (percentual === 'manual') {
            amount.readOnly = false;
            percentage.readOnly = false; 

            percentage.placeholder = 'Insira a porcentagem';
            amount.placeholder = 'Ou o valor de entrada';

            getTotalMortgage();
            pointsCostsManual('percentage');
            return false; }

        percentage.value = +percentual + '%';
        amount.value = FormatMoney(getPercentage(+percentual, loan_total));

        getTotalMortgage();
    }
    function pointsCostsManual(inputType) {
        const downPayment = document.getElementById('downPayment__amount');
        const rehabTotal = document.getElementById('rehabTotal__amount');
        const priceBuy = getPriceBuy();

        // Valor total do empréstimo
        const loan_total = getPriceBuy() + getRehabTotal();

        // Seletores
        const percentage = document.getElementById('points__percentage');
        const amount = document.getElementById('points__amount');

        if (inputType === 'percentage') {
            amount.value = FormatMoney(getPercentage(percentToNumber(percentage.value), loan_total)); 

        } else if (inputType === 'amount') {
            percentage.value = numberToPercent(+FormatMoneyToSql(amount.value), loan_total); }

        getTotalMortgage();
    }
    function interestCostsCheck() {
        const downPayment = document.getElementById('downPayment__amount');
        const rehabTotal = document.getElementById('rehabTotal__amount');
        const priceBuy = getPriceBuy();

        // Valor total do empréstimo
        const loan_total = (priceBuy - +FormatMoneyToSql(downPayment.value)) + +FormatMoneyToSql(rehabTotal.value);

        // Seletores
        const percentage = document.getElementById('interest__percentage');
        const amount = document.getElementById('interest__amount');

        // Busca o percentual automático
        const inputs = document.querySelectorAll('input[name="interest"]');
        const checkedValue = Array.from(inputs).find(input => input.checked)?.value;
        const percentual = checkedValue ? checkedValue : 9;

        amount.readOnly = true;
        percentage.readOnly = true;

        if (percentual === 'manual') {
            amount.readOnly = false;
            percentage.readOnly = false; 

            percentage.placeholder = 'Insira a porcentagem';
            amount.placeholder = 'Ou o valor de entrada';

            interestCostsManual('percentage');
            getTotalMortgage();
            return false; 
        }


        const quantityMonths = document.getElementById('roi__quantity__months').value;
        const calc_percentual = (+percentual / 12) * (quantityMonths ? quantityMonths : 1);

        const amountInterest = FormatMoney(getPercentage(calc_percentual, loan_total));

        percentage.value = +percentual + '%';
        amount.value = amountInterest;

        getTotalMortgage();
    }
    function interestCostsManual(inputType) {
        const downPayment = document.getElementById('downPayment__amount');
        const rehabTotal = document.getElementById('rehabTotal__amount');
        const priceBuy = getPriceBuy();

        // Valor total do empréstimo
        const loan_total = (priceBuy - +FormatMoneyToSql(downPayment.value)) + +FormatMoneyToSql(rehabTotal.value);

        // Seletores
        const percentage = document.getElementById('interest__percentage');
        const amount = document.getElementById('interest__amount');

        if (inputType === 'percentage') {
            const quantityMonths = document.getElementById('roi__quantity__months').value;
            const percentual = percentToNumber(percentage.value);
            const calc_percentual = (+percentual / 12) * (quantityMonths ? quantityMonths : 1);
            amount.value = FormatMoney(getPercentage(calc_percentual, loan_total)); 

        } else if (inputType === 'amount') {
            percentage.value = numberToPercent(+FormatMoneyToSql(amount.value), loan_total); }

        getTotalMortgage();
    }
    function getLoanCosts() {
        const points = document.getElementById('points__amount').value;
        const interest = document.getElementById('interest__amount').value;
        const points_cost = points ? +FormatMoneyToSql(points) : 0;
        const interest_cost = interest ? +FormatMoneyToSql(interest) : 0;
        return loan_costs = points_cost + interest_cost;
    }
    function updateLoanCosts() {
        downPaymentCheck();
        rehabCostsCheck();
        pointsCostsCheck();
        interestCostsCheck();
        updateTotalLoanCosts();
    }
    function JsonFirstMortgage() {

        // Down Payment
        const downpay__percentage = document.getElementById('downPayment__percentage');
        const downpay__amount = document.getElementById('downPayment__amount');

        // Rehab
        const rehab__percentage = document.getElementById('rehabTotal__percentage');
        const rehab__amount = document.getElementById('rehabTotal__amount');

        // Points
        const points__percentage = document.getElementById('points__percentage');
        const points__amount = document.getElementById('points__amount');

        // Interest
        const interest__percentage = document.getElementById('interest__percentage');
        const interest__amount = document.getElementById('interest__amount');

        // Loan Amount
        const loan_amount = document.getElementById('totalLoanAmount');

        const array = {

            down_payment: { 
                percentage: percentToNumber(downpay__percentage.value) > 0 ? percentToNumber(downpay__percentage.value) : 0, 
                amount: +FormatMoneyToSql(downpay__amount.value) > 0 ? +FormatMoneyToSql(downpay__amount.value) : 0
            },
            rehab: { 
                percentage: percentToNumber(rehab__percentage.value) > 0 ? percentToNumber(rehab__percentage.value) : 0, 
                amount: +FormatMoneyToSql(rehab__amount.value) > 0 ? +FormatMoneyToSql(rehab__amount.value) : 0
            },
            points: { 
                percentage: percentToNumber(points__percentage.value) > 0 ? percentToNumber(points__percentage.value) : 0, 
                amount: +FormatMoneyToSql(points__amount.value) > 0 ? +FormatMoneyToSql(points__amount.value) : 0
            },
            interest: { 
                percentage: percentToNumber(interest__percentage.value) > 0 ? percentToNumber(interest__percentage.value) : 0, 
                amount: +FormatMoneyToSql(interest__amount.value) > 0 ? +FormatMoneyToSql(interest__amount.value) : 0
            },
            amount: +FormatMoneyToSql(loan_amount.value) > 0 ? +FormatMoneyToSql(loan_amount.value) : 0,
            costs: getLoanCosts(),

        };

        return JSON.stringify(array);
    }

    // Secound Mortgage
    function secoundMortgagePoints(inputType) {
        const total = document.getElementById('secound__mortgage__amount');
        const percentage = document.getElementById('sec__points__percentage');
        const amount = document.getElementById('sec__points__amount');

        const loan__total = +FormatMoneyToSql(total.value) > 0 ? +FormatMoneyToSql(total.value) : 0;

        if (inputType === 'percentage') {
            const percentual = percentToNumber(percentage.value) > 0 ? percentToNumber(percentage.value) : 0;
            amount.value = FormatMoney(getPercentage(percentual, loan__total)); 

        } else if (inputType === 'amount') {
            percentage.value = numberToPercent(+FormatMoneyToSql(amount.value), loan__total);
        }

        updateSecoundLoanCosts();
    }
    function secoundMortgageInterest(inputType) {
        const total = document.getElementById('secound__mortgage__amount');
        const percentage = document.getElementById('sec__interest__percentage');
        const amount = document.getElementById('sec__interest__amount');

        const loan__total = +FormatMoneyToSql(total.value) > 0 ? +FormatMoneyToSql(total.value) : 0;

        if (inputType === 'percentage') {
            const quantityMonths = document.getElementById('roi__quantity__months').value;
            const percentual = percentToNumber(percentage.value) > 0 ? percentToNumber(percentage.value) : 0;
            const calc_percentual = (+percentual / 12) * (quantityMonths ? quantityMonths : 1);
            amount.value = FormatMoney(getPercentage(calc_percentual, loan__total)); 

        } else if (inputType === 'amount') {
            percentage.value = numberToPercent(+FormatMoneyToSql(amount.value), loan__total);
        }

        updateSecoundLoanCosts();
    }
    function getSecoundMortgageLoanCosts() {
        const secound__amount = document.getElementById('secound__mortgage__amount');
        const sec__loan__total = document.getElementById('secMortage__total');

        // Costs input
        const points__input = document.getElementById('sec__points__amount');
        const interest__input = document.getElementById('sec__interest__amount');

        // Costs value
        const secound__points = +FormatMoneyToSql(points__input.value) > 0 ? +FormatMoneyToSql(points__input.value) : 0;
        const secound__interest = +FormatMoneyToSql(interest__input.value) > 0 ? +FormatMoneyToSql(interest__input.value) : 0;

        // Update total label
        const secound__loan__costs = (secound__points + secound__interest);
        return secound__loan__costs > 0 ? secound__loan__costs : 0;
    }
    function updateSecoundLoanCosts() {
        const sec__loan__total = document.getElementById('secMortage__total');
        const secound__loan__costs = getSecoundMortgageLoanCosts();
        sec__loan__total.innerHTML = FormatMoney(secound__loan__costs);
        updateTotalLoanCosts();
    }
    function JsonSecoundMortgage() {

        // Points
        const points__percentage = document.getElementById('sec__points__percentage');
        const points__amount = document.getElementById('sec__points__amount');

        // Interest
        const interest__percentage = document.getElementById('sec__interest__percentage');
        const interest__amount = document.getElementById('sec__interest__amount');

        // Loan Amount
        const loan_amount = document.getElementById('secound__mortgage__amount');

        const array = {

            points: { 
                percentage: percentToNumber(points__percentage.value) > 0 ? percentToNumber(points__percentage.value) : 0, 
                amount: +FormatMoneyToSql(points__amount.value) > 0 ? +FormatMoneyToSql(points__amount.value) : 0
            },
            interest: { 
                percentage: percentToNumber(interest__percentage.value) > 0 ? percentToNumber(interest__percentage.value) : 0, 
                amount: +FormatMoneyToSql(interest__amount.value) > 0 ? +FormatMoneyToSql(interest__amount.value) : 0
            },
            amount: +FormatMoneyToSql(loan_amount.value) > 0 ? +FormatMoneyToSql(loan_amount.value) : 0,
            costs: getSecoundMortgageLoanCosts(),

        };

        return JSON.stringify(array);
    }

    // Get miscellaneous costs
    function getMiscellaneosCosts() {
        const miscellaneous = document.getElementById('miscellaneous__costs');
        const total = +FormatMoneyToSql(miscellaneous.value) > 0 ? +FormatMoneyToSql(miscellaneous.value) : 0;
        return total;
    }

    // Get total financial costs
    function getTotalFinancialCosts() {
        const first__mortgage = getLoanCosts();
        const secound__mortgage = getSecoundMortgageLoanCosts();
        const miscellaneous__costs = getMiscellaneosCosts();

        // Retorna o total
        const total__financial__costs = (first__mortgage + secound__mortgage + miscellaneous__costs);
        return total__financial__costs > 0 ? total__financial__costs : 0;
        updateProfit();
    }
    function updateTotalLoanCosts() {
        const total = getTotalFinancialCosts();
        const total__label = document.getElementById('totalFinancialCosts');
        total__label.innerHTML = FormatMoney(total);
        updateProfit();
    }

    updateLoanCosts();
    updateSecoundLoanCosts();

    // Buy costs
    function buyCostsUpdate(inputType) {
        const price_buy = getPriceBuy() > 0 ? getPriceBuy() : 0;
        const percentage__input = document.getElementById('buycosts__percentage');
        const amount__input = document.getElementById('buycosts__amount');

        // Calc costs
        const percentage = percentToNumber(percentage__input.value) > 0 ? percentToNumber(percentage__input.value) : 0;
        const amount = +FormatMoneyToSql(amount__input.value) > 0 ? +FormatMoneyToSql(amount__input.value) : 0;

        if (inputType === 'percentage') {
            amount__input.value = FormatMoney(getPercentage(percentage, price_buy));

        } else if (inputType === 'amount') {
            percentage__input.value = numberToPercent(amount, price_buy);
        }

        updateBuyCostsTotal();
    }
    function buyMiscellaneousUpdate() {
        const miscellaneous = document.getElementById('buycosts__miscellaneous');
        const total = +FormatMoneyToSql(miscellaneous.value) > 0 ? +FormatMoneyToSql(miscellaneous.value) : 0;
        updateBuyCostsTotal();
    }
    function getBuyCostsTotal() {
        const buycosts__input = document.getElementById('buycosts__amount');
        const buycosts__miscellaneous = document.getElementById('buycosts__miscellaneous');
        const total__label = document.getElementById('buycosts__total');

        // Calc costs
        const buycosts = +FormatMoneyToSql(buycosts__input.value) ? +FormatMoneyToSql(buycosts__input.value) : 0;
        const miscellaneous = +FormatMoneyToSql(buycosts__miscellaneous.value) ? +FormatMoneyToSql(buycosts__miscellaneous.value) : 0;

        // Update total costs
        const total__amount = (buycosts + miscellaneous);
        return total__amount > 0 ? total__amount : 0;
    }
    function updateBuyCostsTotal() {
        const total__label = document.getElementById('buycosts__total');
        const total__amount = getBuyCostsTotal();
        total__label.innerHTML = FormatMoney(total__amount);
        updateProfit();
    }
    function JsonBuyCosts() {

        // Transaction
        const buycosts__percentage = document.getElementById('buycosts__percentage');
        const buycosts__amount = document.getElementById('buycosts__amount');

        // Miscellaneous
        const miscellaneous = document.getElementById('buycosts__miscellaneous');

        const array = {

            transaction: { 
                percentage: percentToNumber(buycosts__percentage.value) > 0 ? percentToNumber(buycosts__percentage.value) : 0, 
                amount: +FormatMoneyToSql(buycosts__amount.value) > 0 ? +FormatMoneyToSql(buycosts__amount.value) : 0
            },
            miscellaneous: +FormatMoneyToSql(miscellaneous.value) > 0 ? +FormatMoneyToSql(miscellaneous.value) : 0,
            costs: getBuyCostsTotal(),

        };

        return JSON.stringify(array);
    }

    updateBuyCostsTotal();

    // Sell costs
    function sellCostsUpdate(inputType) {
        const price_arv = getPriceArv() > 0 ? getPriceArv() : 0;
        const percentage__input = document.getElementById('sellcosts__percentage');
        const amount__input = document.getElementById('sellcosts__amount');

        // Calc costs
        const percentage = percentToNumber(percentage__input.value) > 0 ? percentToNumber(percentage__input.value) : 0;
        const amount = +FormatMoneyToSql(amount__input.value) > 0 ? +FormatMoneyToSql(amount__input.value) : 0;

        if (inputType === 'percentage') {
            amount__input.value = FormatMoney(getPercentage(percentage, price_arv));

        } else if (inputType === 'amount') {
            percentage__input.value = numberToPercent(amount, price_arv);
        }

        updateSellCostsTotal();
    }
    function realtorCostsUpdate(inputType) {
        const price_arv = getPriceArv() > 0 ? getPriceArv() : 0;
        const percentage__input = document.getElementById('sellrealtor__percentage');
        const amount__input = document.getElementById('sellrealtor__amount');

        // Calc costs
        const percentage = percentToNumber(percentage__input.value) > 0 ? percentToNumber(percentage__input.value) : 0;
        const amount = +FormatMoneyToSql(amount__input.value) > 0 ? +FormatMoneyToSql(amount__input.value) : 0;

        if (inputType === 'percentage') {
            amount__input.value = FormatMoney(getPercentage(percentage, price_arv));

        } else if (inputType === 'amount') {
            percentage__input.value = numberToPercent(amount, price_arv);
        }

        updateSellCostsTotal();
    }
    function sellMiscellaneousUpdate() {
        const miscellaneous = document.getElementById('sellcosts__miscellaneous');
        const total = +FormatMoneyToSql(miscellaneous.value) > 0 ? +FormatMoneyToSql(miscellaneous.value) : 0;
        updateSellCostsTotal();
    }
    function getSellCostsTotal() {
        const sellcosts__input = document.getElementById('sellcosts__amount');
        const sellrealtor__input = document.getElementById('sellrealtor__amount');
        const sellcosts__miscellaneous = document.getElementById('sellcosts__miscellaneous');
        const total__label = document.getElementById('sellcosts__total');

        // Calc costs
        const sellcosts = +FormatMoneyToSql(sellcosts__input.value) ? +FormatMoneyToSql(sellcosts__input.value) : 0;
        const sellrealtor = +FormatMoneyToSql(sellrealtor__input.value) ? +FormatMoneyToSql(sellrealtor__input.value) : 0;
        const miscellaneous = +FormatMoneyToSql(sellcosts__miscellaneous.value) ? +FormatMoneyToSql(sellcosts__miscellaneous.value) : 0;

        // Update total costs
        const total__amount = (sellcosts + sellrealtor + miscellaneous);
        return total__amount > 0 ? total__amount : 0;
    }
    function updateSellCostsTotal() {
        const total__label = document.getElementById('sellcosts__total');
        const total__amount = getSellCostsTotal();
        total__label.innerHTML = FormatMoney(total__amount);
        updateProfit();
    }
    function JsonSellCosts() {

        // Transaction
        const sellcosts__percentage = document.getElementById('sellcosts__percentage');
        const sellcosts__amount = document.getElementById('sellcosts__amount');

        // Realtor
        const realtor__percentage = document.getElementById('sellrealtor__percentage');
        const realtor__amount = document.getElementById('sellrealtor__amount');

        // Miscellaneous
        const miscellaneous = document.getElementById('sellcosts__miscellaneous');

        const array = {

            transaction: { 
                percentage: percentToNumber(sellcosts__percentage.value) > 0 ? percentToNumber(sellcosts__percentage.value) : 0, 
                amount: +FormatMoneyToSql(sellcosts__amount.value) > 0 ? +FormatMoneyToSql(sellcosts__amount.value) : 0
            },
            realtor: { 
                percentage: percentToNumber(realtor__percentage.value) > 0 ? percentToNumber(realtor__percentage.value) : 0, 
                amount: +FormatMoneyToSql(realtor__amount.value) > 0 ? +FormatMoneyToSql(realtor__amount.value) : 0
            },
            miscellaneous: +FormatMoneyToSql(miscellaneous.value) > 0 ? +FormatMoneyToSql(miscellaneous.value) : 0,
            costs: getSellCostsTotal(),

        };

        return JSON.stringify(array);
    }

    updateSellCostsTotal();

    // Total costs
    function getTotalCosts() {
        const total_monthly = getTotalMonthly() > 0 ? getTotalMonthly() : 0;
        const first_mortgage = getLoanCosts() > 0 ? getLoanCosts() : 0;
        const secound_mortgage = getSecoundMortgageLoanCosts() > 0 ? getSecoundMortgageLoanCosts() : 0;
        const others_mortgage = getMiscellaneosCosts() > 0 ? getMiscellaneosCosts() : 0;
        const buy_costs = getBuyCostsTotal() > 0 ? getBuyCostsTotal() : 0;
        const sell_costs = getSellCostsTotal() > 0 ? getSellCostsTotal() : 0;
        return (first_mortgage + secound_mortgage + others_mortgage + buy_costs + sell_costs + total_monthly);
    }

    // ROI Analysis
    function isNumber(value) {
        return typeof value === "number" && !Number.isNaN(value);
    }
    function getNetProfit() {
        const price_arv = getPriceArv();
        const price_buy = getPriceBuy();
        const total_costs = getTotalCosts();
        const rehab_total = getRehabTotal();
        return price_arv - total_costs - rehab_total - price_buy;
    }
    function getRoiProfit() {
        const profit = getNetProfit();
        const price_arv = getPriceArv();
        const percentage = numberToPercent(profit, price_arv);
        return percentage != 'Valores inválidos' ? +percentage : 0;
    }
    function updateProfit() {
        const input__profit = document.getElementById('statistic__profit');
        const input__roi = document.getElementById('statistic__roi');

        const profit = getNetProfit();
        const roi = getRoiProfit();

        input__roi.innerHTML = roi + '%';
        input__profit.innerHTML = FormatMoney(profit);

        if (profit < 0) {
            input__roi.style.color='#DE574D';
            input__profit.style.color='#DE574D';
        } else {
            input__roi.style.color='#000';
            input__profit.style.color='#000';
        }
    }

    const brandSave = document.getElementById('topbar__save');
    brandSave.addEventListener('click', function() {
        UpdateDraft();
    });

    // Tooltip
    const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
    const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))

</script>
</html>