<!DOCTYPE html>
<html>
<head>

	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<?php $page_name = 'Cadastrar'; ?>

	<?php require_once __DIR__ . '/../../inc/conn.php'; ?>
	<?php require_once __DIR__ . '/../../inc/variables.php'; ?>

	<?php if (isset($_SESSION['user'])) { Route(''); } ?>

	<?php require_once __DIR__ . '/../../inc/cdns.php'; ?>
	<?php require_once __DIR__ . '/../../inc/styles.php'; ?>


	<link rel="stylesheet" type="text/css" href="<?php echo $local['assets'] . '/css/register.css'; ?>">

	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@21.1.1/build/css/intlTelInput.css">
	<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@21.1.1/build/js/intlTelInput.min.js"></script>

	<script type="text/javascript" src="<?php echo $local['assets'] . '/js/authentication/register.js'; ?>"></script>

	<title><?php echo $page_name . ' | ' . $app['name']; ?></title>

</head>
<body>
	<div class="container-fluid">
		<div class="row">
			<div class="mobile_hide col-sm-12 col-md-5 col-lg-6 col-xl-7 gx-0">
				<div class="left__box">
					<div style="background: url('https://i.ibb.co/Q9SR4k8/sunrise-5111409-1280.jpg');" class="left__wallpaper"></div>
				</div>
			</div>
			<div class="col-sm-12 col-md-7 col-lg-6 col-xl-5 gx-0">
				<div class="right__box">
					<div class="right__content">
						<form method="POST" onsubmit="verify__register(event)" id="login__form">
						
						<div class="logo__box">
							<img src="<?php echo $local['assets'] . '/marca/icone_dark.svg'; ?>">
						</div>

						<h1 class="login__title">Cadastre-se!</h1>
						<p class="login__subtitle">Insira abaixo as suas informações para criar sua conta:</p>

						<div class="input__box">
							<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
							  <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 6a3.75 3.75 0 1 1-7.5 0 3.75 3.75 0 0 1 7.5 0ZM4.501 20.118a7.5 7.5 0 0 1 14.998 0A17.933 17.933 0 0 1 12 21.75c-2.676 0-5.216-.584-7.499-1.632Z"></path>
							</svg>
							<input maxlength="255" required placeholder="Digite seu nome completo" type="text" id="login__name">
						</div>

						<div class="input__box">
							<input required placeholder="Digite seu telefone" type="tel" id="login__telephone">
						</div>

						<div class="input__box">
							<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
							  <path stroke-linecap="round" stroke-linejoin="round" d="M21.75 6.75v10.5a2.25 2.25 0 0 1-2.25 2.25h-15a2.25 2.25 0 0 1-2.25-2.25V6.75m19.5 0A2.25 2.25 0 0 0 19.5 4.5h-15a2.25 2.25 0 0 0-2.25 2.25m19.5 0v.243a2.25 2.25 0 0 1-1.07 1.916l-7.5 4.615a2.25 2.25 0 0 1-2.36 0L3.32 8.91a2.25 2.25 0 0 1-1.07-1.916V6.75"></path>
							</svg>
							<input maxlength="255" required placeholder="Digite seu e-mail" type="email" id="login__email">
						</div>

						<div class="input__box">
							<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
							  <path stroke-linecap="round" stroke-linejoin="round" d="M16.5 10.5V6.75a4.5 4.5 0 1 0-9 0v3.75m-.75 11.25h10.5a2.25 2.25 0 0 0 2.25-2.25v-6.75a2.25 2.25 0 0 0-2.25-2.25H6.75a2.25 2.25 0 0 0-2.25 2.25v6.75a2.25 2.25 0 0 0 2.25 2.25Z"></path>
							</svg>
							<input required onkeyup="toggle__password(this)" placeholder="Digite sua senha" type="password" id="login__password" minlength="8" maxlength="255">
							<div onclick="showhide__password()" class="toggle__view" id="toggle__view">
								<svg id="toggle__show" data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
								  <path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 0 1 0-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178Z"></path>
								  <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z"></path>
								</svg>
								<svg style="display: none;" id="toggle__hide" data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
								  <path stroke-linecap="round" stroke-linejoin="round" d="M3.98 8.223A10.477 10.477 0 0 0 1.934 12C3.226 16.338 7.244 19.5 12 19.5c.993 0 1.953-.138 2.863-.395M6.228 6.228A10.451 10.451 0 0 1 12 4.5c4.756 0 8.773 3.162 10.065 7.498a10.522 10.522 0 0 1-4.293 5.774M6.228 6.228 3 3m3.228 3.228 3.65 3.65m7.894 7.894L21 21m-3.228-3.228-3.65-3.65m0 0a3 3 0 1 0-4.243-4.243m4.242 4.242L9.88 9.88"></path>
								</svg>
							</div>
						</div>

						<div class="input__box">
							<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
							  <path stroke-linecap="round" stroke-linejoin="round" d="M16.5 10.5V6.75a4.5 4.5 0 1 0-9 0v3.75m-.75 11.25h10.5a2.25 2.25 0 0 0 2.25-2.25v-6.75a2.25 2.25 0 0 0-2.25-2.25H6.75a2.25 2.25 0 0 0-2.25 2.25v6.75a2.25 2.25 0 0 0 2.25 2.25Z"></path>
							</svg>
							<input required onkeyup="toggle__repassword(this)" placeholder="Repita sua senha" type="password" id="login__repassword" minlength="8" maxlength="255">
							<div onclick="showhide__repassword()" class="toggle__re__view" id="toggle__view">
								<svg style="color: transparent;" id="toggle__re__show" data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
								  <path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 0 1 0-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178Z"></path>
								  <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z"></path>
								</svg>
								<svg style="display: none;" id="toggle__re__hide" data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
								  <path stroke-linecap="round" stroke-linejoin="round" d="M3.98 8.223A10.477 10.477 0 0 0 1.934 12C3.226 16.338 7.244 19.5 12 19.5c.993 0 1.953-.138 2.863-.395M6.228 6.228A10.451 10.451 0 0 1 12 4.5c4.756 0 8.773 3.162 10.065 7.498a10.522 10.522 0 0 1-4.293 5.774M6.228 6.228 3 3m3.228 3.228 3.65 3.65m7.894 7.894L21 21m-3.228-3.228-3.65-3.65m0 0a3 3 0 1 0-4.243-4.243m4.242 4.242L9.88 9.88"></path>
								</svg>
							</div>
						</div>

						<button id="login__button">
							CADASTRAR
						</button>

						<p class="login__register">Já tem uma conta? <a href="<?php echo RouteLink('entrar'); ?>">Faça Login</a></p>

						<p id="message__error"></p>

						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="copy__bar">
		<p>Feito com ❤️ por <?php echo $app['name']; ?>. Todos os direitos reservados © 2024.</p>
	</div>
</body>
<script type="text/javascript">
var phoneInput = document.querySelector("#login__telephone");
iti = window.intlTelInput(phoneInput, {
    initialCountry: "auto",
    geoIpLookup: function(success, failure) {
        success('br');
    },
    utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@21.1.1/build/js/utils.js", // Ajuste para o caminho correto
});
</script>
</html>