<!DOCTYPE html>
<html>
<head>

	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<?php 

		$page_name = 'Meu Perfil'; 
		$profilePage = true;

	?>

	<?php require_once __DIR__ . '/../../inc/conn.php'; ?>
	<?php require_once __DIR__ . '/../../inc/variables.php'; ?>

	<?php require_once __DIR__ . '/../../inc/cdns.php'; ?>
	<?php require_once __DIR__ . '/../../inc/styles.php'; ?>

	<title><?php echo $page_name . ' | ' . $app['name']; ?></title>

	<?php if (!isset($_SESSION['user'])) { Route('entrar'); } ?>

	<link rel="stylesheet" type="text/css" href="<?php echo $local['assets'] . '/css/profile.css'; ?>">

	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@21.1.1/build/css/intlTelInput.css">
	<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@21.1.1/build/js/intlTelInput.min.js"></script>


</head>
<body>

	<?php require_once __DIR__ . '/../layout/topbar.php'; ?>
	<div class="content">
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="header__content">

						<div class="header__title">
							<h1 class="title">Minha conta</h1>
							<p class="subtitle">Gerencie as configurações e o faturamento da sua conta.</p>
						</div>

						<button onclick="window.location.href = '<?php echo RouteLink('sair'); ?>'" class="action align mobile_hide">
							<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
							  <path stroke-linecap="round" stroke-linejoin="round" d="M8.25 9V5.25A2.25 2.25 0 0 1 10.5 3h6a2.25 2.25 0 0 1 2.25 2.25v13.5A2.25 2.25 0 0 1 16.5 21h-6a2.25 2.25 0 0 1-2.25-2.25V15m-3 0-3-3m0 0 3-3m-3 3H15"></path>
							</svg>
							Logout
						</button>

					</div>
				</div>
				<div class="col-12">
					<div class="divider"></div>
				</div>
				<div class="col-12 col-md-6">
					<div style="margin-bottom: 25px;" class="content__module">
						<div class="module__header">
							<h1 class="module__title">Informações básicas</h1>
						</div>
						<div class="module__body">
							<form method="POST" id="updateAccount" onsubmit="UpdateAccount(event)">
								<div class="input__box">
									<label class="input">Nome <b>*</b></label>
									<input required type="text" value="<?php echo !empty($user['name']) ? $user['name'] : ''; ?>" id="account__name">
								</div>
								<div class="input__box">
									<label class="input">Telefone <b>*</b></label>
									<input required type="tel" value="<?php echo !empty($user['telephone']) ? $user['telephone'] : ''; ?>" id="account__phone" class="telephone">
								</div>
								<div class="input__box">
									<label class="input">E-mail <b>*</b></label>
									<input required type="email" disabled value="<?php echo !empty($user['mail']) ? $user['mail'] : ''; ?>" id="account__mail">
								</div>
							</form>
						</div>
						<div class="module__actions">
							<button id="updateAccountButton" form="updateAccount">Salvar</button>
						</div>
					</div>
					<div style="margin-bottom: 25px;" class="content__module mobile_hide">
						<div class="module__header">
							<div class="box__title">
								<h1 class="module__title">Integrações</h1>
								<label class="badge">Em breve</label>
							</div>
							<div class="action">
								<button class="newApi">
									<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
									  <path stroke-linecap="round" stroke-linejoin="round" d="M13.5 16.875h3.375m0 0h3.375m-3.375 0V13.5m0 3.375v3.375M6 10.5h2.25a2.25 2.25 0 0 0 2.25-2.25V6a2.25 2.25 0 0 0-2.25-2.25H6A2.25 2.25 0 0 0 3.75 6v2.25A2.25 2.25 0 0 0 6 10.5Zm0 9.75h2.25A2.25 2.25 0 0 0 10.5 18v-2.25a2.25 2.25 0 0 0-2.25-2.25H6a2.25 2.25 0 0 0-2.25 2.25V18A2.25 2.25 0 0 0 6 20.25Zm9.75-9.75H18a2.25 2.25 0 0 0 2.25-2.25V6A2.25 2.25 0 0 0 18 3.75h-2.25A2.25 2.25 0 0 0 13.5 6v2.25a2.25 2.25 0 0 0 2.25 2.25Z"></path>
									</svg>
									Gerar API Key
								</button>
							</div>
						</div>
						<div class="module__body">
							<?php if (isset($user['api_key']) && !empty($user['api_key'])) { ?>
							<div class="api__box">
								<div class="input__api">
									<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
									  <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 5.25a3 3 0 0 1 3 3m3 0a6 6 0 0 1-7.029 5.912c-.563-.097-1.159.026-1.563.43L10.5 17.25H8.25v2.25H6v2.25H2.25v-2.818c0-.597.237-1.17.659-1.591l6.499-6.499c.404-.404.527-1 .43-1.563A6 6 0 1 1 21.75 8.25Z"></path>
									</svg>
									<input type="password" disabled value="<?php echo $user['api_key'] ?>" id="inputApiKey">
									<div onclick="CopyApiKey(this)" class="copyApiKey">
										<svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
										  <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 17.25v3.375c0 .621-.504 1.125-1.125 1.125h-9.75a1.125 1.125 0 0 1-1.125-1.125V7.875c0-.621.504-1.125 1.125-1.125H6.75a9.06 9.06 0 0 1 1.5.124m7.5 10.376h3.375c.621 0 1.125-.504 1.125-1.125V11.25c0-4.46-3.243-8.161-7.5-8.876a9.06 9.06 0 0 0-1.5-.124H9.375c-.621 0-1.125.504-1.125 1.125v3.5m7.5 10.375H9.375a1.125 1.125 0 0 1-1.125-1.125v-9.25m12 6.625v-1.875a3.375 3.375 0 0 0-3.375-3.375h-1.5a1.125 1.125 0 0 1-1.125-1.125v-1.5a3.375 3.375 0 0 0-3.375-3.375H9.75"></path>
										</svg>
									</div>
								</div>
							</div>
							<?php } else { ?>
							<p class="nothing">Nenhuma aplicação cadastrada.</p>
							<?php } ?>
						</div>
					</div>
				</div>
				<?php if (!UserStatus()) { ?>
				<div class="col-12 order-first">
					<div class="plan__expired">
						&#x1F6A8;⠀
						Sua assinatura está vencida desde <strong><?php echo date('d/m/Y', strtotime($user['next_payment'])); ?></strong>. Para continuar utilizando nossos serviços sem interrupções, por favor, renove seu plano.
					</div>
				</div>
				<?php } ?>
				<div class="col-12 col-md-6">
					<div class="content__module">
						<div class="module__header">
							<h1 class="module__title">Plano e assinatura</h1>
						</div>
						<div class="module__body">
							<div class="plan__box">
								<?php 

									$plan_id = $user['plan'];
									$planQuery = "SELECT * FROM plans WHERE id = '$plan_id'";
									$planResult = $conn->query($planQuery);
									$plan = $planResult->fetch_assoc();

								?>
								<div class="plan__content">
									<?php 

										if (!UserStatus()) {
											echo '<label class="plan__status status__expired">' . Translate(TagToText('Expired')) . '</label>';
										} else {
											echo '<label class="plan__status status__active">' . Translate(TagToText('Active')) . '</label>';
										}

									?>
									<h2 class="plan__name"><?php echo $plan['name'] != 'Teste' ? $plan['name'] . ' - ' . Translate(TagToText($plan['recurrence'])) : 'Teste Grátis'; ?></h2>
									<p class="plan__method">Valor: <strong><?php echo 'USD ' . Money($plan['price']); ?></strong></p>
									<p class="plan__method">Expira em: <strong><?php echo date('d/m/Y', strtotime($user['next_payment'])); ?></strong></p>
								</div>
								<div class="plan__actions">
									<?php if (!UserStatus() && $user['plan'] != 0) { ?>
									<button onclick="Checkout(<?php echo $user['plan']; ?>, this)" id="renewPlan">
										<svg viewBox="0 0 26 24" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M12.2498 18.9752C14.1158 18.9752 16.0208 21.9942 17.7908 20.6602C19.5608 19.3252 17.4908 16.6432 17.9098 14.7342C18.3288 12.8242 21.7178 12.0692 21.1948 9.84417C20.6728 7.62017 16.9028 9.05317 15.6918 7.80017" stroke-linecap="round" stroke-linejoin="round"/>
											<path d="M14.3782 5.16163C13.9042 4.02163 13.3422 2.99963 12.2502 2.99963C10.2142 2.99963 10.0212 6.54663 8.80918 7.79963C7.59718 9.05263 3.82818 7.61963 3.30518 9.84363C2.78218 12.0686 6.17218 12.8236 6.59018 14.7336C7.01118 16.6426 4.93918 19.3246 6.70918 20.6596C7.66218 21.3786 8.65518 20.8346 9.65918 20.1786" stroke-linecap="round" stroke-linejoin="round"/>
										</svg>
										Renovar plano
									</button><br>
									<?php } ?>
									<button onclick="Route('app/plans')" id="changePlan">
										<svg viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M9.25701 7.17664C11.567 7.06764 14.735 6.80164 15.808 6.78764C16.833 6.77464 17.943 6.64064 18.906 7.07364C22.209 8.56064 20.816 14.5356 18.533 16.3096C16.942 17.5456 14.398 17.6376 12.467 17.5876C10.675 17.5426 8.51301 17.3376 7.00501 16.2636C4.40601 14.4126 5.76401 9.36864 5.67901 5.91964C5.73001 3.98964 3.63501 3.67664 3.63501 3.67664" stroke-linecap="round" stroke-linejoin="round"/>
											<path d="M13.135 10.6766H15.908" stroke-linecap="round" stroke-linejoin="round"/>
											<path fill-rule="evenodd" clip-rule="evenodd" d="M7.39876 20.3036C7.69876 20.3036 7.94276 20.5476 7.94276 20.8476C7.94276 21.1486 7.69876 21.3926 7.39876 21.3926C7.09776 21.3926 6.85376 21.1486 6.85376 20.8476C6.85376 20.5476 7.09776 20.3036 7.39876 20.3036Z" stroke-linecap="round" stroke-linejoin="round"/>
											<path fill-rule="evenodd" clip-rule="evenodd" d="M17.7298 20.3036C18.0308 20.3036 18.2748 20.5476 18.2748 20.8476C18.2748 21.1486 18.0308 21.3926 17.7298 21.3926C17.4298 21.3926 17.1858 21.1486 17.1858 20.8476C17.1858 20.5476 17.4298 20.3036 17.7298 20.3036Z" stroke-linecap="round" stroke-linejoin="round"/>
										</svg>
										Alterar plano
									</button><br>
									<button onclick="Route('app/invoices')" id="planInvoices">
										<svg viewBox="0 0 26 24" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M14.5111 15.45H9.11108" stroke-linecap="round" stroke-linejoin="round"/>
											<path d="M12.4659 11.4386H9.10986" stroke-linecap="round" stroke-linejoin="round"/>
											<path d="M12.245 21.25C18.545 21.25 20.645 18.94 20.645 12C20.645 10.58 20.555 9.35 20.365 8.3L14.695 2.9C13.965 2.8 13.145 2.75 12.245 2.75C5.95498 2.75 3.85498 5.07 3.85498 12C3.85498 17.863 5.35398 20.422 9.61198 21.075" stroke-linecap="round" stroke-linejoin="round"/>
											<path d="M14.1389 5.49377C14.1389 7.35177 15.6449 8.85677 17.5029 8.85677H20.4539" stroke-linecap="round" stroke-linejoin="round"/>
										</svg>
										Faturas
									</button>
								</div>
							</div>
						</div>
						<div class="module__actions">
							<!-- <button form="changePassForm" id="changePasswordButton">Change Plan</button> -->
						</div>
					</div>
					<div style="margin-top: 25px;" class="content__module">
						<div class="module__header">
							<h1 class="module__title">Altere sua senha</h1>
						</div>
						<div class="module__body">
							<form method="POST" id="changePassForm" onsubmit="ChangePassword(event)">
								<div class="input__box">
									<label class="input">Nova senha:</label>
									<input required type="password" minlength="6" placeholder="Deve ter pelo menos 6 caracteres" id="change__password">
								</div>
								<div class="input__box">
									<label class="input">Confirme a senha:</label>
									<input required type="password" minlength="6" placeholder="Deve ter pelo menos 6 caracteres" id="change__repass">
								</div>
							</form>
						</div>
						<div class="module__actions">
							<button form="changePassForm" id="changePasswordButton">Alterar</button>
						</div>
					</div>
					<div style="margin-top: 25px;" class="content__module">
						<div class="module__header">
							<h1 class="module__title">Delete sua conta</h1>
						</div>
						<div class="module__body">
							<p class="subtitle">Excluir sua conta excluirá permanentemente todas os seus projetos salvos, dados históricos e configurações. Esta operação é final e não pode ser desfeita.</p>

							<form method="POST" id="deleteForm" onsubmit="DeleteAccount(event)">
								<div class="confirmDelete">
									<input required type="checkbox" id="confirmDelete">
									<label for="confirmDelete">Confirmo que quero excluir minha conta.</label>
								</div>
								<textarea class="feedbackDelete" placeholder="Há algo que possamos fazer melhor?"></textarea>
							</form>

						</div>
						<div class="module__actions">
							<button form="deleteForm" id="deleteButton" class="deleteButton">Excluir conta</button>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

</body>
<script type="text/javascript">

    var phoneInput = document.querySelector("#account__phone");
    iti = window.intlTelInput(phoneInput, {
        // Suas opções aqui
        initialCountry: "auto",
        geoIpLookup: function(success, failure) {
            success('br');
        },
        utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@21.1.1/build/js/utils.js", // Ajuste para o caminho correto
    });

	function Checkout(plan_id, button) {

	    const oldContent = button.innerHTML;
	    button.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i>';

	    $.ajax({
	        type: "POST",
	        url: base_url + "/api/payments/subscription.php",
	        data: {
	            plan: plan_id,
	        },
	        success: function(response) {

	            if (response.status === 'success') {

	                window.location.href = response.checkout;
	                console.log(response);

	            } else { console.log(response); button.innerHTML = oldContent; }

	        },
	        error: function(xhr, status, error) {
	        console.error("Erro:", error);
	        }
	    });
	    
	}

	function UpdateAccount(event) {
		event.preventDefault();

		const the__button = document.getElementById('updateAccountButton');
		const button__old__value = the__button.innerHTML;
		the__button.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i>';

		// Pegar as vars e enviar o ajax.
		const account__name = document.getElementById('account__name');
		const account__phone = document.getElementById('account__phone');
		const phoneNumber = '+' + iti.s.dialCode + account__phone.value.replace(/[\(\)\s\-]/g, '');

	    $.ajax({
			type: "POST",
			url: base_url + "/api/users/update.php",
			data: {
				id: <?php echo $user['id'] ?>,
				telephone: phoneNumber,
				name: account__name.value
			},
			success: function(response) {

				// Sucesso no login
				if (response.status === 'success') {
					console.log(response);

					Swal.fire({
						icon: "success",
						title: "Sucesso!",
						timer: 2000,
						timerProgressBar: true,
						didOpen: () => { Swal.showLoading(); },
						willClose: () => {}
					}).then((result) => {});

					the__button.innerHTML = button__old__value;

				} else { // Erro no Login
					console.log(response);
					the__button.innerHTML = button__old__value;
				}

			},
			error: function(xhr, status, error) {
			console.error("Erro:", error);
			}
	    });
	}


	function CopyApiKey(buttonCopy) {
	    const originalContent = buttonCopy.innerHTML;
	    const input__api = document.getElementById('inputApiKey');
	    const api_key = input__api.value;

	    // Copia para a área de transferência o api_key
	    navigator.clipboard.writeText(api_key).then(() => {

			const Toast = Swal.mixin({
				toast: true,
				position: "bottom-end",
				showConfirmButton: false,
				timer: 2000,
				timerProgressBar: true,
				didOpen: (toast) => {
					toast.onmouseenter = Swal.stopTimer;
					toast.onmouseleave = Swal.resumeTimer;
				}
			});
			Toast.fire({
				icon: "success",
				title: "Chave API copiada!"
			});

	        buttonCopy.innerHTML = '<svg style="color: #007bff !important;" data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true"><path stroke-linecap="round" stroke-linejoin="round" d="m4.5 12.75 6 6 9-13.5"></path></svg>';
	        setTimeout(() => { buttonCopy.innerHTML = originalContent; }, 1000);
	    }).catch(err => { console.error('Erro ao copiar a chave da API:', err);
	    });
	}

	function ChangePassword(event) {
		event.preventDefault();

		const the__button = document.getElementById('changePasswordButton');
		const button__old__value = the__button.innerHTML;
		the__button.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i>';

		// Pegar as vars e enviar o ajax.
		const change__password = document.getElementById('change__password');
		const change__repass = document.getElementById('change__repass');

		if (change__password.value === change__repass.value) {

		    $.ajax({
				type: "POST",
				url: base_url + "/api/authentication/update-password-user.php",
				data: {
					id: <?php echo $user['id'] ?>,
					password: change__password.value
				},
				success: function(response) {

					// Sucesso no login
					if (response.status === 'success') {
						console.log(response);

						Swal.fire({
							icon: "success",
							title: "Sucesso!",
							timer: 2000,
							timerProgressBar: true,
							didOpen: () => { Swal.showLoading(); },
							willClose: () => { window.location.href = '<?php echo RouteLink('sair'); ?>'; }
						}).then((result) => {});

						the__button.innerHTML = button__old__value;

					} else { // Erro no Login
						console.log(response);
						the__button.innerHTML = button__old__value;
					}

				},
				error: function(xhr, status, error) {
				console.error("Erro:", error);
				}
		    });

		} else {
			change__repass.style.borderColor = '#ff0000';
			change__repass.value = '';
		}
	}

	function DeleteAccount(event) {
		event.preventDefault();

		const the__button = document.getElementById('changePasswordButton');
		const button__old__value = the__button.innerHTML;
		the__button.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i>';

		Swal.fire({
			icon: 'warning',
			title: "Você tem certeza?",
			showCancelButton: true,
			confirmButtonColor: '#ea295e',
			confirmButtonText: "Excluir conta",
			cancelButtonText: "Cancelar",
			focusCancel: true,
		}).then((result) => {
			if (result.isConfirmed) {
			    $.ajax({
					type: "POST",
					url: base_url + "/api/users/delete.php",
					data: { id: <?php echo $user['id'] ?> },
					success: function(response) {

						// Sucesso no login
						if (response.status === 'success') {
							console.log(response);

							Swal.fire({
								icon: "success",
								title: "Sucesso!",
								timer: 2000,
								timerProgressBar: true,
								didOpen: () => { Swal.showLoading(); },
								willClose: () => { window.location.href = '<?php echo RouteLink('sair'); ?>'; }
							}).then((result) => {});

							the__button.innerHTML = button__old__value;

						} else { // Erro no Login
							console.log(response);
							the__button.innerHTML = button__old__value;
						}

					},
					error: function(xhr, status, error) {
					console.error("Erro:", error);
					}
			    });
			}
		});
	}

</script>
</html>