<?php 

require_once __DIR__ . '/../conn.php';
require_once __DIR__ . '/dictionary.php';

header('Content-Type: application/json; charset=utf-8');

function TagToText($text) {
    $removeSymbols = str_replace(['-', '_'], ' ', $text);
    return ucwords($removeSymbols);
}

function Translate($text) {
    global $dictionary;
    // Retorna null se a tradução existir, caso contrário, retorna o texto original
    return array_key_exists($text, $dictionary) ? null : $text;
}

$consulta = "SELECT tags FROM properties WHERE tags IS NOT NULL";

$tags = [];
$con = $conn->query($consulta) or die($conn->error);
while($dado = $con->fetch_array()) {
    $tags_data = json_decode($dado['tags'], true);
    foreach ($tags_data as $tag) {
        $tags[$tag] = true; // Usa chave para evitar duplicatas
    }
}

$missing = 0;
$missingTranslate = [];

foreach (array_keys($tags) as $tag) {
    $translatedTag = Translate(TagToText($tag));
    if ($translatedTag !== null) { // Só incrementa se não for null
        $missing += 1;
        $missingTranslate[] = $translatedTag;
    }
}


$translated = count($tags) - $missing;

$response = array(
    'missing' => $missing,
    'translated' => $translated,
    'missing_tags' => $missingTranslate,
);

echo json_encode($response, JSON_PRETTY_PRINT);

?>