<?php 

if (session_status() == PHP_SESSION_NONE) { session_start(); }
require_once __DIR__ . '/../../inc/conn.php';

// Verifica se algum dos parâmetros identificadores foi enviado
if (!isset($_POST['id']) && !isset($_POST['mail']) && !isset($_POST['telephone'])) {
    $response = array(
        'code' => 400,
        'status' => 'error',
        'message' => 'User identifier not provided. Please provide either an id, mail, or telephone.',
    );
} else {
    if ($conn->connect_error) {
        $response = array(
            'code' => 500,
            'status' => 'error',
            'message' => 'Connection error',
            'description' => $conn->connect_error,
        );
    } else {
        // Determina o tipo de identificador e prepara a consulta SQL correspondente
        if (isset($_POST['id'])) {
            $identifier = $_POST['id'];
            $sql = "SELECT * FROM users WHERE id = ?";
        } elseif (isset($_POST['mail'])) {
            $identifier = $_POST['mail'];
            $sql = "SELECT * FROM users WHERE mail = ?";
        } else { // $_POST['telephone']
            $identifier = $_POST['telephone'];
            $sql = "SELECT * FROM users WHERE telephone = ?";
        }

        // Prepara e executa a consulta
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $identifier);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $user = $result->fetch_assoc();
            // Remove a chave 'password' do array antes de enviar a resposta
            unset($user['password']);
            
            $response = array(
                'code' => 200,
                'status' => 'success',
                'data' => $user,
            );
        } else {
            $response = array(
                'code' => 404,
                'status' => 'error',
                'message' => 'User not found',
            );
        }
    }
}

header('Content-Type: application/json');
echo json_encode($response);

?>
