<?php

if (session_status() == PHP_SESSION_NONE) { session_start(); }
require_once __DIR__ . '/../../inc/conn.php';

// Verifica se o método é POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Query para buscar informações de endereço, cidade e código postal
    $sql = "SELECT latitude, longitude, api_id FROM properties";
    $result = $conn->query($sql);

    // Construir a resposta para o AJAX
    $response = array();

    if ($result->num_rows > 0) {
        $rows = $result->fetch_all(MYSQLI_ASSOC); // Obter todas as linhas como array associativo
        $response = array(
            'status' => 'success',
            'rows' => $rows,
        );
    }

} else {
    $response = array(
        'code' => 400 ,
        'status' => 'error',
        'message' => 'invalid request method',
        'description' => 'The endpoint request method is invalid, check the documentation.',
    );
}

header('Content-Type: application/json');
echo json_encode($response);

?>
