<?php

if (session_status() == PHP_SESSION_NONE) { session_start(); }
require_once __DIR__ . '/../../inc/conn.php';
require_once __DIR__ . '/../../inc/translate/dictionary.php';

function TagToText($text) {
    $removeSymbols = str_replace(['-', '_'], ' ', $text);
    return ucwords($removeSymbols);
}

function Translate($text) {
    global $dictionary;

    if (array_key_exists($text, $dictionary)) {
        return $dictionary[$text];
    }

    foreach ($dictionary as $key => $value) {
        if (strpos($key, ":") !== false) {
            $pattern_isolated = '/(^|\n|\r|^)\s*' . preg_quote($key, '/') . '(?=:)/';
            $text = preg_replace($pattern_isolated, '$1' . $value, $text);
        }
    }
    
    return $text;
}

function IssetNotEmpty($value, $typeReturn = 'null') {
    if (isset($value) && !empty($value)) {
        return $value;
    } else {
        if ($typeReturn == 'null') {
            return NULL;
        } elseif ($typeReturn == 'number') {
            return 0;
        } elseif ($typeReturn == 'date') {
            return date('Y-m-d H:i:s', timestamp());
        }
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Pega as variáveis de busca e filtro
    $state_code = !empty($_POST['state_code']) ? $_POST['state_code'] : NULL;
    $address = !empty($_POST['address']) ? $_POST['address'] : NULL;
    $zipcode = !empty($_POST['zipcode']) ? $_POST['zipcode'] : NULL;
    $city = !empty($_POST['city']) ? $_POST['city'] : NULL;
    $property_type = !empty($_POST['property_type']) ? $_POST['property_type'] : NULL;
    $business_type = !empty($_POST['business_type']) ? $_POST['business_type'] : NULL;
    $bedrooms = !empty($_POST['bedrooms']) ? $_POST['bedrooms'] : 0;
    $bathrooms = !empty($_POST['bathrooms']) ? $_POST['bathrooms'] : 0;

    // Verifica se há dados suficientes no banco de dados
    $query = "SELECT COUNT(*) as count FROM properties WHERE 1=1";
    $params = [];
    $types = '';

    if ($state_code !== NULL) {
        $query .= " AND state = ?";
        $params[] = $state_code;
        $types .= 's';
    }

    if ($city !== NULL) {
        $query .= " AND city = ?";
        $params[] = $city;
        $types .= 's';
    }

    if ($property_type !== NULL) {
        $query .= " AND property_type = ?";
        $params[] = $property_type;
        $types .= 's';
    }

    if ($business_type !== NULL) {
        $query .= " AND business_type = ?";
        $params[] = $business_type;
        $types .= 's';
    }

    if ($bedrooms > 0) {
        $query .= " AND bedrooms >= ?";
        $params[] = $bedrooms;
        $types .= 'i';
    }

    if ($bathrooms > 0) {
        $query .= " AND bathrooms >= ?";
        $params[] = $bathrooms;
        $types .= 'i';
    }

    // Prepara a consulta
    $stmt = mysqli_prepare($conn, $query);

    // Vincula os parâmetros dinamicamente
    mysqli_stmt_bind_param($stmt, $types, ...$params);
    mysqli_stmt_execute($stmt);

    // Obtém o resultado
    $result = mysqli_stmt_get_result($stmt);
    $row = mysqli_fetch_assoc($result);
    $count = $row['count'];

    if ($count >= 50) {

        $querySelectDb = "SELECT * FROM properties WHERE 1=1";

        $params = [];
        $types = '';

        if ($state_code !== NULL) {
            $querySelectDb .= " AND state = ?";
            $params[] = $state_code;
            $types .= 's';
        }

        if ($city !== NULL) {
            $querySelectDb .= " AND city = ?";
            $params[] = $city;
            $types .= 's';
        }

        if ($property_type !== NULL) {
            $querySelectDb .= " AND property_type = ?";
            $params[] = $property_type;
            $types .= 's';
        }

        if ($business_type !== NULL) {
            $querySelectDb .= " AND business_type = ?";
            $params[] = $business_type;
            $types .= 's';
        }

        if ($bedrooms > 0) {
            $querySelectDb .= " AND bedrooms >= ?";
            $params[] = $bedrooms;
            $types .= 'i';
        }

        if ($bathrooms > 0) {
            $querySelectDb .= " AND bathrooms >= ?";
            $params[] = $bathrooms;
            $types .= 'i';
        }

        $stmt = mysqli_prepare($conn, $querySelectDb);

        mysqli_stmt_bind_param($stmt, $types, ...$params);
        mysqli_stmt_execute($stmt);

        $result = mysqli_stmt_get_result($stmt);

        $db_data = [];
        while ($row = mysqli_fetch_assoc($result)) {
            $row['square_footage'] = !empty($row['square_footage']) ? $row['square_footage'] . ' sqft' : '-';
            $row['property_type'] = Translate(TagToText($row['property_type']));
            $db_data[] = $row; }
        
        $response = [
            'code' => 200,
            'status' => 'success',
            'message' => 'Data fetched from database',
            'in_db' => $count,
            'rows' => $db_data
        ];

    } else {
    
        // Verifica o tipo de transação para enviar o cURL
        if ($business_type == 'rent' AND $property_type != 'land') {

            $curl = curl_init();
            $baseUrl = "https://us-real-estate.p.rapidapi.com/v2/for-rent";

            $params = [
                'city' => $city,
                'state_code' => $state_code,
                'location' => $address,
                'beds_min' => $bedrooms,
                'baths_min' => $bathrooms,
                'property_type' => $property_type,
                'sort' => 'newest',
                'expand_search_radius' => '10',
                'limit' => '200',
                'offset' => '0',
                'price_min' => 1,
                'home_size_min' => 1,
            ];

            $encodedParams = http_build_query($params);
            $fullUrl = $baseUrl . '?' . $encodedParams;

            curl_setopt_array($curl, [
                CURLOPT_URL => $fullUrl,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => [
                    "X-RapidAPI-Host: us-real-estate.p.rapidapi.com",
                    "X-RapidAPI-Key: 0e81c64f85msh344a62f86282268p15eb81jsn7faa9194b5c8"
                ],
            ]);

            $api_data = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);


            if ($err) {
                $response = [
                    'code' => 601,
                    'status' => 'error',
                    'message' => 'API Rent request error',
                    'data' => $err
                ];
            } else {

                $api_data = json_decode($api_data, true);
                $api_data = $api_data['data']['home_search']['results'];

                if (count($api_data) == 0) {
                    $response = [
                        'code' => 100,
                        'status' => 'nothing',
                        'api_row' => $api_data
                    ];
                } else {

                    // Atualiza as propriedades no db
                    $query = "INSERT INTO properties (mls_id,api_id,business_type,address,zipcode,county,state,city,latitude,longitude,property_type,bedrooms,bathrooms,lot_size,square_footage,year_built,primary_photo,price,listed_date,last_seen_date,tags,status) VALUES ";

                    $values = [];
                    $idToSearch = [];
                    foreach ($api_data as $row) {

                        $idToSearch[] = $row['property_id'];

                        $mls_id = $row['listing_id'];
                        $api_id = $row['property_id'];
                        $business_type = 'rent';
                        $address = IssetNotEmpty($row['location']['address']['line']);
                        $zipcode = $row['location']['address']['postal_code'];
                        $country = $row['location']['county']['name'];
                        $state = $row['location']['county']['state_code'];
                        $city = $row['location']['address']['city'];
                        $latitude = $row['location']['address']['coordinate']['lat'];
                        $longitude = $row['location']['address']['coordinate']['lon'];
                        $property_type = $row['description']['type'];
                        $bedrooms = $row['description']['beds'] ?? $row['description']['beds_max'] ?? $row['description']['beds_min'] ?? 0;
                        $bathrooms = $row['description']['baths'] ?? $row['description']['baths_max'] ?? $row['description']['baths_min'] ?? 0;
                        $lot_size = $row['description']['lot_sqft'];
                        $square_footage = $row['description']['sqft'] ?? $row['description']['sqft_max'] ?? $row['description']['sqft_min'] ?? null;
                        $year_built = $row['description']['year_built'];
                        $primary_photo = isset($row['primary_photo']) ? $row['primary_photo']['href'] : null;
                        $tags = isset($row['tags']) ? json_encode($row['tags'], true) : null;
                        $listed_date = isset($row['list_date']) ? date('Y-m-d H:i:s', strtotime($row['list_date'])) : date('Y-m-d H:i:s');
                        $price = $row['list_price'] ?? $row['list_price_max'] ?? $row['list_price_min'] ?? 0;
                        $last_seen_date = date('Y-m-d H:i:s', strtotime($row['last_update_date']));
                        $status = $row['status'];

                        $values[] = "('$mls_id', '$api_id', '$business_type', '$address', '$zipcode', '$country', '$state', '$city', '$latitude', '$longitude', '$property_type', '$bedrooms', '$bathrooms', '$lot_size', '$square_footage', '$year_built', '$primary_photo', '$price', '$listed_date', '$last_seen_date', '$tags', '$status')";
                    }

                    // Adiciona os valores na query
                    $query .= implode(', ', $values);
                    $query .= " ON DUPLICATE KEY UPDATE 
                                address = VALUES(address), 
                                zipcode = VALUES(zipcode), 
                                county = VALUES(county), 
                                state = VALUES(state), 
                                city = VALUES(city), 
                                latitude = VALUES(latitude), 
                                longitude = VALUES(longitude), 
                                property_type = VALUES(property_type), 
                                bedrooms = VALUES(bedrooms), 
                                bathrooms = VALUES(bathrooms), 
                                lot_size = VALUES(lot_size), 
                                square_footage = VALUES(square_footage), 
                                year_built = VALUES(year_built), 
                                primary_photo = VALUES(primary_photo), 
                                price = VALUES(price), 
                                listed_date = VALUES(listed_date), 
                                last_seen_date = VALUES(last_seen_date), 
                                tags = VALUES(tags), 
                                status = VALUES(status)";

                    mysqli_query($conn, $query);

                    $idList = "'" . implode("','", $idToSearch) . "'";
                    $query = "SELECT * FROM properties WHERE api_id IN ($idList) AND address IS NOT NULL";
                    $result = mysqli_query($conn, $query);

                    $db_data = [];
                    while ($row = mysqli_fetch_assoc($result)) {
                        $row['square_footage'] = !empty($row['square_footage']) ? $row['square_footage'] . ' sqft' : '-';
                        $row['property_type'] = Translate(TagToText($row['property_type']));
                        $db_data[] = $row; }

                    $response = [
                        'code' => 200,
                        'status' => 'success',
                        'message' => 'Successfully data request',
                        'rows' => $db_data,
                        'in_db' => $count,
                        'type' => $property_type,
                        // 'api_row' => $api_data
                    ];

                }

            }

        // Pesquisa propriedades à venda
        } elseif ($business_type == 'rent' AND $property_type == 'land') {

            $response = array(
                'status' => 'nothing',
            );

        } elseif ($business_type == 'sale') {

            $curl = curl_init();
            $baseUrl = "https://us-real-estate.p.rapidapi.com/v3/for-sale";

            $params = [
                'state_code' => $state_code,
                'city' => $city,
                'sort' => 'newest',
                'offset' => '0',
                'limit' => '200',
                'location' => $address,
                'beds_min' => $bedrooms,
                'baths_min' => $bathrooms,
                'property_type' => $property_type,
                'expand_search_radius' => '10',
                'price_min' => 1,
                'home_size_min' => 1,
            ];

            $encodedParams = http_build_query($params);
            $fullUrl = $baseUrl . '?' . $encodedParams;

            curl_setopt_array($curl, [
                CURLOPT_URL => $fullUrl,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => [
                    "X-RapidAPI-Host: us-real-estate.p.rapidapi.com",
                    "X-RapidAPI-Key: 0e81c64f85msh344a62f86282268p15eb81jsn7faa9194b5c8"
                ],
            ]);

            $api_data = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);


            if ($err) {
                $response = [
                    'code' => 601,
                    'status' => 'error',
                    'message' => 'API Sale request error',
                    'data' => $err
                ];
            } else {

                $api_data = json_decode($api_data, true);

                if (isset($api_data['data']['home_search']['results'])) {

                    // Pega os resultados da API
                    $api_data = $api_data['data']['home_search']['results'];

                    if (count($api_data) == 0) {
                        $response = [
                            'code' => 100,
                            'status' => 'nothing',
                            'api_row' => $api_data
                        ];

                    } else {

                        // Atualiza as propriedades no db
                        $query = "INSERT INTO properties (mls_id,api_id,business_type,address,zipcode,county,state,city,latitude,longitude,property_type,bedrooms,bathrooms,lot_size,square_footage,year_built,primary_photo,price,listed_date,last_seen_date,tags,status) VALUES ";

                        $values = [];
                        $idToSearch = [];
                        foreach ($api_data as $row) {

                            $idToSearch[] = $row['property_id'];

                            $mls_id = $row['listing_id'];
                            $api_id = $row['property_id'];
                            $business_type = 'sale';
                            $address = IssetNotEmpty($row['location']['address']['line']);
                            $zipcode = $row['location']['address']['postal_code'];
                            $country = $row['location']['address']['state'];
                            $state = $row['location']['address']['state_code'];
                            $city = $row['location']['address']['city'];
                            $latitude = $row['location']['address']['coordinate']['lat'];
                            $longitude = $row['location']['address']['coordinate']['lon'];
                            $property_type = $row['description']['type'];
                            $bedrooms = $row['description']['beds'] ?? $row['description']['beds_max'] ?? $row['description']['beds_min'] ?? 0;
                            $bathrooms = $row['description']['baths'] ?? $row['description']['baths_max'] ?? $row['description']['baths_min'] ?? 0;
                            $lot_size = $row['description']['lot_sqft'];
                            $square_footage = $row['description']['sqft'] ?? $row['description']['sqft_max'] ?? $row['description']['sqft_min'] ?? null;
                            $year_built = $row['description']['year_built'];
                            $primary_photo = isset($row['primary_photo']) ? $row['primary_photo']['href'] : null;
                            $tags = isset($row['tags']) ? json_encode($row['tags']) : null;
                            $price = $row['list_price'] ?? $row['list_price_max'] ?? $row['list_price_min'] ?? 0;
                            $listed_date = date('Y-m-d H:i:s', strtotime($row['list_date']));
                            $last_seen_date = date('Y-m-d H:i:s', strtotime($row['last_update_date']));
                            $status = $row['status'];

                            $values[] = "('$mls_id', '$api_id', '$business_type', '$address', '$zipcode', '$country', '$state', '$city', '$latitude', '$longitude', '$property_type', '$bedrooms', '$bathrooms', '$lot_size', '$square_footage', '$year_built', '$primary_photo', '$price', '$listed_date', '$last_seen_date', '$tags', '$status')";
                        }

                        // Adiciona os valores na query
                        $query .= implode(', ', $values);
                        $query .= " ON DUPLICATE KEY UPDATE 
                                    address = VALUES(address), 
                                    zipcode = VALUES(zipcode), 
                                    county = VALUES(county), 
                                    state = VALUES(state), 
                                    city = VALUES(city), 
                                    latitude = VALUES(latitude), 
                                    longitude = VALUES(longitude), 
                                    property_type = VALUES(property_type), 
                                    bedrooms = VALUES(bedrooms), 
                                    bathrooms = VALUES(bathrooms), 
                                    lot_size = VALUES(lot_size), 
                                    square_footage = VALUES(square_footage), 
                                    year_built = VALUES(year_built), 
                                    primary_photo = VALUES(primary_photo), 
                                    price = VALUES(price), 
                                    listed_date = VALUES(listed_date), 
                                    last_seen_date = VALUES(last_seen_date), 
                                    tags = VALUES(tags), 
                                    status = VALUES(status)";

                        mysqli_query($conn, $query);

                        $idList = "'" . implode("','", $idToSearch) . "'";
                        $query = "SELECT * FROM properties WHERE api_id IN ($idList) AND address IS NOT NULL";
                        $result = mysqli_query($conn, $query);

                        $db_data = [];
                        while ($row = mysqli_fetch_assoc($result)) {
                            $row['square_footage'] = !empty($row['square_footage']) ? $row['square_footage'] . ' sqft' : '-';
                            $row['property_type'] = Translate(TagToText($row['property_type']));
                            $db_data[] = $row; }

                        $response = [
                            'code' => 200,
                            'status' => 'success',
                            'message' => 'Successfully data request',
                            'rows' => $db_data,
                            'in_db' => $count
                        ];

                    }

                } else {

                    $response = [
                        'code' => 602,
                        'status' => 'error',
                        'message' => 'Api data error',
                        'response' => json_encode($api_data)
                    ];

                }

            }

        } elseif ($business_type == 'sold') {

            $curl = curl_init();
            $baseUrl = "https://us-real-estate.p.rapidapi.com/sold-homes";

            $params = [
                'state_code' => $state_code,
                'city' => $city,
                'sort' => 'sold_date',
                'offset' => '0',
                'limit' => '200',
                'location' => $address,
                'beds_min' => $bedrooms,
                'baths_min' => $bathrooms,
                'property_type' => $property_type,
                'expand_search_radius' => '10',
                'price_min' => 1,
                'home_size_min' => 1,
            ];

            $encodedParams = http_build_query($params);
            $fullUrl = $baseUrl . '?' . $encodedParams;

            curl_setopt_array($curl, [
                CURLOPT_URL => $fullUrl,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => [
                    "X-RapidAPI-Host: us-real-estate.p.rapidapi.com",
                    "X-RapidAPI-Key: 0e81c64f85msh344a62f86282268p15eb81jsn7faa9194b5c8"
                ],
            ]);

            $api_data = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);


            if ($err) {
                $response = [
                    'code' => 601,
                    'status' => 'error',
                    'message' => 'API Sale request error',
                    'data' => $err
                ];
            } else {

                $api_data = json_decode($api_data, true);

                if (isset($api_data['data']['results'])) {

                    // Pega os resultados da API
                    $api_data = $api_data['data']['results'];

                    if (count($api_data) == 0) {
                        $response = [
                            'code' => 100,
                            'status' => 'nothing',
                            'api_row' => $api_data
                        ];

                    } else {

                        // Atualiza as propriedades no db
                        $query = "INSERT INTO properties (mls_id,api_id,business_type,address,zipcode,county,state,city,latitude,longitude,property_type,bedrooms,bathrooms,lot_size,square_footage,year_built,primary_photo,price,listed_date,last_seen_date,tags,status) VALUES ";

                        $values = [];
                        $idToSearch = [];
                        foreach ($api_data as $row) {

                            $idToSearch[] = $row['property_id'];

                            $mls_id = $row['listing_id'];
                            $api_id = $row['property_id'];
                            $business_type = 'sold';
                            $address = IssetNotEmpty($row['location']['address']['line']);
                            $zipcode = $row['location']['address']['postal_code'];
                            $country = $row['location']['address']['state'];
                            $state = $row['location']['address']['state_code'];
                            $city = $row['location']['address']['city'];
                            $latitude = $row['location']['address']['coordinate']['lat'];
                            $longitude = $row['location']['address']['coordinate']['lon'];
                            $property_type = $row['description']['type'];
                            $bedrooms = $row['description']['beds'] ?? $row['description']['beds_max'] ?? $row['description']['beds_min'] ?? 0;
                            $bathrooms = $row['description']['baths'] ?? $row['description']['baths_max'] ?? $row['description']['baths_min'] ?? 0;
                            $lot_size = $row['description']['lot_sqft'];
                            $square_footage = $row['description']['sqft'] ?? $row['description']['sqft_max'] ?? $row['description']['sqft_min'] ?? null;
                            $year_built = $row['description']['year_built'];
                            $primary_photo = isset($row['primary_photo']) ? $row['primary_photo']['href'] : null;
                            $tags = isset($row['tags']) ? json_encode($row['tags']) : null;
                            $price = $row['list_price'] ?? $row['list_price_max'] ?? $row['list_price_min'] ?? 0;
                            $listed_date = date('Y-m-d H:i:s', strtotime($row['list_date']));
                            $last_seen_date = date('Y-m-d H:i:s', strtotime($row['last_update_date']));
                            $status = $row['status'];

                            $values[] = "('$mls_id', '$api_id', '$business_type', '$address', '$zipcode', '$country', '$state', '$city', '$latitude', '$longitude', '$property_type', '$bedrooms', '$bathrooms', '$lot_size', '$square_footage', '$year_built', '$primary_photo', '$price', '$listed_date', '$last_seen_date', '$tags', '$status')";
                        }

                        // Adiciona os valores na query
                        $query .= implode(', ', $values);
                        $query .= " ON DUPLICATE KEY UPDATE 
                                    address = VALUES(address), 
                                    zipcode = VALUES(zipcode), 
                                    county = VALUES(county), 
                                    state = VALUES(state), 
                                    city = VALUES(city), 
                                    latitude = VALUES(latitude), 
                                    longitude = VALUES(longitude), 
                                    property_type = VALUES(property_type), 
                                    bedrooms = VALUES(bedrooms), 
                                    bathrooms = VALUES(bathrooms), 
                                    lot_size = VALUES(lot_size), 
                                    square_footage = VALUES(square_footage), 
                                    year_built = VALUES(year_built), 
                                    primary_photo = VALUES(primary_photo), 
                                    price = VALUES(price), 
                                    listed_date = VALUES(listed_date), 
                                    last_seen_date = VALUES(last_seen_date), 
                                    tags = VALUES(tags), 
                                    status = VALUES(status)";

                        mysqli_query($conn, $query);

                        $idList = "'" . implode("','", $idToSearch) . "'";
                        $query = "SELECT * FROM properties WHERE api_id IN ($idList) AND address IS NOT NULL";
                        $result = mysqli_query($conn, $query);

                        $db_data = [];
                        while ($row = mysqli_fetch_assoc($result)) {
                            $row['square_footage'] = !empty($row['square_footage']) ? $row['square_footage'] . ' sqft' : '-';
                            $row['property_type'] = Translate(TagToText($row['property_type']));
                            $db_data[] = $row; }

                        $response = [
                            'code' => 200,
                            'status' => 'success',
                            'message' => 'Successfully data request',
                            'rows' => $db_data,
                            'in_db' => $count
                        ];

                    }

                } else {

                    $response = [
                        'code' => 602,
                        'status' => 'error',
                        'message' => 'Api data error',
                        'response' => json_encode($api_data)
                    ];

                }

            }

        // Não definiu o tipo da propriedade
        } else {
            $response = array(
                'code' => 501,
                'status' => 'error',
                'message' => 'Fill in all required fields and resend the request.',
            );
        }

    }

} else {

    $response = array(
        'code' => 400,
        'status' => 'error',
        'message' => 'invalid request method',
        'description' => 'The endpoint request method is invalid, check the documentation.',
    );

}

// $response['business_type'] = $business_type;
header('Content-Type: application/json');
echo json_encode($response);

?>