<?php

if (session_status() == PHP_SESSION_NONE) { session_start(); }
require_once __DIR__ . '/../../inc/conn.php';

// Verifica se o método é POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $propId = $_POST['id'];

    // Verifica se as informações estão completas
    $queryGet = "SELECT * FROM properties WHERE id = '$propId'";
    $mysqliGet = mysqli_query($conn, $queryGet);
    while ($prop_data = mysqli_fetch_assoc($mysqliGet)) {
        $prop = $prop_data;

        // Atualiza as informações
        $queryConfig = "SELECT mls_api FROM config LIMIT 1";
        $mysqliQueryConfig = mysqli_query($conn, $queryConfig);
        while ($config_data = mysqli_fetch_assoc($mysqliQueryConfig)) { $config = $config_data; }

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => "https://us-real-estate.p.rapidapi.com/v3/property-detail?property_id=" . $prop['api_id'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => [
                "X-RapidAPI-Host: us-real-estate.p.rapidapi.com",
                "X-RapidAPI-Key: 0e81c64f85msh344a62f86282268p15eb81jsn7faa9194b5c8"
            ],
        ]);

        $api_data = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);

        if ($err) {
            $response = array(
                'code' => 400 ,
                'status' => 'error',
                'message' => 'api error',
                'description' => $err,
            );
        } else {

            // Pega as informações atualizadas da API
            $prop_api = json_decode($api_data, true);
            $prop_sync = $prop_api['data'];

            $features = isset($prop_sync['details']) ? json_encode($prop_sync['details']) : 'null';
            $tax_assessments = isset($prop_sync['tax_history']) ? json_encode($prop_sync['tax_history']) : 'null';
            $photos = isset($prop_sync['photos']) ? json_encode($prop_sync['photos']) : 'null';
            $tags = isset($prop_sync['tags']) ? json_encode($prop_sync['tags']) : 'null';
            $price_history = isset($prop_sync['estimates']['historical_value']) ? json_encode($prop_sync['estimates']['historical_value']) : 'null';

            $updateStmt = $conn->prepare("UPDATE properties SET features = ?, tax_assessments = ?, pictures = ?, tags = ?, price_history = ?, sync_status = 1 WHERE id = ?");
            $updateStmt->bind_param("sssssi", $features, $tax_assessments, $photos, $tags, $price_history, $propId);
            $success = $updateStmt->execute();
            $updateStmt->close();

            $queryGet = "SELECT * FROM properties WHERE id = '$propId'";
            $mysqliGet = mysqli_query($conn, $queryGet);
            while ($prop_data = mysqli_fetch_assoc($mysqliGet)) { 
                $propNew = $prop_data; 

                $propNew['features'] = !empty($propNew['features']) ? json_decode($propNew['features'], true) : null;
                $propNew['tax_assessments'] = !empty($propNew['tax_assessments']) ? json_decode($propNew['tax_assessments'], true) : null;
                $propNew['pictures'] = !empty($propNew['pictures']) ? json_decode($propNew['pictures'], true) : null;
                $propNew['tags'] = !empty($propNew['tags']) ? json_decode($propNew['tags'], true) : null;
                $propNew['price_history'] = !empty($propNew['price_history']) ? json_decode($propNew['price_history'], true) : null;

            }

            // Retorna a response
            $response = array(
                'code' => 200 ,
                'status' => 'success',
                'data' => json_encode($propNew),
                // 'response_api' => $api_data
            );

        }
    }

} else {
    $response = array(
        'code' => 400 ,
        'status' => 'error',
        'message' => 'invalid request method',
        'description' => 'The endpoint request method is invalid, check the documentation.',
    );
}

header('Content-Type: application/json');
echo json_encode($response);

?>