<?php

if (session_status() == PHP_SESSION_NONE) { session_start(); }
require_once __DIR__ . '/../../inc/conn.php';

// Verifica se o método é POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $code = $_POST['code'];
    $queryValues = '';

    // ======== STEP ONE =========
    $address        = !empty($_POST['address']) ? $_POST['address'] : NULL;
    $city           = !empty($_POST['city']) ? $_POST['city'] : NULL;
    $zipcode        = !empty($_POST['zipcode']) ? $_POST['zipcode'] : NULL;
    $bedrooms       = !empty($_POST['bedrooms']) ? $_POST['bedrooms'] : 0;
    $bathrooms      = !empty($_POST['bathrooms']) ? $_POST['bathrooms'] : 0;
    $size           = !empty($_POST['size']) ? $_POST['size'] : 0;
    $notes          = !empty($_POST['notes']) ? $_POST['notes'] : NULL;

    isset($address) ? $queryValues .= " address = '$address', " : '';
    isset($city) ? $queryValues .= " city = '$city', " : '';
    isset($zipcode) ? $queryValues .= " zipcode = '$zipcode', " : '';
    isset($bedrooms) ? $queryValues .= " bedrooms = '$bedrooms', " : '';
    isset($bathrooms) ? $queryValues .= " bathrooms = '$bathrooms', " : '';
    isset($size) ? $queryValues .= " size = '$size', " : '';
    isset($notes) ? $queryValues .= " notes = '$notes', " : '';

    // ======== STEP PICTURE =========
    $picture = isset($_POST['picture']) ? $_POST['picture'] : NULL;
    !empty($picture) ? $queryValues .= " picture = '$picture', " : '';

    // ======== STEP REHAB =========
    $rehab = json_encode($_POST['rehab'], JSON_UNESCAPED_UNICODE);
    isset($rehab) && !empty($rehab) && $rehab != '""' ? $queryValues .= " rehab = '$rehab', " : '';

    // ======== STEP ROI =========
    $price__arv = !empty($_POST['price__arv']) ? $_POST['price__arv'] : 0;
    $price__buy = !empty($_POST['price__buy']) ? $_POST['price__buy'] : 0;
    $rehab__total = !empty($_POST['rehab__total']) ? $_POST['rehab__total'] : 0;
    $duration = !empty($_POST['duration']) ? $_POST['duration'] : 0;
    $holding_costs = !empty($_POST['holding_costs']) ? $_POST['holding_costs'] : 0;

    // Financial costs
    $first_mortgage = !empty($_POST['first_mortgage']) ? $_POST['first_mortgage'] : 0;
    $secound_mortgage = !empty($_POST['secound_mortgage']) ? $_POST['secound_mortgage'] : 0;
    $others_mortgage = !empty($_POST['others_mortgage']) ? $_POST['others_mortgage'] : 0;
    $buy_costs = !empty($_POST['buy_costs']) ? $_POST['buy_costs'] : 0;
    $sell_costs = !empty($_POST['sell_costs']) ? $_POST['sell_costs'] : 0;
    $total_costs = !empty($_POST['total_costs']) ? $_POST['total_costs'] : 0;

    isset($price__arv) ? $queryValues .= " price_arv = '$price__arv', " : '';
    isset($price__buy) ? $queryValues .= " is_draft = 0, " : '';
    isset($price__buy) ? $queryValues .= " price_buy = '$price__buy', " : '';
    isset($rehab__total) ? $queryValues .= " rehab_total = '$rehab__total', " : '';
    isset($duration) ? $queryValues .= " duration = '$duration', " : '';
    isset($holding_costs) ? $queryValues .= " holding_costs = '$holding_costs', " : '';
    isset($first_mortgage) ? $queryValues .= " first_mortgage = '$first_mortgage', " : '';
    isset($secound_mortgage) ? $queryValues .= " secound_mortgage = '$secound_mortgage', " : '';
    isset($others_mortgage) ? $queryValues .= " others_mortgage = '$others_mortgage', " : '';
    isset($buy_costs) ? $queryValues .= " buy_costs = '$buy_costs', " : '';
    isset($sell_costs) ? $queryValues .= " sell_costs = '$sell_costs', " : '';
    isset($total_costs) ? $queryValues .= " total_costs = '$total_costs', " : '';

    // Forma a query
    $queryUpdate = "UPDATE projects SET " . $queryValues . " code = '$code' WHERE code = '$code'";

    if (mysqli_query($conn, $queryUpdate)) {
        $response = array(
            'code' => 200 ,
            'status' => 'success'
        );
    } else {
        $response = array(
            'code' => 400 ,
            'status' => 'error',
            'message' => 'Erro na query',
        );
    }


} else {
    $response = array(
        'code' => 400 ,
        'status' => 'error',
        'message' => 'invalid request method',
        'description' => 'The endpoint request method is invalid, check the documentation.',
    );
}

// Forma a query
$queryTrashDrafts = "DELETE FROM projects WHERE updated_at <= DATE_SUB(NOW(), INTERVAL 24 HOUR) AND is_draft = 1";
@mysqli_query($conn, $queryTrashDrafts);

header('Content-Type: application/json');
echo json_encode($response);

?>