<!DOCTYPE html>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php 

        $page_name = 'Usuários';

        require_once __DIR__ . '/../../../../inc/conn.php';
        
        require_once __DIR__ . '/../../../inc/config.php';
        require_once __DIR__ . '/../../../inc/functions.php';

        CheckAuth();

        require_once __DIR__ . '/../../../../inc/cdns.php';
        require_once __DIR__ . '/../../../inc/styles.php';


    ?>

    <title><?php echo $page_name . ' | ' . $app['name']; ?></title>

    <script src="<?php echo $local['assets'] . '/js/functions.js'; ?>"></script>
    <link rel="stylesheet" type="text/css" href="<?php echo $local['assets'] . '/css/users/list.css'; ?>">

    <!-- Datatables -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.8/css/dataTables.dataTables.min.css">

</head>
<body>

    <?php require_once __DIR__ . '/../layout/leftbar.php'; ?>
    <div class="content__box">
        <div class="container">
            <div class="row">
                <div class="col-12 col-xl-9">
                    <div class="module">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Nome</th>
                                    <th>E-mail</th>
                                    <th class="center">Plano</th>
                                    <th class="center">Status</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 

                                $users['ativos'] = 0;
                                $users['inativos'] = 0;

                                $consulta = "SELECT users.*,
                                                    plans.name AS plan_name

                                                    FROM users 
                                                    LEFT JOIN plans ON plans.id = users.plan

                                                    ORDER BY id DESC";

                                $con = $conn->query($consulta) or die($conn->error);
                                while($user = $con->fetch_array()) {

                                    $user['status'] == 1 ? $users['ativos'] = $users['ativos'] + 1 : $users['inativos'] = $users['inativos'] + 1;

                                ?>
                                <tr id="<?php echo 'user__' . $user['id']; ?>">
                                    <td><?php echo '#' . $user['id']; ?></td>
                                    <td><?php echo $user['name']; ?></td>
                                    <td><?php echo $user['mail']; ?></td>
                                    <td class="center"><?php echo $user['plan_name']; ?></td>
                                    <td class="center">
                                        <?php $status = $user['status'] == 0 ? 'inativo' : 'ativo'; ?>
                                        <label class="status st_<?php echo $status; ?>"><?php echo strtoupper($status); ?></label>
                                    </td>
                                    <td class="td__actions">
                                        <label onclick="OpenUser(<?php echo $user['id']; ?>)"> <!-- See -->
                                            <svg data-slot="icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                              <path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 0 1 0-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178Z"></path>
                                              <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z"></path>
                                            </svg>
                                        </label>
                                        <label onclick="DeleteUser(<?php echo $user['id']; ?>)"> <!-- Trash -->
                                            <svg data-slot="icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                              <path stroke-linecap="round" stroke-linejoin="round" d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0"></path>
                                            </svg>
                                        </label>
                                    </td>
                                </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="col-12 col-md-12 col-xl-3 order-first order-xl-last">
                    <div class="row">
                        <div class="col-6 col-xl-12">
                            <div class="topbar__module">
                                <div class="module__icon">
                                    <svg data-slot="icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                      <path stroke-linecap="round" stroke-linejoin="round" d="M15 19.128a9.38 9.38 0 0 0 2.625.372 9.337 9.337 0 0 0 4.121-.952 4.125 4.125 0 0 0-7.533-2.493M15 19.128v-.003c0-1.113-.285-2.16-.786-3.07M15 19.128v.106A12.318 12.318 0 0 1 8.624 21c-2.331 0-4.512-.645-6.374-1.766l-.001-.109a6.375 6.375 0 0 1 11.964-3.07M12 6.375a3.375 3.375 0 1 1-6.75 0 3.375 3.375 0 0 1 6.75 0Zm8.25 2.25a2.625 2.625 0 1 1-5.25 0 2.625 2.625 0 0 1 5.25 0Z"></path>
                                    </svg>
                                </div>
                                <div class="module__content">
                                    <p class="module__value animated_number"><?php echo $users['ativos']; ?></p>
                                    <p class="module__title">Usuários ativos</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-6 col-xl-12">
                            <div class="topbar__module">
                                <div class="module__icon">
                                    <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                      <path stroke-linecap="round" stroke-linejoin="round" d="M5.636 5.636a9 9 0 1 0 12.728 0M12 3v9"></path>
                                    </svg>
                                </div>
                                <div class="module__content">
                                    <p class="module__value animated_number"><?php echo $users['inativos']; ?></p>
                                    <p class="module__title">Usuários Inativos</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</body>
<script type="text/javascript" src="https://cdn.datatables.net/2.0.8/js/dataTables.min.js"></script>
<script type="text/javascript">

    function OpenUser(user_id) {
        window.location.href = base_url + '/users/' + user_id;
    }

    function DeleteUser(user_id) {
        Swal.fire({
            icon: 'warning',
            title: "Você tem certeza?",
            html: 'Essa ação é irreversível!',
            showCancelButton: true,
            confirmButtonText: "Excluir",
            cancelButtonText: "Cancelar",
        }).then((result) => {
            if (result.isConfirmed) {
                // Envia o AJAX 
                $.ajax({
                    type: "POST",
                    url: base_url + "/api/user/delete.php",
                    data: { id: user_id },
                    success: function(response) {
                        console.log(response);

                        // Sucesso
                        if (response.status === 'success') {
                            const rowToDelete = document.getElementById('user__' + user_id);
                            rowToDelete.remove();
                            Swal.fire("Saved!", "", "success");
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error("Erro:", error);
                    }
                });
            }
        });
    }

    // Datatables    
    $(document).ready(function(){
        $('table').DataTable({
            language: {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "_START_ à _END_ de _TOTAL_ registros",
                "sInfoEmpty": "Nenhum registro",
                "sInfoFiltered": "(filtrado de _MAX_ registros)",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_ registros",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sSearch": "Pesquisar:",
                "sZeroRecords": "Nenhum registro encontrado",
                "oPaginate": {
                    "sFirst": "<<",
                    "sLast": ">>",
                    "sNext": ">",
                    "sPrevious": "<"
                },
                "oAria": {
                    "sSortAscending": ": ativar para ordenar a coluna em ordem crescente",
                    "sSortDescending": ": ativar para ordenar a coluna em ordem decrescente"
                }
            },
            dom: '<"top"rt><"dt__bottom"ipf><"clear">',
            order: [[0, 'desc']]
        });

        $('.dt-search input').attr('placeholder', 'Pesquisar');
    });

</script>
</html>