<!DOCTYPE html>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php 

        $page_name = 'Faturas'; 
        $profilePage = true;

    ?>

    <?php require_once __DIR__ . '/../../inc/conn.php'; ?>
    <?php require_once __DIR__ . '/../../inc/variables.php'; ?>

    <?php require_once __DIR__ . '/../../inc/cdns.php'; ?>
    <?php require_once __DIR__ . '/../../inc/styles.php'; ?>

    <title><?php echo $page_name . ' | ' . $app['name']; ?></title>

    <?php if (!isset($_SESSION['user'])) { Route('entrar'); } ?>

    <link rel="stylesheet" type="text/css" href="<?php echo $local['assets'] . '/css/invoices.css'; ?>">

</head>
<body>

    <?php require_once __DIR__ . '/../layout/topbar.php'; ?>
    <div class="content">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="header__content">

                        <div class="header__title">
                            <h1 class="title">Faturas</h1>
                            <p class="subtitle">Acompanhe suas faturas e recibos.</p>
                        </div>

                    </div>
                </div>
                <div class="col-12">
                    <div class="divider"></div>
                </div>
                <?php if (!UserStatus()) { ?>
                <div class="col-12">
                    <div class="plan__expired">
                        &#x1F6A8;⠀
                        Sua assinatura está vencida desde <strong><?php echo date('d/m/Y', strtotime($user['next_payment'])); ?></strong>. Para continuar utilizando nossos serviços sem interrupções, por favor, renove seu plano.
                    </div>
                </div>
                <?php } ?>
                <div class="col-12">
                    <div class="invoice__module">
                        <table class="table responsive-table">
                            <thead>
                                <tr>
                                    <th>Identificação</th>
                                    <th style="text-align: center;">Plano</th>
                                    <th style="text-align: center;">Valor</th>
                                    <th style="text-align: center;">Data</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $user_id = $user['id'];
                                $consulta = "SELECT * FROM invoices WHERE user = '$user_id' ORDER BY created_at DESC";
                                $con = $conn->query($consulta) or die($conn->error);
                                while($invoice = $con->fetch_array()) { ?>
                                <tr>
                                    <td>#<?php echo str_replace(['in_', 'sub_'], '', $invoice['invoice']); ?></td>
                                    <td style="text-align: center;"><?php echo $invoice['description']; ?></td>
                                    <td style="text-align: center;"><?php echo 'USD ' . Money($invoice['price']); ?></td>
                                    <td style="text-align: center;"><?php echo date('d/m/Y H:i', strtotime($invoice['created_at'])); ?></td>
                                    <td style="text-align: right;">
                                        <span onclick="GetInvoicePDF('<?php echo $invoice['invoice']; ?>')">
                                            <svg viewBox="0 0 26 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M12.245 21.25C18.545 21.25 20.645 18.94 20.645 12C20.645 10.58 20.555 9.35 20.365 8.3L14.695 2.9C13.965 2.8 13.145 2.75 12.245 2.75C5.95498 2.75 3.85498 5.07 3.85498 12C3.85498 17.205 5.03598 19.806 8.27998 20.781" stroke-linecap="round" stroke-linejoin="round"/>
                                                <path d="M14.1392 5.49377C14.1392 7.35177 15.6452 8.85677 17.5032 8.85677H20.4542" stroke-linecap="round" stroke-linejoin="round"/>
                                                <path d="M11.8652 16.0173V9.97632" stroke-linecap="round" stroke-linejoin="round"/>
                                                <path d="M9.52002 13.6624L11.865 16.0174L14.21 13.6624" stroke-linecap="round" stroke-linejoin="round"/>
                                            </svg>
                                        </span>
                                    </td>
                                </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

</body>
<script type="text/javascript">
    
    function GetInvoicePDF(invoice_id) {
        $.ajax({
            type: "POST",
            url: base_url + "/api/payments/invoice.php",
            data: { invoice: invoice_id },
            success: function(response) {
                if (response.status === 'success') {
                    console.log(response);
                    window.open(response.url);

                } else { console.log(response); }
            },
            error: function(xhr, status, error) {
            console.error("Erro:", error);
            }
        });
    }

</script>
</html>