<style type="text/css">
	
:root {

	--color-primary: #000;
	--color-secondary: #161617;

	--color-dark: #161618;
	--color-white: #ffffff;
	--color-border: #1F2023;
	--color-module: #222225;

	--color-mid: #19191B;
	--color-midwhite: #f9f9f9;

}

* {
	font-family: Inter;
	transition: all 300ms;
}

.mobile__menu {
	display: none;
	justify-content: center;
	align-items: center;

	background: linear-gradient(60deg, #29323c 0%, #485563 100%);
	border-radius: 15px;

	width: 40px;
	height: 40px;

	margin-left: 15px;
}

.mobile__menu svg {
	width: 25px;
	color: #ffffff;
}

@media (max-width: 767px) {
	.mobile_hide { display: none !important; }
	.mobile__menu { display: flex !important; }
	.mb-margin { margin-bottom: 55px !important; }
}

@media (min-width: 768px) and (max-width: 995px) {
	.mobile_hide { display: none !important; }
	.mobile__menu { display: flex !important; }
}

@media (max-width: 767px) {
    .content {
        margin-top: calc(var(--topbar-height) + 15px) !important;
        padding-bottom: 75px !important;
    }
}

body {
	background: var(--color-midwhite);
}

.copy__bar {
	position: fixed;
	padding: 5px 0px;
	text-align: center;
	bottom: 0;
	left: 0;
	width: 100%;
	background: white;
	font-size: .65em;
	font-weight: 300;
}

.copy__bar p {
	margin: 0px !important;
}

.module {
	padding: 15px 20px;
	border: 1px solid var(--color-border);
	background: var(--color-module);
	border-radius: 15px;
	color: #fff;
	font-size: .9em;
	font-weight: 300;
}

.content__inner {
	padding: calc(var(--topbar-altura) + 50px) 50px 50px calc(var(--leftbar-largura) + 50px);
}

/* SWALL */

.swal2-popup {
	padding-bottom: 45px !important;
	border-radius: 25px !important;
}

.swal2-actions button {
	padding: 6px 15px !important !important;
	text-transform: uppercase;
	font-size: .9em !important;
	font-weight: 400 !important;
}

.swal2-toast {
	padding: 15px !important;
}

.swal2-toast .swal2-title {
	font-weight: 400 !important;
}

</style>

<link rel="icon" type="image/x-icon" href="<?php echo $local['assets'] . '/marca/favicon.png'; ?>">

<script>

// $(document).ready(function(){
//     $('.telephone').inputmask({
//         mask: ['99 9999 9999', '99 9 9999 9999'],
//         keepStatic: true,
//         placeholder: '',
//         showMaskOnHover: false,
//         clearIncomplete: true
//     });
// });

document.addEventListener('DOMContentLoaded', function() {

	$('.moneyMask').inputmask({
	    alias: 'numeric',
	    radixPoint: '.',
	    groupSeparator: ',',
	    autoGroup: true,
	    digits: 2,
	    digitsOptional: false,
	    placeholder: '0',
	    rightAlign: false,
	    prefix: '$ ',
	    numericInput: true,
	    allowMinus: false,
	    onBeforeMask: function(value, opts) {
	        return value.replace(/[^\d.]/g, '');
	    }
	});

	$('.money').inputmask({
	    alias: 'numeric',
	    radixPoint: '.',
	    groupSeparator: ',',
	    autoGroup: true,
	    digits: 2,
	    digitsOptional: false,
	    placeholder: '0',
	    rightAlign: false,
	    prefix: '$ ',
	    numericInput: true,
	    allowMinus: false,
	    onBeforeMask: function(value, opts) {
	        return value.replace(/[^\d.]/g, '');
	    }
	});

	$('.percentageMask').inputmask({
	    alias: 'numeric',
	    radixPoint: '.',
	    autoGroup: true,
	    digits: 2,
	    digitsOptional: false,
	    placeholder: '0',
	    rightAlign: false,
	    suffix: ' %',
	    numericInput: true,
	    min: 0,
	    max: 100,
	});

	$('.maskStateCode').inputmask({
	    mask: "AA",
	    definitions: {
	        'A': {
	            validator: "[A-Za-z]",
	            casing: "upper"
	        }
	    },
	    placeholder: "",
	    showMaskOnHover: false,
	    showMaskOnFocus: false,
	    clearIncomplete: true
	});


});

</script>