<?php 

if (session_status() == PHP_SESSION_NONE) { session_start(); }
require_once __DIR__ . '/../../inc/conn.php';

if (!isset($_POST['api_key'])) {
    $response = array(
        'code' => 401,
        'status' => 'error',
        'message' => 'API key not provided',
    );
} else {
    $api_key = $_POST['api_key'];
    if ($conn->connect_error) {
        $response = array(
            'code' => 500,
            'status' => 'error',
            'message' => 'Connection error',
            'description' => $conn->connect_error,
        );
    } else {
        $stmt = $conn->prepare("SELECT * FROM users WHERE api_key = ?");
        $stmt->bind_param("s", $api_key);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $sql = "SELECT id, name, telephone, mail, created_at FROM users";
            $result = $conn->query($sql);

            if ($result->num_rows > 0) {
                $users = [];
                while ($row = $result->fetch_assoc()) {
                    $users[] = $row;
                }
                $response = array(
                    'code' => 200,
                    'status' => 'success',
                    'data' => $users
                );
            } else {
                $response = array(
                    'code' => 404,
                    'status' => 'error',
                    'message' => 'No records found',
                );
            }
        } else {
            $response = array(
                'code' => 403,
                'status' => 'error',
                'message' => 'Invalid API key',
            );
        }
    }
}

header('Content-Type: application/json');
echo json_encode($response);

?>
