<?php 

    require_once __DIR__ . '/../../inc/conn.php';
    require_once __DIR__ . '/../../inc/translate/dictionary.php';

    $api_key = '0e81c64f85msh344a62f86282268p15eb81jsn7faa9194b5c8';

    // Verifica se o método foi POST
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        function TagToText($text) {
            $removeSymbols = str_replace(['-', '_'], ' ', $text);
            return ucwords($removeSymbols);
        }

        function Translate($text) {
            global $dictionary;

            if (array_key_exists($text, $dictionary)) {
                return $dictionary[$text];
            }

            foreach ($dictionary as $key => $value) {
                if (strpos($key, ":") !== false) {
                    $pattern_isolated = '/(^|\n|\r|^)\s*' . preg_quote($key, '/') . '(?=:)/';
                    $text = preg_replace($pattern_isolated, '$1' . $value, $text);
                }
            }
            
            return $text;
        }

        function SizeToSqft($type, $value) {
            if ($type == 'acres') {
                return round(($value * 43560));
            } else {
                return $value;
            }
        }

        function StatusCheck($status) {
            if ($status == 'FOR_SALE') {
                return 'sale';
            } elseif ($status == 'FOR_RENT') {
                return 'rent';
            } elseif ($status == 'RECENTLY_SOLD') {
                return 'sold';
            } else {
                return 'off_market';
            }
        }

        // Pega os parametros
        $address_place = isset($_POST['address']) && !empty($_POST['address']) ? $_POST['address'] . ' ' : '';
        $address_zipcode = isset($_POST['zipcode']) && !empty($_POST['zipcode']) ? $_POST['zipcode'] . ' ' : '';
        $address_city = isset($_POST['city']) && !empty($_POST['city']) ? $_POST['city'] . ' ' : '';
        $address_county = isset($_POST['state_code']) && !empty($_POST['state_code']) ? ', ' . $_POST['state_code'] . '' : '';

        // Define os filtros
        $property_type = isset($_POST['property_type']) && !empty($_POST['property_type']) ? $_POST['property_type'] . ' ' : null;
        $transaction_type = isset($_POST['business_type']) && !empty($_POST['business_type']) ? $_POST['business_type'] . ' ' : null;
        $bedrooms = isset($_POST['bedrooms']) && !empty($_POST['bedrooms']) ? $_POST['bedrooms'] . ' ' : null;
        $bathrooms = isset($_POST['bathrooms']) && !empty($_POST['bathrooms']) ? $_POST['bathrooms'] . ' ' : null;

        // Monta a localização
        $location = $address_place . $address_zipcode . $address_city . $address_county;

        // Verifica se o endereço tá completo
        if (isset($location) && !empty($location)) {

            $curl = curl_init();

            if (empty($address_place)) {

                $baseUrl = "https://zillow56.p.rapidapi.com/search";
                $params = [
                    'location' => $location,
                ];

            } else {

                $baseUrl = "https://zillow56.p.rapidapi.com/search_address";
                $params = [
                    'address' => $location,
                ];

            }

            $property_type == 'townhome ' ? $params['isTownhouse'] = 'true' : null;
            $property_type == 'single_family ' ? $params['isSingleFamily'] = 'true' : null;
            $property_type == 'apartment ' ? $params['isApartment'] = 'true' : null;
            $property_type == 'condo ' ? $params['isCondo'] = 'true' : null;
            $property_type == 'land ' ? $params['isLotLand'] = 'true' : null;

            isset($bedrooms) ? $params['beds_min'] = $bedrooms : null;
            isset($bathrooms) ? $params['baths_min'] = $bathrooms : null;

            $transaction_type == 'rent ' ? $params['status'] = 'forRent' : null;
            $transaction_type == 'sale ' ? $params['status'] = 'forSale' : null;
            $transaction_type == 'sold ' ? $params['status'] = 'recentlySold' : null;

            $apiParams = $params;

            $encodedParams = http_build_query($params);
            $fullUrl = $baseUrl . '?' . $encodedParams;

            curl_setopt_array($curl, [
                CURLOPT_URL => $fullUrl,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => [
                    "X-RapidAPI-Host: zillow56.p.rapidapi.com",
                    "X-RapidAPI-Key: " . $api_key
                ],
            ]);

            $api_data = curl_exec($curl);
            $err = curl_error($curl);

            curl_close($curl);

            if ($err) { // Erro na API
                $response = array(
                    'status' => 'error',
                    'message' => 'Error returned in API',
                    'details' => $err
                );
            } else {

                // Faz o decode do JSON
                $api_data = json_decode($api_data, true);

                // Verifica se a API retornou dados válidos
                if (isset($api_data['totalResultCount']) OR isset($api_data['zpid'])) {

                    // Verifica se veio alguma propriedade
                    if (isset($api_data['totalResultCount']) && $api_data['totalResultCount'] > 0) {

                        $row_data = [];

                        // Remapeia as keys da response
                        foreach ($api_data['results'] AS $row) {

                            $row_api['api_id'] = isset($row['zpid']) ? $row['zpid'] : null;
                            $row_api['address'] = isset($row['streetAddress']) ? $row['streetAddress'] : null;
                            $row_api['business_type'] = isset($row['homeStatus']) ? StatusCheck($row['homeStatus']) : 'off_market';
                            $row_api['zipcode'] = isset($row['zipcode']) ? $row['zipcode'] : null;
                            $row_api['state'] = isset($row['state']) ? $row['state'] : null;
                            $row_api['city'] = isset($row['city']) ? $row['city'] : null;
                            $row_api['latitude'] = isset($row['latitude']) ? $row['latitude'] : null;
                            $row_api['longitude'] = isset($row['longitude']) ? $row['longitude'] : null;
                            $row_api['property_type'] = isset($row['homeType']) ? Translate(ucfirst(TagToText($row['homeType']))) : null;
                            $row_api['bedrooms'] = isset($row['bedrooms']) ? $row['bedrooms'] : 0;
                            $row_api['bathrooms'] = isset($row['bathrooms']) ? $row['bathrooms'] : 0;
                            $row_api['lot_size'] = isset($row['lotAreaValue']) && isset($row['lotAreaUnit']) ? SizeToSqft($row['lotAreaUnit'], $row['lotAreaValue']) : 0;
                            $row_api['primary_photo'] = isset($row['imgSrc']) ? $row['imgSrc'] : null;
                            $row_api['price'] = isset($row['price']) ? $row['price'] : 0;
                            $row_api['status'] = isset($row['homeStatus']) ? $row['homeStatus'] : null;

                            // Insere no array
                            $row_data[] = $row_api;
                        }

                        // Prepara a base da query SQL com placeholders para inserção
                        $query_insert = "INSERT INTO properties 
                            (api_id, address, business_type, zipcode, state, city, latitude, longitude, property_type, bedrooms, bathrooms, lot_size, primary_photo, price, status)
                            VALUES ";

                        // Array para armazenar os placeholders e os tipos
                        $values = [];
                        $params = [];
                        $types = '';

                        // Monta os valores e os parâmetros
                        foreach ($row_data as $row) {
                            $values[] = "(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                            $types .= 'sssssssssssssss';
                            $params = array_merge($params, array_values($row));
                        }

                        // Completa a query com múltiplos valores
                        $query_insert .= implode(', ', $values);
                        $query_insert .= " ON DUPLICATE KEY UPDATE
                            api_id = VALUES(api_id), 
                            address = VALUES(address), 
                            business_type = VALUES(business_type), 
                            zipcode = VALUES(zipcode), 
                            state = VALUES(state), 
                            city = VALUES(city), 
                            latitude = VALUES(latitude), 
                            longitude = VALUES(longitude), 
                            property_type = VALUES(property_type), 
                            bedrooms = VALUES(bedrooms), 
                            bathrooms = VALUES(bathrooms), 
                            lot_size = VALUES(lot_size), 
                            primary_photo = VALUES(primary_photo), 
                            price = VALUES(price), 
                            status = VALUES(status)";

                        $stmt = mysqli_prepare($conn, $query_insert);
                        if ($stmt) {
                            $refs = [];
                            $params = array_merge([$types], $params);
                            foreach ($params as $key => $value) {
                                $refs[$key] = &$params[$key];
                            }

                            call_user_func_array([$stmt, 'bind_param'], $refs);
                            mysqli_stmt_execute($stmt);
                            mysqli_stmt_close($stmt);
                        }

                        // Status success
                        $response = array(
                            'status' => 'success',
                            'message' => 'Data returned from the API: /search',
                            'query' => $apiParams,
                            'rows' => $row_data
                        );

                    } elseif (isset($api_data['zpid'])) {

                        // Status success: search_address

                        $row_data['mls_id'] = isset($api_data['mlsid']) ? $api_data['mlsid'] : '';
                        $row_data['api_id'] = isset($api_data['zpid']) ? $api_data['zpid'] : '';
                        $row_data['address'] = isset($api_data['abbreviatedAddress']) ? $api_data['abbreviatedAddress'] : null;
                        $row_data['business_type'] = isset($api_data['homeStatus']) ? StatusCheck($api_data['homeStatus']) : 'off_market';
                        $row_data['zipcode'] = isset($api_data['address']['zipcode']) ? $api_data['address']['zipcode'] : null;
                        $row_data['county'] = isset($api_data['county']) ? $api_data['county'] : null;
                        $row_data['state'] = isset($api_data['address']['state']) ? $api_data['address']['state'] : null;
                        $row_data['city'] = isset($api_data['city']) ? $api_data['city'] : null;
                        $row_data['latitude'] = isset($api_data['latitude']) ? $api_data['latitude'] : null;
                        $row_data['longitude'] = isset($api_data['longitude']) ? $api_data['longitude'] : null;
                        $row_data['property_type'] = isset($api_data['homeType']) ? Translate(ucfirst(TagToText($api_data['homeType']))) : null;
                        $row_data['bedrooms'] = isset($api_data['bedrooms']) ? $api_data['bedrooms'] : 0;
                        $row_data['bathrooms'] = isset($api_data['bathrooms']) ? $api_data['bathrooms'] : 0;
                        $row_data['lot_size'] = isset($api_data['lotSize']) ? $api_data['lotSize'] : null;
                        $row_data['square_footage'] = isset($api_data['livingArea']) ? SizeToSqft((isset($api_data['livingAreaUnitsShort']) ? $api_data['livingAreaUnitsShort'] : 'sqft'), $api_data['livingArea']) : null;
                        $row_data['year_built'] = isset($api_data['yearBuilt']) ? $api_data['yearBuilt'] : null;
                        $row_data['features'] = isset($api_data['resoFacts']) ? json_encode($api_data['resoFacts']) : null;
                        $row_data['tax_assessments'] = isset($api_data['taxHistory']) ? json_encode($api_data['taxHistory']) : null;
                        $row_data['comparisons'] = isset($api_data['nearbyHomes']) ? json_encode($api_data['nearbyHomes']) : null;
                        $row_data['price_history'] = isset($api_data['priceHistory']) ? json_encode($api_data['priceHistory']) : null;
                        $row_data['tags'] = isset($api_data['resoFacts']) ? json_encode($api_data['resoFacts']) : null;
                        $row_data['primary_photo'] = isset($api_data['responsivePhotos'][0]['url']) ? $api_data['responsivePhotos'][0]['url'] : null;
                        $row_data['pictures'] = isset($api_data['big']) ? json_encode($api_data['big']) : null;
                        $row_data['price'] = isset($api_data['price']) ? $api_data['price'] : 0;
                        $row_data['status'] = isset($api_data['homeStatus']) ? $api_data['homeStatus'] : null;

                        // Insere ou atualiza no banco de dados
                        // Adicionar o tratamento para business_type
                        $query_insert = "INSERT INTO properties 
                            (mls_id, api_id, address, business_type, zipcode, county, state, city, latitude, longitude, property_type, bedrooms, bathrooms, lot_size, square_footage, year_built, features, tax_assessments, comparisons, price_history, tags, primary_photo, pictures, price, status)
                            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
                            ON DUPLICATE KEY UPDATE
                            api_id = VALUES(api_id), 
                            address = VALUES(address), 
                            business_type = VALUES(business_type), 
                            zipcode = VALUES(zipcode), 
                            county = VALUES(county), 
                            state = VALUES(state), 
                            city = VALUES(city), 
                            latitude = VALUES(latitude), 
                            longitude = VALUES(longitude), 
                            property_type = VALUES(property_type), 
                            bedrooms = VALUES(bedrooms), 
                            bathrooms = VALUES(bathrooms), 
                            lot_size = VALUES(lot_size), 
                            square_footage = VALUES(square_footage), 
                            year_built = VALUES(year_built), 
                            features = VALUES(features), 
                            tax_assessments = VALUES(tax_assessments), 
                            comparisons = VALUES(comparisons), 
                            price_history = VALUES(price_history), 
                            tags = VALUES(tags), 
                            primary_photo = VALUES(primary_photo), 
                            pictures = VALUES(pictures), 
                            price = VALUES(price), 
                            status = VALUES(status)";
                        $stmt = mysqli_prepare($conn, $query_insert);
                        if ($stmt) {
                            mysqli_stmt_bind_param($stmt, "sssssssssssssssssssssssss", 
                                $row_data['mls_id'], 
                                $row_data['api_id'], 
                                $row_data['address'], 
                                $row_data['business_type'], 
                                $row_data['zipcode'], 
                                $row_data['county'], 
                                $row_data['state'], 
                                $row_data['city'], 
                                $row_data['latitude'], 
                                $row_data['longitude'], 
                                $row_data['property_type'], 
                                $row_data['bedrooms'], 
                                $row_data['bathrooms'], 
                                $row_data['lot_size'], 
                                $row_data['square_footage'], 
                                $row_data['year_built'], 
                                $row_data['features'], 
                                $row_data['tax_assessments'], 
                                $row_data['comparisons'], 
                                $row_data['price_history'], 
                                $row_data['tags'], 
                                $row_data['primary_photo'], 
                                $row_data['pictures'], 
                                $row_data['price'], 
                                $row_data['status']);

                            mysqli_stmt_execute($stmt);
                            mysqli_stmt_close($stmt);}

                        $rows[0] = $row_data;

                        $response = array(
                            'status' => 'success',
                            'message' => 'Data returned from the API: /search_address',
                            'query' => $apiParams,
                            'rows' => $rows
                        );

                    } else {

                        // Status nothing
                        $response = array(
                            'status' => 'nothing',
                            'message' => 'Valid API return but no results.',
                            'details' => $api_data
                        );

                    }

                } else {
                    $response = array(
                        'status' => 'nothing',
                        'message' => 'The API did not return valid data',
                        'details' => $api_data
                    );
                }

            }

        } else { // Localização inválida
            $response = array(
                'status' => 'nothing',
                'message' => 'Invalid or not received location.',
            );
        }

    } else { // Método de requisição inválido
        $response = array(
            'status' => 'error',
            'message' => 'Invalid method, check documentation and try again.',
        );
    }

    function Response() {
        global $conn;

        $params = [
            'place' => $_POST['address'] ?? '',
            'zipcode' => $_POST['zipcode'] ?? '',
            'property_type' => $_POST['property_type'] ?? '',
            'transaction_type' => $_POST['business_type'] ?? '',
            'bedrooms' => $_POST['bedrooms'] ?? '',
            'bathrooms' => $_POST['bathrooms'] ?? ''
        ];

        $city = $_POST['city'] ?? ''; // Get the city from POST data

        $query = "SELECT *, (0";
        if (!empty($params['place'])) {
            $query .= " + CASE WHEN address LIKE '%" . $conn->real_escape_string($params['place']) . "%' THEN 1 ELSE 0 END";
        }
        if (!empty($params['zipcode'])) {
            $query .= " + CASE WHEN zipcode LIKE '%" . $conn->real_escape_string($params['zipcode']) . "%' THEN 1 ELSE 0 END";
        }
        if (!empty($params['property_type'])) {
            $query .= " + CASE WHEN property_type LIKE '%" . $conn->real_escape_string($params['property_type']) . "%' THEN 1 ELSE 0 END";
        }
        $query .= ") AS relevance FROM properties WHERE 1=1";
        if (!empty($business_type)) {
            $query .= " AND business_type = '" . $conn->real_escape_string($params['transaction_type']) . "'";
        }
        if (!empty($params['bedrooms'])) {
            $query .= " AND bedrooms = " . (int) $params['bedrooms'];
        }
        if (!empty($params['bathrooms'])) {
            $query .= " AND bathrooms = " . (int) $params['bathrooms'];
        }
        if (!empty($city)) {
            $query .= " AND city = '" . $conn->real_escape_string($city) . "'";
        }
        $query .= " ORDER BY relevance DESC LIMIT 200";

        // Executando a query
        $result = $conn->query($query);
        $response = [];
        if ($result) {
            while ($row = $result->fetch_assoc()) {
                $row['property_type'] = Translate($row['property_type']);
                $response[] = $row;
            }
        }

        return $response;
    }

    header('Content-Type: application/json');
    echo json_encode($response);

?>