<?php

require_once __DIR__ . '/../../inc/conn.php';
require_once __DIR__ . '/../../assets/vendor/autoload.php';

$query_secret = "SELECT pay_api FROM config";
$result = $conn->query($query_secret);
$api_data = $result->fetch_assoc();

$api = json_decode($api_data['pay_api'], true);

\Stripe\Stripe::setApiKey($api['secret']);
$endpoint_secret = $api['webhook'];

$payload = @file_get_contents('php://input');
$sig_header = $_SERVER['HTTP_STRIPE_SIGNATURE'];

try {

    $event = \Stripe\Webhook::constructEvent($payload, $sig_header, $endpoint_secret);
    // $event = json_decode($payload);

    switch ($event->type) {
        case 'checkout.session.completed':
            $session = $event->data->object;

            $customer_id = $session->customer;
            $subscription_id = $session->subscription;
            $payment_status = $session->payment_status;
            $price_total = ($session->amount_total / 100);
            $invoice_id = $session->invoice;
            $email = $session->customer_details->email;

            $stripe = new \Stripe\StripeClient($api['secret']);
            $subscription = $stripe->subscriptions->retrieve($subscription_id, []);
            $price_id = $subscription['items']['data'][0]['price']['id'];

            if ($payment_status == 'paid') {

                // Pega as informações do plano
                $planQuery = "SELECT * FROM plans WHERE api_id = '$price_id'";
                $result = $conn->query($planQuery);
                $plan = $result->fetch_assoc();
                $plan_id = $plan['id'];

                // Pega as informações do usuário
                $userQuery = "SELECT * FROM users WHERE pay_id = '$customer_id'";
                $userResult = $conn->query($userQuery);
                $user = $userResult->fetch_assoc();
                $user_id = $user['id'];

                // Próxima data de pagamento e descrição
                if ($plan['recurrence'] == 'yearly') {
                    $renewDate = date('Y-m-d', strtotime('+12 month', time()));
                    $plan_description = $plan['name'] . ' - Anual';
                } elseif ($plan['recurrence'] == 'semi-annual') {
                    $renewDate = date('Y-m-d', strtotime('+6 month', time()));
                    $plan_description = $plan['name'] . ' - Semestral';
                } elseif ($plan['recurrence'] == 'quarterly') {
                    $renewDate = date('Y-m-d', strtotime('+3 month', time()));
                    $plan_description = $plan['name'] . ' - Trimestral';
                } elseif ($plan['recurrence'] == 'monthly') {
                    $renewDate = date('Y-m-d', strtotime('+1 month', time()));
                    $plan_description = $plan['name'] . ' - Mensal';
                } else {
                    $renewDate = date('Y-m-d', strtotime('+1 month', time()));
                    $plan_description = $plan['name'];
                }

                // Atualiza o registro do usuário
                $updateQuery = "UPDATE users SET subscription = '$subscription_id', status = 1, plan = '$plan_id', last_payment = NOW(), next_payment = '$renewDate' WHERE id = '$user_id'";
                $conn->query($updateQuery);

                // Registra a invoice
                $invoiceQuery = "INSERT INTO invoices (user, subscription, invoice, price, description) VALUES ('$user_id', '$subscription_id', '$invoice_id', '$price_total', '$plan_description')";
                $conn->query($invoiceQuery);

            }
            break;
        
        case 'invoice.payment_failed':
            $invoice = $event->data->object;
            $customer_id = $invoice->customer;
            // Lógica para tratar falha de pagamento
            $updateQuery = "UPDATE users SET status = 0 WHERE pay_id = '$customer_id'";
            $conn->query($updateQuery);
            break;

        case 'customer.subscription.deleted':
            $subscription = $event->data->object;
            $customer_id = $subscription->customer;
            // Lógica para tratar cancelamento de assinatura
            $updateQuery = "UPDATE users SET status = 0 WHERE pay_id = '$customer_id'";
            $conn->query($updateQuery);
            break;

        case 'customer.subscription.updated':
            $subscription = $event->data->object;
            if ($subscription->status == 'past_due') {
                $customer_id = $subscription->customer;
                // Lógica para tratar assinatura em atraso
                $updateQuery = "UPDATE users SET status = 0 WHERE pay_id = '$customer_id'";
                $conn->query($updateQuery);
            }
            break;

        default:
            // Tratar outros eventos se necessário
            break;
    }

    // Registrar todos os eventos recebidos (opcional)
    $eventType = $event->type;
    $eventContent = $conn->real_escape_string(json_encode($event));
    $query = "INSERT INTO webhooks (event, content) VALUES ('$eventType', '$eventContent')";
    $conn->query($query);

    http_response_code(200);

} catch(\UnexpectedValueException $e) {
    http_response_code(400);
    exit();
} catch(\Stripe\Exception\SignatureVerificationException $e) {
    http_response_code(400);
    exit();
}

?>