<?php

if (session_status() == PHP_SESSION_NONE) { session_start(); }
require_once __DIR__ . '/../../inc/conn.php';
require_once __DIR__ . '/../../assets/vendor/autoload.php';

$query_secret = "SELECT pay_api FROM config";
$result = $conn->query($query_secret);
$api_data = $result->fetch_assoc();

$api = json_decode($api_data['pay_api'], true);

\Stripe\Stripe::setApiKey($api['secret']);

// Verifica se o método é POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $invoice_id = $_POST['invoice'];

    $invoice = \Stripe\Invoice::retrieve($invoice_id);
    $hosted_invoice_url = $invoice->hosted_invoice_url;
    $invoice_pdf = $invoice->invoice_pdf;

    if (isset($invoice_pdf)) {
        // Enviar a response
        $response = array(
            'status' => 'success',
            'url' => $invoice_pdf,
        );
    } else {
        // Enviar a response
        $response = array(
            'status' => 'error',
        );
    }


} else {
    $response = array(
        'code' => 400 ,
        'status' => 'error',
        'message' => 'invalid request method',
        'description' => 'The endpoint request method is invalid, check the documentation.',
    );
}

header('Content-Type: application/json');
echo json_encode($response);

?>