<?php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

session_start();
require_once __DIR__ . '/../../inc/conn.php';

$mail = $_POST['mail'];

$stmt = $conn->prepare("SELECT id FROM users WHERE mail = ?");
$stmt->bind_param("s", $mail);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {

    $user = $result->fetch_assoc();

    $userId = $user['id'];
    $code = substr(str_shuffle(str_repeat($x='0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ', ceil(6/strlen($x)) )),1,6);
    $requesterIp = $_SERVER['REMOTE_ADDR'];

    $insertStmt = $conn->prepare("INSERT INTO recovery_requests (user, code, requester) VALUES (?, ?, ?)");
    $insertStmt->bind_param("iss", $userId, $code, $requesterIp);
    $insertStmt->execute();

    $base_url = 'http://' . (in_array($_SERVER['HTTP_HOST'], array('localhost', '192.168.0.111')) ? $_SERVER['HTTP_HOST'] . '/quick-realty' : $_SERVER['HTTP_HOST']);

	$mail_vars = array(
		'link' => $base_url . '/entrar/recuperar/alterar-senha?code=' . $code,
		'suport' => 'suporte@quickrealty.com.br',
	);

	require_once __DIR__ . '/../../assets/vendor/autoload.php';
	$mailFile = __DIR__ . '/../../assets/mails/RecoveryPassword.php';

	$mail = new PHPMailer(true); try {
	$mail->isSMTP();
	$mail->Host         = $smtp['host'];
	$mail->SMTPAuth     = true;
	$mail->Username     = $smtp['user'];
	$mail->Password     = $smtp['pass'];
	$mail->SMTPSecure   = PHPMailer::ENCRYPTION_SMTPS;
	$mail->Port         = $smtp['port'];
	$mail->setFrom($smtp['user'], utf8_decode('Quick Realty | Noreply'));
	$mail->addAddress($_POST['mail']);
	$mail->Subject = utf8_decode('Quick Realty | Recuperar Senha');
	ob_start();
	include $mailFile;
	$body = ob_get_clean();
	$mail->isHTML(true);
	$mail->Body = $body;
	$mail->send();

	} catch (Exception $e) {}
    $insertStmt->close();
}

$stmt->close();

$response = [
    'message' => 'Se o e-mail for válido, enviaremos um link para que recupere sua senha.'
];

header('Content-Type: application/json');
echo json_encode($response);

?>
